/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.systemsbiology.biotapestry.perturb.LegacyPert;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertDataPointEditPanel
extends AnimatedSplitEditPanel {
    private EditableTable etudf_;
    private PertDataPoint pdpResult_;
    private List userValsResult_;
    private PerturbationData pd_;
    private String currKey_;
    private List currAnnots_;
    private PerturbationData.RegionRestrict currRegRes_;
    private JLabel idLabel_;
    private JTextField commentField_;
    private JTextField dateField_;
    private JTextField batchKeyField_;
    private JTextField pertValField_;
    private JTextField footField_;
    private JTextField regResField_;
    private JLabel legacyLabel_;
    private JComboBox sourceCombo_;
    private JComboBox targCombo_;
    private JComboBox forceCombo_;
    private JComboBox ctrlCombo_;
    private JComboBox measureTypeCombo_;
    private PertManageHelper pmh_;
    private List userCols_;
    static /* synthetic */ Class class$java$lang$String;

    public PertDataPointEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey, int legacyModes) {
        super(parent, pet, myKey, 6);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        int colNum = 0;
        this.idLabel_ = new JLabel("");
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 6, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.idLabel_, this.gbc_);
        ++this.rowNum_;
        colNum = 0;
        colNum = 0;
        JLabel srcLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.source"));
        this.sourceCombo_ = new JComboBox();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)srcLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.sourceCombo_, this.gbc_);
        JButton addNewSource = new JButton(this.rMan_.getString("pertDataPointEdit.manageSources"), this.pmh_.getJumpIcon());
        addNewSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.sourceCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertDataPointEditPanel.this.pet_.jumpToRemoteEdit("sources", "editSrcs", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, colNum += 4, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        this.add((Component)addNewSource, this.gbc_);
        ++this.rowNum_;
        colNum = 0;
        JLabel targLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.targ"));
        this.targCombo_ = new JComboBox();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)targLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.targCombo_, this.gbc_);
        JButton addNewTarget = new JButton(this.rMan_.getString("pertDataPointEdit.manageTargets"), this.pmh_.getJumpIcon());
        addNewTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.targCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertDataPointEditPanel.this.pet_.jumpToRemoteEdit("srcsAndTargs", "editTrg", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, colNum += 4, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        colNum += 2;
        this.add((Component)addNewTarget, this.gbc_);
        ++this.rowNum_;
        colNum = 0;
        JLabel valueLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.value"));
        this.pertValField_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)valueLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.pertValField_, this.gbc_);
        JLabel measureLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.meaType"));
        this.measureTypeCombo_ = new JComboBox();
        JButton mtJump = new JButton(this.rMan_.getString("pdpe.jump"), this.pmh_.getJumpIcon());
        mtJump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.measureTypeCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertDataPointEditPanel.this.pet_.jumpToRemoteEdit("pertMeasure", "editMeas", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel mtCombo = this.pmh_.componentWithJumpButton(this.measureTypeCombo_, mtJump);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)measureLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)mtCombo, this.gbc_);
        Vector sigOps = PertDataPoint.getSignificanceOptions();
        JLabel forceLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.forceSig"));
        this.forceCombo_ = new JComboBox(sigOps);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)forceLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.forceCombo_, this.gbc_);
        ++this.rowNum_;
        if ((legacyModes & 1) != 0) {
            JLabel dummyLabel = new JLabel("");
            UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
            this.add((Component)dummyLabel, this.gbc_);
            this.legacyLabel_ = new JLabel("");
            UiUtil.gbcSet(this.gbc_, 1, this.rowNum_++, 5, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
            this.add((Component)this.legacyLabel_, this.gbc_);
        }
        colNum = 0;
        JLabel batchLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.batch"));
        this.batchKeyField_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)batchLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_++, 5, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.batchKeyField_, this.gbc_);
        colNum = 0;
        JLabel dateLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.date"));
        this.dateField_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)dateLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.dateField_, this.gbc_);
        JLabel ctrlLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.ctrl"));
        this.ctrlCombo_ = new JComboBox();
        JButton ctrlJump = new JButton(this.rMan_.getString("pdpe.jump"), this.pmh_.getJumpIcon());
        ctrlJump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.ctrlCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertDataPointEditPanel.this.pet_.jumpToRemoteEdit("expSetup", "editControl", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel combo = this.pmh_.componentWithJumpButton(this.ctrlCombo_, ctrlJump);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)ctrlLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)combo, this.gbc_);
        JLabel commentLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.comment"));
        this.commentField_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)commentLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.commentField_, this.gbc_);
        JLabel footLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.footnotes"));
        this.footField_ = new JTextField();
        this.footField_.setEditable(false);
        FixedJButton editFoots = new FixedJButton(this.rMan_.getString("pdpe.editAnnotations"));
        editFoots.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertDataPointEditPanel.this.pet_.editIsPushed("editDataAnnot");
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        colNum = 0;
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)footLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.footField_, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum += 4, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        colNum += 2;
        this.add((Component)editFoots, this.gbc_);
        JLabel regLabel = new JLabel(this.rMan_.getString("pdpe.regRestrict"));
        this.regResField_ = new JTextField();
        this.regResField_.setEditable(false);
        FixedJButton editRegRes = new FixedJButton(this.rMan_.getString("pdpe.editRegRestrict"));
        editRegRes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertDataPointEditPanel.this.pet_.editIsPushed("editRegRestrict");
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        colNum = 0;
        UiUtil.gbcSet(this.gbc_, colNum++, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)regLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum, this.rowNum_, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.regResField_, this.gbc_);
        UiUtil.gbcSet(this.gbc_, colNum += 4, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        colNum += 2;
        this.add((Component)editRegRes, this.gbc_);
        JLabel ufLabel = new JLabel(this.rMan_.getString("pertDataPointEdit.userFields"));
        this.userCols_ = this.buildUserColumns(pd);
        this.etudf_ = new EditableTable(new UserFieldsTableModel(this.userCols_, pd.getUserFieldCount() > 0), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.tableIsUnselectable = true;
        etp.buttons = 0;
        etp.noScroll = true;
        JPanel userFieldsTablePan = this.etudf_.buildEditableTable(etp);
        JPanel userFieldsWithButton = this.pmh_.addEditButton(userFieldsTablePan, "pdpe.UDFEdit", true, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertDataPointEditPanel.this.pet_.jumpToRemoteEdit("setup", "editUDF", null);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)ufLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_, 5, 2, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.rowNum_ += 2;
        this.add((Component)userFieldsWithButton, this.gbc_);
        this.finishConstruction();
    }

    public void closeAction() {
        this.etudf_.stopTheEditing(false);
        super.closeAction();
    }

    public void setDataPoint(String pointKey) {
        this.mode_ = 1;
        this.currKey_ = pointKey;
        PertDataPoint pdp = this.currKey_ == null ? null : this.pd_.getDataPoint(this.currKey_);
        this.currAnnots_ = pdp == null ? null : this.pd_.getDataPointNotes(this.currKey_);
        this.currRegRes_ = pdp == null ? null : this.pd_.getRegionRestrictionForDataPoint(this.currKey_);
        this.displayProperties();
    }

    public void setDataPointForDup(String origKey) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        PertDataPoint pdp = this.pd_.getDataPoint(this.currKey_);
        this.currAnnots_ = pdp == null ? null : this.pd_.getDataPointNotes(this.currKey_);
        this.currRegRes_ = pdp == null ? null : this.pd_.getRegionRestrictionForDataPoint(this.currKey_);
        this.displayProperties();
    }

    public void updateAnnotations(List annotations) {
        this.currAnnots_ = annotations == null ? null : new ArrayList(annotations);
        this.footField_.setText(this.currAnnots_ == null ? "" : this.pd_.getFootnoteListAsNVString(this.currAnnots_));
        this.footField_.setCaretPosition(0);
    }

    public void updateRegionRestriction(PerturbationData.RegionRestrict regRes) {
        this.currRegRes_ = regRes;
        this.regResField_.setText(this.currRegRes_ == null ? "" : this.currRegRes_.getDisplayValue());
        this.regResField_.setCaretPosition(0);
    }

    public PertDataPoint getResult() {
        return this.pdpResult_;
    }

    public List getUpdatedAnnotResult() {
        return this.currAnnots_;
    }

    public PerturbationData.RegionRestrict getUpdatedRegionRestrictionResult() {
        return this.currRegRes_;
    }

    public List getUserVals() {
        return this.userValsResult_;
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        Vector srcVec = this.pd_.getExperimentOptions();
        UiUtil.replaceComboItems(this.sourceCombo_, srcVec);
        Vector targVec = this.pd_.getTargetOptions(true);
        UiUtil.replaceComboItems(this.targCombo_, targVec);
        Vector measureTypes = this.pd_.getMeasureDictionary().getMeasurementOptions();
        UiUtil.replaceComboItems(this.measureTypeCombo_, measureTypes);
        Vector sigOps = PertDataPoint.getSignificanceOptions();
        UiUtil.replaceComboItems(this.forceCombo_, sigOps);
        Vector ctrlOps = this.pd_.getConditionDictionary().getExprControlOptions();
        TrueObjChoiceContent tocc = new TrueObjChoiceContent(this.rMan_.getString("pdpe.notSpecified"), null);
        ctrlOps.add(0, tocc);
        UiUtil.replaceComboItems(this.ctrlCombo_, ctrlOps);
        this.userCols_ = this.buildUserColumns(this.pd_);
        ((UserFieldsTableModel)this.etudf_.getModel()).resetColumns(this.userCols_, this.pd_.getUserFieldCount() > 0);
    }

    protected boolean stashResults() {
        int ok;
        PertDataPoint pdpOrig;
        String newDate;
        String newBatch;
        PertDataPoint pdp;
        LegacyPert lp;
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.measureTypeCombo_.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.emptyMeasure"), this.rMan_.getString("pdpe.emptyMeasureTitle"), 0);
            return false;
        }
        String newMeasure = (String)tocc.val;
        tocc = (TrueObjChoiceContent)this.forceCombo_.getSelectedItem();
        Boolean newForce = (Boolean)tocc.val;
        LegacyPert lpForDup = null;
        boolean legacyCasePasses = false;
        if (this.currKey_ != null && (lp = (pdp = this.pd_.getDataPoint(this.currKey_)).getLegacyPert()) != null) {
            String pvft = this.pertValField_.getText().trim();
            if (DataUtil.keysEqual(lp.oldValue, pvft)) {
                boolean illegalChange = false;
                Boolean currForce = pdp.getForcedSignificance();
                if (newForce == null) {
                    if (currForce != null) {
                        illegalChange = true;
                    }
                } else if (!newForce.equals(currForce)) {
                    illegalChange = true;
                }
                if (!illegalChange && !newMeasure.equals(pdp.getMeasurementTypeKey())) {
                    illegalChange = true;
                }
                if (illegalChange) {
                    JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.illegalLegacyChange"), this.rMan_.getString("pdpe.illegalLegacyChangeTitle"), 0);
                    return false;
                }
                if (this.mode_ == 3) {
                    lpForDup = (LegacyPert)lp.clone();
                }
                legacyCasePasses = true;
            } else if (lp.unknownMultiCount) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.cannotModifyMultiCount"), this.rMan_.getString("pdpe.cannotModifyMultiCountTitle"), 0);
                return false;
            }
        }
        Double newVal = null;
        if (!legacyCasePasses) {
            MeasureProps mps;
            newVal = this.getValue();
            if (newVal == null) {
                return false;
            }
            MeasureDictionary mdict = this.pd_.getMeasureDictionary();
            MeasureScale ms = mdict.getMeasureScale((mps = mdict.getMeasureProps(newMeasure)).getScaleKey());
            BoundedDoubMinMax illegal = ms.getIllegalRange();
            if (illegal != null && illegal.contained(newVal)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.valueOutOfRangeForScale"), this.rMan_.getString("pdpe.valueOutOfRangeForScaleTitle"), 0);
                return false;
            }
        }
        if ((newBatch = this.batchKeyField_.getText().trim()) == null || newBatch.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.emptyBatchKey"), this.rMan_.getString("pdpe.emptyBatchKeyTitle"), 0);
            return false;
        }
        tocc = (TrueObjChoiceContent)this.sourceCombo_.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.emptySrc"), this.rMan_.getString("pdpe.emptySrcTitle"), 0);
            return false;
        }
        String newExprKey = (String)tocc.val;
        tocc = (TrueObjChoiceContent)this.targCombo_.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pdpe.emptyTarg"), this.rMan_.getString("pdpe.emptyTargTitle"), 0);
            return false;
        }
        String newTarg = (String)tocc.val;
        tocc = (TrueObjChoiceContent)this.ctrlCombo_.getSelectedItem();
        String newCtrlKey = (String)tocc.val;
        String newComment = this.commentField_.getText().trim();
        if (newComment.equals("")) {
            newComment = null;
        }
        if ((newDate = this.dateField_.getText().trim()).equals("")) {
            newDate = null;
        }
        if (this.currKey_ == null || this.mode_ == 3) {
            long stamp = System.currentTimeMillis();
            String newKey = this.pd_.getNextDataKey();
            this.pdpResult_ = new PertDataPoint(newKey, stamp, newExprKey, newTarg, newMeasure, 0.0);
            if (legacyCasePasses) {
                this.pdpResult_.setLegacyPert(lpForDup);
            } else {
                this.pdpResult_.setLegacyPert(null);
                this.pdpResult_.setValue(newVal);
            }
        } else {
            this.pdpResult_ = (PertDataPoint)this.pd_.getDataPoint(this.currKey_).clone();
            this.pdpResult_.setExperimentKey(newExprKey);
            this.pdpResult_.setTargetKey(newTarg);
            this.pdpResult_.setMeasurementTypeKey(newMeasure);
            if (legacyCasePasses) {
                this.pdpResult_.setLegacyPert((LegacyPert)this.pdpResult_.getLegacyPert().clone());
            } else {
                this.pdpResult_.setLegacyPert(null);
                this.pdpResult_.setValue(newVal);
            }
        }
        this.pdpResult_.setIsSig(newForce);
        this.pdpResult_.setBatchKey(newBatch);
        this.pdpResult_.setDate(newDate);
        this.pdpResult_.setComment(newComment);
        this.pdpResult_.setControl(newCtrlKey);
        int fc = this.pd_.getUserFieldCount();
        if (fc == 0) {
            this.userValsResult_ = null;
        } else {
            this.userValsResult_ = new ArrayList();
            List vals = this.etudf_.getValuesFromTable();
            UserFieldsTableModel.TableRow row = (UserFieldsTableModel.TableRow)vals.get(0);
            for (int i = 0; i < fc; ++i) {
                this.userValsResult_.add(row.values[i]);
            }
        }
        if (this.mode_ == 3 && this.pdpResult_.willFallInSameBatchWithSameVal(pdpOrig = this.pd_.getDataPoint(this.currKey_)) && (ok = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pdpe.identicalDup"), this.rMan_.getString("pdpe.identicalDupTitle"), 0)) != 0) {
            return false;
        }
        this.etudf_.stopTheEditing(false);
        return true;
    }

    private ArrayList buildUserColumns(PerturbationData pd) {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator ufit = pd.getUserFieldNames();
        while (ufit.hasNext()) {
            String field = (String)ufit.next();
            retval.add(field);
        }
        if (retval.isEmpty()) {
            retval.add(this.rMan_.getString("pdpep.noFieldsDefined"));
        }
        return retval;
    }

    private ArrayList buildUserVals(PerturbationData pd, PertDataPoint pdp) {
        String pdpID;
        ArrayList<String> loadVals = new ArrayList<String>();
        int count = pd.getUserFieldCount();
        String string = pdpID = pdp == null ? null : pdp.getID();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String val = pdpID == null ? "" : pd.getUserFieldValue(pdpID, i);
                loadVals.add(val == null ? "" : val);
            }
        } else {
            loadVals.add("");
        }
        UserFieldsTableModel uftm = (UserFieldsTableModel)this.etudf_.getModel();
        UserFieldsTableModel.TableRow tr = uftm.new UserFieldsTableModel.TableRow();
        tr.load(loadVals);
        ArrayList<UserFieldsTableModel.TableRow> retval = new ArrayList<UserFieldsTableModel.TableRow>();
        retval.add(tr);
        return retval;
    }

    private void displayProperties() {
        this.updateOptions();
        if (this.mode_ == 1 && this.currKey_ == null) {
            this.idLabel_.setText(this.rMan_.getString("pdpae.newDataPoint"));
            UiUtil.initCombo(this.sourceCombo_);
            UiUtil.initCombo(this.targCombo_);
            UiUtil.initCombo(this.measureTypeCombo_);
            this.pertValField_.setText("");
            this.commentField_.setText("");
            UiUtil.initCombo(this.forceCombo_);
            UiUtil.initCombo(this.ctrlCombo_);
            this.dateField_.setText("");
            this.batchKeyField_.setText("");
            this.footField_.setText("");
            this.footField_.setCaretPosition(0);
            if (this.legacyLabel_ != null) {
                this.legacyLabel_.setText("");
                this.legacyLabel_.invalidate();
            }
            this.regResField_.setText("");
            this.regResField_.setCaretPosition(0);
            this.measureTypeCombo_.setEnabled(true);
            this.forceCombo_.setEnabled(true);
            ArrayList loadVals = this.buildUserVals(this.pd_, null);
            this.etudf_.updateTable(true, loadVals);
            this.validate();
            return;
        }
        PertDataPoint pdp = this.pd_.getDataPoint(this.currKey_);
        String format = this.rMan_.getString("pertDataPointEdit.numTimeFormat");
        String linkMsg = MessageFormat.format(format, pdp.getID(), DateFormat.getDateInstance().format(new Date(pdp.getTimeStamp())));
        this.idLabel_.setText(linkMsg);
        TrueObjChoiceContent tocc = pdp.getExperiment(this.pd_).getChoiceContent(this.pd_);
        this.sourceCombo_.setSelectedItem(tocc);
        TrueObjChoiceContent tocct = this.pd_.getTargetChoiceContent(pdp.getTargetKey(), true);
        this.targCombo_.setSelectedItem(tocct);
        LegacyPert lp = pdp.getLegacyPert();
        if (lp != null) {
            this.pertValField_.setText(lp.oldValue);
            if (lp.unknownMultiCount) {
                this.legacyLabel_.setText(this.rMan_.getString("pdpe.legacyUnknownMultiCount"));
            } else {
                this.legacyLabel_.setText("");
            }
            this.legacyLabel_.invalidate();
            this.measureTypeCombo_.setEnabled(!lp.unknownMultiCount);
            this.forceCombo_.setEnabled(!lp.unknownMultiCount);
        } else {
            this.pertValField_.setText(Double.toString(pdp.getValue()));
            this.measureTypeCombo_.setEnabled(true);
            this.forceCombo_.setEnabled(true);
        }
        String comment = pdp.getComment();
        this.commentField_.setText(comment == null ? "" : comment);
        TrueObjChoiceContent toccM = this.pd_.getMeasureDictionary().getMeasurementChoice(pdp.getMeasurementTypeKey());
        this.measureTypeCombo_.setSelectedItem(toccM);
        TrueObjChoiceContent toccf = pdp.getForcedSignificanceChoice();
        this.forceCombo_.setSelectedItem(toccf);
        String curr = pdp.getControl();
        if (curr == null) {
            UiUtil.initCombo(this.ctrlCombo_);
        } else {
            TrueObjChoiceContent toccCtrl = this.pd_.getConditionDictionary().getExprControlChoice(curr);
            this.ctrlCombo_.setSelectedItem(toccCtrl);
        }
        String date = pdp.getDate();
        this.dateField_.setText(date == null ? "" : date);
        this.batchKeyField_.setText(pdp.getBatchKey());
        this.footField_.setText(this.currAnnots_ == null ? "" : this.pd_.getFootnoteListAsNVString(this.currAnnots_));
        this.footField_.setCaretPosition(0);
        this.regResField_.setText(this.currRegRes_ == null ? "" : this.currRegRes_.getDisplayValue());
        this.regResField_.setCaretPosition(0);
        ArrayList loadVals = this.buildUserVals(this.pd_, pdp);
        this.etudf_.updateTable(true, loadVals);
        this.validate();
    }

    private Double getValue() {
        String newLevelTxt = this.pertValField_.getText();
        boolean badNum = false;
        double newVal = 0.0;
        if (newLevelTxt == null || newLevelTxt.trim().equals("")) {
            badNum = true;
        } else {
            try {
                newVal = Double.parseDouble(newLevelTxt);
            }
            catch (NumberFormatException nfe) {
                badNum = true;
            }
        }
        if (badNum) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("pdpe.badValueNumber"), rMan.getString("pdpe.badValueNumberTitle"), 0);
            return null;
        }
        return new Double(newVal);
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private List frozenAnnots;
        private PerturbationData.RegionRestrict frozenRegRes;
        private String idLabelText;
        private String commentFieldText;
        private String dateFieldText;
        private String batchKeyFieldText;
        private String pertValFieldText;
        private String legacyLabelText;
        private TrueObjChoiceContent sourceComboTocc;
        private TrueObjChoiceContent targComboTocc;
        private TrueObjChoiceContent forceComboTocc;
        private TrueObjChoiceContent ctrlComboTocc;
        private TrueObjChoiceContent measureTypeComboTocc;
        private List userValues;
        private List uvNames;

        MyFreezeDried() {
            this.idLabelText = PertDataPointEditPanel.this.idLabel_.getText();
            this.commentFieldText = PertDataPointEditPanel.this.commentField_.getText();
            this.dateFieldText = PertDataPointEditPanel.this.dateField_.getText();
            this.batchKeyFieldText = PertDataPointEditPanel.this.batchKeyField_.getText();
            this.pertValFieldText = PertDataPointEditPanel.this.pertValField_.getText();
            if (PertDataPointEditPanel.this.legacyLabel_ != null) {
                this.legacyLabelText = PertDataPointEditPanel.this.legacyLabel_.getText();
            }
            this.sourceComboTocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.sourceCombo_.getSelectedItem();
            this.targComboTocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.targCombo_.getSelectedItem();
            this.forceComboTocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.forceCombo_.getSelectedItem();
            this.ctrlComboTocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.ctrlCombo_.getSelectedItem();
            this.measureTypeComboTocc = (TrueObjChoiceContent)PertDataPointEditPanel.this.measureTypeCombo_.getSelectedItem();
            this.uvNames = new ArrayList(PertDataPointEditPanel.this.userCols_);
            int fc = this.uvNames.size();
            this.userValues = fc == 0 ? null : PertDataPointEditPanel.this.etudf_.getModel().getValuesFromTable();
            this.frozenAnnots = PertDataPointEditPanel.this.currAnnots_ == null ? null : new ArrayList(PertDataPointEditPanel.this.currAnnots_);
            this.frozenRegRes = PertDataPointEditPanel.this.currRegRes_ == null ? null : (PerturbationData.RegionRestrict)PertDataPointEditPanel.this.currRegRes_.clone();
        }

        public boolean needToCancel() {
            if (PertDataPointEditPanel.this.currKey_ != null && PertDataPointEditPanel.this.pd_.getDataPoint(PertDataPointEditPanel.this.currKey_) == null) {
                PertDataPointEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            PertDataPointEditPanel.this.idLabel_.setText(this.idLabelText);
            PertDataPointEditPanel.this.commentField_.setText(this.commentFieldText);
            PertDataPointEditPanel.this.dateField_.setText(this.dateFieldText);
            PertDataPointEditPanel.this.batchKeyField_.setText(this.batchKeyFieldText);
            PertDataPointEditPanel.this.pertValField_.setText(this.pertValFieldText);
            if (PertDataPointEditPanel.this.legacyLabel_ != null) {
                PertDataPointEditPanel.this.legacyLabel_.setText(this.legacyLabelText);
            }
            if (this.sourceComboTocc != null) {
                PertDataPointEditPanel.this.sourceCombo_.setSelectedItem(PertDataPointEditPanel.this.pd_.getExperimentChoice((String)this.sourceComboTocc.val));
            }
            if (this.targComboTocc != null) {
                PertDataPointEditPanel.this.targCombo_.setSelectedItem(PertDataPointEditPanel.this.pd_.getTargetChoiceContent((String)this.targComboTocc.val, true));
            }
            PertDataPointEditPanel.this.forceCombo_.setSelectedItem(this.forceComboTocc);
            if (this.measureTypeComboTocc != null) {
                TrueObjChoiceContent toccM = PertDataPointEditPanel.this.pd_.getMeasureDictionary().getMeasurementChoice((String)this.measureTypeComboTocc.val);
                PertDataPointEditPanel.this.measureTypeCombo_.setSelectedItem(toccM);
            }
            if (this.ctrlComboTocc == null || this.ctrlComboTocc.val == null) {
                UiUtil.initCombo(PertDataPointEditPanel.this.ctrlCombo_);
            } else {
                TrueObjChoiceContent toccCtrl = PertDataPointEditPanel.this.pd_.getConditionDictionary().getExprControlChoice((String)this.ctrlComboTocc.val);
                PertDataPointEditPanel.this.ctrlCombo_.setSelectedItem(toccCtrl);
            }
            this.recoverUserNameData();
            PertDataPointEditPanel.this.currAnnots_ = PertDataPointEditPanel.this.pmh_.fixupFrozenAnnot(this.frozenAnnots);
            PertDataPointEditPanel.this.footField_.setText(PertDataPointEditPanel.this.currAnnots_ == null ? "" : PertDataPointEditPanel.this.pd_.getFootnoteListAsNVString(PertDataPointEditPanel.this.currAnnots_));
            PertDataPointEditPanel.this.footField_.setCaretPosition(0);
            PertDataPointEditPanel.this.currRegRes_ = PertDataPointEditPanel.this.pmh_.fixupFrozenRegRes(this.frozenRegRes);
            PertDataPointEditPanel.this.regResField_.setText(PertDataPointEditPanel.this.currRegRes_ == null ? "" : PertDataPointEditPanel.this.currRegRes_.getDisplayValue());
            PertDataPointEditPanel.this.regResField_.setCaretPosition(0);
        }

        private void recoverUserNameData() {
            int fc = PertDataPointEditPanel.this.pd_.getUserFieldCount();
            ArrayList<String> loadVals = new ArrayList<String>();
            if (fc == 0) {
                loadVals.add("");
            } else {
                int i;
                String[] valList = ((UserFieldsTableModel.TableRow)this.userValues.get((int)0)).values;
                int savedNameCount = this.uvNames.size();
                boolean editAtMost = fc == savedNameCount;
                SortedSet notHit = new MinMax(0, fc - 1).getAsSortedSet();
                int danglingDataIndex = -1;
                HashMap<Integer, String> indexToVal = new HashMap<Integer, String>();
                for (i = 0; i < savedNameCount; ++i) {
                    String oldName = (String)this.uvNames.get(i);
                    Integer index = PertDataPointEditPanel.this.pd_.getUserFieldIndexFromNameAsInt(oldName);
                    if (index == null) {
                        if (!editAtMost) continue;
                        danglingDataIndex = i;
                        continue;
                    }
                    indexToVal.put(index, valList[i]);
                    notHit.remove(index);
                }
                for (i = 0; i < fc; ++i) {
                    String val = (String)indexToVal.get(new Integer(i));
                    if (indexToVal == null) {
                        val = (String)this.uvNames.get(danglingDataIndex);
                    }
                    loadVals.add(val == null ? "" : val);
                }
            }
            UserFieldsTableModel uftm = (UserFieldsTableModel)PertDataPointEditPanel.this.etudf_.getModel();
            UserFieldsTableModel.TableRow tr = uftm.new UserFieldsTableModel.TableRow();
            tr.load(loadVals);
            ArrayList<UserFieldsTableModel.TableRow> invRows = new ArrayList<UserFieldsTableModel.TableRow>();
            invRows.add(tr);
            PertDataPointEditPanel.this.etudf_.updateTable(true, invRows);
        }
    }

    static class UserFieldsTableModel
    extends EditableTable.TableModel {
        public UserFieldsTableModel(List columns, boolean haveFields) {
            super(columns.size());
            int numCol = this.columns_.length;
            this.colNames_ = new String[numCol];
            this.colClasses_ = new Class[numCol];
            this.canEdit_ = new boolean[numCol];
            for (int i = 0; i < numCol; ++i) {
                this.colNames_[i] = (String)columns.get(i);
                this.colClasses_[i] = class$java$lang$String == null ? PertDataPointEditPanel.class$("java.lang.String") : class$java$lang$String;
                this.canEdit_[i] = haveFields;
            }
        }

        public void resetColumns(List columns, boolean haveFields) {
            this.resetColumnCount(columns.size());
            int numCol = this.columns_.length;
            this.colNames_ = new String[numCol];
            this.colClasses_ = new Class[numCol];
            this.canEdit_ = new boolean[numCol];
            for (int i = 0; i < numCol; ++i) {
                this.colNames_[i] = (String)columns.get(i);
                this.colClasses_[i] = class$java$lang$String == null ? PertDataPointEditPanel.class$("java.lang.String") : class$java$lang$String;
                this.canEdit_[i] = haveFields;
            }
            this.fireTableStructureChanged();
        }

        public List getValuesFromTable() {
            ArrayList<TableRow> retval = new ArrayList<TableRow>();
            if (this.rowCount_ != 1) {
                throw new IllegalStateException();
            }
            TableRow ent = new TableRow(this.columns_.length);
            retval.add(ent);
            return retval;
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            Iterator rit = prsList.iterator();
            while (rit.hasNext()) {
                TableRow ent = (TableRow)rit.next();
                ent.toCols();
            }
        }

        public class TableRow {
            public String[] values;

            TableRow() {
            }

            void load(List vals) {
                int numVal = vals.size();
                this.values = new String[numVal];
                for (int i = 0; i < numVal; ++i) {
                    this.values[i] = (String)vals.get(i);
                }
            }

            TableRow(int numCols) {
                this.values = new String[numCols];
                for (int i = 0; i < numCols; ++i) {
                    this.values[i] = (String)UserFieldsTableModel.this.columns_[i].get(0);
                }
            }

            void toCols() {
                for (int i = 0; i < this.values.length; ++i) {
                    UserFieldsTableModel.this.columns_[i].add(this.values[i]);
                }
            }
        }
    }
}

