/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertDataPoint;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertDataAnnotAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertDataPointEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertRegRestrictAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertDataPointManagePanel
extends AnimatedSplitManagePanel
implements PertFilterPanel.Client,
PertFilterExpressionJumpTarget {
    public static final String MANAGER_KEY = "dataPts";
    public static final String DATA_ANNOT_KEY = "editDataAnnot";
    public static final String REG_RESTRICT_KEY = "editRegRestrict";
    private static final String DATA_KEY_ = "editData";
    private ReadOnlyTable rtd_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertDataPointEditPanel pdpep_;
    private PertDataAnnotAddOrEditPanel pdaep_;
    private PertRegRestrictAddOrEditPanel prraep_;
    private PertFilterPanel filtPanel_;
    private String currKey_;
    private String dupKey_;
    private PertFilterExpression currPfe_;
    private String[] stack_;
    private PertManageHelper pmh_;
    private JLabel tableLabel_;
    private String conversionKey_;
    private JComboBox displayScaleCombo_;
    private HashMap currentScaleState_;
    private boolean ignoreScaleChange_;
    private JLabel dispLab_;

    public PertDataPointManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, UndoManager undo, int legacyModes) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.filtPanel_ = new PertFilterPanel(pd, this);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.0);
        this.topPanel_.add((Component)this.filtPanel_, this.gbc_);
        JPanel display = new JPanel();
        display.setBorder(new EtchedBorder());
        display.setLayout(new GridBagLayout());
        this.dispLab_ = new JLabel(this.rMan_.getString("pertManage.chooseScale"));
        this.displayScaleCombo_ = new JComboBox();
        this.displayScaleCombo_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                try {
                    if (PertDataPointManagePanel.this.ignoreScaleChange_) {
                        return;
                    }
                    TrueObjChoiceContent useTocc = (TrueObjChoiceContent)PertDataPointManagePanel.this.displayScaleCombo_.getSelectedItem();
                    PertDataPointManagePanel.this.setDisplayScale((String)useTocc.val);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.initScalingState();
        UiUtil.gbcSet(this.gbc_, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        display.add((Component)this.dispLab_, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, 0, 9, 1, 0, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        display.add((Component)this.displayScaleCombo_, this.gbc_);
        this.rtd_ = new ReadOnlyTable();
        this.rtd_.rowElements = new ArrayList();
        this.rtd_.lateBinding(new PertDataTableModel(this.rtd_.rowElements), new ReadOnlyTable.EmptySelector());
        this.rtd_.setButtonHandler(new AnimatedSplitManagePanel.ButtonHand(DATA_KEY_));
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        tp.multiTableSelectionSyncing = null;
        tp.tableJLabel = this.tableLabel_ = new JLabel(this.rMan_.getString("pertManage.dataPointList"), 2);
        tp.titleFont = null;
        tp.colWidths = null;
        tp.userAddedButtons = new ArrayList();
        FixedJButton myButton = new FixedJButton(this.rMan_.getString("asmp.dupSelected"));
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertDataPointManagePanel.this.doADuplication(PertDataPointManagePanel.DATA_KEY_);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ReadOnlyTable.ExtraButton eb = new ReadOnlyTable.ExtraButton(false, true, false, myButton);
        tp.userAddedButtons.add(eb);
        JPanel tabPan = this.rtd_.buildReadOnlyTable(tp);
        UiUtil.gbcSet(this.gbc_, 0, 1, 10, 10, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        display.add((Component)tabPan, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.rowNum_ += 10;
        this.topPanel_.add((Component)display, this.gbc_);
        this.topPanel_.countOnlyMe(display);
        this.pdpep_ = new PertDataPointEditPanel(this.parent_, pd, this, DATA_KEY_, legacyModes);
        this.addEditPanel(this.pdpep_, DATA_KEY_);
        this.pdaep_ = new PertDataAnnotAddOrEditPanel(this.parent_, pd, this, DATA_ANNOT_KEY);
        this.addEditPanel(this.pdaep_, DATA_ANNOT_KEY);
        this.prraep_ = new PertRegRestrictAddOrEditPanel(this.parent_, pd, this, REG_RESTRICT_KEY, legacyModes);
        this.addEditPanel(this.prraep_, REG_RESTRICT_KEY);
        this.stack_ = new String[2];
        this.stack_[0] = DATA_KEY_;
        this.finishConstruction();
        this.filtPanel_.stockFilterPanel();
    }

    public boolean doScalingUpdate() {
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        Vector scaleTypes = md.getConvertibleScaleOptions();
        int numScaleTypes = scaleTypes.size();
        HashSet<Object> newOptions = new HashSet<Object>();
        for (int i = 0; i < numScaleTypes; ++i) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)scaleTypes.get(i);
            newOptions.add(tocc.val);
        }
        boolean unchanged = true;
        Set currKeys = this.currentScaleState_.keySet();
        if (newOptions.equals(currKeys)) {
            Iterator scit = currKeys.iterator();
            while (scit.hasNext()) {
                MeasureScale ms;
                String key = (String)scit.next();
                MeasureScale.Conversion conv = (MeasureScale.Conversion)this.currentScaleState_.get(key);
                if (conv.equals((ms = md.getMeasureScale(key)).getConvToFold())) continue;
                unchanged = false;
                break;
            }
        } else {
            unchanged = false;
        }
        if (unchanged) {
            return false;
        }
        this.currentScaleState_ = this.generateScalingState(scaleTypes);
        ResourceManager rMan = ResourceManager.getManager();
        TrueObjChoiceContent nativeTocc = new TrueObjChoiceContent(rMan.getString("pertManage.nativeScaling"), null);
        scaleTypes.add(0, nativeTocc);
        TrueObjChoiceContent saveScaleComboTocc = (TrueObjChoiceContent)this.displayScaleCombo_.getSelectedItem();
        String selectedKey = (String)saveScaleComboTocc.val;
        this.ignoreScaleChange_ = true;
        UiUtil.replaceComboItems(this.displayScaleCombo_, scaleTypes);
        TrueObjChoiceContent toccScale = selectedKey == null || scaleTypes.size() == 1 || md.getMeasureScale(selectedKey) == null ? nativeTocc : md.getScaleChoice(selectedKey);
        this.displayScaleCombo_.setSelectedItem(toccScale);
        this.ignoreScaleChange_ = false;
        this.setDisplayScale((String)toccScale.val);
        return true;
    }

    public void setDisplayScale(String key) {
        boolean change = key == null ? this.conversionKey_ != null : !key.equals(this.conversionKey_);
        this.conversionKey_ = key;
        if (change) {
            this.displayProperties(true);
        }
    }

    public void jumpWithNewFilter(PertFilterExpression pfe) {
        this.filtPanel_.setCurrentSettings(pfe);
        this.installNewFilter(pfe);
    }

    public void installNewFilter(PertFilterExpression pfe) {
        this.currPfe_ = pfe;
        this.displayProperties(true);
    }

    public void editIsComplete(String key, int what) {
        String resultKey = this.currKey_;
        if (key.equals(DATA_KEY_)) {
            PertDataPoint pdp = this.pdpep_.getResult();
            List annotResult = this.pdpep_.getUpdatedAnnotResult();
            PerturbationData.RegionRestrict rrResult = this.pdpep_.getUpdatedRegionRestrictionResult();
            ArrayList userV = this.pdpep_.getUserVals();
            UndoSupport support = new UndoSupport(this.undom_, this.currKey_ == null ? "undo.createDataPoint" : "undo.editDataPoint");
            if (this.currKey_ == null) {
                resultKey = pdp.getID();
            }
            PertDataChange pdc = this.pd_.setDataPoint(pdp);
            support.addEdit(new PertDataChangeCmd(pdc));
            boolean allEmpty = true;
            int numV = userV == null ? 0 : userV.size();
            for (int i = 0; i < numV; ++i) {
                String val = (String)userV.get(i);
                if (val.trim().equals("")) continue;
                allEmpty = false;
            }
            userV = allEmpty ? null : new ArrayList(userV);
            pdc = this.pd_.setUserFieldValues(resultKey, userV);
            if (pdc != null) {
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if ((pdc = this.pd_.setFootnotesForDataPoint(resultKey, annotResult)) != null) {
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            if ((pdc = this.pd_.setRegionRestrictionForDataPoint(resultKey, rrResult)) != null) {
                support.addEdit(new PertDataChangeCmd(pdc));
            }
            support.addEvent(new GeneralChangeEvent(3));
            this.pet_.editSubmissionBegins();
            support.finish();
            this.pet_.editSubmissionEnds();
        } else if (key.equals(DATA_ANNOT_KEY)) {
            this.pdpep_.updateAnnotations(this.pdaep_.getResult());
        } else if (key.equals(REG_RESTRICT_KEY)) {
            this.pdpep_.updateRegionRestriction(this.prraep_.getResult());
        } else {
            throw new IllegalArgumentException();
        }
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    public void editIsPushed(String key) {
        String pushKey;
        int pushMode = this.pdpep_.getMode();
        String string = pushKey = pushMode == 1 ? this.currKey_ : this.dupKey_;
        if (key.equals(DATA_ANNOT_KEY)) {
            this.stack_[1] = DATA_ANNOT_KEY;
            this.setEditStack(this.stack_);
            this.pdaep_.setAnnots(pushKey, this.pdpep_.getUpdatedAnnotResult(), pushMode);
            this.pdaep_.startAPush();
        } else if (key.equals(REG_RESTRICT_KEY)) {
            this.stack_[1] = REG_RESTRICT_KEY;
            this.setEditStack(this.stack_);
            this.prraep_.setSources(pushKey, this.pdpep_.getUpdatedRegionRestrictionResult(), pushMode);
            this.prraep_.startAPush();
        } else {
            throw new IllegalArgumentException();
        }
        super.editIsPushed(key);
    }

    public void finished() {
        this.rtd_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.filtPanel_.stockFilterPanel();
        PertFilterExpression pfe = this.filtPanel_.buildPertFilterExpr();
        this.installNewFilter(pfe);
        this.pdaep_.hotUpdate(mustDie);
        this.prraep_.hotUpdate(mustDie);
        this.pdpep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.pdaep_.closeAction();
        this.prraep_.closeAction();
        this.pdpep_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(DATA_KEY_)) {
            PdEntry pse = (PdEntry)obj;
            return pse.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (whichTable.equals(DATA_KEY_)) {
            this.pmh_.selectTableRow(this.rtd_, whichKey, this, DATA_KEY_);
        } else if (!whichTable.equals(DATA_ANNOT_KEY) && !whichTable.equals(REG_RESTRICT_KEY)) {
            throw new IllegalArgumentException();
        }
    }

    public void doADuplication(String key) {
        String useKey = ((PertDataTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        this.currKey_ = null;
        this.dupKey_ = useKey;
        this.pdpep_.setDataPointForDup(this.dupKey_);
        this.pdpep_.startEditing();
    }

    protected void enableTopPane(boolean enable) {
        this.dispLab_.setEnabled(enable);
        this.displayScaleCombo_.setEnabled(enable);
        this.rtd_.setEnabled(enable);
        this.filtPanel_.enableFilters(enable);
    }

    protected void displayProperties(boolean fireChange) {
        String yesStr = this.rMan_.getString("pertManage.yes");
        String noStr = this.rMan_.getString("pertManage.no");
        List pertData = this.pd_.getPerturbations(this.currPfe_);
        List selKeys = this.rtd_.selectedRows == null ? null : ((PertDataTableModel)this.rtd_.getModel()).getSelectedKeys(this.rtd_.selectedRows);
        this.rtd_.rowElements.clear();
        int numPert = pertData.size();
        for (int i = 0; i < numPert; ++i) {
            PertDataPoint pdp = (PertDataPoint)pertData.get(i);
            this.rtd_.rowElements.add(new PdEntry(pdp, this.pd_, yesStr, noStr));
        }
        this.filtPanel_.updateFilterRenderers(pertData);
        this.pmh_.updateAndReselect(fireChange, this.rtd_, this, DATA_KEY_, selKeys);
        String format = this.rMan_.getString("pertManage.dataPointListFormat");
        String desc = MessageFormat.format(format, new Integer(numPert));
        this.tableLabel_.setText(desc);
        this.tableLabel_.invalidate();
        this.tableLabel_.validate();
    }

    protected void doAnAdd(String key) {
        this.currKey_ = null;
        this.rtd_.clearSelections(false);
        this.pdpep_.setDataPoint(this.currKey_);
        this.pdpep_.startEditing();
    }

    protected void doAnEdit(String key) {
        this.currKey_ = ((PertDataTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        this.pdpep_.setDataPoint(this.currKey_);
        this.pdpep_.startEditing();
    }

    protected void doADelete(String key) {
        String delKey = ((PertDataTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertDataPoint");
        PertDataChange pdc = this.pd_.deleteDataPoint(delKey);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.pet_.itemDeleted(DATA_KEY_);
    }

    private void initScalingState() {
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        Vector scaleTypes = md.getConvertibleScaleOptions();
        this.currentScaleState_ = this.generateScalingState(scaleTypes);
        this.ignoreScaleChange_ = true;
        ResourceManager rMan = ResourceManager.getManager();
        TrueObjChoiceContent nativeTocc = new TrueObjChoiceContent(rMan.getString("pertManage.nativeScaling"), null);
        scaleTypes.add(0, nativeTocc);
        UiUtil.replaceComboItems(this.displayScaleCombo_, scaleTypes);
        this.ignoreScaleChange_ = false;
    }

    private HashMap generateScalingState(Vector scaleTypes) {
        HashMap<Object, MeasureScale.Conversion> retval = new HashMap<Object, MeasureScale.Conversion>();
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        int numScaleTypes = scaleTypes.size();
        for (int i = 0; i < numScaleTypes; ++i) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)scaleTypes.get(i);
            MeasureScale ms = md.getMeasureScale((String)tocc.val);
            retval.put(tocc.val, ms.getConvToFold());
        }
        return retval;
    }

    private class PdEntry {
        String perts;
        String time;
        String invest;
        String target;
        String value;
        String forced;
        String control;
        String tech;
        String comment;
        String batch;
        String date;
        String footnote;
        String regRes;
        String key;

        PdEntry(PertDataPoint pdp, PerturbationData pd, String yesStr, String noStr) {
            List footList;
            Boolean forcedObj;
            this.key = pdp.getID();
            this.invest = pdp.getInvestigatorDisplayString(pd);
            if (this.invest == null) {
                this.invest = "";
            }
            this.perts = pdp.getPertDisplayString(pd, 2);
            if (this.perts == null) {
                this.perts = "";
            }
            this.time = pdp.getTimeDisplayString(pd, false, false);
            if (this.time == null) {
                this.time = "";
            }
            this.target = pd.getAnnotatedTargetDisplay(pdp.getTargetKey());
            if (this.target == null) {
                this.target = "";
            }
            this.value = pdp.getScaledDisplayValue(PertDataPointManagePanel.this.conversionKey_, PertDataPointManagePanel.this.pd_, true);
            if (this.value == null) {
                this.value = "";
            }
            this.forced = (forcedObj = pdp.getForcedSignificance()) == null ? "" : (forcedObj != false ? yesStr : noStr);
            String controlKey = pdp.getControl();
            this.control = controlKey == null ? "" : PertDataPointManagePanel.this.pd_.getConditionDictionary().getExprControl(controlKey).getDisplayString();
            this.tech = pdp.getMeasurementDisplayString(pd);
            if (this.tech == null) {
                this.tech = "";
            }
            this.comment = pdp.getComment();
            if (this.comment == null) {
                this.comment = "";
            }
            this.batch = pdp.getBatchKey();
            if (this.batch == null) {
                this.batch = "";
            }
            this.date = pdp.getDate();
            if (this.date == null) {
                this.date = "";
            }
            this.footnote = (footList = pd.getDataPointNotes(this.key)) == null ? "" : pd.getFootnoteListAsString(footList);
            PerturbationData.RegionRestrict rr = pdp.getRegionRestriction(pd);
            this.regRes = rr != null ? rr.getDisplayValue() : "";
        }
    }

    class PertDataTableModel
    extends ReadOnlyTable.TableModel {
        private static final int PERT_ = 0;
        private static final int TARGET_ = 1;
        private static final int TIME_ = 2;
        private static final int VALUE_ = 3;
        private static final int FORCED_ = 4;
        private static final int CTRL_ = 5;
        private static final int TECH_ = 6;
        private static final int INVEST_ = 7;
        private static final int BATCH_ = 8;
        private static final int DATE_ = 9;
        private static final int FOOTS_ = 10;
        private static final int COMMENT_ = 11;
        private static final int REG_RESTRICT_ = 12;
        private static final int NUM_COL_ = 13;
        private ArrayList hidden_;

        PertDataTableModel(List prsList) {
            super(13);
            this.hidden_ = new ArrayList();
            this.colNames_ = new String[]{"pertData.pert", "pertData.target", "pertData.time", "pertData.value", "pertData.forced", "pertData.control", "pertData.technology", "pertData.invest", "pertData.batch", "pertData.date", "pertData.foots", "pertData.comment", "pertData.regRes"};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new PertManageHelper.TimeComparator(), new PertManageHelper.DoubleStrComparator(), String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER};
            this.extractValues(prsList);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hidden_.clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                PdEntry pde = (PdEntry)iit.next();
                this.columns_[0].add(pde.perts);
                this.columns_[1].add(pde.target);
                this.columns_[2].add(pde.time);
                this.columns_[3].add(pde.value);
                this.columns_[4].add(pde.forced);
                this.columns_[5].add(pde.control);
                this.columns_[6].add(pde.tech);
                this.columns_[7].add(pde.invest);
                this.columns_[8].add(pde.batch);
                this.columns_[9].add(pde.date);
                this.columns_[10].add(pde.footnote);
                this.columns_[11].add(pde.comment);
                this.columns_[12].add(pde.regRes);
                this.hidden_.add(pde.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hidden_.get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hidden_.get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

