/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.ExperimentConditions;
import org.systemsbiology.biotapestry.perturb.ExperimentControl;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSimpleNameEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertExpSetupManagePanel
extends AnimatedSplitManagePanel
implements PertSimpleNameEditPanel.Client {
    public static final String MANAGER_KEY = "expSetup";
    public static final String EXC_KEY = "editExC";
    public static final String CONTROL_KEY = "editControl";
    private ReadOnlyTable rtexco_;
    private ReadOnlyTable rtctrl_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertSimpleNameEditPanel excep_;
    private PertSimpleNameEditPanel ctrlep_;
    private String pendingKey_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;

    public PertExpSetupManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        ArrayList<ReadOnlyTable> allTabs = new ArrayList<ReadOnlyTable>();
        this.rtexco_ = new ReadOnlyTable(new PertManageHelper.NameWithHiddenIDAndRefCountModel("pmsm.condition"), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtexco_);
        this.rtctrl_ = new ReadOnlyTable(new PertManageHelper.NameWithHiddenIDAndRefCountModel("pmsm.control"), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtctrl_);
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 150, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 50, 100));
        JPanel excPanel = this.commonTableBuild(this.rtexco_, "pmsmp.expConditions", new AnimatedSplitManagePanel.ButtonHand(EXC_KEY), allTabs, colWidths, EXC_KEY);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)excPanel, this.gbc_);
        JPanel ctrlPanel = this.commonTableBuild(this.rtctrl_, "pmsmp.expControls", new AnimatedSplitManagePanel.ButtonHand(CONTROL_KEY), allTabs, colWidths, CONTROL_KEY);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_++, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)ctrlPanel, this.gbc_);
        this.excep_ = new PertSimpleNameEditPanel(this.parent_, this, "pmsmp.conditionName", this, EXC_KEY);
        this.addEditPanel(this.excep_, EXC_KEY);
        this.ctrlep_ = new PertSimpleNameEditPanel(this.parent_, this, "pmsmp.controlName", this, CONTROL_KEY);
        this.addEditPanel(this.ctrlep_, CONTROL_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public String getNameForKey(String whoAmI, String key) {
        if (whoAmI.equals(EXC_KEY)) {
            return this.pd_.getConditionDictionary().getExprConditions(key).getDescription();
        }
        if (whoAmI.equals(CONTROL_KEY)) {
            return this.pd_.getConditionDictionary().getExprControl(key).getDescription();
        }
        throw new IllegalArgumentException();
    }

    public boolean haveDuplication(String whoAmI, String key, String name) {
        String existingKey;
        if (whoAmI.equals(EXC_KEY)) {
            existingKey = this.pd_.getConditionDictionary().getConditionKeyFromName(name);
        } else if (whoAmI.equals(CONTROL_KEY)) {
            existingKey = this.pd_.getConditionDictionary().getControlKeyFromName(name);
        } else {
            throw new IllegalArgumentException();
        }
        if (existingKey == null) {
            return false;
        }
        if (this.joinKeys_ == null) {
            return key == null || !existingKey.equals(key);
        }
        return !this.joinKeys_.contains(existingKey);
    }

    public boolean haveDisconnect(String whoAmI, String key, String name) {
        return false;
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(EXC_KEY)) {
            if (this.joinKeys_ == null) {
                this.editCondition(key, what);
            } else {
                this.joinConditions(key, what);
            }
        } else if (key.equals(CONTROL_KEY)) {
            if (this.joinKeys_ == null) {
                this.editControl(key, what);
            } else {
                this.joinControls(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtexco_.makeCurrentSelectionVisible();
        this.rtctrl_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.excep_.hotUpdate(mustDie);
        this.ctrlep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.excep_.closeAction();
        this.ctrlep_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(EXC_KEY) || tableID.equals(CONTROL_KEY)) {
            PertManageHelper.ToccWithRefCount twrc = (PertManageHelper.ToccWithRefCount)obj;
            return twrc.tocc.val.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (whichTable.equals(EXC_KEY)) {
            this.pmh_.selectTableRow(this.rtexco_, whichKey, this, EXC_KEY);
        } else if (whichTable.equals(CONTROL_KEY)) {
            this.pmh_.selectTableRow(this.rtctrl_, whichKey, this, CONTROL_KEY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doADuplication(String key) {
        if (key.equals(EXC_KEY)) {
            String useKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKey(this.rtexco_.selectedRows);
            ConditionDictionary cd = this.pd_.getConditionDictionary();
            String copyName = this.pmh_.getUnique(cd.getExprConditionsOptions(), cd.getExprConditions(useKey).getDescription());
            this.pendingKey_ = null;
            this.excep_.setDupName(copyName);
            this.excep_.startEditing();
        } else if (key.equals(CONTROL_KEY)) {
            String useKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKey(this.rtctrl_.selectedRows);
            ConditionDictionary cd = this.pd_.getConditionDictionary();
            String copyName = this.pmh_.getUnique(cd.getExprControlOptions(), cd.getExprControl(useKey).getDescription());
            this.pendingKey_ = null;
            this.ctrlep_.setDupName(copyName);
            this.ctrlep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doAJoin(String key) {
        if (key.equals(EXC_KEY)) {
            this.joinKeys_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKeys(this.rtexco_.selectedRows);
            ConditionDictionary cd = this.pd_.getConditionDictionary();
            String stdco = cd.getStandardConditionKey();
            if (this.joinKeys_.contains(stdco)) {
                this.pendingKey_ = stdco;
            } else {
                DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
                Map refCounts = da.getAllExprConditionReferenceCounts();
                this.pendingKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
            }
            TreeSet<String> nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int numk = this.joinKeys_.size();
            for (int i = 0; i < numk; ++i) {
                String nextJk = (String)this.joinKeys_.get(i);
                nameOptions.add(cd.getExprConditions(nextJk).getDescription());
            }
            this.excep_.setMergeName(this.pendingKey_, nameOptions, new ArrayList(this.joinKeys_));
            this.excep_.startEditing();
        } else if (key.equals(CONTROL_KEY)) {
            this.joinKeys_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKeys(this.rtctrl_.selectedRows);
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            Map refCounts = da.getAllExprControlReferenceCounts();
            this.pendingKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
            TreeSet<String> nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int numk = this.joinKeys_.size();
            ConditionDictionary cd = this.pd_.getConditionDictionary();
            for (int i = 0; i < numk; ++i) {
                String nextJk = (String)this.joinKeys_.get(i);
                nameOptions.add(cd.getExprControl(nextJk).getDescription());
            }
            this.ctrlep_.setMergeName(this.pendingKey_, nameOptions, new ArrayList(this.joinKeys_));
            this.ctrlep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doAFilterJump(String key) {
        if (key.equals(EXC_KEY)) {
            String filterKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKey(this.rtexco_.selectedRows);
            PertFilter filter = new PertFilter(11, 0, filterKey);
            PertFilterExpression pfe = new PertFilterExpression(filter);
            this.pfet_.jumpWithNewFilter(pfe);
        } else if (key.equals(CONTROL_KEY)) {
            String filterKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKey(this.rtctrl_.selectedRows);
            PertFilter filter = new PertFilter(10, 0, filterKey);
            PertFilterExpression pfe = new PertFilterExpression(filter);
            this.pfet_.jumpWithNewFilter(pfe);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void enableTopPane(boolean enable) {
        this.rtexco_.setEnabled(enable);
        this.rtctrl_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtexco_.selectedRows == null ? null : ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKeys(this.rtexco_.selectedRows);
        this.rtexco_.rowElements.clear();
        Vector eco = this.pd_.getConditionDictionary().getExprConditionsOptions();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map sdrefs = da.getAllExprConditionReferenceCounts();
        Integer noCount = new Integer(0);
        Iterator ecit = eco.iterator();
        while (ecit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)ecit.next();
            Integer count = (Integer)sdrefs.get(tocc.val);
            if (count == null) {
                count = noCount;
            }
            PertManageHelper.ToccWithRefCount twrc = new PertManageHelper.ToccWithRefCount(tocc, count);
            this.rtexco_.rowElements.add(twrc);
        }
        this.pmh_.updateAndReselect(fireChange, this.rtexco_, this, EXC_KEY, selKeys);
        selKeys = this.rtctrl_.selectedRows == null ? null : ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKeys(this.rtctrl_.selectedRows);
        this.rtctrl_.rowElements.clear();
        Vector ectrl = this.pd_.getConditionDictionary().getExprControlOptions();
        Map ctrlRefs = da.getAllExprControlReferenceCounts();
        Iterator ecrlit = ectrl.iterator();
        while (ecrlit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)ecrlit.next();
            Integer count = (Integer)ctrlRefs.get(tocc.val);
            if (count == null) {
                count = noCount;
            }
            PertManageHelper.ToccWithRefCount twrc = new PertManageHelper.ToccWithRefCount(tocc, count);
            this.rtctrl_.rowElements.add(twrc);
        }
        this.pmh_.updateAndReselect(fireChange, this.rtctrl_, this, CONTROL_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (key.equals(EXC_KEY)) {
            this.pendingKey_ = null;
            this.rtexco_.clearSelections(false);
            this.rtctrl_.clearSelections(false);
            this.excep_.setEditName(this.pendingKey_);
            this.excep_.startEditing();
        } else if (key.equals(CONTROL_KEY)) {
            this.pendingKey_ = null;
            this.rtexco_.clearSelections(false);
            this.rtctrl_.clearSelections(false);
            this.ctrlep_.setEditName(this.pendingKey_);
            this.ctrlep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doAnEdit(String key) {
        if (key.equals(EXC_KEY)) {
            String std;
            String selKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKey(this.rtexco_.selectedRows);
            if (selKey.equals(std = this.pd_.getConditionDictionary().getStandardConditionKey())) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotEditDefault"), this.rMan_.getString("pmsmp.cannotEditDefaultTitle"), 0);
                return;
            }
            this.pendingKey_ = selKey;
            this.excep_.setEditName(this.pendingKey_);
            this.excep_.startEditing();
        } else if (key.equals(CONTROL_KEY)) {
            this.pendingKey_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKey(this.rtctrl_.selectedRows);
            this.ctrlep_.setEditName(this.pendingKey_);
            this.ctrlep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doADelete(String key) {
        if (key.equals(EXC_KEY)) {
            String std;
            String selKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtexco_.getModel()).getSelectedKey(this.rtexco_.selectedRows);
            if (selKey.equals(std = this.pd_.getConditionDictionary().getStandardConditionKey())) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotDeleteDefault"), this.rMan_.getString("pmsmp.cannotDeleteDefaultTitle"), 0);
                return;
            }
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            DependencyAnalyzer.Dependencies refs = da.getExprConditionReferenceSet(selKey);
            if (!this.pmh_.warnAndAsk(refs)) {
                return;
            }
            UndoSupport support = new UndoSupport(this.undom_, "undo.deleteExprCondition");
            da.killOffDependencies(refs, support);
            PertDataChange pdc = this.pd_.deleteExperimentConditions(selKey);
            support.addEdit(new PertDataChangeCmd(pdc));
            support.addEvent(new GeneralChangeEvent(3));
            this.pet_.editSubmissionBegins();
            support.finish();
            this.pet_.editSubmissionEnds();
            this.pet_.itemDeleted(EXC_KEY);
        } else if (key.equals(CONTROL_KEY)) {
            String selKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtctrl_.getModel()).getSelectedKey(this.rtctrl_.selectedRows);
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            DependencyAnalyzer.Dependencies refs = da.getExprControlReferenceSet(selKey);
            if (!this.pmh_.warnAndAsk(refs)) {
                return;
            }
            UndoSupport support = new UndoSupport(this.undom_, "undo.deleteExprControl");
            da.killOffDependencies(refs, support);
            PertDataChange pdc = this.pd_.deleteExperimentControl(selKey);
            support.addEdit(new PertDataChangeCmd(pdc));
            support.addEvent(new GeneralChangeEvent(3));
            this.pet_.editSubmissionBegins();
            support.finish();
            this.pet_.editSubmissionEnds();
            this.pet_.itemDeleted(CONTROL_KEY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void joinControls(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        String name = this.ctrlep_.getResult();
        ConditionDictionary ecd = this.pd_.getConditionDictionary();
        ExperimentControl revisedECtrl = (ExperimentControl)ecd.getExprControl(this.pendingKey_).clone();
        revisedECtrl.setDescription(name);
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergeExpControls");
        DependencyAnalyzer.Dependencies refs = da.getExprControlMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeExprControls(this.joinKeys_, this.pendingKey_, revisedECtrl);
        for (int i = 0; i < pdc.length; ++i) {
            support.addEdit(new PertDataChangeCmd(pdc[i]));
        }
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        this.joinKeys_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void joinConditions(String key, int what) {
        ExperimentConditions stdCond;
        ConditionDictionary ecd = this.pd_.getConditionDictionary();
        String std = ecd.getStandardConditionKey();
        boolean mustMatchStd = this.joinKeys_.contains(std);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        String name = this.excep_.getResult();
        ExperimentConditions revisedECond = (ExperimentConditions)ecd.getExprConditions(this.pendingKey_).clone();
        revisedECond.setDescription(name);
        if (mustMatchStd && !revisedECond.equals(stdCond = ecd.getExprConditions(std))) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotChangeStd"), this.rMan_.getString("pmsmp.cannotChangeStdTitle"), 0);
            return;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergeExprConditions");
        DependencyAnalyzer.Dependencies refs = da.getExprConditionMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeExprConditions(this.joinKeys_, this.pendingKey_, revisedECond);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editCondition(String key, int what) {
        ExperimentConditions revisedEC;
        String name = this.excep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createConditionName" : "undo.editConditionName");
        ConditionDictionary ecd = this.pd_.getConditionDictionary();
        if (this.pendingKey_ == null) {
            this.pendingKey_ = ecd.getNextDataKey();
            revisedEC = new ExperimentConditions(this.pendingKey_, name);
        } else {
            revisedEC = (ExperimentConditions)ecd.getExprConditions(this.pendingKey_).clone();
            revisedEC.setDescription(name);
        }
        PertDataChange pdc = this.pd_.setExperimentConditions(revisedEC);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editControl(String key, int what) {
        ExperimentControl revisedECtrl;
        String name = this.ctrlep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createExpControl" : "undo.editExpControl");
        ConditionDictionary ecd = this.pd_.getConditionDictionary();
        if (this.pendingKey_ == null) {
            this.pendingKey_ = ecd.getNextDataKey();
            revisedECtrl = new ExperimentControl(this.pendingKey_, name);
        } else {
            revisedECtrl = (ExperimentControl)ecd.getExprControl(this.pendingKey_).clone();
            revisedECtrl.setDescription(name);
        }
        PertDataChange pdc = this.pd_.setExperimentControl(revisedECtrl);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }
}

