/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.ConditionDictionary;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertExperimentAddOrEditPanel
extends AnimatedSplitEditPanel {
    private Experiment expResult_;
    private PerturbationData pd_;
    private ArrayList pertSrcList_;
    private ArrayList investList_;
    private JTextField timeFieldForEdit_;
    private JTextField legacyMaxTimeFieldForEdit_;
    private JComboBox condsComboForEdit_;
    private JComboBox timeCombo_;
    private JComboBox legacyMaxTimeCombo_;
    private JComboBox condsComboForMerge_;
    private EditableTable estInvForEdit_;
    private EditableTable estSrcForEdit_;
    private EditableTable estInvForMerge_;
    private EditableTable estSrcForMerge_;
    private String currKey_;
    private HashSet allMerge_;
    private PertManageHelper pmh_;
    private TreeSet timeOptions_;
    private TreeSet legMaxTimeOptions_;

    public PertExperimentAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey, int legacyModes) {
        super(parent, pet, myKey, 2);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.pertSrcList_ = new ArrayList();
        this.investList_ = new ArrayList();
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        int editRow = 0;
        JPanel[] tabPans = this.buildTables(false);
        JPanel tAndCPan = this.buildTimeAndCond(false, legacyModes);
        UiUtil.gbcSet(this.gbc_, 0, editRow, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.5);
        editPanel.add((Component)tabPans[0], this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, editRow, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.5);
        editPanel.add((Component)tabPans[1], this.gbc_);
        editRow += 2;
        UiUtil.gbcSet(this.gbc_, 0, editRow++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        editPanel.add((Component)tAndCPan, this.gbc_);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        int mergeRow = 0;
        tabPans = this.buildTables(true);
        tAndCPan = this.buildTimeAndCond(true, legacyModes);
        UiUtil.gbcSet(this.gbc_, 0, mergeRow, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.5);
        mergePanel.add((Component)tabPans[0], this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, mergeRow, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.5);
        mergePanel.add((Component)tabPans[1], this.gbc_);
        mergeRow += 2;
        UiUtil.gbcSet(this.gbc_, 0, mergeRow++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        mergePanel.add((Component)tAndCPan, this.gbc_);
        this.makeMultiMode(editPanel, mergePanel, 3);
        this.finishConstruction();
    }

    public void setSources(String currKey) {
        this.mode_ = 1;
        this.currKey_ = currKey;
        this.allMerge_ = null;
        this.displayProperties();
    }

    public void setSourcesForDup(String origKey) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        this.allMerge_ = null;
        this.displayProperties();
    }

    public String setExperimentsForMerge(List joinKeys) {
        this.mode_ = 2;
        this.allMerge_ = new HashSet(joinKeys);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map refCounts = da.getAllExperimentReferenceCounts();
        this.currKey_ = this.pmh_.getMostUsedKey(refCounts, joinKeys);
        this.timeOptions_ = new TreeSet();
        this.legMaxTimeOptions_ = new TreeSet();
        int numk = joinKeys.size();
        for (int i = 0; i < numk; ++i) {
            String nextJk = (String)joinKeys.get(i);
            Experiment exp = this.pd_.getExperiment(nextJk);
            this.timeOptions_.add(Integer.toString(exp.getTime()));
            int legMax = exp.getLegacyMaxTime();
            String legString = legMax == -1 ? "" : Integer.toString(legMax);
            this.legMaxTimeOptions_.add(legString);
        }
        this.displayProperties();
        return this.currKey_;
    }

    public Experiment getResult() {
        return this.expResult_;
    }

    public void closeAction() {
        if (this.mode_ == 2) {
            this.estSrcForMerge_.stopTheEditing(false);
            this.estInvForMerge_.stopTheEditing(false);
        } else {
            this.estSrcForEdit_.stopTheEditing(false);
            this.estInvForEdit_.stopTheEditing(false);
        }
        super.closeAction();
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        this.pertSrcList_ = this.buildPertSourceEnum();
        HashMap<Integer, EditableTable.EnumCellInfo> perColumnEnums = new HashMap<Integer, EditableTable.EnumCellInfo>();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.pertSrcList_));
        EditableTable useTable = this.mode_ == 2 ? this.estSrcForMerge_ : this.estSrcForEdit_;
        useTable.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)useTable.getModel()).setCurrentEnums(this.pertSrcList_);
        this.investList_ = this.buildInvestEnum();
        perColumnEnums = new HashMap();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.investList_));
        EditableTable useInvTable = this.mode_ == 2 ? this.estInvForMerge_ : this.estInvForEdit_;
        useInvTable.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)useInvTable.getModel()).setCurrentEnums(this.investList_);
        ConditionDictionary cd = this.pd_.getConditionDictionary();
        Vector condTypes = cd.getExprConditionsOptions();
        JComboBox useCombo = this.mode_ == 2 ? this.condsComboForMerge_ : this.condsComboForEdit_;
        UiUtil.replaceComboItems(useCombo, condTypes);
        if (this.mode_ == 2) {
            UiUtil.replaceComboItems(this.timeCombo_, new Vector(this.timeOptions_));
            if (this.legacyMaxTimeCombo_ != null) {
                UiUtil.replaceComboItems(this.legacyMaxTimeCombo_, new Vector(this.legMaxTimeOptions_));
            }
        }
    }

    protected boolean stashResults() {
        ArrayList<String> invResult;
        ArrayList<String> srcsResult;
        String timeText;
        boolean badNum = false;
        int timeVal = -1;
        int maxLegVal = -1;
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.timeCombo_.getEditor().getEditorComponent();
            timeText = jtc.getText().trim();
        } else {
            timeText = this.timeFieldForEdit_.getText().trim();
        }
        String legacyMaxText = null;
        if (this.mode_ == 2) {
            if (this.legacyMaxTimeCombo_ != null && this.legacyMaxTimeCombo_.isEnabled()) {
                JTextComponent jtc = (JTextComponent)this.legacyMaxTimeCombo_.getEditor().getEditorComponent();
                legacyMaxText = jtc.getText().trim();
            }
        } else if (this.legacyMaxTimeFieldForEdit_ != null && this.legacyMaxTimeFieldForEdit_.isEnabled()) {
            legacyMaxText = this.legacyMaxTimeFieldForEdit_.getText().trim();
        }
        if (legacyMaxText != null && legacyMaxText.equals("")) {
            legacyMaxText = null;
        }
        try {
            timeVal = Integer.parseInt(timeText);
            if (timeVal < 0) {
                badNum = true;
            }
            if (legacyMaxText != null) {
                maxLegVal = Integer.parseInt(legacyMaxText);
            }
            if (maxLegVal != -1 && timeVal > maxLegVal) {
                badNum = true;
            }
        }
        catch (NumberFormatException nfex) {
            badNum = true;
        }
        if (badNum) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("peaep.badNumber"), this.rMan_.getString("peaep.badNumberTitle"), 0);
            return false;
        }
        EditableTable useTable = this.mode_ == 2 ? this.estSrcForMerge_ : this.estSrcForEdit_;
        Iterator sit = useTable.getModel().getValuesFromTable().iterator();
        if (!sit.hasNext()) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("peaep.emptySrcList"), this.rMan_.getString("peaep.emptySrcListTitle"), 0);
            return false;
        }
        ArrayList<String> arrayList = srcsResult = sit.hasNext() ? new ArrayList<String>() : null;
        while (sit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)sit.next();
            EnumCell ec = ent.enumChoice;
            if (srcsResult.contains(ec.internal)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("peaep.dupSource"), this.rMan_.getString("peaep.dupSourceTitle"), 0);
                return false;
            }
            srcsResult.add(ec.internal);
        }
        PertSources srcs = new PertSources(srcsResult);
        EditableTable useInvTable = this.mode_ == 2 ? this.estInvForMerge_ : this.estInvForEdit_;
        Iterator ivit = useInvTable.getModel().getValuesFromTable().iterator();
        ArrayList<String> arrayList2 = invResult = ivit.hasNext() ? new ArrayList<String>() : null;
        while (ivit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)ivit.next();
            EnumCell ec = ent.enumChoice;
            if (invResult.contains(ec.internal)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("peaep.dupInvest"), this.rMan_.getString("peaep.dupInvestTitle"), 0);
                return false;
            }
            invResult.add(ec.internal);
        }
        JComboBox useCombo = this.mode_ == 2 ? this.condsComboForMerge_ : this.condsComboForEdit_;
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)useCombo.getSelectedItem();
        String expCoKey = (String)tocc.val;
        if (this.currKey_ == null || this.mode_ == 3) {
            String nextKey = this.pd_.getNextDataKey();
            this.expResult_ = new Experiment(nextKey, srcs, timeVal, invResult, expCoKey);
            if (this.mode_ == 3 && maxLegVal != -1) {
                this.expResult_.setLegacyMaxTime(maxLegVal);
            }
        } else {
            this.expResult_ = (Experiment)this.pd_.getExperiment(this.currKey_).clone();
            this.expResult_.setTime(timeVal);
            this.expResult_.setInvestigators(invResult);
            this.expResult_.setLegacyMaxTime(maxLegVal);
            this.expResult_.setSources(srcs);
            this.expResult_.setConditionKey(expCoKey);
        }
        useTable.stopTheEditing(false);
        useInvTable.stopTheEditing(false);
        return true;
    }

    private JPanel[] buildTables(boolean forMerge) {
        final EditableTable useSrcTable = !forMerge ? (this.estSrcForEdit_ = new EditableTable(new EditableTable.OneEnumTableModel("peaep.perturb", this.pertSrcList_), this.parent_)) : (this.estSrcForMerge_ = new EditableTable(new EditableTable.OneEnumTableModel("peaep.perturb", this.pertSrcList_), this.parent_));
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = false;
        etp.tableIsUnselectable = false;
        etp.buttons = 29;
        etp.singleSelectOnly = true;
        etp.buttonsOnSide = true;
        etp.perColumnEnums = new HashMap();
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.pertSrcList_));
        JPanel srcTablePan = useSrcTable.buildEditableTable(etp);
        JPanel srcTableWithButton = this.pmh_.addEditButton(srcTablePan, "peaep.srcEdit", true, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String who = PertExperimentAddOrEditPanel.this.pmh_.getSelectedEnumVal(useSrcTable);
                    PertExperimentAddOrEditPanel.this.pet_.jumpToRemoteEdit("srcDefs", "editPrtDef", who);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        final EditableTable useInvTable = !forMerge ? (this.estInvForEdit_ = new EditableTable(new EditableTable.OneEnumTableModel("peaep.invest", this.investList_), this.parent_)) : (this.estInvForMerge_ = new EditableTable(new EditableTable.OneEnumTableModel("peaep.invest", this.investList_), this.parent_));
        etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = false;
        etp.singleSelectOnly = true;
        etp.cancelEditOnDisable = false;
        etp.buttons = 29;
        etp.tableIsUnselectable = false;
        etp.perColumnEnums = new HashMap();
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.investList_));
        etp.colWidths = null;
        etp.buttonsOnSide = true;
        JPanel invTablePan = useInvTable.buildEditableTable(etp);
        JPanel invTableWithButton = this.pmh_.addEditButton(invTablePan, "peaep.investEdit", true, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String who = PertExperimentAddOrEditPanel.this.pmh_.getSelectedEnumVal(useInvTable);
                    PertExperimentAddOrEditPanel.this.pet_.jumpToRemoteEdit("invests", "editInvest", who);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel[] retval = new JPanel[]{srcTableWithButton, invTableWithButton};
        return retval;
    }

    private JPanel buildTimeAndCond(boolean forMerge, int legacyModes) {
        JComboBox useCombo;
        JComponent useComp;
        JPanel timeAndCondPanel = new JPanel();
        timeAndCondPanel.setBorder(BorderFactory.createEtchedBorder());
        timeAndCondPanel.setLayout(new GridBagLayout());
        int tacpRowNum = 0;
        JLabel timeLabel = new JLabel(this.rMan_.getString("peaep.setTime"));
        if (!forMerge) {
            useComp = this.timeFieldForEdit_ = new JTextField();
        } else {
            this.timeCombo_ = new JComboBox();
            this.timeCombo_.setEditable(true);
            useComp = this.timeCombo_;
        }
        UiUtil.gbcSet(this.gbc_, 0, tacpRowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        timeAndCondPanel.add((Component)timeLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, tacpRowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        timeAndCondPanel.add((Component)useComp, this.gbc_);
        if ((legacyModes & 2) != 0) {
            JLabel legTimeLabel = new JLabel(this.rMan_.getString("peaep.setLegacyTime"));
            if (!forMerge) {
                useComp = this.legacyMaxTimeFieldForEdit_ = new JTextField();
            } else {
                this.legacyMaxTimeCombo_ = new JComboBox();
                this.legacyMaxTimeCombo_.setEditable(true);
                useComp = this.legacyMaxTimeCombo_;
            }
            UiUtil.gbcSet(this.gbc_, 0, tacpRowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
            timeAndCondPanel.add((Component)legTimeLabel, this.gbc_);
            UiUtil.gbcSet(this.gbc_, 1, tacpRowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            timeAndCondPanel.add((Component)useComp, this.gbc_);
        } else if (!forMerge) {
            this.legacyMaxTimeFieldForEdit_ = null;
        } else {
            this.legacyMaxTimeCombo_ = null;
        }
        JLabel condLabel = new JLabel(this.rMan_.getString("peaep.setCondition"));
        Vector condTypes = this.pd_.getConditionDictionary().getExprConditionsOptions();
        if (!forMerge) {
            this.condsComboForEdit_ = new JComboBox(condTypes);
            useCombo = this.condsComboForEdit_;
        } else {
            this.condsComboForMerge_ = new JComboBox(condTypes);
            useCombo = this.condsComboForMerge_;
        }
        JButton jumpToCond = new JButton(this.rMan_.getString("peaep.jumpExpCond"), this.pmh_.getJumpIcon());
        jumpToCond.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)useCombo.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertExperimentAddOrEditPanel.this.pet_.jumpToRemoteEdit("expSetup", "editExC", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel panWB = this.pmh_.componentWithJumpButton(useCombo, jumpToCond);
        UiUtil.gbcSet(this.gbc_, 0, tacpRowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        timeAndCondPanel.add((Component)condLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, tacpRowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        timeAndCondPanel.add((Component)panWB, this.gbc_);
        return timeAndCondPanel;
    }

    private void displayProperties() {
        this.updateOptions();
        EditableTable useSrcTable = this.mode_ == 2 ? this.estSrcForMerge_ : this.estSrcForEdit_;
        EditableTable useInvTable = this.mode_ == 2 ? this.estInvForMerge_ : this.estInvForEdit_;
        List srcRows = this.buildSourceDisplayList();
        useSrcTable.updateTable(true, srcRows);
        List invRows = this.buildInvestDisplayList();
        useInvTable.updateTable(true, invRows);
        if (this.currKey_ == null) {
            this.timeFieldForEdit_.setText("");
            UiUtil.initCombo(this.condsComboForEdit_);
            if (this.legacyMaxTimeFieldForEdit_ != null) {
                this.legacyMaxTimeFieldForEdit_.setEnabled(false);
            }
            this.cardLayout_.show(this.myCard_, "edit");
            return;
        }
        Experiment exp = this.pd_.getExperiment(this.currKey_);
        ConditionDictionary cd = this.pd_.getConditionDictionary();
        switch (this.mode_) {
            case 1: 
            case 3: {
                this.condsComboForEdit_.setSelectedItem(cd.getExprConditionsChoice(exp.getConditionKey()));
                this.timeFieldForEdit_.setText(Integer.toString(exp.getTime()));
                if (this.legacyMaxTimeFieldForEdit_ != null) {
                    int legMax = exp.getLegacyMaxTime();
                    if (legMax != -1) {
                        this.legacyMaxTimeFieldForEdit_.setEnabled(true);
                        this.legacyMaxTimeFieldForEdit_.setText(Integer.toString(legMax));
                    } else {
                        this.legacyMaxTimeFieldForEdit_.setEnabled(false);
                    }
                }
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                this.condsComboForMerge_.setSelectedItem(cd.getExprConditionsChoice(exp.getConditionKey()));
                this.timeCombo_.setSelectedItem(Integer.toString(exp.getTime()));
                if (this.legacyMaxTimeCombo_ != null) {
                    int legMax = exp.getLegacyMaxTime();
                    String legMaxStr = legMax != -1 ? Integer.toString(legMax) : "";
                    this.legacyMaxTimeCombo_.setSelectedItem(legMaxStr);
                    this.legacyMaxTimeCombo_.setEnabled(this.legMaxTimeOptions_.size() > 1 || legMax != -1);
                }
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private ArrayList buildPertSourceEnum() {
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        Iterator sdkit = this.pd_.getSourceDefKeys();
        int count = 0;
        while (sdkit.hasNext()) {
            String key = (String)sdkit.next();
            PertSource ps = this.pd_.getSourceDef(key);
            String display = ps.getDisplayValueWithFootnotes(this.pd_, false);
            retval.add(new EnumCell(display, key, count, count));
            ++count;
        }
        return retval;
    }

    private ArrayList buildInvestEnum() {
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        Iterator ikit = this.pd_.getInvestigatorKeys();
        int count = 0;
        while (ikit.hasNext()) {
            String key = (String)ikit.next();
            String invest = this.pd_.getInvestigator(key);
            retval.add(new EnumCell(invest, key, count, count));
            ++count;
        }
        return retval;
    }

    private List buildSourceDisplayList() {
        if (this.currKey_ == null) {
            return new ArrayList();
        }
        if (this.allMerge_ == null) {
            Experiment exp = this.pd_.getExperiment(this.currKey_);
            PertSources pss = exp.getSources();
            Iterator psit = pss.getSources();
            return this.buildSourceDisplayListCore(psit, false);
        }
        HashSet<String> merged = new HashSet<String>();
        Iterator amit = this.allMerge_.iterator();
        while (amit.hasNext()) {
            String nextKey = (String)amit.next();
            Experiment exp = this.pd_.getExperiment(nextKey);
            PertSources pss = exp.getSources();
            Iterator psit = pss.getSources();
            while (psit.hasNext()) {
                String psID = (String)psit.next();
                merged.add(psID);
            }
        }
        return this.buildSourceDisplayListCore(merged.iterator(), false);
    }

    private List buildSourceDisplayListCore(Iterator psit, boolean forHotUpdate) {
        ArrayList<EditableTable.OneEnumTableModel.TableRow> retval = new ArrayList<EditableTable.OneEnumTableModel.TableRow>();
        EditableTable useTable = this.mode_ == 2 ? this.estSrcForMerge_ : this.estSrcForEdit_;
        EditableTable.OneEnumTableModel rpt = (EditableTable.OneEnumTableModel)useTable.getModel();
        int count = 0;
        int useIndex = -1;
        int numSrc = this.pertSrcList_.size();
        while (psit.hasNext()) {
            String psID = forHotUpdate ? ((EditableTable.OneEnumTableModel.TableRow)psit.next()).enumChoice.internal : (String)psit.next();
            EditableTable.OneEnumTableModel.TableRow tr = rpt.new EditableTable.OneEnumTableModel.TableRow();
            tr.origOrder = new Integer(count++);
            for (int i = 0; i < numSrc; ++i) {
                EnumCell ecp = (EnumCell)this.pertSrcList_.get(i);
                if (!psID.equals(ecp.internal)) continue;
                useIndex = i;
                break;
            }
            if (useIndex == -1) {
                if (forHotUpdate) continue;
                throw new IllegalStateException();
            }
            tr.enumChoice = new EnumCell((EnumCell)this.pertSrcList_.get(useIndex));
            retval.add(tr);
        }
        return retval;
    }

    private List buildInvestDisplayList() {
        if (this.currKey_ == null) {
            return new ArrayList();
        }
        if (this.allMerge_ == null) {
            Experiment exp = this.pd_.getExperiment(this.currKey_);
            List invests = exp.getInvestigators();
            Iterator iit = invests.iterator();
            return this.buildInvestDisplayListCore(iit, false);
        }
        HashSet<String> merged = new HashSet<String>();
        Iterator amit = this.allMerge_.iterator();
        while (amit.hasNext()) {
            String nextKey = (String)amit.next();
            Experiment exp = this.pd_.getExperiment(nextKey);
            List invests = exp.getInvestigators();
            Iterator iit = invests.iterator();
            while (iit.hasNext()) {
                String invID = (String)iit.next();
                merged.add(invID);
            }
        }
        return this.buildInvestDisplayListCore(merged.iterator(), false);
    }

    private List buildInvestDisplayListCore(Iterator iit, boolean forHotUpdate) {
        ArrayList<EditableTable.OneEnumTableModel.TableRow> retval = new ArrayList<EditableTable.OneEnumTableModel.TableRow>();
        EditableTable useTable = this.mode_ == 2 ? this.estInvForMerge_ : this.estInvForEdit_;
        EditableTable.OneEnumTableModel rpt = (EditableTable.OneEnumTableModel)useTable.getModel();
        int numInv = this.investList_.size();
        int count = 0;
        int useIndex = -1;
        while (iit.hasNext()) {
            String invID = forHotUpdate ? ((EditableTable.OneEnumTableModel.TableRow)iit.next()).enumChoice.internal : (String)iit.next();
            EditableTable.OneEnumTableModel.TableRow tr = rpt.new EditableTable.OneEnumTableModel.TableRow();
            tr.origOrder = new Integer(count++);
            for (int i = 0; i < numInv; ++i) {
                EnumCell ecp = (EnumCell)this.investList_.get(i);
                if (!invID.equals(ecp.internal)) continue;
                useIndex = i;
                break;
            }
            if (useIndex == -1) {
                if (forHotUpdate) continue;
                throw new IllegalStateException();
            }
            tr.enumChoice = new EnumCell((EnumCell)this.investList_.get(useIndex));
            retval.add(tr);
        }
        return retval;
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String timeFieldText;
        private String legacyMaxTimeFieldText;
        private List estSrcValues;
        private List estInvValues;
        private TrueObjChoiceContent condsComboTocc;

        MyFreezeDried() {
            if (PertExperimentAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertExperimentAddOrEditPanel.this.timeCombo_.getEditor().getEditorComponent();
                this.timeFieldText = jtc.getText().trim();
                if (PertExperimentAddOrEditPanel.this.legacyMaxTimeCombo_ != null) {
                    jtc = (JTextComponent)PertExperimentAddOrEditPanel.this.legacyMaxTimeCombo_.getEditor().getEditorComponent();
                    this.legacyMaxTimeFieldText = jtc.getText().trim();
                }
                this.condsComboTocc = (TrueObjChoiceContent)PertExperimentAddOrEditPanel.this.condsComboForMerge_.getSelectedItem();
                this.estSrcValues = PertExperimentAddOrEditPanel.this.estSrcForMerge_.getModel().getValuesFromTable();
                this.estInvValues = PertExperimentAddOrEditPanel.this.estInvForMerge_.getModel().getValuesFromTable();
            } else {
                this.timeFieldText = PertExperimentAddOrEditPanel.this.timeFieldForEdit_.getText().trim();
                if (PertExperimentAddOrEditPanel.this.legacyMaxTimeFieldForEdit_ != null) {
                    this.legacyMaxTimeFieldText = PertExperimentAddOrEditPanel.this.legacyMaxTimeFieldForEdit_.getText();
                }
                this.condsComboTocc = (TrueObjChoiceContent)PertExperimentAddOrEditPanel.this.condsComboForEdit_.getSelectedItem();
                this.estSrcValues = PertExperimentAddOrEditPanel.this.estSrcForEdit_.getModel().getValuesFromTable();
                this.estInvValues = PertExperimentAddOrEditPanel.this.estInvForEdit_.getModel().getValuesFromTable();
            }
        }

        public boolean needToCancel() {
            if (PertExperimentAddOrEditPanel.this.mode_ == 2) {
                PertExperimentAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertExperimentAddOrEditPanel.this.currKey_ != null && PertExperimentAddOrEditPanel.this.mode_ == 1 && PertExperimentAddOrEditPanel.this.pd_.getExperiment(PertExperimentAddOrEditPanel.this.currKey_) == null) {
                PertExperimentAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            List srcRows = PertExperimentAddOrEditPanel.this.buildSourceDisplayListCore(this.estSrcValues.iterator(), true);
            List invRows = PertExperimentAddOrEditPanel.this.buildInvestDisplayListCore(this.estInvValues.iterator(), true);
            if (PertExperimentAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertExperimentAddOrEditPanel.this.timeCombo_.getEditor().getEditorComponent();
                jtc.setText(this.timeFieldText);
                if (PertExperimentAddOrEditPanel.this.legacyMaxTimeCombo_ != null) {
                    jtc = (JTextComponent)PertExperimentAddOrEditPanel.this.legacyMaxTimeCombo_.getEditor().getEditorComponent();
                    jtc.setText(this.legacyMaxTimeFieldText);
                }
                if (this.condsComboTocc != null) {
                    PertExperimentAddOrEditPanel.this.condsComboForMerge_.setSelectedItem(PertExperimentAddOrEditPanel.this.pd_.getConditionDictionary().getExprConditionsChoice((String)this.condsComboTocc.val));
                }
                PertExperimentAddOrEditPanel.this.estSrcForMerge_.updateTable(true, srcRows);
                PertExperimentAddOrEditPanel.this.estInvForMerge_.updateTable(true, invRows);
            } else {
                PertExperimentAddOrEditPanel.this.timeFieldForEdit_.setText(this.timeFieldText);
                if (PertExperimentAddOrEditPanel.this.legacyMaxTimeFieldForEdit_ != null) {
                    PertExperimentAddOrEditPanel.this.legacyMaxTimeFieldForEdit_.setText(this.legacyMaxTimeFieldText);
                }
                if (this.condsComboTocc != null) {
                    PertExperimentAddOrEditPanel.this.condsComboForEdit_.setSelectedItem(PertExperimentAddOrEditPanel.this.pd_.getConditionDictionary().getExprConditionsChoice((String)this.condsComboTocc.val));
                }
                PertExperimentAddOrEditPanel.this.estSrcForEdit_.updateTable(true, srcRows);
                PertExperimentAddOrEditPanel.this.estInvForEdit_.updateTable(true, invRows);
            }
        }
    }
}

