/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.Experiment;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.BatchDupReportDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertExperimentAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertExperimentManagePanel
extends AnimatedSplitManagePanel {
    public static final String MANAGER_KEY = "sources";
    public static final String SOURCES_KEY = "editSrcs";
    private ReadOnlyTable rtd_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private String pendingKey_;
    private PertExperimentAddOrEditPanel pssaep_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertExperimentManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo, int legacyModes) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.rtd_ = new ReadOnlyTable();
        this.rtd_.lateBinding(new PertSourcesTableModel(this.rtd_.rowElements), new ReadOnlyTable.EmptySelector());
        this.rtd_.setButtonHandler(new AnimatedSplitManagePanel.ButtonHand(SOURCES_KEY));
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        tp.multiTableSelectionSyncing = null;
        tp.tableTitle = this.rMan_.getString("pertSourcesManage.sourceList");
        tp.titleFont = null;
        tp.colWidths = new ArrayList();
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 150, 200));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(1, 100, 100, 200));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(2, 100, 100, 200));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(3, 100, 200, Integer.MAX_VALUE));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(4, 50, 50, 100));
        tp.canMultiSelect = true;
        this.addExtraButtons(tp, SOURCES_KEY);
        JPanel tabPan = this.rtd_.buildReadOnlyTable(tp);
        tabPan.setMinimumSize(new Dimension(400, 100));
        UiUtil.gbcSet(this.gbc_, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.topPanel_.add((Component)tabPan, this.gbc_);
        this.pssaep_ = new PertExperimentAddOrEditPanel(this.parent_, this.pd_, this, SOURCES_KEY, legacyModes);
        this.addEditPanel(this.pssaep_, SOURCES_KEY);
        this.finishConstruction();
        this.displayProperties(false);
    }

    public void finished() {
        this.rtd_.makeCurrentSelectionVisible();
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(SOURCES_KEY)) {
            if (this.joinKeys_ == null) {
                this.editAnExperiment(key, what);
            } else {
                this.joinExperiments(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void editAnExperiment(String key, int what) {
        String resultKey = this.pendingKey_;
        Experiment psi = this.pssaep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createExperiment" : "undo.editExperiment");
        if (this.pendingKey_ == null) {
            resultKey = psi.getID();
        }
        PertDataChange pdc = this.pd_.setExperiment(psi);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        super.editIsComplete(key, what);
        this.setTableSelection(SOURCES_KEY, resultKey);
    }

    private void joinExperiments(String key, int what) {
        Experiment psi = this.pssaep_.getResult();
        Map collisions = this.pd_.mergeExperimentBatchCollisions(new HashSet(this.joinKeys_));
        Map batchDups = this.pd_.prepBatchCollisions(collisions, psi.getDisplayString(this.pd_));
        if (batchDups != null) {
            BatchDupReportDialog bdrd = new BatchDupReportDialog(this.parent_, batchDups, "batchDup.MergeDialog", "batchDup.MergeTable");
            bdrd.show();
            if (!bdrd.keepGoing()) {
                return;
            }
        }
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergeExperiments");
        DependencyAnalyzer.Dependencies refs = da.getExperimentMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeExperiments(this.joinKeys_, this.pendingKey_, psi);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(SOURCES_KEY)) {
            PsEntry pse = (PsEntry)obj;
            return pse.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(SOURCES_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtd_, whichKey, this, SOURCES_KEY);
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.pssaep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.pssaep_.closeAction();
    }

    public void doADuplication(String key) {
        String useKey = ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        this.pendingKey_ = null;
        this.pssaep_.setSourcesForDup(useKey);
        this.pssaep_.startEditing();
    }

    public void doAJoin(String key) {
        if (key.equals(SOURCES_KEY)) {
            int ok;
            this.joinKeys_ = ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKeys(this.rtd_.selectedRows);
            Iterator jkit = this.joinKeys_.iterator();
            Experiment exp = null;
            boolean mismatch = false;
            while (jkit.hasNext()) {
                String ckey = (String)jkit.next();
                Experiment chkExp = this.pd_.getExperiment(ckey);
                if (exp == null) {
                    exp = chkExp;
                    continue;
                }
                if (exp.getTime() != chkExp.getTime()) {
                    mismatch = true;
                    break;
                }
                if (exp.getLegacyMaxTime() != chkExp.getLegacyMaxTime()) {
                    mismatch = true;
                    break;
                }
                if (!exp.getSources().equals(chkExp.getSources())) {
                    mismatch = true;
                    break;
                }
                if (exp.getConditionKey().equals(chkExp.getConditionKey())) continue;
                mismatch = true;
                break;
            }
            if (mismatch && (ok = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.experimentMergeMismatch"), this.rMan_.getString("pmsmp.experimentMergeMismatchTitle"), 0)) != 0) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = this.pssaep_.setExperimentsForMerge(this.joinKeys_);
        this.pssaep_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(SOURCES_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        PertFilter srcFilter = new PertFilter(0, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(srcFilter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    protected void doAnAdd(String key) {
        this.pendingKey_ = null;
        this.rtd_.clearSelections(false);
        this.pssaep_.setSources(this.pendingKey_);
        this.pssaep_.startEditing();
    }

    protected void doAnEdit(String key) {
        this.pendingKey_ = ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKey(this.rtd_.selectedRows);
        this.pssaep_.setSources(this.pendingKey_);
        this.pssaep_.startEditing();
    }

    protected void doADelete(String key) {
        if (this.deleteExpr(this.rtd_.selectedRows)) {
            this.pet_.itemDeleted(SOURCES_KEY);
        }
    }

    protected void enableTopPane(boolean enable) {
        this.rtd_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtd_.selectedRows == null ? null : ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKeys(this.rtd_.selectedRows);
        this.rtd_.rowElements.clear();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map expRefs = da.getAllExperimentReferenceCounts();
        Integer noCount = new Integer(0);
        Iterator pskit = this.pd_.getExperimentKeys();
        while (pskit.hasNext()) {
            String key = (String)pskit.next();
            Integer count = (Integer)expRefs.get(key);
            if (count == null) {
                count = noCount;
            }
            Experiment psi = this.pd_.getExperiment(key);
            this.rtd_.rowElements.add(new PsEntry(psi, count, this.pd_));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtd_, this, SOURCES_KEY, selKeys);
    }

    private boolean deleteExpr(int[] selectedRows) {
        String key;
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getExperimentReferenceSet(key = ((PertSourcesTableModel)this.rtd_.getModel()).getSelectedKey(selectedRows));
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertSourceInfo");
        da.killOffDependencies(refs, support);
        PertDataChange pdc = this.pd_.deleteExperiment(key);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private class PsEntry {
        String perts;
        String time;
        String conds;
        String invest;
        String key;
        Integer count;

        PsEntry(Experiment psi, Integer count, PerturbationData pd) {
            this.key = psi.getID();
            this.invest = psi.getInvestigatorDisplayString(pd);
            if (this.invest == null) {
                this.invest = "";
            }
            this.perts = psi.getPertDisplayString(pd, 2);
            if (this.perts == null) {
                this.perts = "";
            }
            this.conds = psi.getCondsDisplayString(pd);
            if (this.conds == null) {
                this.conds = "";
            }
            this.time = psi.getTimeDisplayString(true, true);
            if (this.time == null) {
                this.time = "";
            }
            this.count = count;
        }
    }

    class PertSourcesTableModel
    extends ReadOnlyTable.TableModel {
        static final int PERT = 0;
        static final int TIME = 1;
        static final int CONDS = 2;
        static final int INVEST = 3;
        static final int COUNT = 4;
        private static final int NUM_COL_ = 5;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        PertSourcesTableModel(List prsList) {
            super(5);
            this.colNames_ = new String[]{"pertSource.pert", "pertSource.time", "pertSource.conditions", "pertSource.invest", "pertSource.refCount"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertExperimentManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertExperimentManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertExperimentManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertExperimentManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertExperimentManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                PsEntry pse = (PsEntry)iit.next();
                this.columns_[0].add(pse.perts);
                this.columns_[1].add(pse.time);
                this.columns_[2].add(pse.conds);
                this.columns_[3].add(pse.invest);
                this.columns_[4].add(pse.count);
                this.hiddenColumns_[0].add(pse.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

