/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertFilterPanel
extends JPanel {
    private PerturbationData pd_;
    private JComboBox srcCombo_;
    private JComboBox pertCombo_;
    private JComboBox targCombo_;
    private JComboBox timeCombo_;
    private JComboBox investCombo_;
    private JComboBox investModeCombo_;
    private JComboBox valCombo_;
    private JLabel srcLabel_;
    private JLabel pertLabel_;
    private JLabel targLabel_;
    private JLabel timeLabel_;
    private JLabel investLabel_;
    private JLabel valLabel_;
    private int[] currIndices_;
    private JCheckBox customFilterInstalled_;
    private PertFilterExpression customFilterExp_;
    private FixedJButton buttonO_;
    private boolean trueBOEnable_;
    private FixedJButton buttonC_;
    private ApplyButtonControl myABC_;
    private PertManageHelper.FilterListRenderer srcRender_;
    private PertManageHelper.FilterListRenderer pertRender_;
    private PertManageHelper.FilterListRenderer targRender_;
    private PertManageHelper.FilterListRenderer timeRender_;
    private PertManageHelper.FilterListRenderer investRender_;
    private PertManageHelper.FilterListRenderer valRender_;
    private Dimension savePref_;
    private Dimension saveMin_;
    private Client myClient_;

    public PertFilterPanel(PerturbationData pd, Client myClient) {
        this.pd_ = pd;
        this.myClient_ = myClient;
        this.myABC_ = new ApplyButtonControl();
        ResourceManager rMan = ResourceManager.getManager();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel mainLabel = new JLabel(rMan.getString("pertManage.chooseOpFilters"));
        int rowNum = 0;
        int colNum = 0;
        UiUtil.gbcSet(gbc, colNum, rowNum++, 5, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        this.add((Component)mainLabel, gbc);
        this.srcLabel_ = new JLabel(rMan.getString("pertManage.chooseSource"));
        this.srcCombo_ = new JComboBox();
        this.srcRender_ = new PertManageHelper.FilterListRenderer(this.srcCombo_.getRenderer());
        this.srcCombo_.setRenderer(this.srcRender_);
        this.srcCombo_.addActionListener(this.myABC_);
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.srcLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.srcCombo_, gbc);
        this.pertLabel_ = new JLabel(rMan.getString("pertManage.choosePert"));
        this.pertCombo_ = new JComboBox();
        this.pertRender_ = new PertManageHelper.FilterListRenderer(this.pertCombo_.getRenderer());
        this.pertCombo_.setRenderer(this.pertRender_);
        this.pertCombo_.addActionListener(this.myABC_);
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.pertLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.pertCombo_, gbc);
        this.targLabel_ = new JLabel(rMan.getString("pertManage.chooseTarg"));
        this.targCombo_ = new JComboBox();
        this.targRender_ = new PertManageHelper.FilterListRenderer(this.targCombo_.getRenderer());
        this.targCombo_.setRenderer(this.targRender_);
        this.targCombo_.addActionListener(this.myABC_);
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.targLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.targCombo_, gbc);
        colNum += 2;
        rowNum = 1;
        this.timeLabel_ = new JLabel(rMan.getString("pertManage.chooseTime"));
        this.timeCombo_ = new JComboBox();
        this.timeRender_ = new PertManageHelper.FilterListRenderer(this.timeCombo_.getRenderer());
        this.timeCombo_.setRenderer(this.timeRender_);
        this.timeCombo_.addActionListener(this.myABC_);
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.timeLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.timeCombo_, gbc);
        this.investLabel_ = new JLabel(rMan.getString("pertManage.chooseInvest"));
        this.investCombo_ = new JComboBox();
        this.investRender_ = new PertManageHelper.FilterListRenderer(this.investCombo_.getRenderer());
        this.investCombo_.setRenderer(this.investRender_);
        this.investCombo_.addActionListener(this.myABC_);
        Vector fmo = this.getInvestOptions();
        this.investModeCombo_ = new JComboBox(fmo);
        this.investModeCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertFilterPanel.this.myABC_.enableApply();
                    PertFilterPanel.this.stockInvestigatorChoices();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.investLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.investModeCombo_, gbc);
        UiUtil.gbcSet(gbc, colNum + 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.investCombo_, gbc);
        this.valLabel_ = new JLabel(rMan.getString("pertManage.chooseVal"));
        this.valCombo_ = new JComboBox();
        this.valRender_ = new PertManageHelper.FilterListRenderer(this.valCombo_.getRenderer());
        this.valCombo_.setRenderer(this.valRender_);
        this.valCombo_.addActionListener(this.myABC_);
        UiUtil.gbcSet(gbc, colNum, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        this.add((Component)this.valLabel_, gbc);
        UiUtil.gbcSet(gbc, colNum + 1, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.valCombo_, gbc);
        colNum = 0;
        this.customFilterInstalled_ = new JCheckBox(rMan.getString("pertManage.customFilter"));
        this.customFilterInstalled_.setSelected(false);
        this.customFilterInstalled_.setEnabled(false);
        this.customFilterInstalled_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                try {
                    boolean amSel = PertFilterPanel.this.customFilterInstalled_.isSelected();
                    PertFilterPanel.this.enableFilterCombos(!amSel);
                    PertFilterPanel.this.customFilterInstalled_.setEnabled(amSel);
                    if (!amSel) {
                        PertFilterPanel.this.myABC_.enableApply();
                        PertFilterPanel.this.customFilterExp_ = null;
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, colNum, rowNum++, 5, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        this.add((Component)this.customFilterInstalled_, gbc);
        this.buttonO_ = new FixedJButton(rMan.getString("pertManage.applyFilter"));
        this.buttonO_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertFilterExpression pfe = PertFilterPanel.this.buildPertFilterExpr();
                    PertFilterPanel.this.myClient_.installNewFilter(pfe);
                    PertFilterPanel.this.myABC_.disableApply(true);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.buttonO_.setEnabled(false);
        this.trueBOEnable_ = false;
        this.buttonC_ = new FixedJButton(rMan.getString("pertManage.clearFilter"));
        this.buttonC_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PertFilterPanel.this.clearAllFilters();
                    PertFilterExpression pfe = PertFilterPanel.this.buildPertFilterExpr();
                    PertFilterPanel.this.myClient_.installNewFilter(pfe);
                    PertFilterPanel.this.myABC_.disableApply(true);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.buttonO_);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.buttonC_);
        buttonPanel.add(Box.createHorizontalGlue());
        UiUtil.gbcSet(gbc, 0, rowNum, 5, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        this.add((Component)buttonPanel, gbc);
    }

    public void clearAllFilters() {
        UiUtil.initCombo(this.pertCombo_);
        UiUtil.initCombo(this.targCombo_);
        UiUtil.initCombo(this.srcCombo_);
        UiUtil.initCombo(this.timeCombo_);
        UiUtil.initCombo(this.investCombo_);
        UiUtil.initCombo(this.valCombo_);
        this.customFilterExp_ = null;
        this.customFilterInstalled_.setSelected(false);
        this.customFilterInstalled_.setEnabled(false);
    }

    public void enableFilterCombos(boolean enable) {
        this.srcLabel_.setEnabled(enable);
        this.pertLabel_.setEnabled(enable);
        this.targLabel_.setEnabled(enable);
        this.timeLabel_.setEnabled(enable);
        this.investLabel_.setEnabled(enable);
        this.valLabel_.setEnabled(enable);
        this.srcCombo_.setEnabled(enable);
        this.pertCombo_.setEnabled(enable);
        this.targCombo_.setEnabled(enable);
        this.timeCombo_.setEnabled(enable);
        this.investModeCombo_.setEnabled(enable);
        this.investCombo_.setEnabled(enable);
        this.valCombo_.setEnabled(enable);
    }

    public void enableFilters(boolean enable) {
        this.enableFilterCombos(enable);
        this.buttonO_.setEnabled(enable ? this.trueBOEnable_ : false);
        this.buttonC_.setEnabled(enable);
        if (!enable) {
            if (this.savePref_ == null) {
                this.savePref_ = this.getPreferredSize();
            }
            if (this.saveMin_ == null) {
                this.saveMin_ = this.getMinimumSize();
            }
            this.setPreferredSize(new Dimension(0, 0));
            this.setMinimumSize(new Dimension(0, 0));
        } else {
            this.setPreferredSize(this.savePref_);
            this.setMinimumSize(this.saveMin_);
        }
    }

    public void setCurrentSettings(PertFilterExpression pfe) {
        boolean match;
        this.clearAllFilters();
        int pfeOp = pfe.getOperator();
        if (pfeOp == 3) {
            boolean match2 = this.setCurrentSingleSetting((PertFilterExpression)pfe.getTarget1());
            boolean bl = match2 = match2 && this.setCurrentSingleSetting((PertFilterExpression)pfe.getTarget2());
            if (!match2) {
                throw new IllegalArgumentException();
            }
            this.customFilterInstalled_.setSelected(false);
            this.customFilterInstalled_.setEnabled(false);
        } else if (pfeOp != 1 && !(match = this.setCurrentSingleSetting(pfe))) {
            this.customFilterExp_ = (PertFilterExpression)pfe.clone();
            this.customFilterInstalled_.setSelected(true);
            this.customFilterInstalled_.setEnabled(true);
        }
        this.myABC_.disableApply(true);
    }

    public boolean setCurrentSingleSetting(PertFilterExpression pfe) {
        JComboBox useCombo;
        if (pfe.getOperator() != 2) {
            return false;
        }
        PertFilter filter = (PertFilter)pfe.getTarget1();
        String matchVal = filter.getStringValue();
        int filtCat = filter.getCategory();
        if (filter.getMatchType() != 0) {
            throw new IllegalArgumentException();
        }
        if (filtCat == 2) {
            useCombo = this.srcCombo_;
        } else if (filtCat == 5) {
            useCombo = this.targCombo_;
        } else if (filtCat == 8) {
            useCombo = this.investCombo_;
        } else if (filtCat == 4) {
            useCombo = this.pertCombo_;
        } else {
            return false;
        }
        int numSrc = useCombo.getItemCount();
        for (int i = 0; i < numSrc; ++i) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)useCombo.getItemAt(i);
            if (tocc.val == null || !tocc.val.equals(matchVal)) continue;
            useCombo.setSelectedIndex(i);
            break;
        }
        return true;
    }

    public void stockFilterPanel() {
        ResourceManager rMan = ResourceManager.getManager();
        TrueObjChoiceContent ncstr = new TrueObjChoiceContent(rMan.getString("pertManage.chooseAll"), null);
        SortedSet srcCand = this.pd_.getCandidates(2);
        this.srcCombo_.removeAllItems();
        this.srcCombo_.addItem(ncstr);
        Iterator scit = srcCand.iterator();
        while (scit.hasNext()) {
            this.srcCombo_.addItem(scit.next());
        }
        srcCand.add(ncstr);
        this.srcRender_.setActive(srcCand);
        SortedSet pertCand = this.pd_.getCandidates(4);
        this.pertCombo_.removeAllItems();
        this.pertCombo_.addItem(ncstr);
        Iterator pit = pertCand.iterator();
        while (pit.hasNext()) {
            this.pertCombo_.addItem(pit.next());
        }
        pertCand.add(ncstr);
        this.pertRender_.setActive(pertCand);
        SortedSet targCand = this.pd_.getCandidates(5);
        this.targCombo_.removeAllItems();
        this.targCombo_.addItem(ncstr);
        Iterator tcit = targCand.iterator();
        while (tcit.hasNext()) {
            this.targCombo_.addItem(tcit.next());
        }
        targCand.add(ncstr);
        this.targRender_.setActive(targCand);
        SortedSet timeCand = this.pd_.getCandidates(6);
        this.timeCombo_.removeAllItems();
        this.timeCombo_.addItem(ncstr);
        Iterator tmit = timeCand.iterator();
        while (tmit.hasNext()) {
            this.timeCombo_.addItem(tmit.next());
        }
        timeCand.add(ncstr);
        this.timeRender_.setActive(timeCand);
        this.stockInvestigatorChoices();
        SortedSet valCand = this.pd_.getCandidates(7);
        this.valCombo_.removeAllItems();
        this.valCombo_.addItem(ncstr);
        Iterator vcit = valCand.iterator();
        while (vcit.hasNext()) {
            this.valCombo_.addItem(vcit.next());
        }
        valCand.add(ncstr);
        this.valRender_.setActive(valCand);
        this.myABC_.disableApply(true);
    }

    public void stockInvestigatorChoices() {
        ResourceManager rMan = ResourceManager.getManager();
        TrueObjChoiceContent ncstr = new TrueObjChoiceContent(rMan.getString("pertManage.chooseAll"), null);
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.investModeCombo_.getSelectedItem();
        SortedSet investCand = this.pd_.getCandidates((Integer)tocc.val);
        this.investCombo_.removeAllItems();
        this.investCombo_.addItem(ncstr);
        Iterator icit = investCand.iterator();
        while (icit.hasNext()) {
            this.investCombo_.addItem(icit.next());
        }
        investCand.add(ncstr);
        this.investRender_.setActive(investCand);
    }

    public void updateFilterRenderers(List filteredData) {
        ResourceManager rMan = ResourceManager.getManager();
        TrueObjChoiceContent ncstr = new TrueObjChoiceContent(rMan.getString("pertManage.chooseAll"), null);
        SortedSet srcCand = this.pd_.getCandidates(filteredData, 2);
        srcCand.add(ncstr);
        this.srcRender_.setActive(srcCand);
        this.srcCombo_.invalidate();
        SortedSet pertCand = this.pd_.getCandidates(filteredData, 4);
        pertCand.add(ncstr);
        this.pertRender_.setActive(pertCand);
        this.pertCombo_.invalidate();
        SortedSet targCand = this.pd_.getCandidates(filteredData, 5);
        targCand.add(ncstr);
        this.targRender_.setActive(targCand);
        this.targCombo_.invalidate();
        SortedSet timeCand = this.pd_.getCandidates(filteredData, 6);
        timeCand.add(ncstr);
        this.timeRender_.setActive(timeCand);
        this.timeCombo_.invalidate();
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.investModeCombo_.getSelectedItem();
        SortedSet investCand = this.pd_.getCandidates(filteredData, (Integer)tocc.val);
        investCand.add(ncstr);
        this.investRender_.setActive(investCand);
        this.investCombo_.invalidate();
        SortedSet valCand = this.pd_.getCandidates(filteredData, 7);
        valCand.add(ncstr);
        this.valRender_.setActive(valCand);
        this.valCombo_.invalidate();
        this.validate();
        this.repaint();
    }

    public PertFilterExpression buildPertFilterExpr() {
        PertFilterExpression retval = null;
        if (this.customFilterExp_ != null) {
            return this.customFilterExp_;
        }
        if (this.srcCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent useSrc = (TrueObjChoiceContent)this.srcCombo_.getSelectedItem();
            PertFilter srcFilter = new PertFilter(2, 0, useSrc.val);
            retval = new PertFilterExpression(srcFilter);
        }
        if (this.pertCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent usePert = (TrueObjChoiceContent)this.pertCombo_.getSelectedItem();
            PertFilter pertFilter = new PertFilter(4, 0, usePert.val);
            retval = retval == null ? new PertFilterExpression(pertFilter) : new PertFilterExpression(3, retval, pertFilter);
        }
        if (this.targCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent useTarg = (TrueObjChoiceContent)this.targCombo_.getSelectedItem();
            PertFilter targFilter = new PertFilter(5, 0, useTarg.val);
            retval = retval == null ? new PertFilterExpression(targFilter) : new PertFilterExpression(3, retval, targFilter);
        }
        if (this.timeCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent useTime = (TrueObjChoiceContent)this.timeCombo_.getSelectedItem();
            PertFilter timeFilter = new PertFilter(6, 7, useTime.val);
            retval = retval == null ? new PertFilterExpression(timeFilter) : new PertFilterExpression(3, retval, timeFilter);
        }
        if (this.investCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent useInvest = (TrueObjChoiceContent)this.investCombo_.getSelectedItem();
            TrueObjChoiceContent useInvestMode = (TrueObjChoiceContent)this.investModeCombo_.getSelectedItem();
            int cat = (Integer)useInvestMode.val;
            PertFilter investFilter = new PertFilter(cat, 0, useInvest.val);
            retval = retval == null ? new PertFilterExpression(investFilter) : new PertFilterExpression(3, retval, investFilter);
        }
        if (this.valCombo_.getSelectedIndex() != 0) {
            TrueObjChoiceContent useVal = (TrueObjChoiceContent)this.valCombo_.getSelectedItem();
            PertFilter valFilter = new PertFilter(7, (Integer)useVal.val, null);
            retval = retval == null ? new PertFilterExpression(valFilter) : new PertFilterExpression(3, retval, valFilter);
        }
        if (retval == null) {
            retval = new PertFilterExpression(1);
        }
        return retval;
    }

    public Vector getInvestOptions() {
        Vector<TrueObjChoiceContent> retval = new Vector<TrueObjChoiceContent>();
        retval.add(this.getMatchOptionsChoice(8));
        retval.add(this.getMatchOptionsChoice(9));
        return retval;
    }

    public TrueObjChoiceContent getMatchOptionsChoice(int which) {
        return new TrueObjChoiceContent(ResourceManager.getManager().getString("pertFilt." + PertFilter.mapCategory(which)), new Integer(which));
    }

    public int[] gatherFilterIndices() {
        int[] retval = new int[]{this.srcCombo_.getSelectedIndex(), this.pertCombo_.getSelectedIndex(), this.targCombo_.getSelectedIndex(), this.timeCombo_.getSelectedIndex(), this.investCombo_.getSelectedIndex(), this.investModeCombo_.getSelectedIndex(), this.valCombo_.getSelectedIndex()};
        return retval;
    }

    private class ApplyButtonControl
    implements ActionListener {
        private ApplyButtonControl() {
        }

        public void actionPerformed(ActionEvent ev) {
            this.enableApply();
        }

        void enableApply() {
            int[] gfi = PertFilterPanel.this.gatherFilterIndices();
            PertFilterPanel.this.buttonO_.setForeground(Color.red);
            PertFilterPanel.this.trueBOEnable_ = true;
            PertFilterPanel.this.buttonO_.setEnabled(true);
            PertFilterPanel.this.validate();
            PertFilterPanel.this.repaint();
        }

        void disableApply(boolean doPaint) {
            PertFilterPanel.this.buttonO_.setForeground(Color.black);
            PertFilterPanel.this.trueBOEnable_ = false;
            PertFilterPanel.this.buttonO_.setEnabled(false);
            if (doPaint) {
                PertFilterPanel.this.validate();
                PertFilterPanel.this.repaint();
            }
        }
    }

    public static interface Client {
        public void installNewFilter(PertFilterExpression var1);
    }
}

