/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSimpleNameEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertInvestManagePanel
extends AnimatedSplitManagePanel
implements PertSimpleNameEditPanel.Client {
    public static final String MANAGER_KEY = "invests";
    public static final String INVEST_KEY = "editInvest";
    private ReadOnlyTable rtdi_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private String pendingKey_;
    private PertSimpleNameEditPanel pip_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;

    public PertInvestManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.pfet_ = pfet;
        this.rtdi_ = new ReadOnlyTable(new PertManageHelper.NameWithHiddenIDAndRefCountModel("pdim.invName"), new ReadOnlyTable.EmptySelector());
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 150, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 50, 100));
        JPanel srcsPanel = this.commonTableBuild(this.rtdi_, "pertDefInvestManage.invests", new AnimatedSplitManagePanel.ButtonHand(INVEST_KEY), null, colWidths, INVEST_KEY);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)srcsPanel, this.gbc_);
        this.pip_ = new PertSimpleNameEditPanel(this.parent_, this, "pdim.investName", this, INVEST_KEY);
        this.addEditPanel(this.pip_, INVEST_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public String getNameForKey(String whoAmI, String key) {
        if (whoAmI.equals(INVEST_KEY)) {
            return this.pd_.getInvestigator(key);
        }
        throw new IllegalArgumentException();
    }

    public boolean haveDuplication(String whoAmI, String key, String name) {
        if (!whoAmI.equals(INVEST_KEY)) {
            throw new IllegalArgumentException();
        }
        String existingKey = this.pd_.getInvestKeyFromName(name);
        if (existingKey == null) {
            return false;
        }
        if (this.joinKeys_ == null) {
            return key == null || !existingKey.equals(key);
        }
        return !this.joinKeys_.contains(existingKey);
    }

    public boolean haveDisconnect(String whoAmI, String key, String name) {
        if (whoAmI.equals(INVEST_KEY)) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(INVEST_KEY)) {
            if (this.joinKeys_ == null) {
                this.editAnInvest(key, what);
            } else {
                this.joinInvestigators(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtdi_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.pip_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.pip_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(INVEST_KEY)) {
            PertManageHelper.ToccWithRefCount twrc = (PertManageHelper.ToccWithRefCount)obj;
            return twrc.tocc.val.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(INVEST_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtdi_, whichKey, this, INVEST_KEY);
    }

    public void doAJoin(String key) {
        TreeSet<String> nameOptions;
        if (key.equals(INVEST_KEY)) {
            this.joinKeys_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKeys(this.rtdi_.selectedRows);
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            Map refCounts = da.getAllInvestigatorReferenceCounts(true);
            this.pendingKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
            nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int numk = this.joinKeys_.size();
            for (int i = 0; i < numk; ++i) {
                String nextJk = (String)this.joinKeys_.get(i);
                nameOptions.add(this.pd_.getInvestigator(nextJk));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.pip_.setMergeName(this.pendingKey_, nameOptions, new ArrayList(this.joinKeys_));
        this.pip_.startEditing();
    }

    public void doADuplication(String key) {
        HashSet<String> allInvests;
        String useKey;
        if (key.equals(INVEST_KEY)) {
            useKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKey(this.rtdi_.selectedRows);
            allInvests = new HashSet<String>();
            Iterator ikeys = this.pd_.getInvestigatorKeys();
            while (ikeys.hasNext()) {
                String iKey = (String)ikeys.next();
                allInvests.add(this.pd_.getInvestigator(iKey));
            }
        } else {
            throw new IllegalArgumentException();
        }
        String copyName = this.pmh_.getNewUniqueCopyName(allInvests, this.pd_.getInvestigator(useKey));
        this.pendingKey_ = null;
        this.pip_.setDupName(copyName);
        this.pip_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(INVEST_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKey(this.rtdi_.selectedRows);
        PertFilter invFilter = new PertFilter(8, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(invFilter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    protected void enableTopPane(boolean enable) {
        this.rtdi_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Integer noCount = new Integer(0);
        List selKeys = this.rtdi_.selectedRows == null ? null : ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKeys(this.rtdi_.selectedRows);
        this.rtdi_.rowElements.clear();
        Map invRefs = da.getAllInvestigatorReferenceCounts(false);
        Iterator iit = this.pd_.getInvestigatorKeys();
        while (iit.hasNext()) {
            String key = (String)iit.next();
            String invest = this.pd_.getInvestigator(key);
            Integer count = (Integer)invRefs.get(key);
            if (count == null) {
                count = noCount;
            }
            TrueObjChoiceContent tocc = new TrueObjChoiceContent(invest, key);
            PertManageHelper.ToccWithRefCount twrc = new PertManageHelper.ToccWithRefCount(tocc, count);
            this.rtdi_.rowElements.add(twrc);
        }
        this.pmh_.updateAndReselect(fireChange, this.rtdi_, this, INVEST_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (!key.equals(INVEST_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = null;
        this.rtdi_.clearSelections(false);
        this.pip_.setEditName(this.pendingKey_);
        this.pip_.startEditing();
    }

    protected void doAnEdit(String key) {
        if (!key.equals(INVEST_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKey(this.rtdi_.selectedRows);
        this.pip_.setEditName(this.pendingKey_);
        this.pip_.startEditing();
    }

    protected void doADelete(String key) {
        if (key.equals(INVEST_KEY)) {
            String deleteKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtdi_.getModel()).getSelectedKey(this.rtdi_.selectedRows);
            if (this.deleteAnInvestigator(deleteKey)) {
                this.pet_.itemDeleted(INVEST_KEY);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean deleteAnInvestigator(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getInvestReferenceSet(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deleteInvestigator");
        da.killOffDependencies(refs, support);
        PertDataChange pdc2 = this.pd_.deleteInvestigator(key);
        support.addEdit(new PertDataChangeCmd(pdc2));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private void joinInvestigators(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        String name = this.pip_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertTargets");
        DependencyAnalyzer.Dependencies refs = da.getInvestigatorMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeInvestigatorNames(this.joinKeys_, this.pendingKey_, name);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    public void editAnInvest(String key, int what) {
        String name = this.pip_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createInvestigatorName" : "undo.editInvestigatorName");
        if (this.pendingKey_ == null) {
            this.pendingKey_ = this.pd_.getNextDataKey();
        }
        PertDataChange pdc = this.pd_.setInvestigator(this.pendingKey_, name);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }
}

