/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.ui.dialogs.utils.SelectionOracle;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertManageHelper {
    private PerturbationData pd_;
    private ResourceManager rMan_;
    private JFrame parent_;
    private GridBagConstraints gbc_;
    private ImageIcon jump_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertManageHelper(JFrame parent, PerturbationData pd, ResourceManager rMan, GridBagConstraints gbc, PendingEditTracker pet) {
        this.parent_ = parent;
        this.pd_ = pd;
        this.rMan_ = rMan;
        this.gbc_ = gbc;
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FastForward16.gif");
        this.jump_ = new ImageIcon(ugif);
    }

    public ImageIcon getJumpIcon() {
        return this.jump_;
    }

    public String getNewUniqueCopyName(Set existingNames, String baseName) {
        String origName;
        String testName;
        int lastCopyNum = 0;
        while (DataUtil.containsKey(existingNames, testName = UiUtil.createCopyName(origName = baseName, lastCopyNum++))) {
        }
        return testName;
    }

    public String getMostUsedKey(Map countMap, List usedKeys) {
        int numJoin = usedKeys.size();
        Integer noCount = new Integer(0);
        int maxRefs = Integer.MIN_VALUE;
        String useKey = null;
        for (int i = 0; i < numJoin; ++i) {
            String targKey = (String)usedKeys.get(i);
            Integer refs = (Integer)countMap.get(targKey);
            if (refs == null) {
                refs = noCount;
            }
            if (refs <= maxRefs) continue;
            maxRefs = refs;
            useKey = targKey;
        }
        return useKey;
    }

    public int findSelectedRow(ReadOnlyTable rtab, String whichKey, SelectionOracle oracle, String tableID) {
        int selRow = -1;
        if (whichKey != null) {
            int numElem = rtab.rowElements.size();
            for (int j = 0; j < numElem; ++j) {
                Object obj = rtab.rowElements.get(j);
                if (!oracle.tableRowMatches(whichKey, obj, tableID)) continue;
                selRow = rtab.getModel().mapToSelectionIndex(obj, rtab.rowElements);
                break;
            }
        }
        return selRow;
    }

    public void selectTableRow(ReadOnlyTable rtab, String whichKey, SelectionOracle oracle, String tableID) {
        int selRow = this.findSelectedRow(rtab, whichKey, oracle, tableID);
        if (selRow == -1) {
            rtab.clearSelections(false);
        } else {
            rtab.getTable().getSelectionModel().setSelectionInterval(selRow, selRow);
            rtab.makeSelectionVisible(selRow);
        }
    }

    public void updateAndReselect(boolean fireChange, ReadOnlyTable rtab, SelectionOracle oracle, String tableID, List selKeys) {
        rtab.updateTable(fireChange, -1);
        if (selKeys != null && !selKeys.isEmpty()) {
            ListSelectionModel lsm = rtab.getTable().getSelectionModel();
            int numSel = selKeys.size();
            for (int i = 0; i < numSel; ++i) {
                String key = (String)selKeys.get(i);
                int selRow = this.findSelectedRow(rtab, key, oracle, tableID);
                if (selRow == -1) continue;
                lsm.addSelectionInterval(selRow, selRow);
            }
        }
    }

    public String getSelectedEnumVal(EditableTable et) {
        int[] sel = et.getSelectedRows();
        if (sel.length != 1) {
            return null;
        }
        EditableTable.OneEnumTableModel oetm = (EditableTable.OneEnumTableModel)et.getModel();
        List vft = oetm.getValuesFromTable();
        EditableTable.OneEnumTableModel.TableRow tr = (EditableTable.OneEnumTableModel.TableRow)vft.get(sel[0]);
        return tr.enumChoice.internal;
    }

    public EditableTable.TableParams tableParamsForAnnot(List annotList) {
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = true;
        etp.tableIsUnselectable = false;
        etp.buttons = 5;
        etp.singleSelectOnly = true;
        etp.buttonsOnSide = true;
        etp.perColumnEnums = new HashMap();
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, annotList));
        return etp;
    }

    public ArrayList buildAnnotEnum() {
        Vector annotOps = this.pd_.getPertAnnotations().getAnnotationOptions();
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        Iterator ait = annotOps.iterator();
        int count = 0;
        while (ait.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)ait.next();
            retval.add(new EnumCell(tocc.name, (String)tocc.val, count, count));
            ++count;
        }
        return retval;
    }

    public List buildAnnotDisplayList(List annotKeys, EditableTable estAnnot, List annotList, boolean forHotUpdate) {
        ArrayList<EditableTable.OneEnumTableModel.TableRow> retval = new ArrayList<EditableTable.OneEnumTableModel.TableRow>();
        if (annotKeys == null) {
            return retval;
        }
        EditableTable.OneEnumTableModel rpt = (EditableTable.OneEnumTableModel)estAnnot.getModel();
        Iterator akit = annotKeys.iterator();
        int count = 0;
        int useIndex = -1;
        int numA = annotList.size();
        while (akit.hasNext()) {
            String annotID = forHotUpdate ? ((EditableTable.OneEnumTableModel.TableRow)akit.next()).enumChoice.internal : (String)akit.next();
            EditableTable.OneEnumTableModel.TableRow tr = rpt.new EditableTable.OneEnumTableModel.TableRow();
            tr.origOrder = new Integer(count++);
            for (int i = 0; i < numA; ++i) {
                EnumCell ecp = (EnumCell)annotList.get(i);
                if (!annotID.equals(ecp.internal)) continue;
                useIndex = i;
                break;
            }
            if (useIndex == -1) {
                if (forHotUpdate) continue;
                throw new IllegalStateException();
            }
            tr.enumChoice = new EnumCell((EnumCell)annotList.get(useIndex));
            retval.add(tr);
        }
        return retval;
    }

    public List fixupFrozenAnnot(List frozenAnnots) {
        if (frozenAnnots == null) {
            return null;
        }
        ArrayList<String> currAnnots = new ArrayList<String>();
        HashSet<Object> surviving = new HashSet<Object>();
        Vector annotOps = this.pd_.getPertAnnotations().getAnnotationOptions();
        Iterator ait = annotOps.iterator();
        while (ait.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)ait.next();
            surviving.add(tocc.val);
        }
        int numFroz = frozenAnnots.size();
        for (int i = 0; i < numFroz; ++i) {
            String testKey = (String)frozenAnnots.get(i);
            if (!surviving.contains(testKey)) continue;
            currAnnots.add(testKey);
        }
        return currAnnots;
    }

    public PerturbationData.RegionRestrict fixupFrozenRegRes(PerturbationData.RegionRestrict frozenRegRes) {
        if (frozenRegRes == null) {
            return null;
        }
        ArrayList<String> regList = new ArrayList<String>();
        TimeCourseData tcd = Database.getDB().getTimeCourseData();
        Set surviving = tcd.getRegions();
        Iterator rit = frozenRegRes.getRegions();
        while (rit.hasNext()) {
            String region = (String)rit.next();
            if (!DataUtil.containsKey(surviving, region)) continue;
            regList.add(region);
        }
        PerturbationData.RegionRestrict currRegRes = new PerturbationData.RegionRestrict(regList);
        return currRegRes;
    }

    public JPanel addEditButton(JPanel tablePane, String label, boolean onBottom, ActionListener alisten) {
        JPanel tableWithButton = new JPanel();
        tableWithButton.setLayout(new GridBagLayout());
        UiUtil.gbcSet(this.gbc_, 0, 0, 5, 5, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        tableWithButton.add((Component)tablePane, this.gbc_);
        if (onBottom) {
            UiUtil.gbcSet(this.gbc_, 0, 5, 5, 1, 0, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        } else {
            UiUtil.gbcSet(this.gbc_, 5, 0, 1, 5, 0, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        }
        JButton jumpButton = new JButton(this.rMan_.getString(label), this.jump_);
        jumpButton.addActionListener(alisten);
        tableWithButton.add((Component)jumpButton, this.gbc_);
        tableWithButton.setBorder(BorderFactory.createEtchedBorder());
        return tableWithButton;
    }

    public JPanel componentWithJumpButton(JComponent comp, JButton jump) {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        UiUtil.gbcSet(this.gbc_, 0, 0, 4, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        retval.add((Component)comp, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.0, 1.0);
        retval.add((Component)jump, this.gbc_);
        return retval;
    }

    public boolean warnAndAsk(DependencyAnalyzer.Dependencies refs) {
        if (refs.type == 0) {
            return this.warnAndAskToDie(refs);
        }
        if (refs.type == 12 || refs.type == 14 || refs.type == 5) {
            return this.warnAndAskToDieOnMerge(refs);
        }
        if (refs.type == 1 || refs.type == 2 || refs.type == 3) {
            return this.warnAndAskToPrune(refs);
        }
        throw new IllegalStateException();
    }

    public boolean warnAndAskToDie(DependencyAnalyzer.Dependencies refs) {
        int numWarns = 0;
        String measWarn = null;
        if (refs.measureProps != null && refs.measureProps.size() > 0) {
            measWarn = MessageFormat.format(this.rMan_.getString("pertDelete.measurePropFormat"), new Integer(refs.measureProps.size()));
            ++numWarns;
        }
        String sourceWarn = null;
        if (refs.pertSources != null && refs.pertSources.size() > 0) {
            sourceWarn = MessageFormat.format(this.rMan_.getString("pertDelete.pertSourcesFormat"), new Integer(refs.pertSources.size()));
            ++numWarns;
        }
        String sourceInfoWarn = null;
        if (refs.experiments != null && refs.experiments.size() > 0) {
            sourceInfoWarn = MessageFormat.format(this.rMan_.getString("pertDelete.pertSourceInfosFormat"), new Integer(refs.experiments.size()));
            ++numWarns;
        }
        String dataPointWarn = null;
        if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
            dataPointWarn = MessageFormat.format(this.rMan_.getString("pertDelete.dataPointFormat"), new Integer(refs.dataPoints.size()));
            ++numWarns;
        }
        String timeCourseWarn = null;
        if (refs.timeCourseRefs != null && refs.timeCourseRefs.size() > 0) {
            timeCourseWarn = MessageFormat.format(this.rMan_.getString("pertDelete.timeCourseFormat"), new Integer(refs.timeCourseRefs.size()));
            ++numWarns;
        }
        if (numWarns == 0) {
            return true;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.rMan_.getString("pertDelete.haveDependencies"));
        if (measWarn != null) {
            buf.append(measWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (sourceWarn != null) {
            buf.append(sourceWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (sourceInfoWarn != null) {
            buf.append(sourceInfoWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (dataPointWarn != null) {
            buf.append(dataPointWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (timeCourseWarn != null) {
            buf.append(timeCourseWarn);
        }
        buf.append("\n");
        buf.append(this.rMan_.getString("pertDelete.continueQ"));
        String desc = UiUtil.convertMessageToHtml(buf.toString());
        int doit = JOptionPane.showConfirmDialog(this.parent_, desc, this.rMan_.getString("pertDelete.gottaDeleteTitle"), 2);
        return doit == 0;
    }

    public boolean warnAndAskToDieOnMerge(DependencyAnalyzer.Dependencies refs) {
        int numWarns = 0;
        String timeCourseWarn = null;
        if (refs.timeCourseMergeRefs != null && refs.timeCourseMergeRefs.size() > 0) {
            timeCourseWarn = MessageFormat.format(this.rMan_.getString("pertDelete.timeCourseFormat"), new Integer(refs.timeCourseMergeRefs.size()));
            ++numWarns;
        }
        if (numWarns == 0) {
            return true;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.rMan_.getString("pertDelete.haveTCMergeDependencies"));
        if (timeCourseWarn != null) {
            buf.append(timeCourseWarn);
        }
        buf.append("\n");
        buf.append(this.rMan_.getString("pertDelete.continueQ"));
        String desc = UiUtil.convertMessageToHtml(buf.toString());
        int doit = JOptionPane.showConfirmDialog(this.parent_, desc, this.rMan_.getString("pertDelete.gottaDeleteTCMergeTitle"), 2);
        return doit == 0;
    }

    public String getUnique(Vector sno, String baseName) {
        HashSet<String> existing = new HashSet<String>();
        Iterator snit = sno.iterator();
        while (snit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)snit.next();
            existing.add(tocc.name);
        }
        String copyName = this.getNewUniqueCopyName(existing, baseName);
        return copyName;
    }

    public boolean warnAndAskToPrune(DependencyAnalyzer.Dependencies refs) {
        int numWarns = 0;
        String sourceDefWarn = null;
        if (refs.pertSources != null && refs.pertSources.size() > 0) {
            sourceDefWarn = MessageFormat.format(this.rMan_.getString("pertPrune.prunePertSourceDefsFormat"), new Integer(refs.pertSources.size()));
            ++numWarns;
        }
        String sourceInfoWarn = null;
        if (refs.experiments != null && refs.experiments.size() > 0) {
            sourceInfoWarn = MessageFormat.format(this.rMan_.getString("pertPrune.prunePertSourceInfosFormat"), new Integer(refs.experiments.size()));
            ++numWarns;
        }
        String dataPointWarn = null;
        if (refs.dataPoints != null && refs.dataPoints.size() > 0) {
            dataPointWarn = MessageFormat.format(this.rMan_.getString("pertPrune.pruneDataPointFormat"), new Integer(refs.dataPoints.size()));
            ++numWarns;
        }
        if (numWarns == 0) {
            return true;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.rMan_.getString("pertPrune.havePruneDependencies"));
        if (sourceDefWarn != null) {
            buf.append(sourceDefWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (sourceInfoWarn != null) {
            buf.append(sourceInfoWarn);
            if (--numWarns > 0) {
                buf.append("\n");
            }
        }
        if (dataPointWarn != null) {
            buf.append(dataPointWarn);
        }
        buf.append("\n");
        buf.append(this.rMan_.getString("pertPrune.continueQ"));
        String desc = UiUtil.convertMessageToHtml(buf.toString());
        int doit = JOptionPane.showConfirmDialog(this.parent_, desc, this.rMan_.getString("pertPrune.gottaPruneTitle"), 2);
        return doit == 0;
    }

    public static class FilterListRenderer
    extends JLabel
    implements ListCellRenderer {
        private Set activeValues_;
        private ListCellRenderer defaultRenderer_;

        public FilterListRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer_ = defaultRenderer;
            this.activeValues_ = new HashSet();
        }

        public void setActive(Set values) {
            this.activeValues_.clear();
            this.activeValues_.addAll(values);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            try {
                this.setOpaque(isSelected);
                if (isSelected) {
                    Component aComp = this.defaultRenderer_.getListCellRendererComponent(list, value, index, true, hasFocus);
                    this.setBackground(aComp.getBackground());
                }
                if (value == null) {
                    return this;
                }
                this.setText(value.toString());
                this.setEnabled(this.activeValues_.contains(value));
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }

    public static class TimeComparator
    implements Comparator {
        private TimeAxisDefinition tad_ = Database.getDB().getTimeAxisDefinition();
        private boolean namedStages_ = this.tad_.haveNamedStages();

        public int compare(Object o1, Object o2) {
            int val2a;
            int val1a;
            String str1 = ((String)o1).trim();
            String str2 = ((String)o2).trim();
            int dash1 = str1.indexOf(" to ");
            int dash2 = str2.indexOf(" to ");
            String str1a = str1;
            String str1b = null;
            if (dash1 != -1) {
                str1a = str1.substring(0, dash1);
                str1b = str1.substring(dash1 + 4);
            }
            String str2a = str2;
            String str2b = null;
            if (dash2 != -1) {
                str2a = str2.substring(0, dash2);
                str2b = str2.substring(dash2 + 4);
            }
            int val1b = -1;
            if (this.namedStages_) {
                val1a = this.tad_.getIndexForNamedStage(str1a.trim());
                if (str1b != null) {
                    val1b = this.tad_.getIndexForNamedStage(str1b.trim());
                }
            } else {
                val1a = new Integer(str1a);
                if (str1b != null) {
                    val1b = new Integer(str1b);
                }
            }
            int val2b = -1;
            if (this.namedStages_) {
                val2a = this.tad_.getIndexForNamedStage(str2a.trim());
                if (str2b != null) {
                    val2b = this.tad_.getIndexForNamedStage(str2b.trim());
                }
            } else {
                val2a = new Integer(str2a);
                if (str2b != null) {
                    val2b = new Integer(str2b);
                }
            }
            if (val1a != val2a) {
                return val1a - val2a;
            }
            if (val1b != -1 || val2b != -1) {
                if (val1b != -1 && val2b != -1) {
                    return val1b - val2b;
                }
                if (val1b == -1) {
                    return -1;
                }
                if (val2b == -1) {
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class DoubleStrComparator
    implements Comparator {
        private Pattern pattern_ = Pattern.compile("--*");
        private Matcher matcher_ = this.pattern_.matcher("");

        public int compare(Object o1, Object o2) {
            String str1 = ((String)o1).trim();
            String str2 = ((String)o2).trim();
            boolean str1IsNS = str1.equalsIgnoreCase("NS");
            boolean str2IsNS = str2.equalsIgnoreCase("NS");
            this.matcher_.reset(str1);
            boolean str1IsDashes = this.matcher_.matches();
            this.matcher_.reset(str2);
            boolean str2IsDashes = this.matcher_.matches();
            if (str1IsDashes || str2IsDashes) {
                if (str1IsDashes && str2IsDashes) {
                    return str1.length() - str2.length();
                }
                if (str1IsDashes) {
                    return 1;
                }
                return -1;
            }
            Double doub1 = null;
            Double doub2 = null;
            try {
                doub1 = str1IsNS ? new Double(-1.0E-10) : new Double(str1);
            }
            catch (NumberFormatException nfex) {
                return 1;
            }
            try {
                doub2 = str2IsNS ? new Double(-1.0E-10) : new Double(str2);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
            return doub1.compareTo(doub2);
        }
    }

    public static class ToccWithRefCount {
        public TrueObjChoiceContent tocc;
        public int refCount;

        public ToccWithRefCount(TrueObjChoiceContent tocc, int refCount) {
            this.tocc = tocc;
            this.refCount = refCount;
        }
    }

    public static class NameWithHiddenIDAndRefCountModel
    extends ReadOnlyTable.TableModel {
        public static final int NAME = 0;
        public static final int REF_COUNT = 1;
        private static final int NUM_COL_ = 2;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        public NameWithHiddenIDAndRefCountModel(String mainColName) {
            super(2);
            this.colNames_ = new String[]{mainColName, "pertHelper.refCount"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertManageHelper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertManageHelper.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                ToccWithRefCount twr = (ToccWithRefCount)iit.next();
                this.columns_[0].add(twr.tocc.name);
                this.columns_[1].add(new Integer(twr.refCount));
                this.hiddenColumns_[0].add(twr.tocc.val);
            }
        }

        public String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

