/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertManagePrefaceDialog
extends JDialog {
    private JComboBox sourceCombo_;
    private JComboBox targCombo_;
    private boolean haveResult_ = false;
    private PertFilterExpression pertFilterExpr_;

    public PertManagePrefaceDialog(JFrame parent) {
        super(parent, ResourceManager.getManager().getString("pertManagePreface.title"), true);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(600, 350);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel mainLabel = new JLabel(rMan.getString("pertManagePreface.chooseOpFilters"));
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum++, 2, 1, 0, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        cp.add((Component)mainLabel, gbc);
        PerturbationData pd = Database.getDB().getPertData();
        SortedSet srcCand = pd.getCandidates(1);
        String ncstr = rMan.getString("pertManagePreface.chooseAll");
        Vector<String> srcVec = new Vector<String>();
        srcVec.add(ncstr);
        srcVec.addAll(srcCand);
        JLabel srcLabel = new JLabel(rMan.getString("pertManagePreface.chooseSource"));
        this.sourceCombo_ = new JComboBox(srcVec);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        cp.add((Component)srcLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.sourceCombo_, gbc);
        SortedSet targCand = pd.getCandidates(5);
        Vector<String> targVec = new Vector<String>();
        targVec.add(ncstr);
        targVec.addAll(targCand);
        JLabel targLabel = new JLabel(rMan.getString("pertManagePreface.chooseTarg"));
        this.targCombo_ = new JComboBox(targVec);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        cp.add((Component)targLabel, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.targCombo_, gbc);
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (PertManagePrefaceDialog.this.stashResults(true)) {
                        PertManagePrefaceDialog.this.setVisible(false);
                        PertManagePrefaceDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (PertManagePrefaceDialog.this.stashResults(false)) {
                        PertManagePrefaceDialog.this.setVisible(false);
                        PertManagePrefaceDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, rowNum, 4, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public boolean haveResult() {
        return this.haveResult_;
    }

    public PertFilterExpression getFilterExpr() {
        return this.pertFilterExpr_;
    }

    private boolean stashResults(boolean ok) {
        if (ok) {
            PertFilter targFilter;
            PertFilter srcFilter;
            if (this.sourceCombo_.getSelectedIndex() == 0) {
                srcFilter = null;
            } else {
                String useSrc = (String)this.sourceCombo_.getSelectedItem();
                srcFilter = new PertFilter(1, 0, useSrc);
            }
            if (this.targCombo_.getSelectedIndex() == 0) {
                targFilter = null;
            } else {
                String useTarg = (String)this.targCombo_.getSelectedItem();
                targFilter = new PertFilter(5, 0, useTarg);
            }
            if (srcFilter == null && targFilter == null) {
                this.pertFilterExpr_ = new PertFilterExpression(1);
            } else if (srcFilter != null) {
                this.pertFilterExpr_ = new PertFilterExpression(srcFilter);
                if (targFilter != null) {
                    this.pertFilterExpr_ = new PertFilterExpression(3, this.pertFilterExpr_, targFilter);
                }
            } else {
                this.pertFilterExpr_ = new PertFilterExpression(targFilter);
            }
            this.haveResult_ = true;
            return true;
        }
        this.haveResult_ = false;
        return true;
    }
}

