/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.utils.BuildListUtil;
import org.systemsbiology.biotapestry.ui.dialogs.utils.DialogSupport;
import org.systemsbiology.biotapestry.util.CheckBoxList;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class PertMappingPanel
extends JPanel {
    private CheckBoxList lwnt_;
    private CheckBoxList lw_;
    private PerturbationData pd_;
    private BuildListUtil.BuildListResult targResult_;
    private BuildListUtil.BuildListResult srcResult_;
    private DialogSupport ds_;
    private BuildListUtil tblu_;
    private BuildListUtil sblu_;
    private ArrayList allTabs_;

    public PertMappingPanel(JFrame parent, String nodeName, List currEntries, List currSources, boolean msgSeparate, boolean forceDrop) {
        ResourceManager rMan = ResourceManager.getManager();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.ds_ = new DialogSupport(rMan, gbc);
        int rowNum = 0;
        int columns = 6;
        this.pd_ = Database.getDB().getPertData();
        Vector targCand = this.pd_.getTargetOptions(false);
        this.tblu_ = new BuildListUtil(parent, nodeName, currEntries == null ? new ArrayList() : new ArrayList(currEntries), targCand, forceDrop);
        this.targResult_ = this.tblu_.getBuildListResult();
        String msg = rMan.getString("pertMapping.targets");
        msg = MessageFormat.format(msg, nodeName);
        JLabel lab = new JLabel(msg);
        rowNum = this.ds_.addWidgetFullRow(this, lab, true, true, rowNum, columns);
        this.lw_ = this.tblu_.getBuiltList();
        JScrollPane jsp = new JScrollPane(this.lw_);
        rowNum = this.ds_.addTable(this, jsp, 5, rowNum, columns);
        if (this.targResult_.firstSel != -1) {
            this.lw_.ensureIndexIsVisible(this.targResult_.firstSel);
        }
        Vector srcCand = this.pd_.getSourceNameOptions();
        this.sblu_ = new BuildListUtil(parent, nodeName, currSources == null ? new ArrayList() : new ArrayList(currSources), srcCand, false);
        this.srcResult_ = this.sblu_.getBuildListResult();
        msg = rMan.getString("pertMapping.sources");
        msg = MessageFormat.format(msg, nodeName);
        lab = new JLabel(msg);
        rowNum = this.ds_.addWidgetFullRow(this, lab, true, true, rowNum, columns);
        this.lwnt_ = this.sblu_.getBuiltList();
        jsp = new JScrollPane(this.lwnt_);
        rowNum = this.ds_.addTable(this, jsp, 5, rowNum, columns);
        if (this.srcResult_.firstSel != -1) {
            this.lwnt_.ensureIndexIsVisible(this.srcResult_.firstSel);
        }
        this.allTabs_ = new ArrayList();
        this.allTabs_.add(this.targResult_);
        this.allTabs_.add(this.srcResult_);
        if (!msgSeparate) {
            JPanel messagePanel = BuildListUtil.buildMessagePanel(this.allTabs_);
            rowNum = this.ds_.addTable(this, messagePanel, 5, rowNum, columns);
        }
    }

    public List getAllTabs() {
        return this.allTabs_;
    }

    public List getEntryList() {
        return this.tblu_.getFinishedEntryList();
    }

    public List getSourceList() {
        return this.sblu_.getFinishedEntryList();
    }

    public boolean stashForOKSupport() {
        ResourceManager rMan = ResourceManager.getManager();
        this.tblu_.stashForOKSupport(rMan.getString("pertMapping.forTargets"));
        this.sblu_.stashForOKSupport(rMan.getString("pertMapping.forSources"));
        return true;
    }
}

