/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertMeasureAddOrEditPanel
extends AnimatedSplitEditPanel {
    private JTextField nameField_;
    private JComboBox nameCombo_;
    private JComboBox scaleCombo_;
    private JComboBox mergeScaleCombo_;
    private JTextField negThresh_;
    private JComboBox negCombo_;
    private JTextField posThresh_;
    private JComboBox posCombo_;
    private PerturbationData pd_;
    private String currKey_;
    private String dupName_;
    private HashSet allMerge_;
    private MeasureProps newProps_;
    private PertManageHelper pmh_;
    private TreeSet nameOptions_;
    private TreeSet posOptions_;
    private TreeSet negOptions_;

    public PertMeasureAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey) {
        super(parent, pet, myKey, 4);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        int editRow = 0;
        this.nameField_ = new JTextField();
        this.scaleCombo_ = new JComboBox();
        JButton scJump = new JButton(this.rMan_.getString("pdpe.jump"), this.pmh_.getJumpIcon());
        scJump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertMeasureAddOrEditPanel.this.scaleCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertMeasureAddOrEditPanel.this.pet_.jumpToRemoteEdit("setup", "editMeasScale", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel scCombo = this.pmh_.componentWithJumpButton(this.scaleCombo_, scJump);
        editRow = this.ds_.installLabelJCompPair(editPanel, "pertMeasureEdit.name", this.nameField_, "pertMeasureEdit.scale", scCombo, editRow, 4, true);
        this.negThresh_ = new JTextField();
        this.posThresh_ = new JTextField();
        editRow = this.ds_.installLabelJCompPair(editPanel, "pertMeasureEdit.negThresh", this.negThresh_, "pertMeasureEdit.posThresh", this.posThresh_, editRow, 4, true);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        int mergeRow = 0;
        this.nameCombo_ = new JComboBox();
        this.nameCombo_.setEditable(true);
        this.mergeScaleCombo_ = new JComboBox();
        JButton scJumpToo = new JButton(this.rMan_.getString("pdpe.jump"), this.pmh_.getJumpIcon());
        scJumpToo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertMeasureAddOrEditPanel.this.mergeScaleCombo_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertMeasureAddOrEditPanel.this.pet_.jumpToRemoteEdit("setup", "editMeasScale", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel scComboToo = this.pmh_.componentWithJumpButton(this.mergeScaleCombo_, scJumpToo);
        mergeRow = this.ds_.installLabelJCompPair(mergePanel, "pertMeasureEdit.name", this.nameCombo_, "pertMeasureEdit.scale", scComboToo, mergeRow, 4, true);
        this.negCombo_ = new JComboBox();
        this.posCombo_ = new JComboBox();
        this.negCombo_.setEditable(true);
        this.posCombo_.setEditable(true);
        mergeRow = this.ds_.installLabelJCompPair(mergePanel, "pertMeasureEdit.negThresh", this.negCombo_, "pertMeasureEdit.posThresh", this.posCombo_, mergeRow, 4, true);
        this.makeMultiMode(editPanel, mergePanel, 4);
        this.finishConstruction();
    }

    public void setEditMeasureProps(String newKey) {
        this.mode_ = 1;
        this.currKey_ = newKey;
        this.displayProperties();
    }

    public void setMeasurePropsForDup(String origKey) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        this.dupName_ = this.pmh_.getUnique(md.getMeasurementOptions(), md.getMeasureProps(this.currKey_).getName());
        this.displayProperties();
    }

    public String setMeasurePropsForMerge(List joinKeys) {
        this.mode_ = 2;
        this.allMerge_ = new HashSet(joinKeys);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map refCounts = da.getAllMeasurePropReferenceCounts();
        this.currKey_ = this.pmh_.getMostUsedKey(refCounts, joinKeys);
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        this.nameOptions_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.posOptions_ = new TreeSet();
        this.negOptions_ = new TreeSet();
        int numk = joinKeys.size();
        for (int i = 0; i < numk; ++i) {
            String nextJk = (String)joinKeys.get(i);
            MeasureProps mp = md.getMeasureProps(nextJk);
            this.nameOptions_.add(mp.getName());
            this.posOptions_.add(mp.getPosThresh());
            this.negOptions_.add(mp.getNegThresh());
        }
        this.displayProperties();
        return this.currKey_;
    }

    public MeasureProps getResult() {
        return this.newProps_;
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        Vector scaleTypes = this.pd_.getMeasureDictionary().getScaleOptions();
        if (this.mode_ == 2) {
            UiUtil.replaceComboItems(this.mergeScaleCombo_, scaleTypes);
            UiUtil.replaceComboItems(this.nameCombo_, new Vector(this.nameOptions_));
            UiUtil.replaceComboItems(this.posCombo_, new Vector(this.posOptions_));
            UiUtil.replaceComboItems(this.negCombo_, new Vector(this.negOptions_));
        } else {
            UiUtil.replaceComboItems(this.scaleCombo_, scaleTypes);
        }
    }

    protected boolean stashResults() {
        String nameText;
        String ntText;
        String ptText;
        boolean badNum = false;
        Double posThresh = null;
        Double negThresh = null;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.posCombo_.getEditor().getEditorComponent();
            ptText = jtc.getText().trim();
            jtc = (JTextComponent)this.negCombo_.getEditor().getEditorComponent();
            ntText = jtc.getText().trim();
        } else {
            ptText = this.posThresh_.getText().trim();
            ntText = this.negThresh_.getText().trim();
        }
        try {
            if (!ptText.equals("")) {
                posThresh = Double.valueOf(ptText);
            }
            if (!ntText.equals("")) {
                negThresh = Double.valueOf(ntText);
            }
        }
        catch (NumberFormatException nfex) {
            badNum = true;
        }
        if (negThresh != null && posThresh != null && negThresh > posThresh) {
            badNum = true;
        }
        if (badNum) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertMeasureEdit.badNumber"), this.rMan_.getString("pertMeasureEdit.badNumberTitle"), 0);
            return false;
        }
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.nameCombo_.getEditor().getEditorComponent();
            nameText = jtc.getText().trim();
        } else {
            nameText = this.nameField_.getText().trim();
        }
        if (nameText.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmae.emptyName"), this.rMan_.getString("pmae.emptyNameTitle"), 0);
            return false;
        }
        JComboBox useCombo = this.mode_ == 2 ? this.mergeScaleCombo_ : this.scaleCombo_;
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)useCombo.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmae.emptyScale"), this.rMan_.getString("pmae.emptyScaleTitle"), 0);
            return false;
        }
        String newScaleKey = (String)tocc.val;
        MeasureScale ms = md.getMeasureScale(newScaleKey);
        BoundedDoubMinMax illegal = ms.getIllegalRange();
        if (illegal != null) {
            boolean outOfRange = false;
            if (negThresh != null) {
                outOfRange = illegal.contained(negThresh);
            }
            if (posThresh != null) {
                boolean bl = outOfRange = outOfRange || illegal.contained(posThresh);
            }
            if (outOfRange) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmae.valueOutOfRangeForScale"), this.rMan_.getString("pmae.valueOutOfRangeForScaleTitle"), 0);
                return false;
            }
        }
        Iterator kit = md.getKeys();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            MeasureProps mp = md.getMeasureProps(key);
            String name = mp.getName();
            if (!DataUtil.keysEqual(name, nameText)) continue;
            boolean problem = false;
            if (this.mode_ == 2) {
                problem = !this.allMerge_.contains(key);
            } else {
                boolean bl = problem = this.mode_ == 3 || this.currKey_ == null || !this.currKey_.equals(key);
            }
            if (!problem) continue;
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmae.dupName"), this.rMan_.getString("pmae.dupNameTitle"), 0);
            return false;
        }
        if (this.currKey_ == null || this.mode_ == 3) {
            String nextKey = md.getNextDataKey();
            this.newProps_ = new MeasureProps(nextKey, nameText, newScaleKey, negThresh, posThresh);
        } else {
            MeasureProps currProps = md.getMeasureProps(this.currKey_);
            this.newProps_ = (MeasureProps)currProps.clone();
            this.newProps_.setName(nameText);
            this.newProps_.setScaleKey(newScaleKey);
            this.newProps_.setPosThresh(posThresh);
            this.newProps_.setNegThresh(negThresh);
        }
        return true;
    }

    private void displayProperties() {
        this.updateOptions();
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        switch (this.mode_) {
            case 1: {
                if (this.currKey_ == null) {
                    String empty = "";
                    this.nameField_.setText(empty);
                    this.posThresh_.setText(empty);
                    this.negThresh_.setText(empty);
                    UiUtil.initCombo(this.scaleCombo_);
                    this.cardLayout_.show(this.myCard_, "edit");
                } else {
                    MeasureProps currProps = md.getMeasureProps(this.currKey_);
                    this.stockEditFields(md, currProps, null);
                }
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 3: {
                MeasureProps currProps = md.getMeasureProps(this.currKey_);
                this.stockEditFields(md, currProps, this.dupName_);
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                MeasureProps currProps = md.getMeasureProps(this.currKey_);
                this.stockMergeFields(md, currProps);
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void stockEditFields(MeasureDictionary md, MeasureProps currProps, String nameOverride) {
        String currName = nameOverride == null ? currProps.getName() : nameOverride;
        this.nameField_.setText(currName);
        String scalekey = currProps.getScaleKey();
        TrueObjChoiceContent toccScale = md.getScaleChoice(scalekey);
        this.scaleCombo_.setSelectedItem(toccScale);
        Double posThresh = currProps.getPosThresh();
        String posThreshStr = posThresh == null ? "" : posThresh.toString();
        this.posThresh_.setText(posThreshStr);
        Double negThresh = currProps.getNegThresh();
        String negThreshStr = negThresh == null ? "" : negThresh.toString();
        this.negThresh_.setText(negThreshStr);
    }

    private void stockMergeFields(MeasureDictionary md, MeasureProps currProps) {
        String currName = currProps.getName();
        JTextComponent jtc = (JTextComponent)this.nameCombo_.getEditor().getEditorComponent();
        jtc.setText(currName);
        String scalekey = currProps.getScaleKey();
        TrueObjChoiceContent toccScale = md.getScaleChoice(scalekey);
        this.mergeScaleCombo_.setSelectedItem(toccScale);
        Double posThresh = currProps.getPosThresh();
        String posThreshStr = posThresh == null ? "" : posThresh.toString();
        jtc = (JTextComponent)this.posCombo_.getEditor().getEditorComponent();
        jtc.setText(posThreshStr);
        Double negThresh = currProps.getNegThresh();
        String negThreshStr = negThresh == null ? "" : negThresh.toString();
        jtc = (JTextComponent)this.negCombo_.getEditor().getEditorComponent();
        jtc.setText(negThreshStr);
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String nameFieldText;
        private String negThreshText;
        private String posThreshText;
        private TrueObjChoiceContent scaleComboTocc;

        MyFreezeDried() {
            if (PertMeasureAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.nameCombo_.getEditor().getEditorComponent();
                this.nameFieldText = jtc.getText().trim();
                jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.posCombo_.getEditor().getEditorComponent();
                this.posThreshText = jtc.getText().trim();
                jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.negCombo_.getEditor().getEditorComponent();
                this.negThreshText = jtc.getText().trim();
                this.scaleComboTocc = (TrueObjChoiceContent)PertMeasureAddOrEditPanel.this.mergeScaleCombo_.getSelectedItem();
            } else {
                this.nameFieldText = PertMeasureAddOrEditPanel.this.nameField_.getText();
                this.negThreshText = PertMeasureAddOrEditPanel.this.negThresh_.getText();
                this.posThreshText = PertMeasureAddOrEditPanel.this.posThresh_.getText();
                this.scaleComboTocc = (TrueObjChoiceContent)PertMeasureAddOrEditPanel.this.scaleCombo_.getSelectedItem();
            }
        }

        public boolean needToCancel() {
            MeasureDictionary md;
            if (PertMeasureAddOrEditPanel.this.mode_ == 2) {
                PertMeasureAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertMeasureAddOrEditPanel.this.currKey_ != null && PertMeasureAddOrEditPanel.this.mode_ == 1 && (md = PertMeasureAddOrEditPanel.this.pd_.getMeasureDictionary()).getMeasureProps(PertMeasureAddOrEditPanel.this.currKey_) == null) {
                PertMeasureAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            if (PertMeasureAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.nameCombo_.getEditor().getEditorComponent();
                jtc.setText(this.nameFieldText);
                jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.posCombo_.getEditor().getEditorComponent();
                jtc.setText(this.posThreshText);
                jtc = (JTextComponent)PertMeasureAddOrEditPanel.this.negCombo_.getEditor().getEditorComponent();
                jtc.setText(this.negThreshText);
                MeasureDictionary md = PertMeasureAddOrEditPanel.this.pd_.getMeasureDictionary();
                if (this.scaleComboTocc != null) {
                    TrueObjChoiceContent toccScale = md.getScaleChoice((String)this.scaleComboTocc.val);
                    PertMeasureAddOrEditPanel.this.mergeScaleCombo_.setSelectedItem(toccScale);
                }
            } else {
                PertMeasureAddOrEditPanel.this.nameField_.setText(this.nameFieldText);
                PertMeasureAddOrEditPanel.this.negThresh_.setText(this.negThreshText);
                PertMeasureAddOrEditPanel.this.posThresh_.setText(this.posThreshText);
                MeasureDictionary md = PertMeasureAddOrEditPanel.this.pd_.getMeasureDictionary();
                if (this.scaleComboTocc != null) {
                    TrueObjChoiceContent toccScale = md.getScaleChoice((String)this.scaleComboTocc.val);
                    PertMeasureAddOrEditPanel.this.scaleCombo_.setSelectedItem(toccScale);
                }
            }
        }
    }
}

