/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertMeasureScaleAddOrEditPanel
extends AnimatedSplitEditPanel {
    private EditOrMergeComps editComps_;
    private EditOrMergeComps mergeComps_;
    private PerturbationData pd_;
    private String currKey_;
    private String dupName_;
    private HashSet allMerge_;
    private MeasureScale newScale_;
    private PertManageHelper pmh_;
    private TreeSet nameOptions_;
    private TreeSet foldOptions_;
    private TreeSet minOptions_;
    private TreeSet maxOptions_;
    private TreeSet uchOptions_;

    public PertMeasureScaleAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey) {
        super(parent, pet, myKey, 6);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        this.editComps_ = new EditOrMergeComps();
        this.editComps_.compMode = 1;
        this.editComps_.nameField = new JTextField();
        this.editComps_.foldCheck = new JCheckBox(this.rMan_.getString("pmsaep.doFoldConvert"));
        this.editComps_.foldCombo = new JComboBox();
        this.editComps_.foldLabel = new JLabel(this.rMan_.getString("pmsaep.toFoldType"));
        this.editComps_.foldField = new JTextField();
        this.editComps_.foldFieldLabel = new JLabel(this.rMan_.getString("pmsaep.toFoldVal"));
        this.editComps_.illegalCheck = new JCheckBox(this.rMan_.getString("pmsaep.setIllegalBounds"));
        this.editComps_.minCombo = new JComboBox();
        this.editComps_.minLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMin"));
        this.editComps_.maxCombo = new JComboBox();
        this.editComps_.maxLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMax"));
        this.editComps_.minField = new JTextField();
        this.editComps_.minValLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMinVal"));
        this.editComps_.maxField = new JTextField();
        this.editComps_.maxValLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMaxVal"));
        this.editComps_.unchangedField = new JTextField();
        this.commonConstruct(editPanel, this.editComps_);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        this.mergeComps_ = new EditOrMergeComps();
        this.mergeComps_.compMode = 2;
        this.mergeComps_.nameField = new JComboBox();
        ((JComboBox)this.mergeComps_.nameField).setEditable(true);
        this.mergeComps_.foldCheck = new JCheckBox(this.rMan_.getString("pmsaep.doFoldConvert"));
        this.mergeComps_.foldCombo = new JComboBox();
        this.mergeComps_.foldLabel = new JLabel(this.rMan_.getString("pmsaep.toFoldType"));
        this.mergeComps_.foldField = new JComboBox();
        ((JComboBox)this.mergeComps_.foldField).setEditable(true);
        this.mergeComps_.foldFieldLabel = new JLabel(this.rMan_.getString("pmsaep.toFoldVal"));
        this.mergeComps_.illegalCheck = new JCheckBox(this.rMan_.getString("pmsaep.setIllegalBounds"));
        this.mergeComps_.minCombo = new JComboBox();
        this.mergeComps_.minLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMin"));
        this.mergeComps_.maxCombo = new JComboBox();
        this.mergeComps_.maxLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMax"));
        this.mergeComps_.minField = new JComboBox();
        ((JComboBox)this.mergeComps_.minField).setEditable(true);
        this.mergeComps_.minValLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMinVal"));
        this.mergeComps_.maxField = new JComboBox();
        ((JComboBox)this.mergeComps_.maxField).setEditable(true);
        this.mergeComps_.maxValLabel = new JLabel(this.rMan_.getString("pmsaep.illegalMaxVal"));
        this.mergeComps_.unchangedField = new JComboBox();
        ((JComboBox)this.mergeComps_.unchangedField).setEditable(true);
        this.commonConstruct(mergePanel, this.mergeComps_);
        this.makeMultiMode(editPanel, mergePanel, 4);
        this.finishConstruction();
    }

    private int commonConstruct(JPanel panel, EditOrMergeComps comps) {
        int currRow = 0;
        currRow = this.ds_.installLabelJCompPair(panel, "pmsaep.name", comps.nameField, "pmsaep.unchanged", comps.unchangedField, currRow, 6, false);
        comps.foldCheck.addActionListener(new ToFoldCheckListener(comps));
        comps.foldCombo.addActionListener(new ToFoldComboListener(comps));
        currRow = this.ds_.installLabelJCompTriple(panel, null, comps.foldCheck, comps.foldLabel, comps.foldCombo, comps.foldFieldLabel, comps.foldField, currRow, 6);
        comps.illegalCheck.addActionListener(new IllegalCheckListener(comps));
        comps.minCombo.addActionListener(new IllegalComboListener(comps, true));
        currRow = this.ds_.installLabelJCompTriple(panel, null, comps.illegalCheck, comps.minLabel, comps.minCombo, comps.minValLabel, comps.minField, currRow, 6);
        comps.maxCombo.addActionListener(new IllegalComboListener(comps, false));
        currRow = this.ds_.installLabelJCompTriple(panel, null, new JLabel(""), comps.maxLabel, comps.maxCombo, comps.maxValLabel, comps.maxField, currRow, 6);
        comps.foldCombo.setEnabled(false);
        comps.foldLabel.setEnabled(false);
        comps.minCombo.setEnabled(false);
        comps.maxCombo.setEnabled(false);
        comps.minLabel.setEnabled(false);
        comps.maxLabel.setEnabled(false);
        comps.minField.setEnabled(false);
        comps.minValLabel.setEnabled(false);
        comps.maxField.setEnabled(false);
        comps.maxValLabel.setEnabled(false);
        return currRow;
    }

    public void setEditMeasureScale(String currKey) {
        this.mode_ = 1;
        this.currKey_ = currKey;
        this.displayProperties();
    }

    public void setMeasureScaleForDup(String origKey) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        this.dupName_ = this.pmh_.getUnique(md.getScaleOptions(), md.getMeasureScale(origKey).getName());
        this.displayProperties();
    }

    public String setMeasureScaleForMerge(List joinKeys) {
        this.mode_ = 2;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        this.allMerge_ = new HashSet(joinKeys);
        this.currKey_ = null;
        String[] stdkeys = md.getStandardScaleKeys();
        for (int i = 0; i < stdkeys.length; ++i) {
            if (!joinKeys.contains(stdkeys[i])) continue;
            if (this.currKey_ != null) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.doubleDefaultMerge"), this.rMan_.getString("pmsaep.doubleDefaultMergeTitle"), 0);
                return null;
            }
            this.currKey_ = stdkeys[i];
        }
        if (this.currKey_ == null) {
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            Map refCounts = da.getAllMeasureScaleReferenceCounts(true);
            this.currKey_ = this.pmh_.getMostUsedKey(refCounts, joinKeys);
        }
        this.nameOptions_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.foldOptions_ = new TreeSet();
        this.minOptions_ = new TreeSet();
        this.maxOptions_ = new TreeSet();
        this.uchOptions_ = new TreeSet();
        int numk = joinKeys.size();
        for (int i = 0; i < numk; ++i) {
            BoundedDoubMinMax bdmm;
            MeasureScale.Conversion msc;
            String nextJk = (String)joinKeys.get(i);
            MeasureScale mp = md.getMeasureScale(nextJk);
            this.nameOptions_.add(mp.getName());
            Double uch = mp.getUnchanged();
            if (uch != null) {
                this.uchOptions_.add(uch.toString());
            }
            if ((msc = mp.getConvToFold()) != null && msc.type == 1) {
                this.foldOptions_.add(msc.factor.toString());
            }
            if ((bdmm = mp.getIllegalRange()) == null) continue;
            if (bdmm.min != Double.NEGATIVE_INFINITY) {
                this.minOptions_.add(Double.toString(bdmm.min));
            }
            if (bdmm.max == Double.POSITIVE_INFINITY) continue;
            this.maxOptions_.add(Double.toString(bdmm.max));
        }
        this.displayProperties();
        return this.currKey_;
    }

    public MeasureScale getResult() {
        return this.newScale_;
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        if (this.mode_ == 2) {
            UiUtil.replaceComboItems((JComboBox)this.mergeComps_.nameField, new Vector(this.nameOptions_));
            UiUtil.replaceComboItems((JComboBox)this.mergeComps_.foldField, new Vector(this.foldOptions_));
            UiUtil.replaceComboItems((JComboBox)this.mergeComps_.minField, new Vector(this.minOptions_));
            UiUtil.replaceComboItems((JComboBox)this.mergeComps_.maxField, new Vector(this.maxOptions_));
            UiUtil.replaceComboItems((JComboBox)this.mergeComps_.unchangedField, new Vector(this.uchOptions_));
            Vector convertTypes = MeasureScale.Conversion.getConvertChoices();
            UiUtil.replaceComboItems(this.mergeComps_.foldCombo, convertTypes);
            Vector illegalNeg = MeasureScale.getIllegalChoices(true);
            UiUtil.replaceComboItems(this.mergeComps_.minCombo, illegalNeg);
            Vector illegalPos = MeasureScale.getIllegalChoices(false);
            UiUtil.replaceComboItems(this.mergeComps_.maxCombo, illegalPos);
        } else {
            Vector convertTypes = MeasureScale.Conversion.getConvertChoices();
            UiUtil.replaceComboItems(this.editComps_.foldCombo, convertTypes);
            Vector illegalNeg = MeasureScale.getIllegalChoices(true);
            UiUtil.replaceComboItems(this.editComps_.minCombo, illegalNeg);
            Vector illegalPos = MeasureScale.getIllegalChoices(false);
            UiUtil.replaceComboItems(this.editComps_.maxCombo, illegalPos);
        }
    }

    protected boolean stashResults() {
        EditOrMergeComps useComps = this.mode_ == 2 ? this.mergeComps_ : this.editComps_;
        MeasureScale.Conversion conv = null;
        try {
            conv = this.buildToFoldResults(useComps);
        }
        catch (IOException ioex) {
            return false;
        }
        BoundedDoubMinMax illegal = null;
        try {
            illegal = this.buildRangeResults(useComps);
        }
        catch (IOException ioex) {
            return false;
        }
        String nameText = useComps.getText(useComps.nameField);
        if (nameText.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.emptyName"), this.rMan_.getString("pmsaep.emptyNameTitle"), 0);
            return false;
        }
        Double unchanged = null;
        String uchText = useComps.getText(useComps.unchangedField);
        if (!uchText.equals("")) {
            try {
                unchanged = Double.valueOf(uchText);
            }
            catch (NumberFormatException nfex) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.badNumber"), this.rMan_.getString("pmsaep.badNumberTitle"), 0);
                return false;
            }
        }
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        Iterator kit = md.getScaleKeys();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            MeasureScale ms = md.getMeasureScale(key);
            String name = ms.getName();
            if (!DataUtil.keysEqual(name, nameText)) continue;
            boolean problem = false;
            if (this.mode_ == 2) {
                problem = !this.allMerge_.contains(key);
            } else {
                boolean bl = problem = this.mode_ == 3 || this.currKey_ == null || !this.currKey_.equals(key);
            }
            if (!problem) continue;
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.dupName"), this.rMan_.getString("pmsaep.dupNameTitle"), 0);
            return false;
        }
        if (this.currKey_ == null || this.mode_ == 3) {
            String nextKey = md.getNextDataKey();
            this.newScale_ = new MeasureScale(nextKey, nameText, conv, illegal, unchanged);
        } else {
            MeasureScale currScale = md.getMeasureScale(this.currKey_);
            this.newScale_ = (MeasureScale)currScale.clone();
            this.newScale_.setName(nameText);
            this.newScale_.setConvToFold(conv);
            this.newScale_.setIllegalRange(illegal);
            this.newScale_.setUnchanged(unchanged);
        }
        return true;
    }

    private void displayProperties() {
        this.updateOptions();
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        switch (this.mode_) {
            case 1: {
                if (this.currKey_ == null) {
                    this.stockFields(this.editComps_, null, "");
                } else {
                    MeasureScale currScale = md.getMeasureScale(this.currKey_);
                    this.stockFields(this.editComps_, currScale, null);
                }
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 3: {
                MeasureScale currScale = md.getMeasureScale(this.currKey_);
                this.stockFields(this.editComps_, currScale, this.dupName_);
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                MeasureScale currScale = md.getMeasureScale(this.currKey_);
                this.stockFields(this.mergeComps_, currScale, null);
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void stockFields(EditOrMergeComps comps, MeasureScale currScale, String nameOverride) {
        String currName = nameOverride == null ? currScale.getName() : nameOverride;
        comps.setText(comps.nameField, currName);
        Double unchObj = currScale == null ? null : currScale.getUnchanged();
        comps.setText(comps.unchangedField, unchObj == null ? "" : unchObj.toString());
        MeasureScale.Conversion msc = currScale == null ? null : currScale.getConvToFold();
        comps.foldCheck.setSelected(msc != null);
        if (msc != null) {
            comps.foldCombo.setSelectedItem(MeasureScale.Conversion.convertTypeForCombo(msc.type));
            comps.setText(comps.foldField, msc.factor != null ? msc.factor.toString() : "");
        } else {
            comps.foldCombo.setSelectedIndex(0);
            comps.setText(comps.foldField, "");
        }
        BoundedDoubMinMax bdmm = currScale == null ? null : currScale.getIllegalRange();
        comps.illegalCheck.setSelected(bdmm != null);
        if (bdmm != null) {
            int negType = MeasureScale.rangeToType(bdmm, true);
            comps.minCombo.setSelectedItem(MeasureScale.convertTypeForCombo(negType, true));
            comps.setText(comps.minField, negType != 0 ? Double.toString(bdmm.min) : "");
            int posType = MeasureScale.rangeToType(bdmm, false);
            comps.maxCombo.setSelectedItem(MeasureScale.convertTypeForCombo(posType, false));
            comps.setText(comps.maxField, posType != 0 ? Double.toString(bdmm.max) : "");
        } else {
            comps.minCombo.setSelectedIndex(0);
            comps.setText(comps.minField, "");
            comps.maxCombo.setSelectedIndex(0);
            comps.setText(comps.maxField, "");
        }
    }

    private MeasureScale.Conversion buildToFoldResults(EditOrMergeComps comps) throws IOException {
        if (!comps.foldCheck.isSelected()) {
            return null;
        }
        Double toFold = null;
        int convertType = ((ChoiceContent)comps.foldCombo.getSelectedItem()).val;
        if (convertType == 1) {
            boolean badNum = false;
            String foldText = comps.getText(comps.foldField);
            if (!foldText.equals("")) {
                try {
                    toFold = Double.valueOf(foldText);
                }
                catch (NumberFormatException nfex) {
                    badNum = true;
                }
            } else {
                badNum = true;
            }
            if (badNum) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.badNumber"), this.rMan_.getString("pmsaep.badNumberTitle"), 0);
                throw new IOException();
            }
        }
        return new MeasureScale.Conversion(convertType, toFold);
    }

    private BoundedDoubMinMax buildRangeResults(EditOrMergeComps comps) throws IOException {
        int maxSpec;
        if (!comps.illegalCheck.isSelected()) {
            return null;
        }
        double minVal = Double.NEGATIVE_INFINITY;
        boolean minInclude = true;
        double maxVal = Double.POSITIVE_INFINITY;
        boolean maxInclude = true;
        boolean badMin = false;
        boolean badMax = false;
        int minSpec = ((ChoiceContent)comps.minCombo.getSelectedItem()).val;
        if (minSpec != 0) {
            String minText = comps.getText(comps.minField);
            if (!minText.equals("")) {
                try {
                    minVal = Double.valueOf(minText);
                }
                catch (NumberFormatException nfex) {
                    badMin = true;
                }
            } else {
                badMin = true;
            }
            boolean bl = minInclude = minSpec == 2;
        }
        if ((maxSpec = ((ChoiceContent)comps.maxCombo.getSelectedItem()).val) != 0) {
            String maxText = comps.getText(comps.maxField);
            if (!maxText.equals("")) {
                try {
                    maxVal = Double.valueOf(maxText);
                }
                catch (NumberFormatException nfex) {
                    badMax = true;
                }
            } else {
                badMax = true;
            }
            boolean bl = maxInclude = maxSpec == 2;
        }
        if (badMin || badMax) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsaep.badNumber"), this.rMan_.getString("pmsaep.badNumberTitle"), 0);
            throw new IOException();
        }
        return new BoundedDoubMinMax(minVal, maxVal, minInclude, maxInclude);
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String nameFieldText;
        private String toFoldText;
        private String minValText;
        private String maxValText;
        private String uchText;
        private boolean toFold;
        private boolean illegal;
        private ChoiceContent foldComboCc;
        private ChoiceContent minComboCc;
        private ChoiceContent maxComboCc;

        MyFreezeDried() {
            EditOrMergeComps useComps = PertMeasureScaleAddOrEditPanel.this.mode_ == 2 ? PertMeasureScaleAddOrEditPanel.this.mergeComps_ : PertMeasureScaleAddOrEditPanel.this.editComps_;
            this.nameFieldText = useComps.getText(useComps.nameField);
            this.toFoldText = useComps.getText(useComps.foldField);
            this.minValText = useComps.getText(useComps.minField);
            this.maxValText = useComps.getText(useComps.maxField);
            this.uchText = useComps.getText(useComps.unchangedField);
            this.toFold = useComps.foldCheck.isSelected();
            this.illegal = useComps.illegalCheck.isSelected();
            this.foldComboCc = (ChoiceContent)useComps.foldCombo.getSelectedItem();
            this.minComboCc = (ChoiceContent)useComps.minCombo.getSelectedItem();
            this.maxComboCc = (ChoiceContent)useComps.maxCombo.getSelectedItem();
        }

        public boolean needToCancel() {
            if (PertMeasureScaleAddOrEditPanel.this.mode_ == 2) {
                PertMeasureScaleAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertMeasureScaleAddOrEditPanel.this.currKey_ != null && PertMeasureScaleAddOrEditPanel.this.mode_ == 1 && PertMeasureScaleAddOrEditPanel.this.pd_.getMeasureDictionary().getMeasureScale(PertMeasureScaleAddOrEditPanel.this.currKey_) == null) {
                PertMeasureScaleAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            EditOrMergeComps useComps = PertMeasureScaleAddOrEditPanel.this.mode_ == 2 ? PertMeasureScaleAddOrEditPanel.this.mergeComps_ : PertMeasureScaleAddOrEditPanel.this.editComps_;
            useComps.setText(useComps.nameField, this.nameFieldText);
            useComps.setText(useComps.foldField, this.toFoldText);
            useComps.setText(useComps.minField, this.minValText);
            useComps.setText(useComps.maxField, this.maxValText);
            useComps.setText(useComps.unchangedField, this.uchText);
            useComps.foldCheck.setSelected(this.toFold);
            useComps.illegalCheck.setSelected(this.illegal);
            useComps.foldCombo.setSelectedItem(this.foldComboCc);
            useComps.minCombo.setSelectedItem(this.minComboCc);
            useComps.maxCombo.setSelectedItem(this.maxComboCc);
        }
    }

    static class ToFoldCheckListener
    implements ActionListener {
        private EditOrMergeComps eomc_;

        ToFoldCheckListener(EditOrMergeComps eomc) {
            this.eomc_ = eomc;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                boolean doFold = this.eomc_.foldCheck.isSelected();
                this.eomc_.foldCombo.setEnabled(doFold);
                this.eomc_.foldLabel.setEnabled(doFold);
                ChoiceContent cc = (ChoiceContent)this.eomc_.foldCombo.getSelectedItem();
                boolean doFact = cc == null ? false : cc.val == 1;
                this.eomc_.foldField.setEnabled(doFold && doFact);
                this.eomc_.foldFieldLabel.setEnabled(doFold && doFact);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    static class IllegalCheckListener
    implements ActionListener {
        private EditOrMergeComps eomc_;

        IllegalCheckListener(EditOrMergeComps eomc) {
            this.eomc_ = eomc;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                boolean doIll = this.eomc_.illegalCheck.isSelected();
                this.eomc_.minCombo.setEnabled(doIll);
                this.eomc_.maxCombo.setEnabled(doIll);
                this.eomc_.minLabel.setEnabled(doIll);
                this.eomc_.maxLabel.setEnabled(doIll);
                ChoiceContent cc = (ChoiceContent)this.eomc_.minCombo.getSelectedItem();
                boolean doFact = cc == null ? false : cc.val != 0;
                this.eomc_.minField.setEnabled(doIll && doFact);
                this.eomc_.minValLabel.setEnabled(doIll && doFact);
                cc = (ChoiceContent)this.eomc_.maxCombo.getSelectedItem();
                doFact = cc == null ? false : cc.val != 0;
                this.eomc_.maxField.setEnabled(doIll && doFact);
                this.eomc_.maxValLabel.setEnabled(doIll && doFact);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    static class ToFoldComboListener
    implements ActionListener {
        private EditOrMergeComps eomc_;

        ToFoldComboListener(EditOrMergeComps eomc) {
            this.eomc_ = eomc;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                ChoiceContent cc = (ChoiceContent)this.eomc_.foldCombo.getSelectedItem();
                boolean doFact = cc == null ? false : cc.val == 1;
                this.eomc_.foldField.setEnabled(doFact);
                this.eomc_.foldFieldLabel.setEnabled(doFact);
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }
    }

    static class IllegalComboListener
    implements ActionListener {
        private EditOrMergeComps eomc_;
        private boolean forMin_;

        IllegalComboListener(EditOrMergeComps eomc, boolean forMin) {
            this.eomc_ = eomc;
            this.forMin_ = forMin;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                JComboBox combo = this.forMin_ ? this.eomc_.minCombo : this.eomc_.maxCombo;
                ChoiceContent cc = (ChoiceContent)combo.getSelectedItem();
                boolean doFact = cc == null ? false : cc.val != 0;
                JComponent field = this.forMin_ ? this.eomc_.minField : this.eomc_.maxField;
                field.setEnabled(doFact);
                JLabel label = this.forMin_ ? this.eomc_.minValLabel : this.eomc_.maxValLabel;
                label.setEnabled(doFact);
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }
    }

    static class EditOrMergeComps {
        int compMode;
        JComponent nameField;
        JCheckBox foldCheck;
        JComboBox foldCombo;
        JLabel foldLabel;
        JComponent foldField;
        JLabel foldFieldLabel;
        JCheckBox illegalCheck;
        JComboBox minCombo;
        JLabel minLabel;
        JComboBox maxCombo;
        JLabel maxLabel;
        JComponent minField;
        JLabel minValLabel;
        JComponent maxField;
        JLabel maxValLabel;
        JComponent unchangedField;

        EditOrMergeComps() {
        }

        public String getText(JComponent comp) {
            if (this.compMode == 2) {
                JTextComponent jtc = (JTextComponent)((JComboBox)comp).getEditor().getEditorComponent();
                return jtc.getText().trim();
            }
            return ((JTextField)comp).getText().trim();
        }

        public void setText(JComponent comp, String text) {
            if (this.compMode == 2) {
                JTextComponent jtc = (JTextComponent)((JComboBox)comp).getEditor().getEditorComponent();
                jtc.setText(text);
            } else {
                ((JTextField)comp).setText(text);
            }
        }
    }
}

