/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureProps;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertMeasureAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertMeasurementManagePanel
extends AnimatedSplitManagePanel {
    public static final String MANAGER_KEY = "pertMeasure";
    public static final String MEAS_KEY = "editMeas";
    private ReadOnlyTable rtdm_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertMeasureAddOrEditPanel pmaep_;
    private String pendingKey_;
    private List joinKeys_;
    private PertManageHelper pmh_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertMeasurementManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.rtdm_ = new ReadOnlyTable(new MeasurementModel(), new ReadOnlyTable.EmptySelector());
        JPanel mPanel = this.buildMeasurementPanel(null);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 6, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)mPanel, this.gbc_);
        this.pmaep_ = new PertMeasureAddOrEditPanel(this.parent_, this.pd_, this, MEAS_KEY);
        this.addEditPanel(this.pmaep_, MEAS_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(MEAS_KEY)) {
            if (this.joinKeys_ == null) {
                this.editMeasure(key, what);
            } else {
                this.joinMeasures(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtdm_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.pmaep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.pmaep_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(MEAS_KEY)) {
            MeasEntry me = (MeasEntry)obj;
            return me.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(MEAS_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtdm_, whichKey, this, MEAS_KEY);
    }

    public void doADuplication(String key) {
        if (!key.equals(MEAS_KEY)) {
            throw new IllegalArgumentException();
        }
        String useKey = ((MeasurementModel)this.rtdm_.getModel()).getSelectedKey(this.rtdm_.selectedRows);
        this.pendingKey_ = null;
        this.pmaep_.setMeasurePropsForDup(useKey);
        this.pmaep_.startEditing();
    }

    public void doAJoin(String key) {
        if (key.equals(MEAS_KEY)) {
            int ok;
            this.joinKeys_ = ((MeasurementModel)this.rtdm_.getModel()).getSelectedKeys(this.rtdm_.selectedRows);
            MeasureDictionary md = this.pd_.getMeasureDictionary();
            Iterator jkit = this.joinKeys_.iterator();
            String scaleKey = null;
            boolean mismatch = false;
            while (jkit.hasNext()) {
                String ckey = (String)jkit.next();
                MeasureProps chkProps = md.getMeasureProps(ckey);
                String chkKey = chkProps.getScaleKey();
                if (scaleKey == null) {
                    scaleKey = chkKey;
                    continue;
                }
                if (scaleKey.equals(chkKey)) continue;
                mismatch = true;
                break;
            }
            if (mismatch && (ok = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousMergeScaleMismatch"), this.rMan_.getString("pmsmp.dangerousMergeScaleMismatchTitle"), 0)) != 0) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = this.pmaep_.setMeasurePropsForMerge(this.joinKeys_);
        this.pmaep_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(MEAS_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((MeasurementModel)this.rtdm_.getModel()).getSelectedKey(this.rtdm_.selectedRows);
        PertFilter pertFilter = new PertFilter(14, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(pertFilter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    protected void enableTopPane(boolean enable) {
        this.rtdm_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map mprefs = da.getAllMeasurePropReferenceCounts();
        Integer noCount = new Integer(0);
        List selKeys = this.rtdm_.selectedRows == null ? null : ((MeasurementModel)this.rtdm_.getModel()).getSelectedKeys(this.rtdm_.selectedRows);
        this.rtdm_.rowElements.clear();
        MeasureDictionary mDict = this.pd_.getMeasureDictionary();
        Iterator mtit = mDict.getKeys();
        while (mtit.hasNext()) {
            String key = (String)mtit.next();
            MeasureProps mp = mDict.getMeasureProps(key);
            Integer count = (Integer)mprefs.get(key);
            if (count == null) {
                count = noCount;
            }
            this.rtdm_.rowElements.add(new MeasEntry(mp, count));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtdm_, this, MEAS_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (!key.equals(MEAS_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = null;
        this.rtdm_.clearSelections(false);
        this.pmaep_.setEditMeasureProps(this.pendingKey_);
        this.pmaep_.startEditing();
    }

    protected void doAnEdit(String key) {
        if (!key.equals(MEAS_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = ((MeasurementModel)this.rtdm_.getModel()).getSelectedKey(this.rtdm_.selectedRows);
        this.pmaep_.setEditMeasureProps(this.pendingKey_);
        this.pmaep_.startEditing();
    }

    protected void doADelete(String key) {
        if (key.equals(MEAS_KEY)) {
            String selected = ((MeasurementModel)this.rtdm_.getModel()).getSelectedKey(this.rtdm_.selectedRows);
            if (this.deleteMeasureProps(selected)) {
                this.pet_.itemDeleted(MEAS_KEY);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void joinMeasures(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        MeasureProps mp = this.pmaep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertMeasure");
        DependencyAnalyzer.Dependencies refs = da.getMeasurePropMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeMeasureProps(this.joinKeys_, this.pendingKey_, mp);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editMeasure(String key, int what) {
        MeasureProps mp = this.pmaep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createPertMeasure" : "undo.editPertMeasure");
        if (this.pendingKey_ == null) {
            this.pendingKey_ = mp.getID();
        }
        PertDataChange pdc = this.pd_.setMeasureProp(mp);
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        support.addEdit(new PertDataChangeCmd(pdc));
        DisplayOptionsManager.getMgr().modifyForPertDataChange(support);
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private JPanel buildMeasurementPanel(List allTabs) {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel display = new JPanel();
        display.setBorder(new EtchedBorder());
        display.setLayout(new GridBagLayout());
        this.rtdm_.setButtonHandler(new AnimatedSplitManagePanel.ButtonHand(MEAS_KEY));
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        tp.multiTableSelectionSyncing = allTabs;
        tp.clearOthersOnSelect = true;
        tp.tableTitle = rMan.getString("pertSetupManage.measurementTypes");
        tp.titleFont = null;
        tp.colWidths = new ArrayList();
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(0, 50, 100, Integer.MAX_VALUE));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 150, 250));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(2, 50, 150, 250));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(3, 50, 150, 250));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(4, 50, 50, 100));
        tp.canMultiSelect = true;
        this.addExtraButtons(tp, MEAS_KEY);
        JPanel tabPan = this.rtdm_.buildReadOnlyTable(tp);
        GridBagConstraints gbc = new GridBagConstraints();
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        display.add((Component)tabPan, gbc);
        return display;
    }

    private boolean deleteMeasureProps(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getMeasureReferenceSet(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deleteMeasureProp");
        da.killOffDependencies(refs, support);
        PertDataChange pdc2 = this.pd_.deleteMeasureProp(key);
        support.addEdit(new PertDataChangeCmd(pdc2));
        DisplayOptionsManager.getMgr().modifyForPertDataChange(support);
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private class MeasEntry {
        String key;
        String name;
        String scale;
        String posThresh;
        String negThresh;
        Integer count;

        MeasEntry(MeasureProps mp, Integer count) {
            this.key = mp.getID();
            this.name = mp.getName();
            if (this.name == null) {
                this.name = "";
            }
            String scaleKey = mp.getScaleKey();
            this.scale = PertMeasurementManagePanel.this.pd_.getMeasureDictionary().getMeasureScale(scaleKey).getDisplayString();
            Double posThreshVal = mp.getPosThresh();
            this.posThresh = posThreshVal == null ? "" : posThreshVal.toString();
            Double negThreshVal = mp.getNegThresh();
            this.negThresh = negThreshVal == null ? "" : negThreshVal.toString();
            this.count = count;
        }
    }

    private class MeasurementModel
    extends ReadOnlyTable.TableModel {
        static final int NAME = 0;
        static final int SCALE = 1;
        static final int POST = 2;
        static final int NEGT = 3;
        static final int COUNT = 4;
        private static final int NUM_COL_ = 5;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        MeasurementModel() {
            super(5);
            this.colNames_ = new String[]{"pertMeas.name", "pertMeas.scale", "pertMeas.posThresh", "pertMeas.negThresh", "pertMeas.count"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertMeasurementManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMeasurementManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMeasurementManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMeasurementManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertMeasurementManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                MeasEntry me = (MeasEntry)iit.next();
                this.columns_[0].add(me.name);
                this.columns_[1].add(me.scale);
                this.columns_[2].add(me.posThresh);
                this.columns_[3].add(me.negThresh);
                this.columns_[4].add(me.count);
                this.hiddenColumns_[0].add(me.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

