/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.MeasureDictionary;
import org.systemsbiology.biotapestry.perturb.MeasureScale;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertMeasureScaleAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSimpleNameEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.BoundedDoubMinMax;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertMiscSetupManagePanel
extends AnimatedSplitManagePanel
implements PertSimpleNameEditPanel.Client {
    public static final String MANAGER_KEY = "setup";
    public static final String UDF_KEY = "editUDF";
    public static final String MEAS_SCALE_KEY = "editMeasScale";
    private ReadOnlyTable rtudf_;
    private ReadOnlyTable rtmt_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertSimpleNameEditPanel udfep_;
    private PertMeasureScaleAddOrEditPanel mtep_;
    private String pendingKey_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertMiscSetupManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        ArrayList<ReadOnlyTable> allTabs = new ArrayList<ReadOnlyTable>();
        this.rtudf_ = new ReadOnlyTable(new ReadOnlyTable.NameWithHiddenIDModel(), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtudf_);
        this.rtmt_ = new ReadOnlyTable(new MeasureScaleModel(), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtmt_);
        JPanel ufPanel = this.commonTableBuild(this.rtudf_, "pmsmp.userFields", new AnimatedSplitManagePanel.ButtonHand(UDF_KEY), allTabs, null, null);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)ufPanel, this.gbc_);
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 200, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 50, 100));
        colWidths.add(new ReadOnlyTable.ColumnWidths(2, 100, 250, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(3, 50, 200, 300));
        colWidths.add(new ReadOnlyTable.ColumnWidths(4, 50, 50, 100));
        JPanel mtPanel = this.commonTableBuild(this.rtmt_, "pmsmp.measure", new AnimatedSplitManagePanel.ButtonHand(MEAS_SCALE_KEY), allTabs, colWidths, MEAS_SCALE_KEY);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_++, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)mtPanel, this.gbc_);
        this.udfep_ = new PertSimpleNameEditPanel(this.parent_, this, "pmsmp.userField", this, UDF_KEY);
        this.addEditPanel(this.udfep_, UDF_KEY);
        this.mtep_ = new PertMeasureScaleAddOrEditPanel(this.parent_, this.pd_, this, MEAS_SCALE_KEY);
        this.addEditPanel(this.mtep_, MEAS_SCALE_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public String getNameForKey(String whoAmI, String key) {
        if (whoAmI.equals(UDF_KEY)) {
            return this.pd_.getUserFieldName(Integer.parseInt(key));
        }
        throw new IllegalArgumentException();
    }

    public boolean haveDuplication(String whoAmI, String key, String name) {
        if (!whoAmI.equals(UDF_KEY)) {
            throw new IllegalArgumentException();
        }
        String existingKey = this.pd_.getUserFieldIndexFromName(name);
        if (existingKey == null) {
            return false;
        }
        if (this.joinKeys_ == null) {
            return key == null || !existingKey.equals(key);
        }
        return !this.joinKeys_.contains(existingKey);
    }

    public boolean haveDisconnect(String whoAmI, String key, String name) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void editIsComplete(String key, int what) {
        if (key.equals(UDF_KEY)) {
            if (this.joinKeys_ != null) throw new IllegalStateException();
            this.editUserField(key, what);
            return;
        } else {
            if (!key.equals(MEAS_SCALE_KEY)) throw new IllegalArgumentException();
            if (this.joinKeys_ == null) {
                this.editMeasureScale(key, what);
                return;
            } else {
                this.joinMeasureScales(key, what);
            }
        }
    }

    public void finished() {
        this.rtudf_.makeCurrentSelectionVisible();
        this.rtmt_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.udfep_.hotUpdate(mustDie);
        this.mtep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.udfep_.closeAction();
        this.mtep_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(UDF_KEY)) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)obj;
            return tocc.val.equals(key);
        }
        if (tableID.equals(MEAS_SCALE_KEY)) {
            MSMEntry twrc = (MSMEntry)obj;
            return twrc.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (whichTable.equals(UDF_KEY)) {
            this.pmh_.selectTableRow(this.rtudf_, whichKey, this, UDF_KEY);
        } else if (whichTable.equals(MEAS_SCALE_KEY)) {
            this.pmh_.selectTableRow(this.rtmt_, whichKey, this, MEAS_SCALE_KEY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doADuplication(String key) {
        if (!key.equals(MEAS_SCALE_KEY)) {
            throw new IllegalArgumentException();
        }
        String useKey = ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKey(this.rtmt_.selectedRows);
        this.pendingKey_ = null;
        this.mtep_.setMeasureScaleForDup(useKey);
        this.mtep_.startEditing();
    }

    public void doAJoin(String key) {
        if (key.equals(MEAS_SCALE_KEY)) {
            this.joinKeys_ = ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKeys(this.rtmt_.selectedRows);
            MeasureDictionary md = this.pd_.getMeasureDictionary();
            Iterator jkit = this.joinKeys_.iterator();
            MeasureScale.Conversion conv = null;
            boolean isFirst = true;
            boolean mismatch = false;
            while (jkit.hasNext()) {
                String ckey = (String)jkit.next();
                MeasureScale chkScale = md.getMeasureScale(ckey);
                if (isFirst) {
                    conv = chkScale.getConvToFold();
                    isFirst = false;
                    continue;
                }
                if (conv == null) {
                    if (chkScale.getConvToFold() == null) continue;
                    mismatch = true;
                    break;
                }
                if (conv.equals(chkScale.getConvToFold())) continue;
                mismatch = true;
                break;
            }
            if (mismatch) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousFoldMismatchMerge"), this.rMan_.getString("pmsmp.dangerousMergeTitle"), 2);
            }
            this.pendingKey_ = this.mtep_.setMeasureScaleForMerge(this.joinKeys_);
            if (this.pendingKey_ == null) {
                this.joinKeys_ = null;
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.mtep_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(MEAS_SCALE_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKey(this.rtmt_.selectedRows);
        PertFilter filter = new PertFilter(12, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(filter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    protected void enableTopPane(boolean enable) {
        this.rtudf_.setEnabled(enable);
        this.rtmt_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtudf_.selectedRows == null ? null : ((ReadOnlyTable.NameWithHiddenIDModel)this.rtudf_.getModel()).getSelectedKeys(this.rtudf_.selectedRows);
        List ufnames = this.buildUserFieldList();
        this.rtudf_.rowElements.clear();
        this.rtudf_.rowElements.addAll(ufnames);
        this.pmh_.updateAndReselect(fireChange, this.rtudf_, this, UDF_KEY, selKeys);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        this.rtmt_.rowElements.clear();
        Vector mopts = this.pd_.getMeasureDictionary().getScaleOptions();
        Map scaleRefs = da.getAllMeasureScaleReferenceCounts(false);
        Integer noCount = new Integer(0);
        Iterator mopit = mopts.iterator();
        while (mopit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)mopit.next();
            Integer count = (Integer)scaleRefs.get(tocc.val);
            if (count == null) {
                count = noCount;
            }
            MSMEntry msme = new MSMEntry((String)tocc.val, count);
            this.rtmt_.rowElements.add(msme);
        }
        selKeys = this.rtmt_.selectedRows == null ? null : ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKeys(this.rtmt_.selectedRows);
        this.pmh_.updateAndReselect(fireChange, this.rtmt_, this, MEAS_SCALE_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (key.equals(UDF_KEY)) {
            this.pendingKey_ = null;
            this.rtudf_.clearSelections(false);
            this.rtmt_.clearSelections(false);
            this.udfep_.setEditName(this.pendingKey_);
            this.udfep_.startEditing();
        } else if (key.equals(MEAS_SCALE_KEY)) {
            this.pendingKey_ = null;
            this.rtudf_.clearSelections(false);
            this.rtmt_.clearSelections(false);
            this.mtep_.setEditMeasureScale(this.pendingKey_);
            this.mtep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doAnEdit(String key) {
        if (key.equals(UDF_KEY)) {
            this.pendingKey_ = ((ReadOnlyTable.NameWithHiddenIDModel)this.rtudf_.getModel()).getSelectedKey(this.rtudf_.selectedRows);
            this.udfep_.setEditName(this.pendingKey_);
            this.udfep_.startEditing();
        } else if (key.equals(MEAS_SCALE_KEY)) {
            String selKey = ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKey(this.rtmt_.selectedRows);
            String[] stds = this.pd_.getMeasureDictionary().getStandardScaleKeys();
            for (int i = 0; i < stds.length; ++i) {
                if (!selKey.equals(stds[i])) continue;
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotEditDefaultScale"), this.rMan_.getString("pmsmp.cannotEditDefaultScaleTitle"), 0);
                return;
            }
            this.pendingKey_ = selKey;
            this.mtep_.setEditMeasureScale(this.pendingKey_);
            this.mtep_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doADelete(String key) {
        if (key.equals(UDF_KEY)) {
            String selKey = ((ReadOnlyTable.NameWithHiddenIDModel)this.rtudf_.getModel()).getSelectedKey(this.rtudf_.selectedRows);
            String delWarn = this.rMan_.getString("pertDelete.losingUserDataInDataPoints");
            int doit = JOptionPane.showConfirmDialog(this.parent_, delWarn, this.rMan_.getString("pertDelete.losingUserDataInDataPointsTitle"), 2);
            if (doit != 0) {
                return;
            }
            UndoSupport support = new UndoSupport(this.undom_, "undo.deleteUserDataField");
            PertDataChange pdc = this.pd_.deleteUserFieldName(selKey);
            support.addEdit(new PertDataChangeCmd(pdc));
            support.addEvent(new GeneralChangeEvent(3));
            this.pet_.editSubmissionBegins();
            support.finish();
            this.pet_.editSubmissionEnds();
            this.pet_.itemDeleted(UDF_KEY);
        } else if (key.equals(MEAS_SCALE_KEY)) {
            String selKey = ((MeasureScaleModel)this.rtmt_.getModel()).getSelectedKey(this.rtmt_.selectedRows);
            String[] stds = this.pd_.getMeasureDictionary().getStandardScaleKeys();
            for (int i = 0; i < stds.length; ++i) {
                if (!selKey.equals(stds[i])) continue;
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotDeleteDefaultScale"), this.rMan_.getString("pmsmp.cannotDeleteDefaultScaleTitle"), 0);
                return;
            }
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            DependencyAnalyzer.Dependencies refs = da.getMeasScaleReferenceSet(selKey);
            if (!this.pmh_.warnAndAsk(refs)) {
                return;
            }
            UndoSupport support = new UndoSupport(this.undom_, "undo.deleteMeasScale");
            da.killOffDependencies(refs, support);
            PertDataChange pdc = this.pd_.deleteMeasureScale(selKey);
            support.addEdit(new PertDataChangeCmd(pdc));
            DisplayOptionsManager.getMgr().modifyForPertDataChange(support);
            support.addEvent(new GeneralChangeEvent(3));
            this.pet_.editSubmissionBegins();
            support.finish();
            this.pet_.editSubmissionEnds();
            this.pet_.itemDeleted(MEAS_SCALE_KEY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void joinMeasureScales(String key, int what) {
        int ok;
        int ok2;
        MeasureScale stdScale;
        MeasureDictionary md = this.pd_.getMeasureDictionary();
        String[] stds = md.getStandardScaleKeys();
        String chkStd = null;
        for (int i = 0; i < stds.length; ++i) {
            if (!this.joinKeys_.contains(stds[i])) continue;
            if (chkStd != null) {
                throw new IllegalStateException();
            }
            chkStd = stds[i];
        }
        MeasureScale revisedScale = this.mtep_.getResult();
        if (chkStd != null && !revisedScale.equals(stdScale = md.getMeasureScale(chkStd))) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pmsmp.cannotChangeStd"), this.rMan_.getString("pmsmp.cannotChangeStdTitle"), 0);
            return;
        }
        MeasureScale origScale = md.getMeasureScale(this.pendingKey_);
        MeasureScale.Conversion revisedFold = revisedScale.getConvToFold();
        MeasureScale.Conversion origFold = origScale.getConvToFold();
        boolean danger = false;
        if (revisedFold == null) {
            danger = origFold != null;
        } else {
            boolean bl = danger = !revisedFold.equals(origFold);
        }
        if (danger && (ok2 = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousMergeForFold"), this.rMan_.getString("pmsmp.dangerousMergeForFoldTitle"), 0)) != 0) {
            return;
        }
        BoundedDoubMinMax revisedIllegal = revisedScale.getIllegalRange();
        BoundedDoubMinMax origIllegal = origScale.getIllegalRange();
        boolean dangerIlleg = false;
        if (revisedIllegal != null) {
            boolean bl = dangerIlleg = !revisedIllegal.equals(origIllegal);
        }
        if (dangerIlleg && (ok = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousMergeForRange"), this.rMan_.getString("pmsmp.dangerousMergeForRangeTitle"), 0)) != 0) {
            return;
        }
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergeMeasureScales");
        DependencyAnalyzer.Dependencies refs = da.getMeasureScaleMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeMeasureScales(this.joinKeys_, this.pendingKey_, revisedScale);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        DisplayOptionsManager.getMgr().modifyForPertDataChange(support);
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editUserField(String key, int what) {
        String name = this.udfep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createUserFieldName" : "undo.editUserFieldName");
        if (this.pendingKey_ == null) {
            this.pendingKey_ = Integer.toString(this.pd_.getUserFieldCount());
        }
        PertDataChange pdc = this.pd_.setUserFieldName(this.pendingKey_, name);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editMeasureScale(String key, int what) {
        MeasureScale revisedScale = this.mtep_.getResult();
        if (this.pendingKey_ != null) {
            int ok;
            int ok2;
            MeasureScale origScale = this.pd_.getMeasureDictionary().getMeasureScale(this.pendingKey_);
            MeasureScale.Conversion revisedFold = revisedScale.getConvToFold();
            MeasureScale.Conversion origFold = origScale.getConvToFold();
            boolean danger = false;
            if (revisedFold == null) {
                danger = origFold != null;
            } else {
                boolean bl = danger = !revisedFold.equals(origFold);
            }
            if (danger && (ok2 = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousFoldChange"), this.rMan_.getString("pmsmp.dangerousFoldChangeTitle"), 0)) != 0) {
                return;
            }
            BoundedDoubMinMax revisedIllegal = revisedScale.getIllegalRange();
            BoundedDoubMinMax origIllegal = origScale.getIllegalRange();
            boolean dangerIlleg = false;
            if (revisedIllegal != null) {
                boolean bl = dangerIlleg = !revisedIllegal.equals(origIllegal);
            }
            if (dangerIlleg && (ok = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pmsmp.dangerousRangeChange"), this.rMan_.getString("pmsmp.dangerousRangeChangeTitle"), 0)) != 0) {
                return;
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createMeasureScale" : "undo.editMeasureScale");
        PertDataChange pdc = this.pd_.setMeasureScale(revisedScale);
        support.addEdit(new PertDataChangeCmd(pdc));
        DisplayOptionsManager.getMgr().modifyForPertDataChange(support);
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private List buildUserFieldList() {
        ArrayList<TrueObjChoiceContent> ufnames = new ArrayList<TrueObjChoiceContent>();
        Iterator ufit = this.pd_.getUserFieldNames();
        int count = 0;
        while (ufit.hasNext()) {
            TrueObjChoiceContent tocc = new TrueObjChoiceContent((String)ufit.next(), Integer.toString(count++));
            ufnames.add(tocc);
        }
        return ufnames;
    }

    private class MSMEntry {
        String key;
        String type;
        String unchanged;
        String convertType;
        String illegalRange;
        Integer count;

        MSMEntry(String key, Integer count) {
            this.key = key;
            this.count = count;
            MeasureScale ms = PertMiscSetupManagePanel.this.pd_.getMeasureDictionary().getMeasureScale(key);
            this.type = ms.getDisplayString();
            Double unch = ms.getUnchanged();
            this.unchanged = unch == null ? "" : unch.toString();
            MeasureScale.Conversion conv = ms.getConvToFold();
            this.convertType = conv == null ? "" : conv.getDisplayString();
            BoundedDoubMinMax illegal = ms.getIllegalRange();
            this.illegalRange = illegal == null ? "" : illegal.toString();
        }
    }

    private class MeasureScaleModel
    extends ReadOnlyTable.TableModel {
        static final int TYPE = 0;
        static final int UNCHANGED = 1;
        static final int CONVERT_TYPE = 2;
        static final int ILLEGAL_RANGE = 3;
        static final int COUNT = 4;
        private static final int NUM_COL_ = 5;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        MeasureScaleModel() {
            super(5);
            this.colNames_ = new String[]{"pertMeaSc.type", "pertMeaSc.unchanged", "pertMeaSc.convertType", "pertMeaSc.illegalRange", "pertMeaSc.refCount"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertMiscSetupManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMiscSetupManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMiscSetupManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertMiscSetupManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertMiscSetupManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                MSMEntry msm = (MSMEntry)iit.next();
                this.columns_[0].add(msm.type);
                this.columns_[1].add(msm.unchanged);
                this.columns_[2].add(msm.convertType);
                this.columns_[3].add(msm.illegalRange);
                this.columns_[4].add(msm.count);
                this.hiddenColumns_[0].add(msm.key);
            }
        }

        public String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

