/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertPropsAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertPropertiesManagePanel
extends AnimatedSplitManagePanel {
    public static final String MANAGER_KEY = "perProps";
    public static final String PERT_KEY = "editPert";
    private ReadOnlyTable rtdp_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertPropsAddOrEditPanel ppaep_;
    private String pendingKey_;
    private List joinKeys_;
    private PertManageHelper pmh_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertPropertiesManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.rtdp_ = new ReadOnlyTable(new PertPropsModel(), new ReadOnlyTable.EmptySelector());
        JPanel ppPanel = this.buildPertPropertiesPanel(null);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 6, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)ppPanel, this.gbc_);
        this.ppaep_ = new PertPropsAddOrEditPanel(this.parent_, this.pd_, this, PERT_KEY);
        this.addEditPanel(this.ppaep_, PERT_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(PERT_KEY)) {
            if (this.joinKeys_ == null) {
                this.editPertProp(key, what);
            } else {
                this.joinPertProps(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtdp_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.ppaep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.ppaep_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(PERT_KEY)) {
            PPropsEntry ppe = (PPropsEntry)obj;
            return ppe.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(PERT_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtdp_, whichKey, this, PERT_KEY);
    }

    public void doADuplication(String key) {
        String legAlt;
        HashSet<String> allLegAlt;
        HashSet<String> allAbbrev;
        HashSet<String> allTypes;
        PertDictionary pDict;
        String useKey;
        if (key.equals(PERT_KEY)) {
            useKey = ((PertPropsModel)this.rtdp_.getModel()).getSelectedKey(this.rtdp_.selectedRows);
            this.pendingKey_ = null;
            pDict = this.pd_.getPertDictionary();
            allTypes = new HashSet<String>();
            allAbbrev = new HashSet<String>();
            allLegAlt = new HashSet<String>();
            Iterator kit = pDict.getKeys();
            while (kit.hasNext()) {
                String pkey = (String)kit.next();
                PertProperties pp = pDict.getPerturbProps(pkey);
                String type = pp.getType();
                String abbrev = pp.getAbbrev();
                legAlt = pp.getLegacyAlt();
                allTypes.add(type);
                if (abbrev != null) {
                    allAbbrev.add(abbrev);
                }
                if (legAlt == null) continue;
                allLegAlt.add(legAlt);
            }
        } else {
            throw new IllegalArgumentException();
        }
        PertProperties ppCurr = pDict.getPerturbProps(useKey);
        String copyType = this.pmh_.getNewUniqueCopyName(allTypes, ppCurr.getType());
        String currAbbrev = ppCurr.getAbbrev();
        String copyAbbrev = currAbbrev == null ? null : this.pmh_.getNewUniqueCopyName(allAbbrev, currAbbrev);
        legAlt = ppCurr.getLegacyAlt();
        String copyLegAlt = legAlt == null ? null : this.pmh_.getNewUniqueCopyName(allLegAlt, legAlt);
        this.pendingKey_ = null;
        this.ppaep_.setPertPropsForDup(useKey, copyType, copyAbbrev, copyLegAlt);
        this.ppaep_.startEditing();
    }

    public void doAJoin(String key) {
        if (!key.equals(PERT_KEY)) {
            throw new IllegalArgumentException();
        }
        this.joinKeys_ = ((PertPropsModel)this.rtdp_.getModel()).getSelectedKeys(this.rtdp_.selectedRows);
        this.pendingKey_ = this.ppaep_.setPertPropsForMerge(this.joinKeys_);
        this.ppaep_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(PERT_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((PertPropsModel)this.rtdp_.getModel()).getSelectedKey(this.rtdp_.selectedRows);
        PertFilter pertFilter = new PertFilter(4, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(pertFilter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    protected void enableTopPane(boolean enable) {
        this.rtdp_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtdp_.selectedRows == null ? null : ((PertPropsModel)this.rtdp_.getModel()).getSelectedKeys(this.rtdp_.selectedRows);
        this.rtdp_.rowElements.clear();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map pprefs = da.getAllPertPropReferenceCounts();
        Integer noCount = new Integer(0);
        PertDictionary pDict = this.pd_.getPertDictionary();
        Iterator etit = pDict.getKeys();
        while (etit.hasNext()) {
            String key = (String)etit.next();
            PertProperties pp = pDict.getPerturbProps(key);
            Integer count = (Integer)pprefs.get(key);
            if (count == null) {
                count = noCount;
            }
            this.rtdp_.rowElements.add(new PPropsEntry(pp, count));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtdp_, this, PERT_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (!key.equals(PERT_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = null;
        this.rtdp_.clearSelections(false);
        this.ppaep_.setPertProps(this.pendingKey_);
        this.ppaep_.startEditing();
    }

    protected void doAnEdit(String key) {
        if (!key.equals(PERT_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = ((PertPropsModel)this.rtdp_.getModel()).getSelectedKey(this.rtdp_.selectedRows);
        this.ppaep_.setPertProps(this.pendingKey_);
        this.ppaep_.startEditing();
    }

    protected void doADelete(String key) {
        if (key.equals(PERT_KEY)) {
            String selected = ((PertPropsModel)this.rtdp_.getModel()).getSelectedKey(this.rtdp_.selectedRows);
            if (this.deletePertProps(selected)) {
                this.pet_.itemDeleted(PERT_KEY);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void editPertProp(String key, int what) {
        PertProperties pp = this.ppaep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createPertProp" : "undo.editPertProp");
        PertDataChange pdc = this.pd_.setPerturbationProp(pp);
        String resultKey = pp.getID();
        this.pendingKey_ = null;
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private boolean joinPertProps(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        PertProperties pp = this.ppaep_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertProps");
        DependencyAnalyzer.Dependencies refs = da.getPertPropMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergePertProps(this.joinKeys_, this.pendingKey_, pp);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
        Iterator sdkit = this.pd_.getSourceDefKeys();
        while (sdkit.hasNext()) {
            String sdkey = (String)sdkit.next();
            PertSource pschk = this.pd_.getSourceDef(sdkey);
            if (!pschk.getExpTypeKey().equals(resultKey)) continue;
            Iterator sdkit2 = this.pd_.getSourceDefKeys();
            while (sdkit2.hasNext()) {
                PertSource pschk2;
                String sdkey2 = (String)sdkit2.next();
                if (sdkey.equals(sdkey2) || !(pschk2 = this.pd_.getSourceDef(sdkey2)).getExpTypeKey().equals(resultKey) || pschk.compareSrcAndType(pschk2) != 0) continue;
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pstmp.mergedSourceDefs"), this.rMan_.getString("pstmp.mergedSourceDefsTitle"), 2);
                return true;
            }
        }
        return true;
    }

    private JPanel buildPertPropertiesPanel(List allTabs) {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel display = new JPanel();
        display.setBorder(new EtchedBorder());
        display.setLayout(new GridBagLayout());
        this.rtdp_.setButtonHandler(new AnimatedSplitManagePanel.ButtonHand(PERT_KEY));
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        tp.multiTableSelectionSyncing = allTabs;
        tp.clearOthersOnSelect = true;
        tp.canMultiSelect = true;
        tp.tableTitle = rMan.getString("pertSetupManage.perturbationTypes");
        tp.titleFont = null;
        tp.colWidths = new ArrayList();
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(0, 50, 100, 150));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 100, 150));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(2, 50, 300, Integer.MAX_VALUE));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(3, 100, 200, Integer.MAX_VALUE));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(4, 50, 50, 100));
        this.addExtraButtons(tp, PERT_KEY);
        JPanel tabPan = this.rtdp_.buildReadOnlyTable(tp);
        GridBagConstraints gbc = new GridBagConstraints();
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        display.add((Component)tabPan, gbc);
        return display;
    }

    private boolean deletePertProps(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getPertTypeReferenceSets(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertProp");
        da.killOffDependencies(refs, support);
        PertDataChange pdc2 = this.pd_.deletePerturbationProp(key);
        support.addEdit(new PertDataChangeCmd(pdc2));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private class PPropsEntry {
        String key;
        String type;
        String expAbbrev;
        String sign;
        String nvPairsStr;
        Integer count;

        PPropsEntry(PertProperties pp, Integer count) {
            String legacyAltTag;
            this.key = pp.getID();
            this.type = pp.getType();
            if (this.type == null) {
                this.type = "";
            }
            this.expAbbrev = pp.getAbbrev();
            if (this.expAbbrev == null) {
                this.expAbbrev = "";
            }
            if ((legacyAltTag = pp.getLegacyAlt()) != null) {
                String format = PertPropertiesManagePanel.this.rMan_.getString("ptmp.legacyAltFormat");
                this.expAbbrev = MessageFormat.format(format, this.expAbbrev, legacyAltTag);
            }
            this.sign = ((PertPropertiesManagePanel)PertPropertiesManagePanel.this).pd_.getPertDictionary().getRelationshipChoice((int)pp.getLinkSignRelationship()).name;
            Iterator nvpkit = pp.getNvpKeys();
            if (nvpkit.hasNext()) {
                StringBuffer buf = new StringBuffer();
                while (nvpkit.hasNext()) {
                    String name = (String)nvpkit.next();
                    buf.append(name);
                    buf.append("=");
                    String value = pp.getValue(name);
                    buf.append(value);
                    if (!nvpkit.hasNext()) continue;
                    buf.append("; ");
                }
                this.nvPairsStr = buf.toString();
            } else {
                this.nvPairsStr = "";
            }
            this.count = count;
        }
    }

    private class PertPropsModel
    extends ReadOnlyTable.TableModel {
        static final int TYPE = 0;
        static final int ABBREV = 1;
        static final int SIGN = 2;
        static final int NVPAIRS = 3;
        static final int COUNT = 4;
        private static final int NUM_COL_ = 5;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        PertPropsModel() {
            super(5);
            this.colNames_ = new String[]{"pertProp.type", "pertProp.abbrev", "pertProp.sign", "pertProp.nvPairs", "pertProp.count"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertPropertiesManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertPropertiesManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertPropertiesManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertPropertiesManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertPropertiesManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                PPropsEntry ppe = (PPropsEntry)iit.next();
                this.columns_[0].add(ppe.type);
                this.columns_[1].add(ppe.expAbbrev);
                this.columns_[2].add(ppe.sign);
                this.columns_[3].add(ppe.nvPairsStr);
                this.columns_[4].add(ppe.count);
                this.hiddenColumns_[0].add(ppe.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

