/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertDictionary;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.NameValuePairTablePanel;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.NameValuePairList;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertPropsAddOrEditPanel
extends AnimatedSplitEditPanel {
    private JTextField typeFieldEdit_;
    private JComboBox typeCombo_;
    private JTextField abbrevFieldEdit_;
    private JComboBox abbrevCombo_;
    private JTextField legFieldEdit_;
    private JComboBox legCombo_;
    private JLabel legLabelEdit_;
    private JLabel legLabelMerge_;
    private JComboBox relationComboEdit_;
    private JComboBox relationComboMerge_;
    private JPanel nvHolderEdit_;
    private JPanel nvHolderMerge_;
    private NameValuePairTablePanel nvptpEdit_;
    private NameValuePairTablePanel nvptpMerge_;
    private PerturbationData pd_;
    private String currKey_;
    private PertProperties newProps_;
    private String copyType_;
    private String copyAbbrev_;
    private String copyLegAlt_;
    private HashSet allMerge_;
    private PertManageHelper pmh_;
    private TreeSet nameOptions_;
    private TreeSet abbrevOptions_;
    private TreeSet altAbbrevOptions_;

    public PertPropsAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey) {
        super(parent, pet, myKey, 6);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        int editRow = 0;
        this.typeFieldEdit_ = new JTextField();
        this.abbrevFieldEdit_ = new JTextField();
        this.legFieldEdit_ = new JTextField();
        this.legLabelEdit_ = new JLabel(this.rMan_.getString("pertPropEdit.legacy"));
        editRow = this.ds_.installLabelJCompTriple(editPanel, "pertPropEdit.type", this.typeFieldEdit_, "pertPropEdit.abbrev", this.abbrevFieldEdit_, this.legLabelEdit_, this.legFieldEdit_, editRow, 6);
        this.relationComboEdit_ = new JComboBox();
        editRow = this.ds_.installLabeledJComp(this.relationComboEdit_, editPanel, "pertPropEdit.relation", editRow, 6);
        JLabel nvLabel = new JLabel(this.rMan_.getString("pertPropEdit.nvPairsLabel"));
        UiUtil.gbcSet(this.gbc_, 0, editRow++, 6, 1, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        editPanel.add((Component)nvLabel, this.gbc_);
        this.nvptpEdit_ = new NameValuePairTablePanel(this.parent_, new NameValuePairList(), new HashSet(), new HashSet(), new HashMap(), true);
        this.nvHolderEdit_ = new JPanel();
        this.nvHolderEdit_.setLayout(new GridLayout(1, 1));
        this.nvHolderEdit_.setMinimumSize(new Dimension(200, 100));
        this.nvHolderEdit_.add(this.nvptpEdit_);
        UiUtil.gbcSet(this.gbc_, 0, editRow, 6, 5, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        editRow += 5;
        editPanel.add((Component)this.nvHolderEdit_, this.gbc_);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        int mergeRow = 0;
        this.typeCombo_ = new JComboBox();
        this.typeCombo_.setEditable(true);
        this.abbrevCombo_ = new JComboBox();
        this.abbrevCombo_.setEditable(true);
        this.legCombo_ = new JComboBox();
        this.legCombo_.setEditable(true);
        this.legLabelMerge_ = new JLabel(this.rMan_.getString("pertPropEdit.legacy"));
        mergeRow = this.ds_.installLabelJCompTriple(mergePanel, "pertPropEdit.type", this.typeCombo_, "pertPropEdit.abbrev", this.abbrevCombo_, this.legLabelMerge_, this.legCombo_, mergeRow, 6);
        this.relationComboMerge_ = new JComboBox();
        mergeRow = this.ds_.installLabeledJComp(this.relationComboMerge_, mergePanel, "pertPropEdit.relation", mergeRow, 6);
        JLabel nvLabelToo = new JLabel(this.rMan_.getString("pertPropEdit.nvPairsLabel"));
        UiUtil.gbcSet(this.gbc_, 0, mergeRow++, 6, 1, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        mergePanel.add((Component)nvLabelToo, this.gbc_);
        this.nvptpMerge_ = new NameValuePairTablePanel(this.parent_, new NameValuePairList(), new HashSet(), new HashSet(), new HashMap(), true);
        this.nvHolderMerge_ = new JPanel();
        this.nvHolderMerge_.setLayout(new GridLayout(1, 1));
        this.nvHolderMerge_.setMinimumSize(new Dimension(200, 100));
        this.nvHolderMerge_.add(this.nvptpMerge_);
        UiUtil.gbcSet(this.gbc_, 0, mergeRow, 6, 5, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        mergeRow += 5;
        mergePanel.add((Component)this.nvHolderMerge_, this.gbc_);
        this.makeMultiMode(editPanel, mergePanel, 8);
        this.finishConstruction();
    }

    public void setPertProps(String newKey) {
        this.mode_ = 1;
        this.currKey_ = newKey;
        this.allMerge_ = null;
        this.setPertPropsCommon();
    }

    public void setPertPropsForDup(String dupKey, String copyType, String copyAbbrev, String copyLegAlt) {
        this.mode_ = 3;
        this.currKey_ = dupKey;
        this.allMerge_ = null;
        this.copyType_ = copyType;
        this.copyAbbrev_ = copyAbbrev;
        this.copyLegAlt_ = copyLegAlt;
        this.setPertPropsCommon();
    }

    public String setPertPropsForMerge(List joinKeys) {
        this.mode_ = 2;
        this.allMerge_ = new HashSet(joinKeys);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map refCounts = da.getAllPertPropReferenceCounts();
        this.currKey_ = this.pmh_.getMostUsedKey(refCounts, joinKeys);
        PertDictionary pd = this.pd_.getPertDictionary();
        this.nameOptions_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.abbrevOptions_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.altAbbrevOptions_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        int numk = joinKeys.size();
        for (int i = 0; i < numk; ++i) {
            String nextJk = (String)joinKeys.get(i);
            PertProperties pp = pd.getPerturbProps(nextJk);
            this.nameOptions_.add(pp.getType());
            String abbrev = pp.getAbbrev();
            if (abbrev == null) {
                abbrev = "";
            }
            this.abbrevOptions_.add(abbrev);
            String lat = pp.getLegacyAlt();
            if (lat == null) {
                lat = "";
            }
            this.altAbbrevOptions_.add(lat);
        }
        this.displayProperties();
        this.setPertPropsCommon();
        return this.currKey_;
    }

    private void setPertPropsCommon() {
        JPanel useHolder;
        PertDictionary pDict = this.pd_.getPertDictionary();
        HashMap nvPairs = new HashMap();
        HashSet allNames = new HashSet();
        HashSet allVals = new HashSet();
        pDict.getNVPairs(nvPairs, allNames, allVals);
        NameValuePairList currList = new NameValuePairList();
        currList.addNameValuePair(new NameValuePair("Iam", "bogus"));
        NameValuePairTablePanel nvpNew = new NameValuePairTablePanel(this.parent_, currList, allNames, allVals, nvPairs, true);
        if (this.mode_ == 2) {
            this.nvptpMerge_ = nvpNew;
            useHolder = this.nvHolderMerge_;
        } else {
            this.nvptpEdit_ = nvpNew;
            useHolder = this.nvHolderEdit_;
        }
        useHolder.removeAll();
        useHolder.add(nvpNew);
        useHolder.invalidate();
        this.displayProperties();
        useHolder.validate();
    }

    public PertProperties getResult() {
        return this.newProps_;
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        PertDictionary pdict = this.pd_.getPertDictionary();
        Vector vec = pdict.getLinkRelationshipOptions();
        if (this.mode_ == 2) {
            UiUtil.replaceComboItems(this.typeCombo_, new Vector(this.nameOptions_));
            UiUtil.replaceComboItems(this.abbrevCombo_, new Vector(this.abbrevOptions_));
            UiUtil.replaceComboItems(this.legCombo_, new Vector(this.altAbbrevOptions_));
            UiUtil.replaceComboItems(this.relationComboMerge_, vec);
        } else {
            UiUtil.replaceComboItems(this.relationComboEdit_, vec);
        }
    }

    protected boolean stashResults() {
        String legacyAltText;
        String abbrevText;
        String typeText;
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.typeCombo_.getEditor().getEditorComponent();
            typeText = jtc.getText().trim();
        } else {
            typeText = this.typeFieldEdit_.getText().trim();
        }
        if (typeText.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertPropEdit.emptyType"), this.rMan_.getString("pertPropEdit.emptyTypeTitle"), 0);
            return false;
        }
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.abbrevCombo_.getEditor().getEditorComponent();
            abbrevText = jtc.getText().trim();
        } else {
            abbrevText = this.abbrevFieldEdit_.getText().trim();
        }
        if (abbrevText.equals("")) {
            abbrevText = null;
        }
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.legCombo_.getEditor().getEditorComponent();
            legacyAltText = jtc.getText().trim();
        } else {
            legacyAltText = this.legFieldEdit_.getText().trim();
        }
        if (legacyAltText.equals("")) {
            legacyAltText = null;
        }
        PertDictionary pDict = this.pd_.getPertDictionary();
        Iterator kit = pDict.getKeys();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            PertProperties pp = pDict.getPerturbProps(key);
            String type = pp.getType();
            if (this.currKey_ != null && this.currKey_.equals(key) || this.mode_ == 2 && this.allMerge_.contains(key)) continue;
            if (DataUtil.keysEqual(type, typeText)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertPropEdit.dupType"), this.rMan_.getString("pertPropEdit.dupTypeTitle"), 0);
                return false;
            }
            boolean problem = false;
            String abbrev = pp.getAbbrev();
            String legAlt = pp.getLegacyAlt();
            if (abbrevText != null) {
                boolean atProb1 = abbrev != null && DataUtil.keysEqual(abbrev, abbrevText);
                boolean atProb2 = legAlt != null && DataUtil.keysEqual(legAlt, abbrevText);
                boolean bl = problem = atProb1 || atProb2;
            }
            if (legacyAltText != null) {
                boolean latProb1 = abbrev != null && DataUtil.keysEqual(abbrev, legacyAltText);
                boolean latProb2 = legAlt != null && DataUtil.keysEqual(legAlt, legacyAltText);
                boolean bl = problem = problem || latProb1 || latProb2;
            }
            if (!problem) continue;
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertPropEdit.dupAbbrev"), this.rMan_.getString("pertPropEdit.dupAbbrevTitle"), 0);
            return false;
        }
        JComboBox useCombo = this.mode_ == 2 ? this.relationComboMerge_ : this.relationComboEdit_;
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)useCombo.getSelectedItem();
        NameValuePairTablePanel useTab = this.mode_ == 2 ? this.nvptpMerge_ : this.nvptpEdit_;
        NameValuePairList nvPairs = useTab.extractData();
        if (this.currKey_ == null || this.mode_ == 3) {
            String nextKey = pDict.getNextDataKey();
            this.newProps_ = new PertProperties(nextKey, typeText, abbrevText, (Integer)tocc.val);
        } else {
            PertProperties currProps = pDict.getPerturbProps(this.currKey_);
            boolean legacyAllowed = currProps.getLegacyAlt() != null || this.mode_ == 2 && this.altAbbrevOptions_.size() > 1;
            this.newProps_ = (PertProperties)currProps.clone();
            this.newProps_.setType(typeText);
            this.newProps_.setAbbrev(abbrevText);
            if (legacyAllowed) {
                this.newProps_.setLegacyAlt(legacyAltText);
            }
            this.newProps_.setLinkSignRelationship((Integer)tocc.val);
            this.newProps_.clearNameValuePairs();
        }
        Iterator nvpit = nvPairs.getIterator();
        while (nvpit.hasNext()) {
            NameValuePair nvp = (NameValuePair)nvpit.next();
            this.newProps_.setNameValue(nvp);
        }
        return true;
    }

    private NameValuePairList buildNVPairs() {
        NameValuePairList nvPairs = new NameValuePairList();
        HashSet<String> seenKeys = new HashSet<String>();
        PertDictionary pdict = this.pd_.getPertDictionary();
        PertProperties currProps = pdict.getPerturbProps(this.currKey_);
        Iterator kit = currProps.getNvpKeys();
        while (kit.hasNext()) {
            String name = (String)kit.next();
            seenKeys.add(name);
            String value = currProps.getValue(name);
            nvPairs.addNameValuePair(new NameValuePair(name, value));
        }
        if (this.mode_ == 2) {
            Iterator amit = this.allMerge_.iterator();
            while (amit.hasNext()) {
                String amkey = (String)amit.next();
                if (amkey.equals(this.currKey_)) continue;
                PertProperties otherProps = pdict.getPerturbProps(amkey);
                Iterator okit = otherProps.getNvpKeys();
                while (okit.hasNext()) {
                    String name = (String)okit.next();
                    if (seenKeys.contains(name)) continue;
                    seenKeys.add(name);
                    String value = otherProps.getValue(name);
                    nvPairs.addNameValuePair(new NameValuePair(name, value));
                }
            }
        }
        return nvPairs;
    }

    private void displayProperties() {
        this.updateOptions();
        if (this.currKey_ == null) {
            if (this.mode_ != 1) {
                throw new IllegalStateException();
            }
            String empty = "";
            this.typeFieldEdit_.setText(empty);
            this.abbrevFieldEdit_.setText(empty);
            this.legLabelEdit_.setEnabled(false);
            this.legFieldEdit_.setEditable(false);
            this.legFieldEdit_.setText(empty);
            UiUtil.initCombo(this.relationComboEdit_);
            this.nvptpEdit_.resetNVPList(new NameValuePairList());
            this.cardLayout_.show(this.myCard_, "edit");
            return;
        }
        PertDictionary pdict = this.pd_.getPertDictionary();
        PertProperties currProps = pdict.getPerturbProps(this.currKey_);
        String currType = currProps.getType();
        String currAbbrev = currProps.getAbbrev();
        String legacy = currProps.getLegacyAlt();
        int lsr = currProps.getLinkSignRelationship();
        NameValuePairList nvPairs = this.buildNVPairs();
        switch (this.mode_) {
            case 1: 
            case 3: {
                this.nvptpEdit_.resetNVPList(nvPairs);
                this.typeFieldEdit_.setText(this.mode_ == 1 ? currType : this.copyType_);
                String useAbbrev = this.mode_ == 1 ? currAbbrev : this.copyAbbrev_;
                this.abbrevFieldEdit_.setText(useAbbrev == null ? "" : useAbbrev);
                String useLeg = this.mode_ == 1 ? legacy : this.copyLegAlt_;
                this.legFieldEdit_.setText(useLeg == null ? "" : useLeg);
                this.legLabelEdit_.setEnabled(useLeg != null);
                this.legFieldEdit_.setEditable(useLeg != null);
                this.relationComboEdit_.setSelectedItem(pdict.getRelationshipChoice(lsr));
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                this.nvptpMerge_.resetNVPList(nvPairs);
                JTextComponent jtc = (JTextComponent)this.typeCombo_.getEditor().getEditorComponent();
                jtc.setText(currType);
                jtc = (JTextComponent)this.abbrevCombo_.getEditor().getEditorComponent();
                jtc.setText(currAbbrev == null ? "" : currAbbrev);
                jtc = (JTextComponent)this.legCombo_.getEditor().getEditorComponent();
                jtc.setText(legacy == null ? "" : legacy);
                boolean legEnable = this.altAbbrevOptions_.size() > 1 || legacy != null;
                this.legLabelMerge_.setEnabled(legEnable);
                this.legCombo_.setEnabled(legEnable);
                this.relationComboMerge_.setSelectedItem(pdict.getRelationshipChoice(lsr));
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String typeFieldText;
        private String abbrevFieldText;
        private String legFieldText;
        private List nvpValues;
        private TrueObjChoiceContent relationComboTocc;

        MyFreezeDried() {
            if (PertPropsAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertPropsAddOrEditPanel.this.typeCombo_.getEditor().getEditorComponent();
                this.typeFieldText = jtc.getText().trim();
                jtc = (JTextComponent)PertPropsAddOrEditPanel.this.abbrevCombo_.getEditor().getEditorComponent();
                this.abbrevFieldText = jtc.getText().trim();
                jtc = (JTextComponent)PertPropsAddOrEditPanel.this.legCombo_.getEditor().getEditorComponent();
                this.legFieldText = jtc.getText().trim();
                this.nvpValues = PertPropsAddOrEditPanel.this.nvptpMerge_.getTable().getModel().getValuesFromTable();
                this.relationComboTocc = (TrueObjChoiceContent)PertPropsAddOrEditPanel.this.relationComboMerge_.getSelectedItem();
            } else {
                this.typeFieldText = PertPropsAddOrEditPanel.this.typeFieldEdit_.getText();
                this.abbrevFieldText = PertPropsAddOrEditPanel.this.abbrevFieldEdit_.getText();
                this.legFieldText = PertPropsAddOrEditPanel.this.legFieldEdit_.getText();
                this.nvpValues = PertPropsAddOrEditPanel.this.nvptpEdit_.getTable().getModel().getValuesFromTable();
                this.relationComboTocc = (TrueObjChoiceContent)PertPropsAddOrEditPanel.this.relationComboEdit_.getSelectedItem();
            }
        }

        public boolean needToCancel() {
            PertDictionary pdict;
            if (PertPropsAddOrEditPanel.this.mode_ == 2) {
                PertPropsAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertPropsAddOrEditPanel.this.currKey_ != null && PertPropsAddOrEditPanel.this.mode_ == 1 && (pdict = PertPropsAddOrEditPanel.this.pd_.getPertDictionary()).getPerturbProps(PertPropsAddOrEditPanel.this.currKey_) == null) {
                PertPropsAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            if (PertPropsAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertPropsAddOrEditPanel.this.typeCombo_.getEditor().getEditorComponent();
                jtc.setText(this.typeFieldText);
                jtc = (JTextComponent)PertPropsAddOrEditPanel.this.abbrevCombo_.getEditor().getEditorComponent();
                jtc.setText(this.abbrevFieldText);
                jtc = (JTextComponent)PertPropsAddOrEditPanel.this.legCombo_.getEditor().getEditorComponent();
                jtc.setText(this.legFieldText);
                PertPropsAddOrEditPanel.this.relationComboMerge_.setSelectedItem(this.relationComboTocc);
                PertPropsAddOrEditPanel.this.nvptpMerge_.getTable().updateTable(true, this.nvpValues);
            } else {
                PertPropsAddOrEditPanel.this.typeFieldEdit_.setText(this.typeFieldText);
                PertPropsAddOrEditPanel.this.abbrevFieldEdit_.setText(this.abbrevFieldText);
                PertPropsAddOrEditPanel.this.legFieldEdit_.setText(this.legFieldText);
                PertPropsAddOrEditPanel.this.relationComboEdit_.setSelectedItem(this.relationComboTocc);
                PertPropsAddOrEditPanel.this.nvptpEdit_.getTable().updateTable(true, this.nvpValues);
            }
        }
    }
}

