/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertRegRestrictAddOrEditPanel
extends AnimatedSplitEditPanel {
    private PerturbationData.RegionRestrict rrResult_;
    private PerturbationData pd_;
    private ArrayList regionList_;
    private String parentCurrKey_;
    private JTextField legacyNullRegion_;
    private EditableTable estRr_;
    private PerturbationData.RegionRestrict currRegRestrict_;
    private PertManageHelper pmh_;
    private JLabel legacyWarning_;
    private JLabel legacyLabel_;

    public PertRegRestrictAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey, int legacyModes) {
        super(parent, pet, myKey, 2);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        JLabel descLabel = new JLabel(this.rMan_.getString("prraep.description"));
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 2, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        this.add((Component)descLabel, this.gbc_);
        this.regionList_ = new ArrayList();
        this.estRr_ = new EditableTable(new EditableTable.OneEnumTableModel("prraep.region", this.regionList_), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = true;
        etp.tableIsUnselectable = false;
        etp.buttons = 5;
        etp.singleSelectOnly = true;
        etp.buttonsOnSide = false;
        etp.perColumnEnums = new HashMap();
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.regionList_));
        JPanel regTablePan = this.estRr_.buildEditableTable(etp);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 2, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)regTablePan, this.gbc_);
        this.rowNum_ += 2;
        if ((legacyModes & 4) != 0) {
            this.legacyLabel_ = new JLabel(this.rMan_.getString("prraep.legacyNullTag"));
            this.legacyNullRegion_ = new JTextField();
            UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
            this.add((Component)this.legacyLabel_, this.gbc_);
            UiUtil.gbcSet(this.gbc_, 1, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.legacyNullRegion_, this.gbc_);
            this.legacyWarning_ = new JLabel("", 0);
            UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 2, 1, 0, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            this.add((Component)this.legacyWarning_, this.gbc_);
        }
        this.finishConstruction();
    }

    public void setSources(String parentKey, PerturbationData.RegionRestrict currRegRestrict, int mode) {
        this.mode_ = mode;
        this.currRegRestrict_ = currRegRestrict;
        this.parentCurrKey_ = parentKey;
        this.displayProperties();
    }

    public PerturbationData.RegionRestrict getResult() {
        return this.rrResult_;
    }

    public void closeAction() {
        this.estRr_.stopTheEditing(false);
        super.closeAction();
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        this.regionList_ = this.buildRegionEnum();
        HashMap<Integer, EditableTable.EnumCellInfo> perColumnEnums = new HashMap<Integer, EditableTable.EnumCellInfo>();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.regionList_));
        this.estRr_.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)this.estRr_.getModel()).setCurrentEnums(this.regionList_);
    }

    protected boolean stashResults() {
        ArrayList<String> regionList;
        int yes;
        String legNullVal = null;
        if (this.legacyNullRegion_ != null) {
            String string = legNullVal = this.legacyNullRegion_.isEnabled() ? this.legacyNullRegion_.getText().trim() : null;
        }
        if (legNullVal != null && legNullVal.equals("")) {
            legNullVal = null;
        }
        if (legNullVal != null && (yes = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("prraep.legacyNotRecommended"), this.rMan_.getString("prraep.legacyNotRecommendedTitle"), 0)) != 0) {
            return false;
        }
        Iterator sit = this.estRr_.getModel().getValuesFromTable().iterator();
        ArrayList<String> arrayList = regionList = sit.hasNext() ? new ArrayList<String>() : null;
        while (sit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)sit.next();
            EnumCell ec = ent.enumChoice;
            if (regionList.contains(ec.internal)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("prraep.dupRegion"), this.rMan_.getString("prraep.dupRegionTitle"), 0);
                return false;
            }
            regionList.add(ec.internal);
        }
        if (legNullVal != null && regionList != null && !regionList.isEmpty()) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("peaep.dualModeIllegal"), this.rMan_.getString("peaep.dualModeIllegalTitle"), 0);
            return false;
        }
        this.rrResult_ = legNullVal != null ? new PerturbationData.RegionRestrict(legNullVal) : (regionList == null ? null : new PerturbationData.RegionRestrict(regionList));
        this.estRr_.stopTheEditing(false);
        return true;
    }

    private void displayProperties() {
        this.updateOptions();
        List srcRows = this.buildRegionDisplayList();
        this.estRr_.updateTable(true, srcRows);
        if (this.currRegRestrict_ == null) {
            if (this.legacyNullRegion_ != null) {
                this.legacyNullRegion_.setText("");
                this.legacyNullRegion_.setEnabled(false);
            }
        } else if (this.legacyNullRegion_ != null) {
            if (this.currRegRestrict_.isLegacyNullStyle()) {
                this.legacyLabel_.setEnabled(true);
                this.legacyNullRegion_.setText(this.currRegRestrict_.getLegacyValue());
                this.legacyNullRegion_.setEnabled(true);
                this.legacyWarning_.setText(this.rMan_.getString("prraep.legacyWarning"));
            } else {
                this.legacyLabel_.setEnabled(false);
                this.legacyNullRegion_.setText("");
                this.legacyNullRegion_.setEnabled(false);
                this.legacyWarning_.setText("");
            }
            this.legacyWarning_.revalidate();
        }
    }

    private ArrayList buildRegionEnum() {
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        TreeSet toSort = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        toSort.addAll(tcd.getRegions());
        Iterator tsit = toSort.iterator();
        int count = 0;
        while (tsit.hasNext()) {
            String regName = (String)tsit.next();
            retval.add(new EnumCell(regName, regName, count, count));
            ++count;
        }
        return retval;
    }

    private List buildRegionDisplayList() {
        ArrayList retval = new ArrayList();
        if (this.currRegRestrict_ == null || this.currRegRestrict_.isLegacyNullStyle()) {
            return retval;
        }
        Iterator rit = this.currRegRestrict_.getRegions();
        return this.buildRegionDisplayListCore(rit, false);
    }

    private List buildRegionDisplayListCore(Iterator rit, boolean forHotUpdate) {
        ArrayList<EditableTable.OneEnumTableModel.TableRow> retval = new ArrayList<EditableTable.OneEnumTableModel.TableRow>();
        EditableTable.OneEnumTableModel rpt = (EditableTable.OneEnumTableModel)this.estRr_.getModel();
        int count = 0;
        int useIndex = -1;
        int numReg = this.regionList_.size();
        while (rit.hasNext()) {
            String regionID = forHotUpdate ? ((EditableTable.OneEnumTableModel.TableRow)rit.next()).enumChoice.internal : (String)rit.next();
            EditableTable.OneEnumTableModel.TableRow tr = rpt.new EditableTable.OneEnumTableModel.TableRow();
            tr.origOrder = new Integer(count++);
            for (int i = 0; i < numReg; ++i) {
                EnumCell ecp = (EnumCell)this.regionList_.get(i);
                if (!regionID.equals(ecp.internal)) continue;
                useIndex = i;
                break;
            }
            if (useIndex == -1) {
                if (forHotUpdate) continue;
                throw new IllegalStateException();
            }
            tr.enumChoice = new EnumCell((EnumCell)this.regionList_.get(useIndex));
            retval.add(tr);
        }
        return retval;
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String legacyNullRegionText;
        private List estRegValues;
        private PerturbationData.RegionRestrict frozenRegRestrict;

        MyFreezeDried() {
            this.legacyNullRegionText = PertRegRestrictAddOrEditPanel.this.legacyNullRegion_ == null ? null : PertRegRestrictAddOrEditPanel.this.legacyNullRegion_.getText();
            this.estRegValues = PertRegRestrictAddOrEditPanel.this.estRr_.getModel().getValuesFromTable();
            this.frozenRegRestrict = PertRegRestrictAddOrEditPanel.this.currRegRestrict_ == null ? null : (PerturbationData.RegionRestrict)PertRegRestrictAddOrEditPanel.this.currRegRestrict_.clone();
        }

        public boolean needToCancel() {
            if (PertRegRestrictAddOrEditPanel.this.parentCurrKey_ != null && PertRegRestrictAddOrEditPanel.this.mode_ == 1 && PertRegRestrictAddOrEditPanel.this.pd_.getDataPoint(PertRegRestrictAddOrEditPanel.this.parentCurrKey_) == null) {
                PertRegRestrictAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            if (PertRegRestrictAddOrEditPanel.this.legacyNullRegion_ != null) {
                PertRegRestrictAddOrEditPanel.this.legacyNullRegion_.setText(this.legacyNullRegionText);
            }
            PertRegRestrictAddOrEditPanel.this.currRegRestrict_ = PertRegRestrictAddOrEditPanel.this.pmh_.fixupFrozenRegRes(this.frozenRegRestrict);
            List regionRows = PertRegRestrictAddOrEditPanel.this.buildRegionDisplayListCore(this.estRegValues.iterator(), true);
            PertRegRestrictAddOrEditPanel.this.estRr_.updateTable(true, regionRows);
        }
    }
}

