/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertSourceDefAddOrEditPanel
extends AnimatedSplitEditPanel {
    private JComboBox srcField_;
    private JComboBox experimentField_;
    private JComboBox proxyName_;
    private JLabel proxyLab_;
    private JComboBox proxySignField_;
    private PertSource resultSource_;
    private String currKey_;
    private PerturbationData pd_;
    private PertManageHelper pmh_;
    private EditableTable estAnnot_;
    private ArrayList annotList_;
    private JButton proxJump_;
    private HashSet allMerge_;

    public PertSourceDefAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey) {
        super(parent, pet, myKey, 4);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        Vector srcVec = this.pd_.getSourceNameOptions();
        JLabel srcLabel = new JLabel(this.rMan_.getString("psdae.src"));
        this.srcField_ = new JComboBox(srcVec);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        this.add((Component)srcLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.srcField_, this.gbc_);
        JButton addNewSource = new JButton(this.rMan_.getString("psdae.manageSources"), this.pmh_.getJumpIcon());
        addNewSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.srcField_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertSourceDefAddOrEditPanel.this.pet_.jumpToRemoteEdit("srcsAndTargs", "editSrc", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, 3, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        this.add((Component)addNewSource, this.gbc_);
        JLabel expLabel = new JLabel(this.rMan_.getString("psdae.experiment"));
        Vector exps = pd.getPertDictionary().getExperimentTypes();
        this.experimentField_ = new JComboBox(exps);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        this.add((Component)expLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.add((Component)this.experimentField_, this.gbc_);
        JButton addNewPert = new JButton(this.rMan_.getString("psdae.managePerts"), this.pmh_.getJumpIcon());
        addNewPert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.experimentField_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertSourceDefAddOrEditPanel.this.pet_.jumpToRemoteEdit("perProps", "editPert", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, 3, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        this.add((Component)addNewPert, this.gbc_);
        JLabel proxSLab = new JLabel(this.rMan_.getString("psdae.proxySign"));
        this.proxyLab_ = new JLabel(this.rMan_.getString("psdae.proxyFor"));
        Vector proxs = new Vector(PertSource.getProxySignValues());
        this.proxySignField_ = new JComboBox(proxs);
        this.proxySignField_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                try {
                    int index = PertSourceDefAddOrEditPanel.this.proxySignField_.getSelectedIndex();
                    PertSourceDefAddOrEditPanel.this.proxyName_.setEnabled(index != 0);
                    PertSourceDefAddOrEditPanel.this.proxyLab_.setEnabled(index != 0);
                    PertSourceDefAddOrEditPanel.this.proxJump_.setEnabled(index != 0);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        this.add((Component)proxSLab, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_, 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.5, 0.0);
        this.add((Component)this.proxySignField_, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 2, this.rowNum_, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        this.add((Component)this.proxyLab_, this.gbc_);
        this.proxyName_ = new JComboBox(srcVec);
        this.proxJump_ = new JButton(this.rMan_.getString("pdpe.jump"), this.pmh_.getJumpIcon());
        this.proxJump_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    TrueObjChoiceContent tocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.proxyName_.getSelectedItem();
                    String whichRow = tocc == null ? null : (String)tocc.val;
                    PertSourceDefAddOrEditPanel.this.pet_.jumpToRemoteEdit("srcsAndTargs", "editSrc", whichRow);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel combo = this.pmh_.componentWithJumpButton(this.proxyName_, this.proxJump_);
        UiUtil.gbcSet(this.gbc_, 3, this.rowNum_++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.5, 0.0);
        this.add((Component)combo, this.gbc_);
        this.annotList_ = new ArrayList();
        this.estAnnot_ = new EditableTable(new EditableTable.OneEnumTableModel("psdae.annot", this.annotList_), this.parent_);
        EditableTable.TableParams etp = this.pmh_.tableParamsForAnnot(this.annotList_);
        JPanel annotTablePan = this.estAnnot_.buildEditableTable(etp);
        JPanel annotTableWithButton = this.pmh_.addEditButton(annotTablePan, "psdae.annotEdit", true, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String who = PertSourceDefAddOrEditPanel.this.pmh_.getSelectedEnumVal(PertSourceDefAddOrEditPanel.this.estAnnot_);
                    PertSourceDefAddOrEditPanel.this.pet_.jumpToRemoteEdit("annotManager", "editAnnot", who);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        annotTableWithButton.setMinimumSize(new Dimension(400, 100));
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 4, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.rowNum_ += 2;
        this.add((Component)annotTableWithButton, this.gbc_);
        this.finishConstruction();
    }

    public void closeAction() {
        this.estAnnot_.stopTheEditing(false);
        super.closeAction();
    }

    public PertSource getResult() {
        return this.resultSource_;
    }

    public void setSource(String srcKey) {
        this.mode_ = 1;
        this.currKey_ = srcKey;
        this.displayProperties();
    }

    public void setDupSourceDef(String origKey) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        this.displayProperties();
    }

    public String setSourceDefsForMerge(List joinKeys) {
        this.mode_ = 2;
        this.allMerge_ = new HashSet(joinKeys);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map refCounts = da.getAllSrcDefReferenceCounts();
        this.currKey_ = this.pmh_.getMostUsedKey(refCounts, joinKeys);
        this.displayProperties();
        return this.currKey_;
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        Vector srcVec = this.pd_.getSourceNameOptions();
        Vector exps = this.pd_.getPertDictionary().getExperimentTypes();
        UiUtil.replaceComboItems(this.srcField_, srcVec);
        UiUtil.replaceComboItems(this.experimentField_, exps);
        UiUtil.replaceComboItems(this.proxyName_, srcVec);
        this.annotList_ = this.pmh_.buildAnnotEnum();
        HashMap<Integer, EditableTable.EnumCellInfo> perColumnEnums = new HashMap<Integer, EditableTable.EnumCellInfo>();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.annotList_));
        this.estAnnot_.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)this.estAnnot_.getModel()).setCurrentEnums(this.annotList_);
    }

    protected boolean stashResults() {
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.srcField_.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.undefinedSrc"), this.rMan_.getString("psdae.undefinedSrcTitle"), 0);
            return false;
        }
        String srcKey = (String)tocc.val;
        tocc = (TrueObjChoiceContent)this.experimentField_.getSelectedItem();
        if (tocc == null) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.undefinedExp"), this.rMan_.getString("psdae.undefinedExpTitle"), 0);
            return false;
        }
        String expKey = (String)tocc.val;
        int index = this.proxySignField_.getSelectedIndex();
        String pSignResult = PertSource.mapProxySignIndex(index);
        String proxNameKey = null;
        if (index != 0) {
            tocc = (TrueObjChoiceContent)this.proxyName_.getSelectedItem();
            if (tocc == null) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.undefinedProx"), this.rMan_.getString("psdae.undefinedProxTitle"), 0);
                return false;
            }
            proxNameKey = (String)tocc.val;
        }
        Iterator tdit = this.estAnnot_.getModel().getValuesFromTable().iterator();
        ArrayList<String> annotResult = new ArrayList<String>();
        while (tdit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)tdit.next();
            EnumCell ec = ent.enumChoice;
            if (ec == null) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.undefinedFoot"), this.rMan_.getString("psdae.undefinedFootTitle"), 0);
                return false;
            }
            annotResult.add(ec.internal);
        }
        if (this.currKey_ == null || this.mode_ == 3) {
            String nextKey = this.pd_.getNextDataKey();
            this.resultSource_ = new PertSource(nextKey, srcKey, expKey, annotResult);
            this.resultSource_.setProxySign(pSignResult);
        } else {
            this.resultSource_ = (PertSource)this.pd_.getSourceDef(this.currKey_).clone();
            this.resultSource_.setSourceNameKey(srcKey);
            this.resultSource_.setExpType(expKey);
            this.resultSource_.setProxySign(pSignResult);
            this.resultSource_.setAnnotationIDs(annotResult);
        }
        Iterator sdkit = this.pd_.getSourceDefKeys();
        while (sdkit.hasNext()) {
            String sdkey = (String)sdkit.next();
            PertSource pschk = this.pd_.getSourceDef(sdkey);
            if (pschk.compareSrcAndType(this.resultSource_) != 0) continue;
            boolean problem = false;
            if (this.mode_ == 2) {
                problem = !this.allMerge_.contains(sdkey);
            } else {
                boolean bl = problem = this.mode_ == 3 || this.currKey_ == null || !this.currKey_.equals(sdkey);
            }
            if (!problem) continue;
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.duplicatedSrcAndType"), this.rMan_.getString("psdae.duplicatedSrcAndTypeTitle"), 0);
            return false;
        }
        if (proxNameKey != null && proxNameKey.equals(srcKey)) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("psdae.srcProxiesItself"), this.rMan_.getString("psdae.srcProxiesItselfTitle"), 0);
            return false;
        }
        if (index == 0) {
            this.resultSource_.setProxiedSpeciesKey(null);
        } else {
            this.resultSource_.setProxiedSpeciesKey(proxNameKey);
        }
        this.estAnnot_.stopTheEditing(false);
        return true;
    }

    private void displayProperties() {
        ArrayList anids;
        this.updateOptions();
        if (this.currKey_ == null && this.mode_ == 1) {
            UiUtil.initCombo(this.srcField_);
            UiUtil.initCombo(this.experimentField_);
            UiUtil.initCombo(this.proxySignField_);
            this.proxyName_.setEnabled(false);
            this.proxyLab_.setEnabled(false);
            UiUtil.initCombo(this.proxyName_);
            List annotRows = this.pmh_.buildAnnotDisplayList(new ArrayList(), this.estAnnot_, this.annotList_, false);
            this.estAnnot_.updateTable(true, annotRows);
            return;
        }
        PertSource ps = this.pd_.getSourceDef(this.currKey_);
        TrueObjChoiceContent currSrc = this.pd_.getSourceOrProxyNameChoiceContent(ps.getSourceNameKey());
        this.srcField_.setSelectedItem(currSrc);
        PertProperties currExp = ps.getExpType(this.pd_.getPertDictionary());
        TrueObjChoiceContent tocc = currExp.getExperimentTypeEntry();
        this.experimentField_.setSelectedItem(tocc);
        String proxSign = ps.getProxySign();
        boolean haveAProx = !proxSign.equals(PertSource.mapProxySignIndex(0));
        ObjChoiceContent occP = PertSource.getProxySignValue(proxSign);
        this.proxySignField_.setSelectedItem(occP);
        this.proxyName_.setEnabled(haveAProx);
        this.proxyLab_.setEnabled(haveAProx);
        if (haveAProx) {
            TrueObjChoiceContent currProx = this.pd_.getSourceOrProxyNameChoiceContent(ps.getProxiedSpeciesKey());
            this.proxyName_.setSelectedItem(currProx);
        } else {
            UiUtil.initCombo(this.proxyName_);
        }
        if (this.mode_ == 2) {
            HashSet allIDs = new HashSet();
            Iterator amit = this.allMerge_.iterator();
            while (amit.hasNext()) {
                String nextKey = (String)amit.next();
                PertSource psa = this.pd_.getSourceDef(nextKey);
                allIDs.addAll(psa.getAnnotationIDs());
            }
            anids = new ArrayList(allIDs);
        } else {
            anids = ps.getAnnotationIDs();
        }
        List annotRows = this.pmh_.buildAnnotDisplayList(anids, this.estAnnot_, this.annotList_, false);
        this.estAnnot_.updateTable(true, annotRows);
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private List estAnnotValues;
        private TrueObjChoiceContent srcComboTocc;
        private TrueObjChoiceContent expTocc;
        private int proxSignIndex;
        private TrueObjChoiceContent proxNameTocc;

        MyFreezeDried() {
            this.srcComboTocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.srcField_.getSelectedItem();
            this.expTocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.experimentField_.getSelectedItem();
            this.proxSignIndex = PertSourceDefAddOrEditPanel.this.proxySignField_.getSelectedIndex();
            this.proxNameTocc = (TrueObjChoiceContent)PertSourceDefAddOrEditPanel.this.proxyName_.getSelectedItem();
            this.estAnnotValues = PertSourceDefAddOrEditPanel.this.estAnnot_.getModel().getValuesFromTable();
        }

        public boolean needToCancel() {
            if (PertSourceDefAddOrEditPanel.this.mode_ == 2) {
                PertSourceDefAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertSourceDefAddOrEditPanel.this.currKey_ != null && PertSourceDefAddOrEditPanel.this.mode_ == 1 && PertSourceDefAddOrEditPanel.this.pd_.getSourceDef(PertSourceDefAddOrEditPanel.this.currKey_) == null) {
                PertSourceDefAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            PertSourceDefAddOrEditPanel.this.proxySignField_.setSelectedIndex(this.proxSignIndex);
            List annotRows = PertSourceDefAddOrEditPanel.this.pmh_.buildAnnotDisplayList(this.estAnnotValues, PertSourceDefAddOrEditPanel.this.estAnnot_, PertSourceDefAddOrEditPanel.this.annotList_, true);
            PertSourceDefAddOrEditPanel.this.estAnnot_.updateTable(true, annotRows);
            if (this.srcComboTocc != null) {
                PertSourceDefAddOrEditPanel.this.srcField_.setSelectedItem(PertSourceDefAddOrEditPanel.this.pd_.getSourceOrProxyNameChoiceContent((String)this.srcComboTocc.val));
            }
            if (this.expTocc != null) {
                PertSourceDefAddOrEditPanel.this.experimentField_.setSelectedItem(PertSourceDefAddOrEditPanel.this.pd_.getPertDictionary().getExperimentTypeChoice((String)this.expTocc.val));
            }
            if (this.proxNameTocc != null) {
                PertSourceDefAddOrEditPanel.this.proxyName_.setSelectedItem(PertSourceDefAddOrEditPanel.this.pd_.getSourceOrProxyNameChoiceContent((String)this.proxNameTocc.val));
            }
        }
    }
}

