/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PertSources;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.utils.BTStashResultsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.EnumCell;

public class PertSourcesDialog
extends BTStashResultsDialog {
    private PerturbationData pd_;
    private HashSet existingSrcs_;
    private PertSources currSources_;
    private ArrayList pertSrcList_;
    private EditableTable estSrcForEdit_;
    private PertSources result_;

    public PertSourcesDialog(JFrame parent, PertSources currSources, Iterator existing) {
        super(parent, "setPertSources.title", new Dimension(500, 300), 1);
        this.currSources_ = currSources;
        this.existingSrcs_ = new HashSet();
        while (existing.hasNext()) {
            PertSources eps = (PertSources)existing.next();
            if (currSources != null && eps.equals(currSources)) continue;
            this.existingSrcs_.add(eps);
        }
        this.pd_ = Database.getDB().getPertData();
        this.pertSrcList_ = this.buildPertSourceEnum();
        JPanel tabPan = this.buildTable();
        this.addTable(tabPan, 5);
        this.finishConstruction();
        this.displayProperties();
    }

    public PertSources getResult() {
        return this.result_;
    }

    protected void updateOptions() {
        this.pertSrcList_ = this.buildPertSourceEnum();
        HashMap<Integer, EditableTable.EnumCellInfo> perColumnEnums = new HashMap<Integer, EditableTable.EnumCellInfo>();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.pertSrcList_));
        this.estSrcForEdit_.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)this.estSrcForEdit_.getModel()).setCurrentEnums(this.pertSrcList_);
    }

    protected boolean stashForOK() {
        ArrayList<String> srcsResult;
        this.estSrcForEdit_.stopTheEditing(false);
        Iterator sit = this.estSrcForEdit_.getModel().getValuesFromTable().iterator();
        if (!sit.hasNext()) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("setPertSources.emptySrcList"), this.rMan_.getString("setPertSources.emptySrcListTitle"), 0);
            return false;
        }
        ArrayList<String> arrayList = srcsResult = sit.hasNext() ? new ArrayList<String>() : null;
        while (sit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)sit.next();
            EnumCell ec = ent.enumChoice;
            if (srcsResult.contains(ec.internal)) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("setPertSources.dupSource"), this.rMan_.getString("setPertSources.dupSourceTitle"), 0);
                return false;
            }
            srcsResult.add(ec.internal);
        }
        this.result_ = new PertSources(srcsResult);
        if (this.existingSrcs_.contains(this.result_)) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("setPertSources.dupOfExistingSource"), this.rMan_.getString("setPertSources.dupOfExistingSourceTitle"), 0);
            this.result_ = null;
            return false;
        }
        return true;
    }

    private JPanel buildTable() {
        this.estSrcForEdit_ = new EditableTable(new EditableTable.OneEnumTableModel("peaep.perturb", this.pertSrcList_), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = false;
        etp.tableIsUnselectable = false;
        etp.buttons = 29;
        etp.singleSelectOnly = true;
        etp.buttonsOnSide = true;
        etp.perColumnEnums = new HashMap();
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.pertSrcList_));
        JPanel srcTablePan = this.estSrcForEdit_.buildEditableTable(etp);
        return srcTablePan;
    }

    private void displayProperties() {
        this.updateOptions();
        List srcRows = this.buildSourceDisplayList();
        this.estSrcForEdit_.updateTable(true, srcRows);
    }

    private ArrayList buildPertSourceEnum() {
        TreeMap<String, ArrayList<String>> sorter = new TreeMap<String, ArrayList<String>>();
        Iterator sdkit = this.pd_.getSourceDefKeys();
        while (sdkit.hasNext()) {
            String key = (String)sdkit.next();
            PertSource ps = this.pd_.getSourceDef(key);
            String display = ps.getDisplayValueWithFootnotes(this.pd_, false);
            ArrayList<String> perName = (ArrayList<String>)sorter.get(display);
            if (perName == null) {
                perName = new ArrayList<String>();
                sorter.put(display, perName);
            }
            perName.add(key);
        }
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        int count = 0;
        Iterator vit = sorter.keySet().iterator();
        while (vit.hasNext()) {
            String display = (String)vit.next();
            ArrayList perName = (ArrayList)sorter.get(display);
            int pns = perName.size();
            for (int i = 0; i < pns; ++i) {
                String key = (String)perName.get(i);
                retval.add(new EnumCell(display, key, count, count));
            }
            ++count;
        }
        return retval;
    }

    private List buildSourceDisplayList() {
        ArrayList<EditableTable.OneEnumTableModel.TableRow> retval = new ArrayList<EditableTable.OneEnumTableModel.TableRow>();
        if (this.currSources_ == null) {
            return retval;
        }
        Iterator psit = this.currSources_.getSources();
        EditableTable.OneEnumTableModel rpt = (EditableTable.OneEnumTableModel)this.estSrcForEdit_.getModel();
        int count = 0;
        int useIndex = -1;
        int numSrc = this.pertSrcList_.size();
        while (psit.hasNext()) {
            String psID = (String)psit.next();
            EditableTable.OneEnumTableModel.TableRow tr = rpt.new EditableTable.OneEnumTableModel.TableRow();
            tr.origOrder = new Integer(count++);
            for (int i = 0; i < numSrc; ++i) {
                EnumCell ecp = (EnumCell)this.pertSrcList_.get(i);
                if (!psID.equals(ecp.internal)) continue;
                useIndex = i;
                break;
            }
            if (useIndex == -1) {
                throw new IllegalStateException();
            }
            tr.enumChoice = new EnumCell((EnumCell)this.pertSrcList_.get(useIndex));
            retval.add(tr);
        }
        return retval;
    }
}

