/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PertProperties;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSourceDefAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertSrcDefsManagePanel
extends AnimatedSplitManagePanel {
    public static final String MANAGER_KEY = "srcDefs";
    public static final String PERT_DEF_KEY = "editPrtDef";
    private ReadOnlyTable rtdps_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private String pendingKey_;
    private PertSourceDefAddOrEditPanel pspp_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertSrcDefsManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.pfet_ = pfet;
        this.rtdps_ = new ReadOnlyTable(new PertSourceModel(), new ReadOnlyTable.EmptySelector());
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 200, 250));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 100, 150));
        colWidths.add(new ReadOnlyTable.ColumnWidths(2, 50, 200, 250));
        colWidths.add(new ReadOnlyTable.ColumnWidths(3, 50, 200, 250));
        colWidths.add(new ReadOnlyTable.ColumnWidths(4, 50, 400, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(5, 50, 50, 100));
        JPanel pertSrcPanel = this.commonTableBuild(this.rtdps_, "psdm.pertDef", new AnimatedSplitManagePanel.ButtonHand(PERT_DEF_KEY), null, colWidths, PERT_DEF_KEY);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_++, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)pertSrcPanel, this.gbc_);
        this.pspp_ = new PertSourceDefAddOrEditPanel(this.parent_, this.pd_, this, PERT_DEF_KEY);
        this.addEditPanel(this.pspp_, PERT_DEF_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(PERT_DEF_KEY)) {
            if (this.joinKeys_ == null) {
                this.editAPertDef(key, what);
            } else {
                this.joinPertDefs(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtdps_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.pspp_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.pspp_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(PERT_DEF_KEY)) {
            PertSourceEntry pse = (PertSourceEntry)obj;
            return pse.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtdps_, whichKey, this, PERT_DEF_KEY);
    }

    public void doAJoin(String key) {
        if (!key.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        this.joinKeys_ = ((PertSourceModel)this.rtdps_.getModel()).getSelectedKeys(this.rtdps_.selectedRows);
        this.pendingKey_ = this.pspp_.setSourceDefsForMerge(this.joinKeys_);
        this.pspp_.startEditing();
    }

    public void doADuplication(String key) {
        if (!key.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        String useKey = ((PertSourceModel)this.rtdps_.getModel()).getSelectedKey(this.rtdps_.selectedRows);
        this.pendingKey_ = null;
        this.pspp_.setDupSourceDef(useKey);
        this.pspp_.startEditing();
    }

    public void doAFilterJump(String key) {
        if (!key.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        String filterKey = ((PertSourceModel)this.rtdps_.getModel()).getSelectedKey(this.rtdps_.selectedRows);
        PertFilter srcFilter = new PertFilter(1, 0, filterKey);
        PertFilterExpression srcExp = new PertFilterExpression(srcFilter);
        this.pfet_.jumpWithNewFilter(srcExp);
    }

    protected void enableTopPane(boolean enable) {
        this.rtdps_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtdps_.selectedRows == null ? null : ((PertSourceModel)this.rtdps_.getModel()).getSelectedKeys(this.rtdps_.selectedRows);
        this.rtdps_.rowElements.clear();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map sdrefs = da.getAllSrcDefReferenceCounts();
        Integer noCount = new Integer(0);
        Iterator pskit = this.pd_.getSourceDefKeys();
        while (pskit.hasNext()) {
            String key = (String)pskit.next();
            PertSource ps = this.pd_.getSourceDef(key);
            Integer count = (Integer)sdrefs.get(key);
            if (count == null) {
                count = noCount;
            }
            this.rtdps_.rowElements.add(new PertSourceEntry(ps, count));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtdps_, this, PERT_DEF_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (!key.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = null;
        this.rtdps_.clearSelections(false);
        this.pspp_.setSource(this.pendingKey_);
        this.pspp_.startEditing();
    }

    protected void doAnEdit(String key) {
        if (!key.equals(PERT_DEF_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pendingKey_ = ((PertSourceModel)this.rtdps_.getModel()).getSelectedKey(this.rtdps_.selectedRows);
        this.pspp_.setSource(this.pendingKey_);
        this.pspp_.startEditing();
    }

    protected void doADelete(String key) {
        if (key.equals(PERT_DEF_KEY)) {
            String deleteKey = ((PertSourceModel)this.rtdps_.getModel()).getSelectedKey(this.rtdps_.selectedRows);
            if (this.deleteSourceDef(deleteKey)) {
                this.pet_.itemDeleted(PERT_DEF_KEY);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean deleteSourceDef(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getSourceDefReferenceSets(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deleteSourceDef");
        da.killOffDependencies(refs, support);
        PertDataChange pdc2 = this.pd_.deleteSourceDef(key);
        support.addEdit(new PertDataChangeCmd(pdc2));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private boolean joinPertDefs(String key, int what) {
        int doit;
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        PertSource psrc = this.pspp_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergeSourceDefs");
        DependencyAnalyzer.Dependencies refs = da.getSourceDefMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        Set multiPertCollapse = da.getMultiSourceDefCollapseMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        if (!multiPertCollapse.isEmpty() && (doit = JOptionPane.showConfirmDialog(this.parent_, UiUtil.convertMessageToHtml(this.rMan_.getString("sdmp.multiPertCollapseOnJoin")), this.rMan_.getString("sdmp.multiPertCollapseOnJoinTitle"), 2)) != 0) {
            return false;
        }
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergePertSourceDefs(this.joinKeys_, this.pendingKey_, psrc);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
        return true;
    }

    public void editAPertDef(String key, int what) {
        PertSource psrc = this.pspp_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, this.pendingKey_ == null ? "undo.createPertSourceDef" : "undo.editPertSourceDef");
        if (this.pendingKey_ == null) {
            this.pendingKey_ = psrc.getID();
        }
        PertDataChange pdc = this.pd_.setSourceDef(psrc);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private class PertSourceEntry {
        String key;
        String srcName;
        String pertType;
        String proxSignStr;
        String proxName;
        String annots;
        Integer count;

        PertSourceEntry(PertSource ps, Integer count) {
            boolean haveAProx;
            this.key = ps.getID();
            this.srcName = ps.getSourceName(PertSrcDefsManagePanel.this.pd_);
            PertProperties currExp = ps.getExpType(PertSrcDefsManagePanel.this.pd_.getPertDictionary());
            this.pertType = currExp.getType();
            String proxSign = ps.getProxySign();
            boolean bl = haveAProx = !proxSign.equals(PertSource.mapProxySignIndex(0));
            if (haveAProx) {
                ObjChoiceContent occP = PertSource.getProxySignValue(proxSign);
                this.proxSignStr = occP.name;
            } else {
                this.proxSignStr = "";
            }
            this.proxName = haveAProx ? ps.getProxiedSpeciesName(PertSrcDefsManagePanel.this.pd_) : "";
            List footKeys = ps.getAnnotationIDs();
            this.annots = PertSrcDefsManagePanel.this.pd_.getFootnoteListAsNVString(footKeys);
            this.count = count;
        }
    }

    private class PertSourceModel
    extends ReadOnlyTable.TableModel {
        static final int SRC_NAME = 0;
        static final int PERT_TYPE = 1;
        static final int PROX_SIGN = 2;
        static final int PROX_NAME = 3;
        static final int ANNOTS = 4;
        static final int COUNT = 5;
        private static final int NUM_COL_ = 6;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        PertSourceModel() {
            super(6);
            this.colNames_ = new String[]{"psdm.srcName", "psdm.pertType", "psdm.proxSign", "psdm.proxName", "psdm.annots", "psdm.count"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertSrcDefsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertSrcDefsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertSrcDefsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertSrcDefsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertSrcDefsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertSrcDefsManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                PertSourceEntry pse = (PertSourceEntry)iit.next();
                this.columns_[0].add(pse.srcName);
                this.columns_[1].add(pse.pertType);
                this.columns_[2].add(pse.proxSignStr);
                this.columns_[3].add(pse.proxName);
                this.columns_[4].add(pse.annots);
                this.columns_[5].add(pse.count);
                this.hiddenColumns_[0].add(pse.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

