/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PertSource;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSimpleNameEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertTargetAddOrEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertSrcsAndTargsManagePanel
extends AnimatedSplitManagePanel
implements PertSimpleNameEditPanel.Client {
    public static final String MANAGER_KEY = "srcsAndTargs";
    public static final String SRC_KEY = "editSrc";
    public static final String TRG_KEY = "editTrg";
    private ReadOnlyTable rtds_;
    private ReadOnlyTable rtdt_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private String pendingKey_;
    private String dupKey_;
    private PertSimpleNameEditPanel psp_;
    private PertTargetAddOrEditPanel ptp_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertSrcsAndTargsManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        ArrayList<ReadOnlyTable> allTabs = new ArrayList<ReadOnlyTable>();
        this.rtds_ = new ReadOnlyTable(new PertManageHelper.NameWithHiddenIDAndRefCountModel("pstm.sourceName"), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtds_);
        this.rtdt_ = new ReadOnlyTable(new AnnotatedTargModel(), new ReadOnlyTable.EmptySelector());
        allTabs.add(this.rtdt_);
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 150, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 50, 100));
        JPanel srcsPanel = this.commonTableBuild(this.rtds_, "pertSrcTargManage.sources", new AnimatedSplitManagePanel.ButtonHand(SRC_KEY), allTabs, colWidths, SRC_KEY);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)srcsPanel, this.gbc_);
        colWidths = new ArrayList();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 100, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 50, 100, 100));
        colWidths.add(new ReadOnlyTable.ColumnWidths(2, 50, 50, 100));
        JPanel targsPanel = this.commonTableBuild(this.rtdt_, "pertSrcTargManage.targets", new AnimatedSplitManagePanel.ButtonHand(TRG_KEY), allTabs, colWidths, TRG_KEY);
        UiUtil.gbcSet(this.gbc_, 1, this.rowNum_, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)targsPanel, this.gbc_);
        this.psp_ = new PertSimpleNameEditPanel(this.parent_, this, "pertSrcTargEdit.sourceName", this, SRC_KEY);
        this.addEditPanel(this.psp_, SRC_KEY);
        this.ptp_ = new PertTargetAddOrEditPanel(this.parent_, this.pd_, this, this, TRG_KEY);
        this.addEditPanel(this.ptp_, TRG_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public String getNameForKey(String whoAmI, String key) {
        if (whoAmI.equals(SRC_KEY)) {
            return this.pd_.getSourceName(key);
        }
        if (whoAmI.equals(TRG_KEY)) {
            return this.pd_.getTarget(key);
        }
        throw new IllegalArgumentException();
    }

    public boolean haveDuplication(String whoAmI, String key, String name) {
        String existingKey;
        if (whoAmI.equals(SRC_KEY)) {
            existingKey = this.pd_.getSourceKeyFromName(name);
        } else if (whoAmI.equals(TRG_KEY)) {
            existingKey = this.pd_.getTargKeyFromName(name);
        } else {
            throw new IllegalArgumentException();
        }
        if (existingKey == null) {
            return false;
        }
        if (this.joinKeys_ == null) {
            return key == null || !existingKey.equals(key);
        }
        return !this.joinKeys_.contains(existingKey);
    }

    public boolean haveDisconnect(String whoAmI, String key, String name) {
        if (key == null) {
            return false;
        }
        if (whoAmI.equals(SRC_KEY)) {
            String currName = this.pd_.getSourceName(key);
            if (!DataUtil.keysEqual(currName, name)) {
                return this.pd_.dataSourceOnlyInverseIsDefault(key);
            }
        } else if (whoAmI.equals(TRG_KEY)) {
            String currName = this.pd_.getTarget(key);
            if (!DataUtil.keysEqual(currName, name)) {
                return this.pd_.dataEntryOnlyInverseIsDefault(key);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(SRC_KEY)) {
            if (this.joinKeys_ == null) {
                this.editASource(key, what);
            } else {
                this.joinSources(key, what);
            }
        } else if (key.equals(TRG_KEY)) {
            if (this.joinKeys_ == null) {
                this.editATarget(key, what);
            } else {
                this.joinTargets(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void finished() {
        this.rtds_.makeCurrentSelectionVisible();
        this.rtdt_.makeCurrentSelectionVisible();
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.psp_.hotUpdate(mustDie);
        this.ptp_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.psp_.closeAction();
        this.ptp_.closeAction();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(SRC_KEY)) {
            PertManageHelper.ToccWithRefCount twrc = (PertManageHelper.ToccWithRefCount)obj;
            return twrc.tocc.val.equals(key);
        }
        if (tableID.equals(TRG_KEY)) {
            ATMEntry atme = (ATMEntry)obj;
            return atme.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (whichTable.equals(SRC_KEY)) {
            this.pmh_.selectTableRow(this.rtds_, whichKey, this, SRC_KEY);
        } else if (whichTable.equals(TRG_KEY)) {
            this.pmh_.selectTableRow(this.rtdt_, whichKey, this, TRG_KEY);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doADuplication(String key) {
        if (key.equals(SRC_KEY)) {
            String useKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKey(this.rtds_.selectedRows);
            String copyName = this.pmh_.getUnique(this.pd_.getSourceNameOptions(), this.pd_.getSourceName(useKey));
            this.dupKey_ = useKey;
            this.pendingKey_ = null;
            this.psp_.setDupName(copyName);
            this.psp_.startEditing();
        } else if (key.equals(TRG_KEY)) {
            String useKey = ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKey(this.rtdt_.selectedRows);
            String copyName = this.pmh_.getUnique(this.pd_.getTargetOptions(false), this.pd_.getTarget(useKey));
            this.dupKey_ = useKey;
            this.pendingKey_ = null;
            this.ptp_.setDupTarget(useKey, copyName);
            this.ptp_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doAJoin(String key) {
        if (key.equals(SRC_KEY)) {
            this.joinKeys_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKeys(this.rtds_.selectedRows);
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            Map refCounts = da.getAllSourceNameReferenceCounts(true);
            this.pendingKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
            TreeSet<String> nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int numk = this.joinKeys_.size();
            for (int i = 0; i < numk; ++i) {
                String nextJk = (String)this.joinKeys_.get(i);
                nameOptions.add(this.pd_.getSourceName(nextJk));
            }
            this.psp_.setMergeName(this.pendingKey_, nameOptions, new ArrayList(this.joinKeys_));
            this.psp_.startEditing();
        } else if (key.equals(TRG_KEY)) {
            this.joinKeys_ = ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKeys(this.rtdt_.selectedRows);
            DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
            Map refCounts = da.getAllTargetReferenceCounts();
            this.pendingKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
            TreeSet<String> nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            int numk = this.joinKeys_.size();
            for (int i = 0; i < numk; ++i) {
                String nextJk = (String)this.joinKeys_.get(i);
                nameOptions.add(this.pd_.getTarget(nextJk));
            }
            this.ptp_.setMergeTarget(this.pendingKey_, new ArrayList(this.joinKeys_), nameOptions);
            this.ptp_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void doAFilterJump(String key) {
        if (key.equals(SRC_KEY)) {
            String filterKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKey(this.rtds_.selectedRows);
            PertFilter srcFilter = new PertFilter(2, 0, filterKey);
            PertFilterExpression pfe = new PertFilterExpression(srcFilter);
            this.pfet_.jumpWithNewFilter(pfe);
        } else if (key.equals(TRG_KEY)) {
            String filterKey = ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKey(this.rtdt_.selectedRows);
            PertFilter trgFilter = new PertFilter(5, 0, filterKey);
            PertFilterExpression pfe = new PertFilterExpression(trgFilter);
            this.pfet_.jumpWithNewFilter(pfe);
        }
    }

    protected void enableTopPane(boolean enable) {
        this.rtds_.setEnabled(enable);
        this.rtdt_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtds_.selectedRows == null ? null : ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKeys(this.rtds_.selectedRows);
        this.rtds_.rowElements.clear();
        Vector sno = this.pd_.getSourceNameOptions();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map sdrefs = da.getAllSourceNameReferenceCounts(false);
        Integer noCount = new Integer(0);
        Iterator snit = sno.iterator();
        while (snit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)snit.next();
            Integer count = (Integer)sdrefs.get(tocc.val);
            if (count == null) {
                count = noCount;
            }
            PertManageHelper.ToccWithRefCount twrc = new PertManageHelper.ToccWithRefCount(tocc, count);
            this.rtds_.rowElements.add(twrc);
        }
        this.pmh_.updateAndReselect(fireChange, this.rtds_, this, SRC_KEY, selKeys);
        selKeys = this.rtdt_.selectedRows == null ? null : ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKeys(this.rtdt_.selectedRows);
        this.rtdt_.rowElements.clear();
        Vector ato = this.pd_.getTargetOptions(false);
        Map trefs = da.getAllTargetReferenceCounts();
        Iterator atoit = ato.iterator();
        while (atoit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)atoit.next();
            Integer count = (Integer)trefs.get(tocc.val);
            if (count == null) {
                count = noCount;
            }
            this.rtdt_.rowElements.add(new ATMEntry((String)tocc.val, tocc.name, count));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtdt_, this, TRG_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        if (key.equals(SRC_KEY)) {
            this.pendingKey_ = null;
            this.rtds_.clearSelections(false);
            this.rtdt_.clearSelections(false);
            this.psp_.setEditName(this.pendingKey_);
            this.psp_.startEditing();
        } else if (key.equals(TRG_KEY)) {
            this.pendingKey_ = null;
            this.rtds_.clearSelections(false);
            this.rtdt_.clearSelections(false);
            this.ptp_.setTarget(this.pendingKey_);
            this.ptp_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doAnEdit(String key) {
        if (key.equals(SRC_KEY)) {
            this.pendingKey_ = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKey(this.rtds_.selectedRows);
            this.psp_.setEditName(this.pendingKey_);
            this.psp_.startEditing();
        } else if (key.equals(TRG_KEY)) {
            this.pendingKey_ = ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKey(this.rtdt_.selectedRows);
            this.ptp_.setTarget(this.pendingKey_);
            this.ptp_.startEditing();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doADelete(String key) {
        if (key.equals(SRC_KEY)) {
            String deleteKey = ((PertManageHelper.NameWithHiddenIDAndRefCountModel)this.rtds_.getModel()).getSelectedKey(this.rtds_.selectedRows);
            if (this.deleteASourceName(deleteKey)) {
                this.pet_.itemDeleted(SRC_KEY);
            }
        } else if (key.equals(TRG_KEY)) {
            String deleteKey = ((AnnotatedTargModel)this.rtdt_.getModel()).getSelectedKey(this.rtdt_.selectedRows);
            if (this.deleteATarget(deleteKey)) {
                this.pet_.itemDeleted(TRG_KEY);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean deleteATarget(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getTargetReferenceSet(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertTarget");
        da.killOffDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.deleteTargetName(key);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private boolean deleteASourceName(String key) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getSourceNameReferenceSets(key);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertSourceName");
        da.killOffDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.deleteSourceName(key);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        return true;
    }

    private void editATarget(String key, int what) {
        String action;
        String name = this.ptp_.getTargetName();
        int mode = this.ptp_.getMode();
        boolean dupMap = false;
        if (mode == 3) {
            if (this.pd_.haveTargetNameMapTo(this.dupKey_)) {
                int doit = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pstmp.wantToDupTrgMap"), this.rMan_.getString("pstmp.wantToDupTrgMapTitle"), 0);
                dupMap = doit == 0;
            }
            this.pendingKey_ = this.pd_.getNextDataKey();
            action = "undo.dupPertTargetName";
        } else {
            String string = action = this.pendingKey_ == null ? "undo.createPertTargetName" : "undo.editPertTargetName";
            if (this.pendingKey_ == null) {
                this.pendingKey_ = this.pd_.getNextDataKey();
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, action);
        List annots = this.ptp_.getTargetAnnots();
        PertDataChange[] pdc = this.pd_.setTargetName(this.pendingKey_, name, annots);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        if (dupMap) {
            PertDataChange[] pdctnm = this.pd_.duplicateTargetNameMap(this.dupKey_, this.pendingKey_);
            support.addEdits(PertDataChangeCmd.wrapChanges(pdctnm));
            this.dupKey_ = null;
        }
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void editASource(String key, int what) {
        String action;
        String name = this.psp_.getResult();
        int mode = this.psp_.getMode();
        boolean dupMap = false;
        if (mode == 3) {
            if (this.pd_.haveSourceNameMapTo(this.dupKey_)) {
                int doit = JOptionPane.showConfirmDialog(this.parent_, this.rMan_.getString("pstmp.wantToDupSrcMap"), this.rMan_.getString("pstmp.wantToDupSrcMapTitle"), 0);
                dupMap = doit == 0;
            }
            this.pendingKey_ = this.pd_.getNextDataKey();
            action = "undo.dupPertSourceName";
        } else if (mode == 1) {
            String string = action = this.pendingKey_ == null ? "undo.createPertSourceName" : "undo.editPertSourceName";
            if (this.pendingKey_ == null) {
                this.pendingKey_ = this.pd_.getNextDataKey();
            }
        } else {
            throw new IllegalStateException();
        }
        UndoSupport support = new UndoSupport(this.undom_, action);
        PertDataChange[] pdc = this.pd_.setSourceName(this.pendingKey_, name);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        if (dupMap) {
            PertDataChange[] pdcsnm = this.pd_.duplicateSourceNameMap(this.dupKey_, this.pendingKey_);
            support.addEdits(PertDataChangeCmd.wrapChanges(pdcsnm));
            this.dupKey_ = null;
        }
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private void joinTargets(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        String name = this.ptp_.getTargetName();
        List annots = this.ptp_.getTargetAnnots();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertTargets");
        DependencyAnalyzer.Dependencies refs = da.getTargetMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeTargetNames(this.joinKeys_, this.pendingKey_, name, annots);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private boolean joinSources(String key, int what) {
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        String name = this.psp_.getResult();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertSourceNames");
        DependencyAnalyzer.Dependencies refs = da.getSourceNameMergeSet(new HashSet(this.joinKeys_), this.pendingKey_);
        if (!this.pmh_.warnAndAsk(refs)) {
            return false;
        }
        da.mergeDependencies(refs, support);
        PertDataChange[] pdc = this.pd_.mergeSourceNames(this.joinKeys_, this.pendingKey_, name);
        support.addEdits(PertDataChangeCmd.wrapChanges(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.joinKeys_ = null;
        String resultKey = this.pendingKey_;
        this.pendingKey_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
        Iterator sdkit = this.pd_.getSourceDefKeys();
        while (sdkit.hasNext()) {
            String sdkey = (String)sdkit.next();
            PertSource pschk = this.pd_.getSourceDef(sdkey);
            if (!pschk.getSourceNameKey().equals(resultKey)) continue;
            Iterator sdkit2 = this.pd_.getSourceDefKeys();
            while (sdkit2.hasNext()) {
                PertSource pschk2;
                String sdkey2 = (String)sdkit2.next();
                if (sdkey.equals(sdkey2) || !(pschk2 = this.pd_.getSourceDef(sdkey2)).getSourceNameKey().equals(resultKey) || pschk.compareSrcAndType(pschk2) != 0) continue;
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pstmp.mergedSourceDefs"), this.rMan_.getString("pstmp.mergedSourceDefsTitle"), 2);
                return true;
            }
        }
        return true;
    }

    private class ATMEntry {
        String key;
        String trgName;
        String annots;
        Integer count;

        ATMEntry(String key, String name, Integer count) {
            this.key = key;
            this.trgName = name;
            this.count = count;
            List anList = PertSrcsAndTargsManagePanel.this.pd_.getFootnotesForTarget(key);
            this.annots = anList == null || anList.isEmpty() ? "" : PertSrcsAndTargsManagePanel.this.pd_.getFootnoteListAsString(anList);
        }
    }

    private class AnnotatedTargModel
    extends ReadOnlyTable.TableModel {
        static final int TRG_NAME = 0;
        static final int ANNOTS = 1;
        static final int COUNT = 2;
        private static final int NUM_COL_ = 3;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        AnnotatedTargModel() {
            super(3);
            this.colNames_ = new String[]{"pertSrc.targName", "pertSrc.annots", "pertSrc.refCounts"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertSrcsAndTargsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertSrcsAndTargsManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertSrcsAndTargsManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{String.CASE_INSENSITIVE_ORDER, String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                ATMEntry atm = (ATMEntry)iit.next();
                this.columns_[0].add(atm.trgName);
                this.columns_[1].add(atm.annots);
                this.columns_[2].add(atm.count);
                this.hiddenColumns_[0].add(atm.key);
            }
        }

        public String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

