/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSimpleNameEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertTargetAddOrEditPanel
extends AnimatedSplitEditPanel {
    private JTextField nameFieldForEdit_;
    private JComboBox nameCombo_;
    private PerturbationData pd_;
    private String currKey_;
    private PertManageHelper pmh_;
    private String nameResult_;
    private List annotResult_;
    private EditableTable estAnnotForEdit_;
    private EditableTable estAnnotForMerge_;
    private ArrayList annotList_;
    private PertSimpleNameEditPanel.Client client_;
    private List allMerge_;
    private String copyName_;
    private SortedSet nameOptions_;

    public PertTargetAddOrEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertSimpleNameEditPanel.Client client, String myKey) {
        super(parent, pet, myKey, 4);
        this.pd_ = pd;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        this.client_ = client;
        this.annotList_ = new ArrayList();
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel(this.rMan_.getString("ptae.targName"));
        int editRow = 0;
        UiUtil.gbcSet(this.gbc_, 0, editRow, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        editPanel.add((Component)label, this.gbc_);
        this.nameFieldForEdit_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, 3, editRow++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        editPanel.add((Component)this.nameFieldForEdit_, this.gbc_);
        JPanel annotTableWithButton = this.buildAnnotTable(false);
        UiUtil.gbcSet(this.gbc_, 0, editRow, 4, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        editRow += 2;
        editPanel.add((Component)annotTableWithButton, this.gbc_);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        JLabel labelToo = new JLabel(this.rMan_.getString("ptae.targName"));
        int mergeRow = 0;
        UiUtil.gbcSet(this.gbc_, 0, mergeRow, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        mergePanel.add((Component)labelToo, this.gbc_);
        this.nameCombo_ = new JComboBox();
        this.nameCombo_.setEditable(true);
        UiUtil.gbcSet(this.gbc_, 3, mergeRow++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        mergePanel.add((Component)this.nameCombo_, this.gbc_);
        JPanel annotTableWithButtonForMerge = this.buildAnnotTable(true);
        UiUtil.gbcSet(this.gbc_, 0, mergeRow, 4, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        mergeRow += 2;
        mergePanel.add((Component)annotTableWithButtonForMerge, this.gbc_);
        this.makeMultiMode(editPanel, mergePanel, 4);
        this.finishConstruction();
    }

    public void closeAction() {
        if (this.mode_ == 2) {
            this.estAnnotForMerge_.stopTheEditing(false);
        } else {
            this.estAnnotForEdit_.stopTheEditing(false);
        }
        super.closeAction();
    }

    public String getTargetName() {
        return this.nameResult_;
    }

    public List getTargetAnnots() {
        return this.annotResult_;
    }

    public void setTarget(String currKey) {
        this.mode_ = 1;
        this.currKey_ = currKey;
        this.displayProperties();
    }

    public void setDupTarget(String origKey, String copyName) {
        this.mode_ = 3;
        this.currKey_ = origKey;
        this.copyName_ = copyName;
        this.displayProperties();
    }

    public void setMergeTarget(String origKey, List allMerge, SortedSet nameOptions) {
        this.mode_ = 2;
        this.currKey_ = origKey;
        this.allMerge_ = allMerge;
        this.nameOptions_ = nameOptions;
        this.displayProperties();
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected boolean stashResults() {
        String newText;
        if (this.mode_ == 2) {
            JTextComponent jtc = (JTextComponent)this.nameCombo_.getEditor().getEditorComponent();
            newText = jtc.getText().trim();
        } else {
            newText = this.nameFieldForEdit_.getText().trim();
        }
        if (newText == null || newText.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("snep.emptyName"), this.rMan_.getString("snep.emptyNameTitle"), 0);
            return false;
        }
        if (this.client_.haveDuplication(this.myKey_, this.currKey_, newText)) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("snep.duplicateName"), this.rMan_.getString("snep.duplicateNameTitle"), 0);
            return false;
        }
        if (this.mode_ == 2) {
            String desc;
            int doit;
            int numDisconnect = 0;
            String exampOldName = null;
            int numM = this.allMerge_.size();
            for (int i = 0; i < numM; ++i) {
                String nextKey = (String)this.allMerge_.get(i);
                if (!this.client_.haveDisconnect(this.myKey_, nextKey, newText)) continue;
                ++numDisconnect;
                if (exampOldName != null) continue;
                exampOldName = this.client_.getNameForKey(this.myKey_, nextKey);
            }
            if (numDisconnect > 0 && (doit = JOptionPane.showConfirmDialog(this.parent_, desc = UiUtil.convertMessageToHtml(MessageFormat.format(this.rMan_.getString("snep.disconnectingMultiRow"), new Integer(numDisconnect), exampOldName, newText)), this.rMan_.getString("snep.disconnectingTitle"), 2)) != 0) {
                return false;
            }
        } else if (this.client_.haveDisconnect(this.myKey_, this.currKey_, newText)) {
            String oldName = this.client_.getNameForKey(this.myKey_, this.currKey_);
            String desc = UiUtil.convertMessageToHtml(MessageFormat.format(this.rMan_.getString("snep.disconnectingRow"), oldName, newText));
            int doit = JOptionPane.showConfirmDialog(this.parent_, desc, this.rMan_.getString("snep.disconnectingTitle"), 2);
            if (doit != 0) {
                return false;
            }
        }
        this.nameResult_ = newText;
        EditableTable useTable = this.mode_ == 2 ? this.estAnnotForMerge_ : this.estAnnotForEdit_;
        Iterator tdit = useTable.getModel().getValuesFromTable().iterator();
        List list = this.annotResult_ = tdit.hasNext() ? new ArrayList() : null;
        while (tdit.hasNext()) {
            EditableTable.OneEnumTableModel.TableRow ent = (EditableTable.OneEnumTableModel.TableRow)tdit.next();
            EnumCell ec = ent.enumChoice;
            this.annotResult_.add(ec.internal);
        }
        useTable.stopTheEditing(false);
        return true;
    }

    protected void updateOptions() {
        this.annotList_ = this.pmh_.buildAnnotEnum();
        HashMap<Integer, EditableTable.EnumCellInfo> perColumnEnums = new HashMap<Integer, EditableTable.EnumCellInfo>();
        perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(false, this.annotList_));
        EditableTable useTable = this.mode_ == 2 ? this.estAnnotForMerge_ : this.estAnnotForEdit_;
        useTable.refreshEditorsAndRenderers(perColumnEnums);
        ((EditableTable.OneEnumTableModel)useTable.getModel()).setCurrentEnums(this.annotList_);
    }

    private JPanel buildAnnotTable(boolean forMerge) {
        final EditableTable useTable = !forMerge ? (this.estAnnotForEdit_ = new EditableTable(new EditableTable.OneEnumTableModel("ptae.annot", this.annotList_), this.parent_)) : (this.estAnnotForMerge_ = new EditableTable(new EditableTable.OneEnumTableModel("ptae.annot", this.annotList_), this.parent_));
        EditableTable.TableParams etp = this.pmh_.tableParamsForAnnot(this.annotList_);
        JPanel annotTablePan = useTable.buildEditableTable(etp);
        JPanel annotTableWithButton = this.pmh_.addEditButton(annotTablePan, "ptae.annotEdit", true, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String who = PertTargetAddOrEditPanel.this.pmh_.getSelectedEnumVal(useTable);
                    PertTargetAddOrEditPanel.this.pet_.jumpToRemoteEdit("annotManager", "editAnnot", who);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        return annotTableWithButton;
    }

    private void displayProperties() {
        this.updateOptions();
        switch (this.mode_) {
            case 1: {
                if (this.currKey_ == null) {
                    this.nameFieldForEdit_.setText("");
                    List annotRows = this.pmh_.buildAnnotDisplayList(new ArrayList(), this.estAnnotForEdit_, this.annotList_, false);
                    this.estAnnotForEdit_.updateTable(true, annotRows);
                    return;
                }
                this.nameFieldForEdit_.setText(this.pd_.getTarget(this.currKey_));
                List anids = this.pd_.getFootnotesForTarget(this.currKey_);
                List annotRows = this.pmh_.buildAnnotDisplayList(anids, this.estAnnotForEdit_, this.annotList_, false);
                this.estAnnotForEdit_.updateTable(true, annotRows);
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 3: {
                this.nameFieldForEdit_.setText(this.copyName_);
                List anids = this.pd_.getFootnotesForTarget(this.currKey_);
                List annotRows = this.pmh_.buildAnnotDisplayList(anids, this.estAnnotForEdit_, this.annotList_, false);
                this.estAnnotForEdit_.updateTable(true, annotRows);
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                UiUtil.replaceComboItems(this.nameCombo_, new Vector(this.nameOptions_));
                this.nameCombo_.setSelectedItem(this.pd_.getTarget(this.currKey_));
                int numMerge = this.allMerge_.size();
                TreeSet combined = new TreeSet();
                for (int i = 0; i < numMerge; ++i) {
                    String tkey = (String)this.allMerge_.get(i);
                    List anids = this.pd_.getFootnotesForTarget(tkey);
                    if (anids == null) continue;
                    combined.addAll(anids);
                }
                List annotRows = this.pmh_.buildAnnotDisplayList(new ArrayList(combined), this.estAnnotForMerge_, this.annotList_, false);
                this.estAnnotForMerge_.updateTable(true, annotRows);
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String nameFieldText;
        private List estAnnotValues;

        MyFreezeDried() {
            if (PertTargetAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertTargetAddOrEditPanel.this.nameCombo_.getEditor().getEditorComponent();
                this.nameFieldText = jtc.getText().trim();
                this.estAnnotValues = PertTargetAddOrEditPanel.this.estAnnotForMerge_.getModel().getValuesFromTable();
            } else {
                this.nameFieldText = PertTargetAddOrEditPanel.this.nameFieldForEdit_.getText().trim();
                this.estAnnotValues = PertTargetAddOrEditPanel.this.estAnnotForEdit_.getModel().getValuesFromTable();
            }
        }

        public boolean needToCancel() {
            if (PertTargetAddOrEditPanel.this.mode_ == 2) {
                PertTargetAddOrEditPanel.this.closeAction();
                return true;
            }
            if (PertTargetAddOrEditPanel.this.currKey_ != null && PertTargetAddOrEditPanel.this.mode_ == 1 && PertTargetAddOrEditPanel.this.client_.getNameForKey(PertTargetAddOrEditPanel.this.myKey_, PertTargetAddOrEditPanel.this.currKey_) == null) {
                PertTargetAddOrEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            if (PertTargetAddOrEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertTargetAddOrEditPanel.this.nameCombo_.getEditor().getEditorComponent();
                jtc.setText(this.nameFieldText);
                List annotRows = PertTargetAddOrEditPanel.this.pmh_.buildAnnotDisplayList(this.estAnnotValues, PertTargetAddOrEditPanel.this.estAnnotForMerge_, PertTargetAddOrEditPanel.this.annotList_, true);
                PertTargetAddOrEditPanel.this.estAnnotForMerge_.updateTable(true, annotRows);
            } else {
                PertTargetAddOrEditPanel.this.nameFieldForEdit_.setText(this.nameFieldText);
                List annotRows = PertTargetAddOrEditPanel.this.pmh_.buildAnnotDisplayList(this.estAnnotValues, PertTargetAddOrEditPanel.this.estAnnotForEdit_, PertTargetAddOrEditPanel.this.annotList_, true);
                PertTargetAddOrEditPanel.this.estAnnotForEdit_.updateTable(true, annotRows);
            }
        }
    }
}

