/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertAnnotManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertDataPointManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertExpSetupManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertExperimentManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertInvestManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertMeasurementManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertMiscSetupManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertPropertiesManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSrcDefsManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertSrcsAndTargsManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.util.AnimatedSplitPane;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PerturbationsManagementWindow
extends JFrame
implements PendingEditTracker,
PertFilterExpressionJumpTarget {
    private PerturbationData pd_;
    private UndoManager undom_;
    private JTabbedPane tabPane_;
    private HashSet currPending_;
    private PMWindowListener pmwl_;
    private AnimatedSplitPane[] asp_;
    private HashMap managePanels_;
    private HashMap panelIndices_;
    private ArrayList tabHistory_;
    private int currTabIndex_;
    private boolean ignoreButtonNav_;
    private JButton backBut_;
    private JButton forwardBut_;
    private PertFilterExpressionJumpTarget filterTarget_;
    private String filterTag_;
    private boolean editSubmissionActive_;

    public PerturbationsManagementWindow(JFrame parent, PerturbationData pd, PertFilterExpression pfe, UndoManager undo) {
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        this.setIconImage(new ImageIcon(ugif).getImage());
        this.setTitle(ResourceManager.getManager().getString("pertManage.title"));
        this.pd_ = pd;
        this.undom_ = undo;
        this.currPending_ = new HashSet();
        this.setDefaultCloseOperation(0);
        this.pmwl_ = new PMWindowListener();
        this.addWindowListener(this.pmwl_);
        this.editSubmissionActive_ = false;
        int legacyModes = this.pd_.getExistingLegacyModes();
        ResourceManager rMan = ResourceManager.getManager();
        UiUtil.centerBigFrame(this, 1600, 1200, 0.8, 900);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int cpRowNum = 0;
        PertDataPointManagePanel pdpm = new PertDataPointManagePanel(this, this.pd_, this, this.undom_, legacyModes);
        this.filterTarget_ = pdpm;
        this.filterTag_ = pdpm.getTag();
        ArrayList<AnimatedSplitManagePanel> panelList = new ArrayList<AnimatedSplitManagePanel>();
        panelList.add(pdpm);
        panelList.add(new PertExperimentManagePanel(this, this.pd_, this, this, this.undom_, legacyModes));
        panelList.add(new PertSrcDefsManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertSrcsAndTargsManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertInvestManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertPropertiesManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertMeasurementManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertAnnotManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertExpSetupManagePanel(this, this.pd_, this, this, this.undom_));
        panelList.add(new PertMiscSetupManagePanel(this, this.pd_, this, this, this.undom_));
        int numPan = panelList.size();
        this.tabPane_ = new JTabbedPane();
        this.managePanels_ = new HashMap();
        this.panelIndices_ = new HashMap();
        this.asp_ = new AnimatedSplitPane[numPan];
        for (int i = 0; i < numPan; ++i) {
            AnimatedSplitManagePanel aspm = (AnimatedSplitManagePanel)panelList.get(i);
            this.tabPane_.addTab(rMan.getString("pertManage." + aspm.getTag()), aspm);
            this.asp_[i] = aspm.getSplit();
            this.managePanels_.put(aspm.getTag(), aspm);
            this.panelIndices_.put(aspm.getTag(), new Integer(i));
        }
        this.tabHistory_ = new ArrayList();
        this.tabHistory_.add(new Integer(0));
        this.currTabIndex_ = 0;
        this.ignoreButtonNav_ = false;
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Back24.gif");
        ImageIcon back = new ImageIcon(ugif);
        this.backBut_ = new FixedJButton(back, 10);
        this.backBut_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (PerturbationsManagementWindow.this.currTabIndex_ <= 0) {
                        return;
                    }
                    PerturbationsManagementWindow.this.currTabIndex_--;
                    PerturbationsManagementWindow.this.ignoreButtonNav_ = true;
                    PerturbationsManagementWindow.this.tabPane_.setSelectedIndex((Integer)PerturbationsManagementWindow.this.tabHistory_.get(PerturbationsManagementWindow.this.currTabIndex_));
                    PerturbationsManagementWindow.this.ignoreButtonNav_ = false;
                    PerturbationsManagementWindow.this.backBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ > 0);
                    PerturbationsManagementWindow.this.forwardBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ < PerturbationsManagementWindow.this.tabHistory_.size() - 1);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.backBut_.setEnabled(false);
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Forward24.gif");
        ImageIcon forward = new ImageIcon(ugif);
        this.forwardBut_ = new FixedJButton(forward, 10);
        this.forwardBut_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (PerturbationsManagementWindow.this.currTabIndex_ >= PerturbationsManagementWindow.this.tabHistory_.size() - 1) {
                        return;
                    }
                    PerturbationsManagementWindow.this.currTabIndex_++;
                    PerturbationsManagementWindow.this.ignoreButtonNav_ = true;
                    PerturbationsManagementWindow.this.tabPane_.setSelectedIndex((Integer)PerturbationsManagementWindow.this.tabHistory_.get(PerturbationsManagementWindow.this.currTabIndex_));
                    PerturbationsManagementWindow.this.ignoreButtonNav_ = false;
                    PerturbationsManagementWindow.this.backBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ > 0);
                    PerturbationsManagementWindow.this.forwardBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ < PerturbationsManagementWindow.this.tabHistory_.size() - 1);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.forwardBut_.setEnabled(false);
        Box topBarPanel = Box.createHorizontalBox();
        topBarPanel.add(Box.createHorizontalStrut(0));
        topBarPanel.add(this.backBut_);
        topBarPanel.add(Box.createHorizontalStrut(2));
        topBarPanel.add(this.forwardBut_);
        topBarPanel.add(Box.createHorizontalGlue());
        UiUtil.gbcSet(gbc, 0, cpRowNum++, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        cp.add((Component)topBarPanel, gbc);
        this.tabPane_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                try {
                    int sel = PerturbationsManagementWindow.this.tabPane_.getSelectedIndex();
                    AnimatedSplitPane asp = PerturbationsManagementWindow.this.asp_[sel];
                    if (asp != null) {
                        asp.doFixie();
                    }
                    ((PerturbationsManagementWindow)PerturbationsManagementWindow.this).asp_[sel] = null;
                    if (PerturbationsManagementWindow.this.ignoreButtonNav_) {
                        return;
                    }
                    int startIndex = PerturbationsManagementWindow.this.tabHistory_.size() - 1;
                    if (PerturbationsManagementWindow.this.currTabIndex_ < startIndex) {
                        for (int i = startIndex; i > PerturbationsManagementWindow.this.currTabIndex_; --i) {
                            PerturbationsManagementWindow.this.tabHistory_.remove(i);
                        }
                    }
                    PerturbationsManagementWindow.this.tabHistory_.add(new Integer(sel));
                    PerturbationsManagementWindow.this.currTabIndex_++;
                    PerturbationsManagementWindow.this.backBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ > 0);
                    PerturbationsManagementWindow.this.forwardBut_.setEnabled(PerturbationsManagementWindow.this.currTabIndex_ < PerturbationsManagementWindow.this.tabHistory_.size() - 1);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, cpRowNum, 1, 10, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cpRowNum += 10;
        cp.add((Component)this.tabPane_, gbc);
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.close"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PerturbationsManagementWindow.this.pmwl_.windowClosing(null);
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        UiUtil.gbcSet(gbc, 0, cpRowNum, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
        if (pfe != null) {
            this.filterTarget_.jumpWithNewFilter(pfe);
        }
    }

    public void editSubmissionBegins() {
        this.editSubmissionActive_ = true;
    }

    public void editSubmissionEnds() {
        this.editSubmissionActive_ = false;
    }

    public void modelChanged() {
        if (this.editSubmissionActive_) {
            return;
        }
        ((PertDataPointManagePanel)this.filterTarget_).doScalingUpdate();
        Iterator mpit = this.managePanels_.values().iterator();
        while (mpit.hasNext()) {
            AnimatedSplitManagePanel asmp = (AnimatedSplitManagePanel)mpit.next();
            asmp.haveAChange(false);
        }
        this.editSubmissionActive_ = false;
    }

    public void jumpWithNewFilter(PertFilterExpression pfe) {
        if (((PertDataPointManagePanel)this.filterTarget_).havePendingEdit()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this, rMan.getString("pertManage.editingCannotJump"), rMan.getString("pertManage.editingCannotJumpTitle"), 0);
            return;
        }
        this.filterTarget_.jumpWithNewFilter(pfe);
        this.jumpToRemoteEdit(this.filterTag_, null, null);
    }

    public boolean havePendingEdit() {
        return !this.currPending_.isEmpty();
    }

    public void editIsPending(String key) {
        int currIndex = this.tabPane_.getSelectedIndex();
        Integer ciObj = new Integer(currIndex);
        if (this.currPending_.contains(ciObj)) {
            return;
        }
        String title = this.tabPane_.getTitleAt(currIndex);
        title = title.concat("*");
        this.tabPane_.setTitleAt(currIndex, title);
        this.currPending_.add(ciObj);
    }

    public void editIsComplete(String key, int what) {
        boolean mustDie = what == 2;
        ((PertDataPointManagePanel)this.filterTarget_).doScalingUpdate();
        Iterator mpit = this.managePanels_.values().iterator();
        while (mpit.hasNext()) {
            AnimatedSplitManagePanel asmp = (AnimatedSplitManagePanel)mpit.next();
            asmp.haveAChange(mustDie);
        }
        Integer completedIndex = (Integer)this.panelIndices_.get(key);
        if (!this.currPending_.contains(completedIndex)) {
            return;
        }
        int currIndex = completedIndex;
        String title = this.tabPane_.getTitleAt(currIndex);
        title = title.substring(0, title.length() - 1);
        this.tabPane_.setTitleAt(currIndex, title);
        this.currPending_.remove(completedIndex);
    }

    public void itemDeleted(String key) {
        if (key.equals("editMeasScale")) {
            ((PertDataPointManagePanel)this.filterTarget_).doScalingUpdate();
        }
        Iterator mpit = this.managePanels_.values().iterator();
        while (mpit.hasNext()) {
            AnimatedSplitManagePanel asmp = (AnimatedSplitManagePanel)mpit.next();
            asmp.haveAChange(false);
        }
    }

    public void dropAllPendingEdits() {
        Iterator mpit = this.managePanels_.values().iterator();
        while (mpit.hasNext()) {
            AnimatedSplitManagePanel asmp = (AnimatedSplitManagePanel)mpit.next();
            asmp.dropPendingEdits();
        }
    }

    public void editIsCancelled(String key) {
        Integer completedIndex = (Integer)this.panelIndices_.get(key);
        if (!this.currPending_.contains(completedIndex)) {
            return;
        }
        int currIndex = completedIndex;
        String title = this.tabPane_.getTitleAt(currIndex);
        title = title.substring(0, title.length() - 1);
        this.tabPane_.setTitleAt(currIndex, title);
        this.currPending_.remove(completedIndex);
    }

    public void editIsPushed(String key) {
    }

    public void jumpToRemoteEdit(String key, String tableTarg, String rowTarg) {
        AnimatedSplitManagePanel asmp = (AnimatedSplitManagePanel)this.managePanels_.get(key);
        if (asmp.havePendingEdit()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this, rMan.getString("pertManage.editingCannotJump"), rMan.getString("pertManage.editingCannotJumpTitle"), 0);
            return;
        }
        asmp.setTableSelection(tableTarg, rowTarg);
        this.tabPane_.setSelectedComponent(asmp);
    }

    private class PMWindowListener
    extends WindowAdapter {
        private PMWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            try {
                ResourceManager rMan;
                int ok;
                if (!PerturbationsManagementWindow.this.currPending_.isEmpty() && (ok = JOptionPane.showConfirmDialog(PerturbationsManagementWindow.this, (rMan = ResourceManager.getManager()).getString("pertManage.pendingEdits"), rMan.getString("pertManage.pendingEditsTitle"), 0)) != 0) {
                    return;
                }
                MainCommands.getCmds().clearPerturbationsManagementWindow();
                PerturbationsManagementWindow.this.setVisible(false);
                PerturbationsManagementWindow.this.dispose();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void windowOpened(WindowEvent e) {
            try {
                AnimatedSplitPane asp = PerturbationsManagementWindow.this.asp_[0];
                if (asp != null) {
                    asp.doFixie();
                }
                ((PerturbationsManagementWindow)PerturbationsManagementWindow.this).asp_[0] = null;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

