/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.DialogSupport;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public abstract class AnimatedSplitEditPanel
extends JPanel
implements DialogSupport.DialogSupportClient {
    public static final int NO_MODE = 0;
    public static final int EDIT_MODE = 1;
    public static final int MERGE_MODE = 2;
    public static final int DUP_MODE = 3;
    protected static final String EDIT_CARD = "edit";
    protected static final String MERGE_CARD = "merge";
    protected PendingEditTracker pet_;
    protected JFrame parent_;
    protected String myKey_;
    protected ResourceManager rMan_;
    protected GridBagConstraints gbc_;
    protected DialogSupport ds_;
    protected int rowNum_;
    protected int colNum_;
    protected boolean editInProgress_;
    protected int mode_;
    protected CardLayout cardLayout_;
    protected JPanel myCard_;

    public AnimatedSplitEditPanel(JFrame parent, PendingEditTracker pet, String myKey, int colNum) {
        this.parent_ = parent;
        this.pet_ = pet;
        this.myKey_ = myKey;
        this.colNum_ = colNum;
        this.editInProgress_ = false;
        this.mode_ = 0;
        this.rMan_ = ResourceManager.getManager();
        this.setLayout(new GridBagLayout());
        this.gbc_ = new GridBagConstraints();
        this.ds_ = new DialogSupport(this, this.rMan_, this.gbc_);
        this.rowNum_ = 0;
    }

    public int getMode() {
        return this.mode_;
    }

    public boolean editInProgress() {
        return this.editInProgress_;
    }

    public void startAPush() {
        this.editInProgress_ = true;
    }

    public void startEditing() {
        this.editInProgress_ = true;
        this.pet_.editIsPending(this.myKey_);
    }

    public void applyAction() {
        throw new UnsupportedOperationException();
    }

    public void okAction() {
        if (this.stashResults()) {
            this.editInProgress_ = false;
            if (this.mode_ == 0) {
                throw new IllegalStateException();
            }
            this.pet_.editIsComplete(this.myKey_, this.mode_);
        }
    }

    public void closeAction() {
        this.editInProgress_ = false;
        this.pet_.editIsCancelled(this.myKey_);
    }

    public void hotUpdate(boolean mustDie) {
        if (!this.editInProgress_) {
            return;
        }
        FreezeDried fd = this.getFreezeDriedState();
        this.updateOptions();
        if (mustDie || fd.needToCancel()) {
            return;
        }
        fd.reInstall();
    }

    protected void makeMultiMode(JPanel editPanel, JPanel mergePanel, int rowHeight) {
        this.myCard_ = new JPanel();
        this.cardLayout_ = new CardLayout();
        this.myCard_.setLayout(this.cardLayout_);
        this.myCard_.add((Component)editPanel, EDIT_CARD);
        this.myCard_.add((Component)mergePanel, MERGE_CARD);
        UiUtil.gbcSet(this.gbc_, 0, this.rowNum_, this.colNum_, rowHeight, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.add((Component)this.myCard_, this.gbc_);
        this.rowNum_ += rowHeight;
    }

    protected void finishConstruction() {
        this.ds_.buildAndInstallCenteredButtonBox(this, this.rowNum_, this.colNum_, false, true);
    }

    protected abstract void updateOptions();

    protected abstract FreezeDried getFreezeDriedState();

    protected abstract boolean stashResults();

    public static interface FreezeDried {
        public boolean needToCancel();

        public void reInstall();
    }
}

