/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.ui.dialogs.utils.SelectionOracle;
import org.systemsbiology.biotapestry.util.AnimatedSplitPane;
import org.systemsbiology.biotapestry.util.AnimatedSplitPaneLayoutManager;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public abstract class AnimatedSplitManagePanel
extends JPanel
implements PendingEditTracker,
AnimatedSplitPane.AnimatedSplitListener,
SelectionOracle {
    protected AnimatedSplitPaneLayoutManager.PanelForSplit topPanel_;
    protected JFrame parent_;
    protected String myKey_;
    private AnimatedSplitPaneLayoutManager.PanelForSplit editPanel_;
    private CardLayout cardLayout_;
    private AnimatedSplitPane asp_;
    protected PendingEditTracker pet_;
    protected GridBagConstraints gbc_;
    protected int rowNum_;
    protected ResourceManager rMan_;
    private int currEditDepth_;
    private String[] editStack_;
    protected boolean editInProgress_;

    public AnimatedSplitManagePanel(JFrame parent, PendingEditTracker pet, String key) {
        this.pet_ = pet;
        this.myKey_ = key;
        this.parent_ = parent;
        this.currEditDepth_ = 0;
        this.editStack_ = null;
        this.setLayout(new GridLayout(1, 1));
        this.rMan_ = ResourceManager.getManager();
        this.topPanel_ = new AnimatedSplitPaneLayoutManager.PanelForSplit();
        this.topPanel_.setLayout(new GridBagLayout());
        this.gbc_ = new GridBagConstraints();
        this.rowNum_ = 0;
        this.editPanel_ = new AnimatedSplitPaneLayoutManager.PanelForSplit();
        this.cardLayout_ = new CardLayout();
        this.editPanel_.setLayout(this.cardLayout_);
        this.editPanel_.add((Component)new JPanel(), "blank");
        this.editInProgress_ = false;
    }

    public abstract boolean tableRowMatches(String var1, Object var2, String var3);

    public String getTag() {
        return this.myKey_;
    }

    public boolean havePendingEdit() {
        return this.editInProgress_;
    }

    public void editIsPending(String key) {
        this.enableTopPane(false);
        this.pet_.editIsPending(this.myKey_);
        this.cardLayout_.show(this.editPanel_, key);
        this.editInProgress_ = true;
        this.asp_.expand();
    }

    public void editIsComplete(String key, int what) {
        if (this.currEditDepth_ != 0) {
            --this.currEditDepth_;
            this.asp_.collapseThenExpand();
        } else {
            this.displayProperties(true);
            this.enableTopPane(true);
            this.pet_.editIsComplete(this.myKey_, 0);
            this.asp_.collapse();
            this.cardLayout_.show(this.editPanel_, "blank");
            this.editInProgress_ = false;
        }
    }

    public void editIsCancelled(String key) {
        if (this.currEditDepth_ != 0) {
            --this.currEditDepth_;
            this.asp_.collapseThenExpand();
        } else {
            this.enableTopPane(true);
            this.pet_.editIsCancelled(this.myKey_);
            this.asp_.collapse();
            this.cardLayout_.show(this.editPanel_, "blank");
            this.editInProgress_ = false;
        }
    }

    public void editIsPushed(String key) {
        ++this.currEditDepth_;
        this.asp_.collapseThenExpand();
    }

    public void itemDeleted(String key) {
    }

    public void editSubmissionBegins() {
    }

    public void editSubmissionEnds() {
    }

    public void jumpToRemoteEdit(String key, String tableTarg, String rowTarg) {
        this.pet_.jumpToRemoteEdit(key, tableTarg, rowTarg);
    }

    public void midBounce() {
        if (this.editStack_ == null) {
            return;
        }
        String targetKey = this.editStack_[this.currEditDepth_];
        this.cardLayout_.show(this.editPanel_, targetKey);
    }

    public void finished() {
    }

    public AnimatedSplitPane getSplit() {
        return this.asp_;
    }

    public abstract void haveAChange(boolean var1);

    public abstract void setTableSelection(String var1, String var2);

    public abstract void dropPendingEdits();

    protected JPanel commonTableBuild(ReadOnlyTable rot, String title, ReadOnlyTable.ButtonHandler bh, List allTabs, List colWidths, String key) {
        JPanel display = new JPanel();
        display.setBorder(BorderFactory.createEtchedBorder());
        display.setLayout(new GridBagLayout());
        rot.setButtonHandler(bh);
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        if (allTabs == null) {
            tp.multiTableSelectionSyncing = null;
        } else {
            tp.multiTableSelectionSyncing = allTabs;
            tp.clearOthersOnSelect = true;
        }
        tp.buttonsOnSide = true;
        tp.tableTitle = this.rMan_.getString(title);
        tp.titleFont = null;
        tp.colWidths = colWidths;
        tp.canMultiSelect = true;
        if (key != null) {
            this.addExtraButtons(tp, key);
        }
        JPanel tabPan = rot.buildReadOnlyTable(tp);
        UiUtil.gbcSet(this.gbc_, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        display.add((Component)tabPan, this.gbc_);
        return display;
    }

    public void addExtraButtons(ReadOnlyTable.TableParams etp, String targKeyArg) {
        if (etp.userAddedButtons == null) {
            etp.userAddedButtons = new ArrayList();
        }
        String buttonTag = this.rMan_.getString("asmp.mergeSelected");
        FixedJButton myButton = etp.buttonsOnSide ? new FixedJButton(1, buttonTag) : new FixedJButton(buttonTag);
        final String targKey = targKeyArg;
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    AnimatedSplitManagePanel.this.doAJoin(targKey);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ReadOnlyTable.ExtraButton eb = new ReadOnlyTable.ExtraButton(false, false, true, myButton);
        etp.userAddedButtons.add(eb);
        buttonTag = this.rMan_.getString("asmp.dupSelected");
        myButton = etp.buttonsOnSide ? new FixedJButton(1, buttonTag) : new FixedJButton(buttonTag);
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    AnimatedSplitManagePanel.this.doADuplication(targKey);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        eb = new ReadOnlyTable.ExtraButton(false, true, false, myButton);
        etp.userAddedButtons.add(eb);
        buttonTag = this.rMan_.getString("asmp.jumpAndFilter");
        myButton = etp.buttonsOnSide ? new FixedJButton(1, buttonTag) : new FixedJButton(buttonTag);
        myButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    AnimatedSplitManagePanel.this.doAFilterJump(targKey);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        eb = new ReadOnlyTable.ExtraButton(false, true, false, myButton);
        etp.userAddedButtons.add(eb);
    }

    protected void addEditPanel(JPanel who, String id) {
        this.editPanel_.add((Component)who, id);
    }

    protected void setEditStack(String[] stack) {
        this.editStack_ = stack;
    }

    protected void finishConstruction() {
        this.asp_ = new AnimatedSplitPane(this.topPanel_, this.editPanel_, this);
        this.add(this.asp_);
    }

    protected abstract void enableTopPane(boolean var1);

    protected abstract void displayProperties(boolean var1);

    protected abstract void doAnAdd(String var1);

    protected abstract void doAnEdit(String var1);

    protected abstract void doADelete(String var1);

    public void doAJoin(String key) {
    }

    public void doADuplication(String key) {
    }

    public void doAFilterJump(String key) {
    }

    public class ButtonHand
    implements ReadOnlyTable.ButtonHandler {
        private String key_;

        public ButtonHand(String key) {
            this.key_ = key;
        }

        public void pressed(int whichButton) {
            switch (whichButton) {
                case 1: {
                    AnimatedSplitManagePanel.this.doAnAdd(this.key_);
                    break;
                }
                case 4: {
                    AnimatedSplitManagePanel.this.doADelete(this.key_);
                    break;
                }
                case 2: {
                    AnimatedSplitManagePanel.this.doAnEdit(this.key_);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

