/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.EtchedBorder;
import org.systemsbiology.biotapestry.util.CheckBoxList;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class BuildListUtil {
    private CheckBoxList lw_;
    private List newEntries_;
    private ArrayList entryList_;
    private BuildListResult targResult_;
    private boolean forceDrops_;
    private JFrame parent_;
    private static ImageIcon greenIcon_;

    public BuildListUtil(JFrame parent, String nodeName, List clonedCurrEntries, Vector targCand, boolean forceDrops) {
        this.parent_ = parent;
        this.newEntries_ = clonedCurrEntries == null ? new ArrayList() : clonedCurrEntries;
        this.forceDrops_ = forceDrops;
        this.targResult_ = this.buildCheckBoxList(this.newEntries_, targCand, nodeName);
        this.lw_ = new CheckBoxList(this.targResult_.listElements);
    }

    public CheckBoxList getBuiltList() {
        return this.lw_;
    }

    public BuildListResult getBuildListResult() {
        return this.targResult_;
    }

    public List getFinishedEntryList() {
        return this.entryList_;
    }

    public static JPanel buildMessagePanel(List buildListResults) {
        ResourceManager rMan = ResourceManager.getManager();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(new EtchedBorder());
        messagePanel.setLayout(new GridBagLayout());
        boolean defaultIsPresent = false;
        int numres = buildListResults.size();
        for (int i = 0; i < numres; ++i) {
            BuildListResult blr = (BuildListResult)buildListResults.get(i);
            if (blr.defaultEntries.isEmpty()) continue;
            defaultIsPresent = true;
            break;
        }
        int rowCount = 0;
        if (defaultIsPresent) {
            String msg = UiUtil.convertMessageToHtml(rMan.getString("pertMapping.greenIsCool"));
            JLabel lab = new JLabel(msg, greenIcon_, 2);
            UiUtil.gbcSet(gbc, 0, rowCount++, 1, 1, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
            messagePanel.add((Component)lab, gbc);
        }
        return messagePanel;
    }

    public boolean stashForOKSupport(String whichList) {
        this.entryList_ = new ArrayList();
        ListModel myModel = this.lw_.getModel();
        this.processAList(myModel, this.entryList_, this.targResult_, whichList);
        return true;
    }

    private BuildListResult buildCheckBoxList(List entries, Vector targCand, String nodeName) {
        BuildListResult retval = new BuildListResult();
        retval.danglingEntries = new HashSet(entries);
        retval.defaultEntries = new HashSet();
        retval.normName = DataUtil.normKey(nodeName);
        int count = 0;
        retval.firstSel = -1;
        int firstDefault = -1;
        ArrayList<CheckBoxList.ListChoice> choices = new ArrayList<CheckBoxList.ListChoice>();
        Iterator tcit = targCand.iterator();
        while (tcit.hasNext()) {
            TrueObjChoiceContent tocc = (TrueObjChoiceContent)tcit.next();
            String normTarg = DataUtil.normKey(tocc.name);
            boolean isDefault = retval.normName.equals(normTarg);
            if (isDefault) {
                retval.defaultEntries.add(tocc.val);
                if (firstDefault == -1) {
                    firstDefault = count;
                }
            }
            String greekToLower = DataUtil.greekToLowerCase(tocc.name);
            boolean selected = entries.contains(tocc.val);
            Color useColor = isDefault ? Color.green : Color.white;
            CheckBoxList.ListChoice lc = new CheckBoxList.ListChoice(tocc.val, greekToLower, useColor, selected, false, false);
            choices.add(lc);
            if (selected) {
                retval.danglingEntries.remove(tocc.val);
                if (retval.firstSel == -1) {
                    retval.firstSel = count;
                }
            }
            ++count;
        }
        if (retval.firstSel == -1) {
            retval.firstSel = firstDefault;
        }
        if (retval.firstSel == 1) {
            retval.firstSel = 0;
        } else if (retval.firstSel >= 2) {
            retval.firstSel -= 2;
        }
        retval.listElements = new Vector(choices);
        return retval;
    }

    private void processAList(ListModel myModel, List results, BuildListResult blr, String whichList) {
        int ok;
        String desc;
        String format;
        int numElem = myModel.getSize();
        HashSet<Object> retval = new HashSet<Object>();
        boolean defaultPresent = !blr.defaultEntries.isEmpty();
        HashSet<Object> defaultSelected = new HashSet<Object>();
        boolean nonDefaultSelected = false;
        for (int i = 0; i < numElem; ++i) {
            CheckBoxList.ListChoice choice = (CheckBoxList.ListChoice)myModel.getElementAt(i);
            if (!choice.isSelected) continue;
            Object choiceObj = choice.getObject();
            retval.add(choiceObj);
            if (blr.defaultEntries.contains(choiceObj)) {
                defaultSelected.add(choiceObj);
                continue;
            }
            nonDefaultSelected = true;
        }
        ResourceManager rMan = ResourceManager.getManager();
        if (defaultPresent && !defaultSelected.isEmpty() && !nonDefaultSelected) {
            if (this.forceDrops_) {
                format = rMan.getString("pertMapping.dontNeedDeleteCheckedWillDrop");
                desc = MessageFormat.format(format, whichList);
                JOptionPane.showMessageDialog(this.parent_, desc, rMan.getString("pertMapping.dontNeedDeleteCheckedTitle"), 2);
                retval.removeAll(defaultSelected);
            } else {
                format = rMan.getString("pertMapping.dontNeedDeleteCheckedAskToDrop");
                desc = MessageFormat.format(format, whichList);
                int ok2 = JOptionPane.showConfirmDialog(this.parent_, desc, rMan.getString("pertMapping.dontNeedDeleteCheckedTitle"), 0);
                if (ok2 == 0) {
                    retval.removeAll(defaultSelected);
                }
            }
        } else if (defaultPresent && !defaultSelected.equals(blr.defaultEntries) && nonDefaultSelected && (ok = JOptionPane.showConfirmDialog(this.parent_, desc = MessageFormat.format(format = rMan.getString("pertMapping.shouldHaveDeleteCheckedAskToAdd"), whichList), rMan.getString("pertMapping.shouldHaveDeleteCheckedTitle"), 0)) == 0) {
            retval.addAll(blr.defaultEntries);
        }
        results.addAll(retval);
    }

    static {
        URL ugif = BuildListUtil.class.getResource("/org/systemsbiology/biotapestry/images/GreenRect-16-64.gif");
        greenIcon_ = new ImageIcon(ugif);
    }

    public static class BuildListResult {
        public boolean haveDanglingKeys;
        public Vector listElements;
        public int firstSel;
        public HashSet defaultEntries;
        public HashSet danglingEntries;
        public String normName;
    }
}

