/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.DialogSupport;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class MessageTableReportingDialog
extends JDialog
implements DialogSupport.DialogSupportClient {
    private ReadOnlyTable rot_;
    private List messages_;
    private boolean keepGoing_;

    public MessageTableReportingDialog(JFrame parent, List messages, String title, String tableLabel, String colLabel, Dimension dim, boolean showCancel, boolean modal) {
        super(parent, ResourceManager.getManager().getString(title), modal);
        this.messages_ = messages;
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(dim.width, dim.height);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        this.rot_ = new ReadOnlyTable(new CheckoutTableModel(colLabel), null);
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = true;
        tp.tableIsUnselectable = true;
        tp.buttons = 0;
        tp.multiTableSelectionSyncing = null;
        tp.tableTitle = rMan.getString(tableLabel);
        tp.titleFont = null;
        JPanel tabPan = this.rot_.buildReadOnlyTable(tp);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        rowNum += 8;
        cp.add((Component)tabPan, gbc);
        if (showCancel) {
            DialogSupport ds = new DialogSupport(this, rMan, gbc);
            ds.buildAndInstallCenteredButtonBox(cp, rowNum, 1, false, true);
        } else {
            DialogSupport ds = new DialogSupport(rMan, gbc, this);
            ds.buildAndInstallCloseButtonBox(cp, rowNum, 1, null);
        }
        this.setLocationRelativeTo(parent);
        this.displayProperties();
    }

    public void applyAction() {
        throw new UnsupportedOperationException();
    }

    public void okAction() {
        this.keepGoing_ = true;
        this.setVisible(false);
        this.dispose();
    }

    public void closeAction() {
        this.keepGoing_ = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean keepGoing() {
        return this.keepGoing_;
    }

    private void displayProperties() {
        this.rot_.rowElements.clear();
        this.rot_.rowElements.addAll(this.initTableRows());
        this.rot_.updateTable(true, -1);
    }

    private List initTableRows() {
        ArrayList<CheckoutTableModel.TableRow> retval = new ArrayList<CheckoutTableModel.TableRow>();
        CheckoutTableModel ctm = (CheckoutTableModel)this.rot_.getModel();
        int numMsg = this.messages_.size();
        for (int i = 0; i < numMsg; ++i) {
            CheckoutTableModel.TableRow tr = ctm.new CheckoutTableModel.TableRow();
            tr.message = (String)this.messages_.get(i);
            retval.add(tr);
        }
        return retval;
    }

    class CheckoutTableModel
    extends ReadOnlyTable.TableModel {
        static final int MESSAGE = 0;
        private static final int NUM_COL_ = 1;

        CheckoutTableModel(String title) {
            super(1);
            this.colNames_ = new String[]{title};
        }

        List getValuesFromTable() {
            ArrayList<TableRow> retval = new ArrayList<TableRow>();
            for (int i = 0; i < this.rowCount_; ++i) {
                TableRow ent = new TableRow(i);
                retval.add(ent);
            }
            return retval;
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            Iterator rit = prsList.iterator();
            while (rit.hasNext()) {
                TableRow ent = (TableRow)rit.next();
                ent.toCols();
            }
        }

        class TableRow {
            String message;

            TableRow() {
            }

            TableRow(int i) {
                this.message = (String)CheckoutTableModel.this.columns_[0].get(i);
            }

            void toCols() {
                CheckoutTableModel.this.columns_[0].add(this.message);
            }
        }
    }
}

