/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.EnumCell;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.NameValuePairList;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class NameValuePairTablePanel
extends JPanel {
    private EditableTable est_;
    private JFrame parent_;
    private List namesList_;
    private List valuesList_;
    private NameValuePairList nvpList_;
    static /* synthetic */ Class class$org$systemsbiology$biotapestry$util$EnumCell;

    public NameValuePairTablePanel(JFrame parent, NameValuePairList currList, Set allKeys, Set allValues, Map allMappedValues, boolean buttonsOnSide) {
        this.parent_ = parent;
        this.nvpList_ = currList;
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.namesList_ = this.buildEnumList(allKeys);
        this.valuesList_ = this.buildEnumList(allValues);
        this.est_ = new EditableTable(new NameValuePairTable(), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = true;
        etp.buttons = 5;
        etp.singleSelectOnly = true;
        etp.perColumnEnums = new HashMap();
        etp.buttonsOnSide = buttonsOnSide;
        etp.perColumnEnums.put(new Integer(0), new EditableTable.EnumCellInfo(true, this.namesList_));
        etp.perColumnEnums.put(new Integer(1), new EditableTable.EnumCellInfo(true, this.valuesList_));
        JPanel tablePan = this.est_.buildEditableTable(etp);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)tablePan, gbc);
    }

    public EditableTable getTable() {
        return this.est_;
    }

    public void resetNVPList(NameValuePairList currList) {
        this.nvpList_ = currList;
        this.displayProperties();
    }

    public void displayProperties() {
        List tableList = this.buildTableList();
        NameValuePairTable nvt = (NameValuePairTable)this.est_.getModel();
        nvt.extractValues(tableList);
        nvt.fireTableDataChanged();
    }

    public NameValuePairList extractData() {
        NameValuePairTable tcs = (NameValuePairTable)this.est_.getModel();
        List vals = tcs.getValuesFromTable();
        if (!this.checkValues(vals)) {
            return null;
        }
        NameValuePairList retval = this.getResult(vals);
        return retval;
    }

    private List buildEnumList(Set allNames) {
        ArrayList<EnumCell> retval = new ArrayList<EnumCell>();
        TreeSet sortedNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        sortedNames.addAll(allNames);
        retval.add(new EnumCell("", null, 0, 0));
        Iterator sit = sortedNames.iterator();
        int count = 1;
        while (sit.hasNext()) {
            String desc = (String)sit.next();
            retval.add(new EnumCell(desc, desc, count, count));
            ++count;
        }
        return retval;
    }

    private List buildTableList() {
        ArrayList<NameValuePairTable.TableRow> retval = new ArrayList<NameValuePairTable.TableRow>();
        if (this.nvpList_ == null) {
            return retval;
        }
        NameValuePairTable nvpt = (NameValuePairTable)this.est_.getModel();
        Iterator pit = this.nvpList_.getIterator();
        while (pit.hasNext()) {
            NameValuePair nvp = (NameValuePair)pit.next();
            NameValuePairTable.TableRow tr = nvpt.new NameValuePairTable.TableRow();
            String name = nvp.getName();
            int rsize = this.namesList_.size();
            for (int i = 1; i < rsize; ++i) {
                EnumCell ecn = (EnumCell)this.namesList_.get(i);
                if (!ecn.internal.equals(name)) continue;
                tr.name = new EnumCell(ecn);
                break;
            }
            String value = nvp.getValue();
            int vsize = this.valuesList_.size();
            for (int i = 1; i < vsize; ++i) {
                EnumCell ecv = (EnumCell)this.valuesList_.get(i);
                if (!ecv.internal.equals(value)) continue;
                tr.value = new EnumCell(ecv);
                break;
            }
            retval.add(tr);
        }
        return retval;
    }

    private boolean checkValues(List vals) {
        ResourceManager rMan = ResourceManager.getManager();
        HashSet<String> otherNames = new HashSet<String>();
        int numRow = vals.size();
        for (int i = 0; i < numRow; ++i) {
            NameValuePairTable.TableRow tr = (NameValuePairTable.TableRow)vals.get(i);
            EnumCell ecn = tr.name;
            String checkName = ecn.display.trim();
            if (checkName.equals("")) {
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("nvpEntry.nameCannotBeBlank"), rMan.getString("nvpEntry.errorTitle"), 0);
                return false;
            }
            String normName = DataUtil.normKey(checkName);
            if (otherNames.contains(normName)) {
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("nvpEntry.duplicateName"), rMan.getString("nvpEntry.errorTitle"), 0);
                return false;
            }
            otherNames.add(normName);
        }
        return true;
    }

    private NameValuePairList getResult(List vals) {
        NameValuePairList retval = new NameValuePairList();
        int numRow = vals.size();
        for (int i = 0; i < numRow; ++i) {
            NameValuePairTable.TableRow tr = (NameValuePairTable.TableRow)vals.get(i);
            NameValuePair nvp = new NameValuePair(tr.name.display.trim(), tr.value.display.trim());
            retval.addNameValuePair(nvp);
        }
        return retval;
    }

    class NameValuePairTable
    extends EditableTable.TableModel {
        static final int NAME = 0;
        static final int VALUE = 1;
        private static final int NUM_COL_ = 2;

        NameValuePairTable() {
            super(2);
            this.colNames_ = new String[]{"nvpEntry.name", "nvpEntry.value"};
            this.colClasses_ = new Class[]{class$org$systemsbiology$biotapestry$util$EnumCell == null ? (class$org$systemsbiology$biotapestry$util$EnumCell = NameValuePairTablePanel.class$("org.systemsbiology.biotapestry.util.EnumCell")) : class$org$systemsbiology$biotapestry$util$EnumCell, class$org$systemsbiology$biotapestry$util$EnumCell == null ? (class$org$systemsbiology$biotapestry$util$EnumCell = NameValuePairTablePanel.class$("org.systemsbiology.biotapestry.util.EnumCell")) : class$org$systemsbiology$biotapestry$util$EnumCell};
            this.canEdit_ = new boolean[]{true, true};
        }

        public List getValuesFromTable() {
            ArrayList<TableRow> retval = new ArrayList<TableRow>();
            for (int i = 0; i < this.rowCount_; ++i) {
                TableRow ent = new TableRow(i);
                retval.add(ent);
            }
            return retval;
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            Iterator rit = prsList.iterator();
            while (rit.hasNext()) {
                TableRow ent = (TableRow)rit.next();
                ent.toCols();
            }
        }

        public boolean addRow(int[] rows) {
            super.addRow(rows);
            int lastIndex = this.rowCount_ - 1;
            this.columns_[0].set(lastIndex, new EnumCell("", null, -1, -1));
            this.columns_[1].set(lastIndex, new EnumCell("", null, -1, -1));
            return true;
        }

        class TableRow {
            EnumCell name;
            EnumCell value;

            TableRow() {
            }

            TableRow(int i) {
                this.name = (EnumCell)NameValuePairTable.this.columns_[0].get(i);
                this.value = (EnumCell)NameValuePairTable.this.columns_[1].get(i);
            }

            void toCols() {
                NameValuePairTable.this.columns_[0].add(this.name);
                NameValuePairTable.this.columns_[1].add(this.value);
            }
        }
    }
}

