/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class ReadOnlyTable {
    public static final int UPDATE_NO_SELECT = -1;
    public static final int UPDATE_SELECT_FIRST = 0;
    public static final int NO_BUTTONS = 0;
    public static final int ADD_BUTTON = 1;
    public static final int EDIT_BUTTON = 2;
    public static final int DELETE_BUTTON = 4;
    public static final int ALL_BUTTONS = 7;
    private JTable jt_;
    private JLabel tableLabel_;
    private JScrollPane jsp_;
    private TableModel atm_;
    public int[] selectedRows;
    private SelectionTracker tracker_;
    public List rowElements = new ArrayList();
    private SelectionHandler userSh_;
    private ButtonHandler bh_;
    private JButton tableButtonA_;
    private JButton tableButtonD_;
    private JButton tableButtonE_;
    private boolean trueButtonDEnable_;
    private boolean trueButtonAEnable_;
    private boolean trueButtonEEnable_;
    private boolean identitySort_;
    private List extraButtonProps_;
    private boolean tableSuppressed_;

    public ReadOnlyTable(TableModel atm, SelectionHandler sh) {
        this.atm_ = atm;
        this.userSh_ = sh;
        this.tableSuppressed_ = false;
    }

    public ReadOnlyTable() {
        this.tableSuppressed_ = false;
    }

    public void lateBinding(TableModel atm, SelectionHandler sh) {
        this.atm_ = atm;
        this.userSh_ = sh;
    }

    public void setButtonHandler(ButtonHandler bh) {
        this.bh_ = bh;
    }

    public JTable getTable() {
        return this.jt_;
    }

    public JScrollPane getScrollPane() {
        return this.jsp_;
    }

    public TableModel getModel() {
        return this.atm_;
    }

    public SelectionTracker getTracker() {
        return this.tracker_;
    }

    public void setEnabled(boolean enable) {
        boolean bl = this.tableSuppressed_ = !enable;
        if (this.tableLabel_ != null) {
            this.tableLabel_.setEnabled(enable);
        }
        this.jt_.setEnabled(enable);
        ((DefaultTableCellRenderer)this.jt_.getTableHeader().getDefaultRenderer()).setEnabled(enable);
        ((DefaultTableCellRenderer)this.jt_.getDefaultRenderer(String.class)).setEnabled(enable);
        ((DefaultTableCellRenderer)this.jt_.getDefaultRenderer(Integer.class)).setEnabled(enable);
        if (!enable) {
            if (this.tableButtonA_ != null) {
                this.tableButtonA_.setEnabled(false);
            }
            if (this.tableButtonD_ != null) {
                this.tableButtonD_.setEnabled(false);
            }
            if (this.tableButtonE_ != null) {
                this.tableButtonE_.setEnabled(false);
            }
            if (this.extraButtonProps_ != null) {
                int numEB = this.extraButtonProps_.size();
                for (int i = 0; i < numEB; ++i) {
                    ExtraButton eb = (ExtraButton)this.extraButtonProps_.get(i);
                    eb.extraButton.setEnabled(false);
                }
            }
        } else {
            this.syncButtons();
        }
    }

    public void setButtonEnabledState(int whichButton, boolean enabled) {
        switch (whichButton) {
            case 2: {
                this.trueButtonEEnable_ = enabled;
                break;
            }
            case 1: {
                this.trueButtonAEnable_ = enabled;
                break;
            }
            case 4: {
                this.trueButtonDEnable_ = enabled;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void syncButtons() {
        if (this.tableSuppressed_) {
            return;
        }
        if (this.tableButtonA_ != null) {
            this.tableButtonA_.setEnabled(this.trueButtonAEnable_);
            this.tableButtonA_.revalidate();
        }
        if (this.tableButtonD_ != null) {
            this.tableButtonD_.setEnabled(this.trueButtonDEnable_);
            this.tableButtonD_.revalidate();
        }
        if (this.tableButtonE_ != null) {
            this.tableButtonE_.setEnabled(this.trueButtonEEnable_);
            this.tableButtonE_.revalidate();
        }
        if (this.extraButtonProps_ != null) {
            int numEB = this.extraButtonProps_.size();
            for (int i = 0; i < numEB; ++i) {
                ExtraButton eb = (ExtraButton)this.extraButtonProps_.get(i);
                eb.extraButton.setEnabled(eb.shadowEnabled);
                eb.extraButton.revalidate();
            }
        }
    }

    public void updateTable(boolean fireChange) {
        this.updateTable(fireChange, -1);
    }

    public void updateTable(boolean fireChange, int selRow) {
        this.atm_.extractValues(this.rowElements);
        if (!this.identitySort_) {
            this.atm_.modifyMap(this.atm_.buildFullClickList());
        }
        if (fireChange) {
            this.atm_.fireTableDataChanged();
        }
        if (this.atm_.getRowCount() > 0 && selRow >= 0) {
            int size = this.rowElements.size();
            if (selRow >= size) {
                selRow = size - 1;
            }
            this.jt_.getSelectionModel().setSelectionInterval(selRow, selRow);
        } else {
            this.trueButtonAEnable_ = true;
            this.trueButtonDEnable_ = false;
            this.trueButtonEEnable_ = false;
            if (this.extraButtonProps_ != null) {
                int numEB = this.extraButtonProps_.size();
                for (int i = 0; i < numEB; ++i) {
                    ExtraButton eb = (ExtraButton)this.extraButtonProps_.get(i);
                    eb.shadowEnabled = eb.behavior.alwaysOn;
                }
            }
            this.syncButtons();
            this.clearSelections(true);
        }
    }

    public void clearSelections(boolean trackerIgnore) {
        if (this.tracker_ != null && trackerIgnore) {
            this.tracker_.setIgnore(true);
        }
        this.jt_.getSelectionModel().clearSelection();
        this.selectedRows = null;
        if (this.tracker_ != null && trackerIgnore) {
            this.tracker_.setIgnore(false);
        }
    }

    public void makeCurrentSelectionVisible() {
        this.makeSelectionVisible(this.jt_.getSelectionModel().getMinSelectionIndex());
    }

    public void makeSelectionVisible(int selRow) {
        JViewport viewport = (JViewport)this.jt_.getParent();
        Rectangle rect = this.jt_.getCellRect(selRow, 0, true);
        int numElem = this.rowElements.size();
        Rectangle vRect = viewport.getViewRect();
        if (rect.y + rect.height < vRect.height / 2) {
            rect.setLocation(rect.x - vRect.x, 0);
            viewport.scrollRectToVisible(rect);
            viewport.validate();
        } else if ((numElem - 1 - selRow) * rect.height < vRect.height / 2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JScrollBar jsb = ReadOnlyTable.this.jsp_.getVerticalScrollBar();
                    int max = jsb.getMaximum();
                    int inc = jsb.getUnitIncrement(1);
                    ReadOnlyTable.this.jsp_.getVerticalScrollBar().setValue(max - inc);
                }
            });
        } else {
            double vHeight = vRect.height;
            double halfHeightInRows = vHeight / (double)rect.height / 2.0;
            int padY = (int)(halfHeightInRows * (double)rect.height);
            int useRectY = rect.y - vRect.y - padY;
            rect.setBounds(rect.x - vRect.x, useRectY, rect.width, vRect.height);
            viewport.scrollRectToVisible(rect);
            viewport.validate();
        }
    }

    public JPanel buildReadOnlyTable(TableParams etp) {
        this.jt_ = new JTable(this.atm_);
        JTableHeader th = this.jt_.getTableHeader();
        if (!etp.disableColumnSort) {
            th.addMouseListener(new SortTrigger());
            this.identitySort_ = false;
        } else {
            this.identitySort_ = true;
        }
        th.setReorderingAllowed(false);
        UiUtil.installDefaultCellRendererForPlatform(this.jt_, String.class, false);
        UiUtil.installDefaultCellRendererForPlatform(this.jt_, Integer.class, false);
        ((DefaultTableCellRenderer)this.jt_.getDefaultRenderer(Integer.class)).setHorizontalAlignment(0);
        this.selectedRows = new int[0];
        if (etp.tableIsUnselectable) {
            this.jt_.setRowSelectionAllowed(false);
            if (this.userSh_ != null) {
                throw new IllegalStateException();
            }
        } else {
            ArrayList<ReadOnlyTable> allTables = new ArrayList<ReadOnlyTable>();
            if (etp.multiTableSelectionSyncing == null) {
                allTables.add(this);
            } else {
                allTables.addAll(etp.multiTableSelectionSyncing);
            }
            if (etp.buttons != 0 && !etp.clientHandlesButtonEnable) {
                this.userSh_ = new SelectorForButtons(this.userSh_);
            }
            this.tracker_ = new SelectionTracker(allTables, etp.clearOthersOnSelect, this.userSh_);
            ListSelectionModel lsm = this.jt_.getSelectionModel();
            lsm.setSelectionMode(etp.canMultiSelect ? 2 : 0);
            lsm.addListSelectionListener(this.tracker_);
        }
        UiUtil.platformTableRowHeight(this.jt_, false);
        if (etp.colWidths != null) {
            int numC = etp.colWidths.size();
            TableColumnModel tcm = this.jt_.getColumnModel();
            for (int i = 0; i < numC; ++i) {
                ColumnWidths cw = (ColumnWidths)etp.colWidths.get(i);
                int viewColumn = this.jt_.convertColumnIndexToView(cw.colNum);
                TableColumn tfCol = tcm.getColumn(viewColumn);
                tfCol.setMinWidth(cw.min);
                tfCol.setPreferredWidth(cw.pref);
                tfCol.setMaxWidth(cw.max);
            }
        }
        return etp.buttonsOnSide ? this.buttonsOnSideLayout(etp) : this.buttonsOnBottomLayout(etp);
    }

    private JPanel buttonsOnBottomLayout(TableParams etp) {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        if (etp.tableTitle != null) {
            this.tableLabel_ = new JLabel(etp.tableTitle, 2);
            if (etp.titleFont != null) {
                this.tableLabel_.setFont(etp.titleFont);
            }
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
            retval.add((Component)this.tableLabel_, gbc);
            ++rowNum;
        } else if (etp.tableJLabel != null) {
            this.tableLabel_ = etp.tableJLabel;
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
            retval.add((Component)etp.tableJLabel, gbc);
            ++rowNum;
        }
        int height = etp.tableHeight == 0 ? 5 : etp.tableHeight;
        this.jsp_ = new JScrollPane(this.jt_);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, height, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        retval.add((Component)this.jsp_, gbc);
        rowNum += height;
        if (etp.buttons != 0 || etp.userAddedButtons != null) {
            this.createButtons(etp);
            int buttonCount = 0;
            Box tableButtonPanel = Box.createHorizontalBox();
            tableButtonPanel.add(Box.createHorizontalGlue());
            if ((etp.buttons & 1) != 0) {
                tableButtonPanel.add(this.tableButtonA_);
                ++buttonCount;
            }
            if ((etp.buttons & 4) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonD_);
                ++buttonCount;
            }
            if ((etp.buttons & 2) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonE_);
                ++buttonCount;
            }
            if (etp.userAddedButtons != null) {
                int numUab = etp.userAddedButtons.size();
                for (int i = 0; i < numUab; ++i) {
                    if (buttonCount != 0) {
                        tableButtonPanel.add(Box.createHorizontalStrut(10));
                    }
                    ExtraButton eb = (ExtraButton)etp.userAddedButtons.get(i);
                    tableButtonPanel.add(eb.extraButton);
                    ++buttonCount;
                }
            }
            tableButtonPanel.add(Box.createHorizontalGlue());
            UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            retval.add((Component)tableButtonPanel, gbc);
        }
        return retval;
    }

    private void createButtons(TableParams etp) {
        ResourceManager rMan = ResourceManager.getManager();
        if (etp.buttons != 0) {
            if ((etp.buttons & 1) != 0) {
                String aTag = rMan.getString("dialogs.addEntry");
                this.tableButtonA_ = etp.buttonsOnSide ? new FixedJButton(1, aTag) : new FixedJButton(aTag);
                this.tableButtonA_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            ReadOnlyTable.this.bh_.pressed(1);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.trueButtonAEnable_ = true;
            }
            if ((etp.buttons & 4) != 0) {
                String dTag = rMan.getString("dialogs.deleteEntry");
                this.tableButtonD_ = etp.buttonsOnSide ? new FixedJButton(1, dTag) : new FixedJButton(dTag);
                this.tableButtonD_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            ReadOnlyTable.this.bh_.pressed(4);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.trueButtonDEnable_ = false;
                this.tableButtonD_.setEnabled(false);
            }
            if ((etp.buttons & 2) != 0) {
                String eTag = rMan.getString("dialogs.editEntry");
                this.tableButtonE_ = etp.buttonsOnSide ? new FixedJButton(1, eTag) : new FixedJButton(eTag);
                this.tableButtonE_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            ReadOnlyTable.this.bh_.pressed(2);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.trueButtonEEnable_ = false;
                this.tableButtonE_.setEnabled(false);
            }
            if (etp.userAddedButtons != null) {
                this.extraButtonProps_ = new ArrayList(etp.userAddedButtons);
                int numEB = this.extraButtonProps_.size();
                for (int i = 0; i < numEB; ++i) {
                    ExtraButton eb = (ExtraButton)this.extraButtonProps_.get(i);
                    eb.shadowEnabled = eb.behavior.alwaysOn;
                    eb.extraButton.setEnabled(eb.shadowEnabled);
                }
            }
        }
    }

    public JPanel buttonsOnSideLayout(TableParams etp) {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        boolean gottaButton = etp.buttons != 0 || etp.userAddedButtons != null;
        int rowNum = 0;
        if (etp.tableTitle != null) {
            this.tableLabel_ = new JLabel(etp.tableTitle, 2);
            if (etp.titleFont != null) {
                this.tableLabel_.setFont(etp.titleFont);
            }
            UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
            retval.add((Component)this.tableLabel_, gbc);
            ++rowNum;
        } else if (etp.tableJLabel != null) {
            this.tableLabel_ = etp.tableJLabel;
            UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
            retval.add((Component)etp.tableJLabel, gbc);
            ++rowNum;
        }
        int height = etp.tableHeight == 0 ? 5 : etp.tableHeight;
        int width = gottaButton ? 2 : 3;
        this.jsp_ = new JScrollPane(this.jt_);
        UiUtil.gbcSet(gbc, 0, rowNum, width, height, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        retval.add((Component)this.jsp_, gbc);
        if (gottaButton) {
            this.createButtons(etp);
            int buttonCount = 0;
            JPanel tableButtonPanel = new JPanel();
            tableButtonPanel.setLayout(new GridBagLayout());
            if ((etp.buttons & 1) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonA_, gbc);
            }
            if ((etp.buttons & 4) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonD_, gbc);
            }
            if ((etp.buttons & 2) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonE_, gbc);
            }
            if (etp.userAddedButtons != null) {
                int numUab = etp.userAddedButtons.size();
                for (int i = 0; i < numUab; ++i) {
                    UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                    ExtraButton eb = (ExtraButton)etp.userAddedButtons.get(i);
                    tableButtonPanel.add((Component)eb.extraButton, gbc);
                    ++buttonCount;
                }
            }
            UiUtil.gbcSet(gbc, width, rowNum, 1, height, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 1.0);
            retval.add((Component)tableButtonPanel, gbc);
        }
        return retval;
    }

    public static class NumStrComparator
    implements Comparator {
        private Pattern pattern_ = Pattern.compile("[0-9][0-9]*");
        private Matcher matcher_ = this.pattern_.matcher("");

        public int compare(Object o1, Object o2) {
            String str1 = ((String)o1).trim();
            String str2 = ((String)o2).trim();
            this.matcher_.reset(str1);
            boolean num1 = this.matcher_.matches();
            this.matcher_.reset(str2);
            boolean num2 = this.matcher_.matches();
            if (num1 && num2) {
                int val1 = new Integer(str1);
                int val2 = new Integer(str2);
                return val1 - val2;
            }
            if (num1) {
                return -1;
            }
            if (num2) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }

    public static class DoubleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Double db1 = (Double)o1;
            Double db2 = (Double)o2;
            return db1.compareTo(db2);
        }
    }

    public static class IntegerComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Integer int1 = (Integer)o1;
            Integer int2 = (Integer)o2;
            return int1.compareTo(int2);
        }
    }

    public static class ExtraButton {
        public ExtraButtonBehavior behavior;
        public boolean shadowEnabled;
        public JButton extraButton;

        public ExtraButton(boolean alwaysOn, boolean singleSelectionOn, boolean multiSelectionOn, JButton extraButton) {
            this.behavior = new ExtraButtonBehavior(alwaysOn, singleSelectionOn, multiSelectionOn);
            this.shadowEnabled = false;
            this.extraButton = extraButton;
        }
    }

    public static class ExtraButtonBehavior {
        public boolean alwaysOn;
        public boolean singleSelectionOn;
        public boolean multiSelectionOn;

        public ExtraButtonBehavior(boolean alwaysOn, boolean singleSelectionOn, boolean multiSelectionOn) {
            this.alwaysOn = alwaysOn;
            this.singleSelectionOn = singleSelectionOn;
            this.multiSelectionOn = multiSelectionOn;
        }
    }

    public class SelectorForButtons
    implements SelectionHandler {
        private SelectionHandler mySelector_;

        SelectorForButtons(SelectionHandler mySelector) {
            this.mySelector_ = mySelector;
        }

        public void selected(Object obj, int whichTab, int[] whichIndex) {
            ReadOnlyTable.this.trueButtonDEnable_ = whichIndex.length == 1;
            ReadOnlyTable.this.trueButtonAEnable_ = true;
            ReadOnlyTable.this.trueButtonEEnable_ = whichIndex.length == 1;
            if (ReadOnlyTable.this.extraButtonProps_ != null) {
                int numEB = ReadOnlyTable.this.extraButtonProps_.size();
                for (int j = 0; j < numEB; ++j) {
                    ExtraButton eb = (ExtraButton)ReadOnlyTable.this.extraButtonProps_.get(j);
                    if (eb.behavior.alwaysOn) {
                        eb.shadowEnabled = true;
                        continue;
                    }
                    if (whichIndex.length == 0) {
                        eb.shadowEnabled = false;
                        continue;
                    }
                    if (whichIndex.length == 1) {
                        eb.shadowEnabled = eb.behavior.singleSelectionOn;
                        continue;
                    }
                    if (whichIndex.length <= 1) continue;
                    eb.shadowEnabled = eb.behavior.multiSelectionOn;
                }
            }
            ReadOnlyTable.this.syncButtons();
            if (this.mySelector_ != null) {
                this.mySelector_.selected(obj, whichTab, whichIndex);
            }
        }
    }

    public static class NameWithHiddenIDModel
    extends TableModel {
        public static final int NAME = 0;
        private static final int NUM_COL_ = 1;
        private static final int HIDDEN_NAME_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        public NameWithHiddenIDModel() {
            super(1);
            this.colNames_ = new String[]{"nameTable.name"};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                TrueObjChoiceContent tocc = (TrueObjChoiceContent)iit.next();
                this.columns_[0].add(tocc.name);
                this.hiddenColumns_[0].add(tocc.val);
            }
        }

        public String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }

    public class SortTrigger
    extends MouseAdapter {
        private ArrayList clickList_ = new ArrayList();

        SortTrigger() {
        }

        public void mouseClicked(MouseEvent evt) {
            try {
                int selRow;
                JTable table = ((JTableHeader)evt.getSource()).getTable();
                TableColumnModel colModel = table.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(evt.getX());
                if (vColIndex == -1) {
                    return;
                }
                boolean isCtrl = evt.isControlDown();
                Integer nextElem = new Integer(vColIndex);
                Integer oppoElem = vColIndex == 0 ? new Integer(Integer.MIN_VALUE) : new Integer(-vColIndex);
                int neind = this.clickList_.indexOf(nextElem);
                int oeind = this.clickList_.indexOf(oppoElem);
                if (!isCtrl) {
                    this.clickList_.clear();
                }
                if (neind != -1) {
                    if (!isCtrl) {
                        this.clickList_.add(oppoElem);
                    } else {
                        this.clickList_.set(neind, oppoElem);
                    }
                } else if (oeind != -1) {
                    if (!isCtrl) {
                        this.clickList_.add(nextElem);
                    } else {
                        this.clickList_.set(oeind, nextElem);
                    }
                } else {
                    this.clickList_.add(nextElem);
                }
                Object selCand = null;
                if (ReadOnlyTable.this.selectedRows != null && ReadOnlyTable.this.selectedRows.length > 0) {
                    selRow = ReadOnlyTable.this.atm_.mapSelectionIndex(ReadOnlyTable.this.selectedRows[0]);
                    selCand = ReadOnlyTable.this.rowElements.get(selRow);
                    ReadOnlyTable.this.selectedRows = null;
                    ReadOnlyTable.this.tracker_.setIgnore(true);
                    ReadOnlyTable.this.jt_.getSelectionModel().clearSelection();
                    ReadOnlyTable.this.tracker_.setIgnore(false);
                }
                ReadOnlyTable.this.atm_.modifyMap(this.clickList_);
                ReadOnlyTable.this.atm_.fireTableDataChanged();
                if (selCand != null) {
                    selRow = ReadOnlyTable.this.atm_.mapToSelectionIndex(selCand, ReadOnlyTable.this.rowElements);
                    ReadOnlyTable.this.tracker_.setIgnore(true);
                    ReadOnlyTable.this.jt_.getSelectionModel().setSelectionInterval(selRow, selRow);
                    ReadOnlyTable.this.selectedRows = new int[]{selRow};
                    ReadOnlyTable.this.tracker_.setIgnore(false);
                    JViewport viewport = (JViewport)table.getParent();
                    Rectangle rect = table.getCellRect(selRow, 0, true);
                    Point pt = viewport.getViewPosition();
                    rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                    viewport.scrollRectToVisible(rect);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SelectionTracker
    implements ListSelectionListener {
        private List allTabs_;
        private boolean ignore_;
        private boolean clearOthers_;
        private SelectionHandler handler_;

        SelectionTracker(List allTabs, boolean clearOthers, SelectionHandler handler) {
            this.allTabs_ = allTabs;
            this.ignore_ = false;
            this.clearOthers_ = clearOthers;
            this.handler_ = handler;
        }

        public void valueChanged(ListSelectionEvent lse) {
            try {
                if (this.ignore_) {
                    return;
                }
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                this.handleSelection();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            catch (OutOfMemoryError oom) {
                ExceptionHandler.getHandler().displayOutOfMemory(oom);
            }
        }

        public void setIgnore(boolean ignore) {
            this.ignore_ = ignore;
        }

        private void handleSelection() {
            int matchTab = 0;
            int numTabs = this.allTabs_.size();
            for (int i = 0; i < numTabs; ++i) {
                ReadOnlyTable td = (ReadOnlyTable)this.allTabs_.get(i);
                if (td == ReadOnlyTable.this) {
                    matchTab = i;
                    continue;
                }
                if (!this.clearOthers_) continue;
                td.tracker_.setIgnore(true);
                td.jt_.getSelectionModel().clearSelection();
                td.selectedRows = null;
                td.trueButtonDEnable_ = false;
                td.trueButtonAEnable_ = true;
                td.trueButtonEEnable_ = false;
                if (td.extraButtonProps_ != null) {
                    int numEB = td.extraButtonProps_.size();
                    for (int j = 0; j < numEB; ++j) {
                        ExtraButton eb = (ExtraButton)td.extraButtonProps_.get(j);
                        eb.shadowEnabled = eb.behavior.alwaysOn;
                    }
                }
                td.syncButtons();
                td.tracker_.setIgnore(false);
            }
            ReadOnlyTable.this.selectedRows = ReadOnlyTable.this.jt_.getSelectedRows();
            if (ReadOnlyTable.this.selectedRows.length > 0) {
                ArrayList obj;
                if (ReadOnlyTable.this.selectedRows.length == 1) {
                    int selRow = ReadOnlyTable.this.atm_.mapSelectionIndex(ReadOnlyTable.this.selectedRows[0]);
                    obj = ReadOnlyTable.this.rowElements.get(selRow);
                } else {
                    obj = new ArrayList();
                    for (int i = 0; i < ReadOnlyTable.this.selectedRows.length; ++i) {
                        int selRow = ReadOnlyTable.this.atm_.mapSelectionIndex(ReadOnlyTable.this.selectedRows[i]);
                        obj.add(ReadOnlyTable.this.rowElements.get(selRow));
                    }
                }
                this.handler_.selected(obj, matchTab, ReadOnlyTable.this.selectedRows);
            } else {
                this.handler_.selected(null, matchTab, ReadOnlyTable.this.selectedRows);
            }
        }
    }

    public static class MapBuilder
    implements Comparable {
        private List elements;
        private Integer index;
        private List columnProps;

        public MapBuilder(List elements, int index, List columnProps) {
            this.elements = elements;
            this.index = new Integer(index);
            this.columnProps = columnProps;
        }

        public int compareTo(Object o) {
            int numElemO;
            MapBuilder other = (MapBuilder)o;
            int numElem = this.elements.size();
            if (numElem != (numElemO = other.elements.size())) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < numElem; ++i) {
                Comparable oComp;
                Comparable tComp = (Comparable)this.elements.get(i);
                int compVal = this.compareOneElem(tComp, oComp = (Comparable)other.elements.get(i), (MapBuilderColumnInfo)this.columnProps.get(i));
                if (compVal == 0) continue;
                return compVal;
            }
            return 0;
        }

        private int compareOneElem(Comparable thiso, Comparable othero, MapBuilderColumnInfo mbci) {
            int retval = mbci.compare.compare(thiso, othero);
            if (!mbci.positive) {
                retval = -retval;
            }
            return retval;
        }

        public static List mapFromSort(List toSort) {
            ArrayList<MapBuilder> builders = new ArrayList<MapBuilder>();
            int numLists = toSort.size();
            int colSize = 0;
            ArrayList<MapBuilderColumnInfo> columnProps = new ArrayList<MapBuilderColumnInfo>();
            for (int j = 0; j < numLists; ++j) {
                MapBuilderArg mba = (MapBuilderArg)toSort.get(j);
                columnProps.add(mba.colInfo);
                if (j != 0) continue;
                colSize = mba.elements.size();
            }
            for (int i = 0; i < colSize; ++i) {
                ArrayList rowData = new ArrayList();
                for (int j = 0; j < numLists; ++j) {
                    MapBuilderArg mba = (MapBuilderArg)toSort.get(j);
                    rowData.add(mba.elements.get(i));
                }
                builders.add(new MapBuilder(rowData, i, columnProps));
            }
            Collections.sort(builders);
            ArrayList<Integer> retval = new ArrayList<Integer>();
            for (int i = 0; i < colSize; ++i) {
                retval.add(((MapBuilder)builders.get((int)i)).index);
            }
            return retval;
        }
    }

    public static class MapBuilderArg {
        public List elements;
        public boolean positive;
        public MapBuilderColumnInfo colInfo;

        public MapBuilderArg(List elements, MapBuilderColumnInfo colInfo) {
            this.elements = elements;
            this.colInfo = colInfo;
        }
    }

    public static class MapBuilderColumnInfo {
        public boolean positive;
        public Comparator compare;

        public MapBuilderColumnInfo(boolean positive, Comparator compare) {
            this.positive = positive;
            this.compare = compare;
        }
    }

    public static interface ButtonHandler {
        public void pressed(int var1);
    }

    public static class EmptySelector
    implements SelectionHandler {
        public void selected(Object obj, int whichTab, int[] whichIndex) {
        }
    }

    public static interface SelectionHandler {
        public void selected(Object var1, int var2, int[] var3);
    }

    public static abstract class TableModel
    extends AbstractTableModel {
        protected ArrayList[] columns_;
        protected ArrayList[] hiddenColumns_;
        protected Class[] colClasses_;
        protected Comparator[] comparators_;
        protected List sortMap_;
        protected int rowCount_;
        protected String[] colNames_;

        protected TableModel(int colNum) {
            this.columns_ = new ArrayList[colNum];
            for (int i = 0; i < colNum; ++i) {
                this.columns_[i] = new ArrayList();
            }
            this.sortMap_ = new ArrayList();
            this.hiddenColumns_ = new ArrayList[0];
        }

        protected void addHiddenColumns(int colNum) {
            this.hiddenColumns_ = new ArrayList[colNum];
            for (int i = 0; i < this.hiddenColumns_.length; ++i) {
                this.hiddenColumns_[i] = new ArrayList();
            }
        }

        public void modifyMap(List columns) {
            int num = columns.size();
            ArrayList<MapBuilderArg> args = new ArrayList<MapBuilderArg>();
            for (int i = 0; i < num; ++i) {
                boolean positive;
                Integer colNum = (Integer)columns.get(i);
                int colNumVal = colNum;
                boolean bl = positive = colNumVal >= 0;
                int trueCol = positive ? colNumVal : (colNumVal == Integer.MIN_VALUE ? 0 : -colNumVal);
                List elems = this.getListAt(trueCol);
                Comparator compare = this.getColumnComparator(trueCol);
                MapBuilderColumnInfo colInfo = new MapBuilderColumnInfo(positive, compare);
                MapBuilderArg mba = new MapBuilderArg(elems, colInfo);
                args.add(mba);
            }
            this.sortMap_ = MapBuilder.mapFromSort(args);
        }

        protected List getListAt(int c) {
            try {
                if (c >= this.columns_.length) {
                    throw new IllegalArgumentException();
                }
                return this.columns_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public String getColumnName(int c) {
            try {
                ResourceManager rMan = ResourceManager.getManager();
                if (c >= this.colNames_.length) {
                    throw new IllegalArgumentException();
                }
                return rMan.getString(this.colNames_[c]);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public int getColumnCount() {
            return this.columns_.length;
        }

        public void extractValues(List rowElements) {
            this.sortMap_.clear();
            for (int i = 0; i < this.columns_.length; ++i) {
                this.columns_[i].clear();
            }
            this.rowCount_ = 0;
            Iterator iit = rowElements.iterator();
            while (iit.hasNext()) {
                Object dc = iit.next();
                this.sortMap_.add(new Integer(this.rowCount_));
                ++this.rowCount_;
            }
        }

        public List buildFullClickList() {
            ArrayList<Integer> retval = new ArrayList<Integer>();
            int numCol = this.getColumnCount();
            for (int i = 0; i < numCol; ++i) {
                retval.add(new Integer(i));
            }
            return retval;
        }

        public int mapSelectionIndex(int r) {
            return (Integer)this.sortMap_.get(r);
        }

        public int mapToSelectionIndex(Object obj, List base) {
            int size = base.size();
            for (int i = 0; i < size; ++i) {
                if (obj != base.get(i)) continue;
                int sSize = this.sortMap_.size();
                for (int j = 0; j < sSize; ++j) {
                    Integer sVal = (Integer)this.sortMap_.get(j);
                    if (sVal != i) continue;
                    return j;
                }
            }
            throw new IllegalArgumentException();
        }

        public int mapToSelectionIndexEquals(Object obj, List base) {
            int size = base.size();
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(base.get(i))) continue;
                int sSize = this.sortMap_.size();
                for (int j = 0; j < sSize; ++j) {
                    Integer sVal = (Integer)this.sortMap_.get(j);
                    if (sVal != i) continue;
                    return j;
                }
            }
            throw new IllegalArgumentException();
        }

        public Object getValueAt(int r, int c) {
            try {
                List list = this.getListAt(c);
                return list.get(this.mapSelectionIndex(r));
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public int getRowCount() {
            return this.rowCount_;
        }

        public Class getColumnClass(int c) {
            try {
                if (this.colClasses_ == null) {
                    return class$java$lang$String == null ? (class$java$lang$String = ReadOnlyTable.class$("java.lang.String")) : class$java$lang$String;
                }
                if (c >= this.colClasses_.length) {
                    throw new IllegalArgumentException();
                }
                return this.colClasses_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public Comparator getColumnComparator(int c) {
            try {
                if (this.comparators_ == null) {
                    return String.CASE_INSENSITIVE_ORDER;
                }
                if (c >= this.comparators_.length) {
                    throw new IllegalArgumentException();
                }
                return this.comparators_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        public void setValueAt(Object value, int r, int c) {
            throw new IllegalStateException();
        }

        public boolean isCellEditable(int r, int c) {
            return false;
        }
    }

    public static class ColumnWidths {
        public int colNum;
        public int min;
        public int pref;
        public int max;

        public ColumnWidths() {
        }

        public ColumnWidths(int colNum, int min, int pref, int max) {
            this.colNum = colNum;
            this.min = min;
            this.pref = pref;
            this.max = max;
        }
    }

    public static class TableParams {
        public boolean disableColumnSort;
        public boolean tableIsUnselectable;
        public int buttons;
        public List multiTableSelectionSyncing;
        public boolean clearOthersOnSelect;
        public String tableTitle;
        public JLabel tableJLabel;
        public Font titleFont;
        public List colWidths;
        public int tableHeight;
        public boolean clientHandlesButtonEnable;
        public boolean buttonsOnSide;
        public List userAddedButtons;
        public boolean canMultiSelect;
    }
}

