/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.ui.dialogs.TimeAxisSetupDialog;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class TimeAxisHelper {
    private UndoManager undo_;
    private JFrame parent_;
    private JLabel minFieldLabel_;
    private JLabel maxFieldLabel_;
    private JDialog dialog_;
    private JTextField minField_;
    private JTextField maxField_;
    private boolean enabled_;
    private int minTime_;
    private int maxTime_;

    public TimeAxisHelper(JFrame parent, JDialog dialog, JLabel minFieldLabel, JLabel maxFieldLabel, UndoManager undo) {
        this.undo_ = undo;
        this.parent_ = parent;
        this.minFieldLabel_ = minFieldLabel;
        this.maxFieldLabel_ = maxFieldLabel;
        this.dialog_ = dialog;
    }

    public TimeAxisHelper(JFrame parent, JDialog dialog, UndoManager undo, int minTime, int maxTime) {
        this.undo_ = undo;
        this.parent_ = parent;
        this.dialog_ = dialog;
        this.enabled_ = true;
        this.minTime_ = minTime;
        this.maxTime_ = maxTime;
    }

    public boolean establishTimeAxis() {
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        if (tad.isInitialized()) {
            return true;
        }
        TimeAxisSetupDialog tasd = TimeAxisSetupDialog.timeAxisSetupDialogWrapper((JFrame)this.parent_, (UndoManager)this.undo_);
        tasd.setVisible(true);
        tad = db.getTimeAxisDefinition();
        if (!tad.isInitialized()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("gicreate.noTimeDefinition"), rMan.getString("gicreate.noTimeDefinitionTitle"), 0);
            return false;
        }
        this.fixMinMaxLabels(true);
        return true;
    }

    public void fixMinMaxLabels(boolean doValidate) {
        String maxLabel;
        String minLabel;
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        ResourceManager rMan = ResourceManager.getManager();
        if (!tad.isInitialized()) {
            minLabel = rMan.getString("gicreate.undefinedMin");
            maxLabel = rMan.getString("gicreate.undefinedMax");
        } else {
            String displayUnits = tad.unitDisplayString();
            minLabel = MessageFormat.format(rMan.getString("gicreate.minTimeUnitFormat"), displayUnits);
            maxLabel = MessageFormat.format(rMan.getString("gicreate.maxTimeUnitFormat"), displayUnits);
        }
        this.minFieldLabel_.setText(minLabel);
        this.maxFieldLabel_.setText(maxLabel);
        if (doValidate) {
            this.minFieldLabel_.invalidate();
            this.maxFieldLabel_.invalidate();
            this.dialog_.validate();
        }
    }

    public String timeValToDisplay(int time) {
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            return tad.getNamedStageForIndex((int)time).name;
        }
        return Integer.toString(time);
    }

    public int timeDisplayToIndex(String display) {
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        ResourceManager rMan = ResourceManager.getManager();
        int timeVal = -1;
        if (tad.haveNamedStages()) {
            timeVal = tad.getIndexForNamedStage(display);
            if (timeVal == -1) {
                JOptionPane.showMessageDialog(this.dialog_, rMan.getString("gicreate.badStageName"), rMan.getString("gicreate.badStageNameTitle"), 0);
                return -1;
            }
        } else {
            boolean badNum = false;
            try {
                timeVal = Integer.parseInt(display);
                if (timeVal < 0) {
                    badNum = true;
                }
            }
            catch (NumberFormatException nfex) {
                badNum = true;
            }
            if (badNum) {
                JOptionPane.showMessageDialog(this.dialog_, rMan.getString("gicreate.badNumber"), rMan.getString("gicreate.badNumberTitle"), 0);
                return -1;
            }
        }
        return timeVal;
    }

    public JPanel buildHelperPanel() {
        JPanel retval = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        retval.setLayout(new GridBagLayout());
        this.minFieldLabel_ = new JLabel("");
        this.maxFieldLabel_ = new JLabel("");
        this.fixMinMaxLabels(false);
        this.minField_ = this.enabled_ ? new JTextField(this.timeValToDisplay(this.minTime_)) : new JTextField();
        this.minFieldLabel_.setEnabled(this.enabled_);
        this.minField_.setEnabled(this.enabled_);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        retval.add((Component)this.minFieldLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        retval.add((Component)this.minField_, gbc);
        this.maxField_ = this.enabled_ ? new JTextField(this.timeValToDisplay(this.maxTime_)) : new JTextField();
        this.maxFieldLabel_.setEnabled(this.enabled_);
        this.maxField_.setEnabled(this.enabled_);
        UiUtil.gbcSet(gbc, 2, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        retval.add((Component)this.maxFieldLabel_, gbc);
        UiUtil.gbcSet(gbc, 3, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        retval.add((Component)this.maxField_, gbc);
        return retval;
    }

    public MinMax getSpanResult() {
        int minResult = this.timeDisplayToIndex(this.minField_.getText());
        if (minResult == -1) {
            return null;
        }
        int maxResult = this.timeDisplayToIndex(this.maxField_.getText());
        if (maxResult == -1) {
            return null;
        }
        if (minResult >= maxResult || minResult < 0) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.dialog_, rMan.getString("timeAxisHelper.badBounds"), rMan.getString("timeAxisHelper.badBoundsTitle"), 0);
        }
        return new MinMax(minResult, maxResult);
    }
}

