/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.SelectionNavController;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class UsageSelector {
    private GenomePresentation pre_;
    private ListEntry selected_;
    private JFrame parent_;

    public UsageSelector(JFrame parent, GenomePresentation pre) {
        this.parent_ = parent;
        this.pre_ = pre;
        this.selected_ = null;
    }

    public void setSelected(ListEntry selected) {
        this.selected_ = selected;
    }

    public ListEntry getSelected() {
        return this.selected_;
    }

    public void goToModelAndSelectLink() {
        if (this.selected_ == null || this.selected_.modelID == null) {
            return;
        }
        HashSet<String> links = new HashSet<String>();
        links.add(this.selected_.itemID);
        HashSet nodes = new HashSet();
        int checkProps = 3;
        String dialogQ = "linkUsage.hiding";
        String dialogT = "linkUsage.hidingTitle";
        this.selectGuts(this.selected_.modelID, nodes, links, checkProps, dialogQ, dialogT);
    }

    public void goToModelAndSelectNode() {
        if (this.selected_ == null || this.selected_.modelID == null) {
            return;
        }
        HashSet<String> nodes = new HashSet<String>();
        nodes.add(this.selected_.itemID);
        HashSet links = new HashSet();
        int checkProps = 2;
        String dialogQ = "nodeUsage.hiding";
        String dialogT = "nodeUsage.hidingTitle";
        this.selectGuts(this.selected_.modelID, nodes, links, checkProps, dialogQ, dialogT);
    }

    public boolean goToModelAndSelect(String modelID, Set nodeIDs, Set linkIDs) {
        String dialogQ = "externalSelect.hiding";
        String dialogT = "externalSelect.hidingTitle";
        int checkProps = 2;
        if (!linkIDs.isEmpty()) {
            checkProps |= 1;
        }
        return this.selectGuts(modelID, nodeIDs, linkIDs, checkProps, dialogQ, dialogT);
    }

    private boolean selectGuts(String modelID, Set nodes, Set links, int checkProps, String dialogQ, String dialogT) {
        MainCommands mcmd = MainCommands.getCmds();
        SelectionNavController snc = mcmd.getSelectionNavController();
        Database db = Database.getDB();
        Genome genome = db.getGenome(modelID);
        Layout lo = db.getLayout(new LayoutManager().getLayout(modelID));
        ArrayList linkIntersections = links.isEmpty() ? new ArrayList() : lo.getIntersectionsForLinks(genome, this.pre_.getFontRenderContext(), links, true);
        NetOverlayController noc = mcmd.getOverlayController();
        StartupView suv = noc.getCachedStateForGenome(modelID);
        int obs = NetOverlayController.hasObscuredElements(suv);
        if (!(nodes.isEmpty() && linkIntersections.isEmpty() || (obs & checkProps) == 0)) {
            ResourceManager rMan = ResourceManager.getManager();
            int choice = JOptionPane.showConfirmDialog(this.parent_, rMan.getString(dialogQ), rMan.getString(dialogT), 0);
            if (choice == 1) {
                return false;
            }
            suv = new StartupView(modelID, null, null, null);
        }
        snc.displayModelAndShow(suv, nodes, linkIntersections, this.pre_);
        mcmd.getZoomController().zoomToSelected();
        return true;
    }

    public static class ListEntry {
        public String display;
        public String modelID;
        public String itemID;

        public ListEntry(String display, String modelID, String itemID) {
            this.display = display;
            this.modelID = modelID;
            this.itemID = itemID;
        }

        public String toString() {
            return this.display;
        }
    }
}

