/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NodeRenderBase;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.Vector2D;

public abstract class AbstractRectangleNodeFree
extends NodeRenderBase {
    protected static final double TEXT_PAD_ = 5.0;
    protected static final double HEIGHT_HACK_ = 0.75;
    protected static final double PAD_WIDTH_ = 15.0;
    protected static final double PAD_SPACING_ = 20.0;
    protected static final int MAX_PADS_ = 4;

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        double dy;
        double height;
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, null, np);
        double width = bounds.getWidth();
        double radius = width > (height = bounds.getHeight()) ? width : height;
        double dx = origin.getX() - pt.getX();
        double distsq = dx * dx + (dy = origin.getY() - pt.getY()) * dy;
        if (distsq <= radius * radius) {
            List pads = this.calcPadIntersects(item, layout, frc, pt);
            if (pads != null) {
                return new Intersection(item.getID(), pads);
            }
            if (Bounds.intersects(bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getMaxY(), pt.getX(), pt.getY())) {
                return new Intersection(item.getID(), null, 0.0);
            }
            return null;
        }
        return null;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, null, np);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double minX = origin.getX() - width / 2.0 - 7.5;
        double minY = origin.getY() - height / 2.0 - 7.5;
        Rectangle2D.Double myBounds = new Rectangle2D.Double(minX, minY, width, height);
        Rectangle2D.Double inbounds = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        if (countPartial) {
            Point2D.Double chkPt = new Point2D.Double(minX, minY);
            boolean gotIt = inbounds.contains(chkPt);
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(minX + width, minY);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(minX + width, minY + height);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(minX, minY + height);
                gotIt = inbounds.contains(chkPt);
            }
            if (gotIt) {
                return new Intersection(item.getID(), null, 0.0);
            }
        } else if (inbounds.contains(myBounds)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Vector2D getLandingPadOffset(int padNum, GenomeItem item, int sign, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Node theBox = (Node)item;
        int totalPads = theBox.getPadCount();
        return this.getLandingPadOffsetGuts(padNum, item, sign, frc, origin, totalPads, np);
    }

    private Vector2D getLandingPadOffsetGuts(int padNum, GenomeItem item, int sign, FontRenderContext frc, Point2D origin, int totalPads, NodeProperties np) {
        Rectangle2D bounds = this.boundsWithXtraPadsGuts(item, frc, null, origin, totalPads, np);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double padTweak = this.padTweak(sign);
        double vVal = height / 2.0 + padTweak;
        double hVal = width / 2.0 + padTweak;
        if (padNum < 0) {
            return this.getExtraLandingPadOffset(padNum, vVal, true, 20.0);
        }
        switch (padNum) {
            case 0: {
                return new Vector2D(0.0, -vVal);
            }
            case 1: {
                return new Vector2D(hVal, 0.0);
            }
            case 2: {
                return new Vector2D(0.0, vVal);
            }
            case 3: {
                return new Vector2D(-hVal, 0.0);
            }
        }
        throw new IllegalArgumentException();
    }

    protected double padTweak(int sign) {
        return 0.0;
    }

    protected List calcPadIntersects(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt) {
        return this.calcSharedNamespacePadIntersectSupport(item, layout, frc, pt, 4, 15.0);
    }

    public Vector2D getLaunchPadOffset(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return this.getLandingPadOffset(padNum, item, 0, layout, frc);
    }

    public double getLandingPadWidth(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 15.0;
    }

    public boolean landingPadsCanOverflow() {
        return true;
    }

    public int getFixedLaunchPadMax() {
        return 4;
    }

    public int getFixedLandingPadMax() {
        return 4;
    }

    protected boolean haveExtraPadWidth(GenomeItem item, FontRenderContext frc, NodeProperties np) {
        int extraPerSide;
        double minWidth;
        int defaultPads;
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        String name = item.getName();
        Rectangle2D bounds = mFont.getStringBounds(name, frc);
        double width = bounds.getWidth() + 10.0;
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        return numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType())) && (minWidth = (double)((extraPerSide = (numPads - 4) / 2) + 2) * 20.0) > width;
    }

    protected boolean mightHaveExtraPadWidth(GenomeItem item) {
        int defaultPads;
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        return numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()));
    }

    protected Rectangle2D boundsWithXtraPads(GenomeItem item, Layout layout, FontRenderContext frc, Rectangle2D textBounds, NodeProperties np) {
        Point2D origin = np.getLocation();
        Node theBox = (Node)item;
        int totalPads = theBox.getPadCount();
        return this.boundsWithXtraPadsGuts(item, frc, textBounds, origin, totalPads, np);
    }

    private Rectangle2D boundsWithXtraPadsGuts(GenomeItem item, FontRenderContext frc, Rectangle2D textBounds, Point2D origin, int totalPads, NodeProperties np) {
        int extraPerSide;
        double minWidth;
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        String name = item.getName();
        Rectangle2D bounds = mFont.getStringBounds(name, frc);
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        double width = bounds.getWidth() + 10.0;
        Node theBox = (Node)item;
        int defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType());
        if (totalPads > defaultPads && (minWidth = (double)((extraPerSide = (totalPads - 4) / 2) + 2) * 20.0) > width) {
            width = minWidth;
        }
        double height = bounds.getHeight() * 0.75 + 10.0;
        double minX = origin.getX() - width / 2.0;
        double minY = origin.getY() - height / 2.0;
        return new Rectangle2D.Double(minX, minY, width, height);
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, null, np);
        return new Rectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    public Rectangle2D getBoundsForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int orientation, boolean labelToo, Integer topPadCount) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Node theBox = (Node)item;
        int totalPads = topPadCount == null ? theBox.getPadCount() : topPadCount * 2 + 2;
        return this.boundsWithXtraPadsGuts(item, frc, null, origin, totalPads, np);
    }

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem item, Layout layout, FontRenderContext frc, int orientation, Integer topPadCount) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Node theBox = (Node)item;
        int totalPads = topPadCount == null ? theBox.getPadCount() : topPadCount * 2 + 2;
        return this.getLandingPadOffsetGuts(1, item, 0, frc, origin, totalPads, np);
    }

    public int topPadCount(int fullPadCount) {
        return (fullPadCount + fullPadCount % 2 - 2) / 2;
    }

    public double getGlyphHeightForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, null, np);
        return bounds.getHeight();
    }

    public double getWidth(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, null, np);
        return bounds.getWidth();
    }

    public Rectangle getNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        int defaultPads;
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()))) {
            return this.getExtraPadNonExpansionRegion(genome, item, layout, frc);
        }
        return super.getNonExpansionRegion(genome, item, layout, frc);
    }

    public int comparePads(int padOne, int padTwo) {
        return this.spiralComparePads(padOne, padTwo);
    }

    public double getExtraLength(Node node, Genome genome, int newCount, boolean oneSideOnly) {
        int currPadCount = node.getPadCount();
        if (oneSideOnly) {
            currPadCount /= 2;
        }
        int padDiff = newCount - currPadCount;
        if (oneSideOnly) {
            padDiff += 3;
        }
        double extra = padDiff <= 0 ? 0.0 : 20.0 * (double)padDiff;
        return extra;
    }

    protected Rectangle2D renderSupportA(Graphics2D g2, GenomeItem item, Layout layout, Intersection selected, Rectangle2D textBounds) {
        FontRenderContext frc = g2.getFontRenderContext();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Rectangle2D bounds = this.boundsWithXtraPads(item, layout, frc, textBounds, np);
        String name = item.getName();
        double height = bounds.getHeight() * 0.75;
        this.selectionSupport(g2, selected, (int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        return bounds;
    }

    protected void renderSupportB(Graphics2D g2, GenomeItem item, Layout layout, boolean isGhosted, boolean textGhosted, boolean showBubbles, Font mFont, Point2D origin, Rectangle2D textBounds, Color nodeColor, Color textCol, DisplayOptions dopt) {
        FontRenderContext frc = g2.getFontRenderContext();
        if (showBubbles) {
            this.renderPads(g2, isGhosted ? Color.LIGHT_GRAY : Color.BLACK, item, layout, frc, 4, 15.0);
        }
        String name = item.getName();
        g2.setPaint(textGhosted ? Color.LIGHT_GRAY : textCol);
        g2.setFont(mFont);
        float textX = (float)(origin.getX() - textBounds.getWidth() / 2.0);
        float textY = (float)(origin.getY() + textBounds.getHeight() * 0.75 / 2.0);
        g2.drawString(name, textX, textY);
        Vector2D lpo = this.getLaunchPadOffset(1, item, layout, frc);
        Point2D.Double pieCenter = new Point2D.Double(origin.getX() + lpo.getX() + 15.0, origin.getY() + lpo.getY() - 15.0);
        this.drawVariableActivityPie(g2, item, nodeColor, pieCenter, dopt);
    }
}

