/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NodeRenderBase;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public abstract class AbstractTabletNodeFree
extends NodeRenderBase {
    protected static final double TEXT_PAD_ = 12.0;
    protected static final float PAD_WIDTH_ = 15.0f;
    protected static final double SELECTION_RADIUS_PAD_ = 7.0;
    protected static final double PAD_SPACING_ = 20.0;
    protected static final int MAX_PADS_ = 4;

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        Point2D origin = np.getLocation();
        String name = item.getName();
        double x = origin.getX();
        double y = origin.getY();
        Rectangle2D extraPad = this.extraPadRectangle(item, layout);
        boolean textGhosted = isGhosted;
        if (item instanceof NodeInstance) {
            int activityLevel = ((NodeInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
            textGhosted = isGhosted && activityLevel != 3;
        }
        Color vac = this.getVariableActivityColor(item, np.getColor(), false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Color textCol = this.getVariableActivityColor(item, Color.BLACK, true, dopt);
        this.tabletSelectionSupport(g2, selected, extraPad, origin.getX(), origin.getY(), np);
        FontRenderContext frc = g2.getFontRenderContext();
        if (showBubbles) {
            this.renderPads(g2, isGhosted ? Color.LIGHT_GRAY : Color.BLACK, item, layout, frc, 4, 15.0);
        }
        g2.setPaint(col);
        this.renderGlyph(g2, item, origin, extraPad, np, dopt, isGhosted);
        g2.setPaint(textGhosted ? Color.LIGHT_GRAY : textCol);
        double textX = x + 12.0;
        double textY = y - 12.0;
        if (extraPad != null) {
            if (np.getExtraGrowthDirection() == 1) {
                textX = extraPad.getMaxX() + 12.0;
            } else {
                textY = extraPad.getMinY() - 12.0;
            }
        }
        Point2D textEnd = this.renderText(g2, (float)textX, (float)textY, name, np.getHideName(), mFont, np.getLineBreakDef());
        Point2D.Double pieCenter = new Point2D.Double(textEnd.getX() + 15.0, textEnd.getY());
        this.drawVariableActivityPie(g2, item, np.getColor().equals(Color.WHITE) ? Color.BLACK : col, pieCenter, dopt);
    }

    protected abstract void renderGlyph(Graphics2D var1, GenomeItem var2, Point2D var3, Rectangle2D var4, NodeProperties var5, DisplayOptions var6, boolean var7);

    protected abstract double glyphHalfWidth();

    protected abstract double glyphHalfHeight();

    protected abstract double glyphLineWidth();

    protected abstract double glyphPadWidth();

    protected abstract double glyphPadTweak();

    private TextStats genTextStats(Rectangle2D extraRect, Point2D origin, int extraDir) {
        boolean defaultLength;
        double x = origin.getX();
        double y = origin.getY();
        double halfWidth = this.glyphHalfWidth();
        double halfHeight = this.glyphHalfHeight();
        double maxRadius = Math.max(halfWidth, halfHeight);
        double bigIntersect = maxRadius + 15.0;
        double bigIntersectSq = bigIntersect * bigIntersect;
        TextStats retval = new TextStats();
        retval.extra = extraRect;
        retval.extraDir = extraDir;
        boolean bl = defaultLength = retval.extra == null;
        if (defaultLength) {
            retval.sqRad = bigIntersectSq;
            retval.textPad = 12.0;
            retval.textX = x + 12.0;
            retval.textY = y - 12.0;
        } else if (retval.extraDir == 1) {
            double width = retval.extra.getWidth() / 2.0;
            double rad = (width + halfWidth) * 1.25;
            retval.sqRad = rad * rad;
            retval.textPad = 12.0 + width;
            retval.textX = retval.extra.getMaxX() + 12.0;
            retval.textY = y - 12.0;
        } else {
            double height = retval.extra.getHeight() / 2.0;
            double rad = (height + halfHeight) * 1.25;
            retval.sqRad = rad * rad;
            retval.textPad = 12.0;
            retval.textX = x + 12.0;
            retval.textY = retval.extra.getY() - 12.0;
        }
        return retval;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double x = origin.getX();
        double y = origin.getY();
        double dx = x - pt.getX();
        double dy = y - pt.getY();
        double distsq = dx * dx + dy * dy;
        double halfWidth = this.glyphHalfWidth();
        double halfHeight = this.glyphHalfHeight();
        double maxRadius = Math.max(halfWidth, halfHeight);
        double intersectSq = maxRadius * maxRadius;
        TextStats stats = this.genTextStats(this.extraPadRectangle(item, layout), origin, np.getExtraGrowthDirection());
        String name = item.getName();
        if (name != null && !name.trim().equals("") && this.isTextCandidate(frc, 1, np.getFontOverride(), name, stats.textPad, dx, distsq, np.getLineBreakDef(), false, np.getHideName()) && this.intersectTextLabel(frc, (float)stats.textX, (float)stats.textY, name, pt, np.getHideName(), 1, np.getFontOverride(), np.getLineBreakDef())) {
            return new Intersection(item.getID(), null, 0.0);
        }
        if (distsq > stats.sqRad) {
            return null;
        }
        List pads = this.calcPadIntersects(item, layout, frc, pt);
        if (pads != null) {
            return new Intersection(item.getID(), pads);
        }
        if (stats.extra == null) {
            if (distsq <= intersectSq) {
                return new Intersection(item.getID(), null, Math.sqrt(distsq));
            }
        } else {
            double ldistsq;
            double rdistsq;
            double ptX = pt.getX();
            double ptY = pt.getY();
            if (Bounds.intersects(stats.extra.getX(), stats.extra.getY(), stats.extra.getMaxX(), stats.extra.getMaxY(), ptX, ptY)) {
                return new Intersection(item.getID(), null, 0.0);
            }
            if (stats.extraDir == 1) {
                double rdx = stats.extra.getMaxX() - ptX;
                double rdy = y - ptY;
                rdistsq = rdx * rdx + rdy * rdy;
                double ldx = stats.extra.getX() - ptX;
                ldistsq = ldx * ldx + rdy * rdy;
            } else {
                double tdx = x - ptX;
                double tdy = stats.extra.getY() - ptY;
                rdistsq = tdx * tdx + tdy * tdy;
                double bdy = stats.extra.getMaxY() - ptX;
                ldistsq = tdx * tdx + bdy * bdy;
            }
            if (rdistsq <= intersectSq || ldistsq <= intersectSq) {
                return new Intersection(item.getID(), null, 0.0);
            }
        }
        return null;
    }

    public int topPadCount(int fullPadCount) {
        return (fullPadCount + fullPadCount % 2 - 2) / 2;
    }

    public Rectangle2D getBoundsForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int orientation, boolean labelToo, Integer topPadCount) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Node theBox = (Node)item;
        int type = theBox.getNodeType();
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        int totalPads = topPadCount == null ? theBox.getPadCount() : topPadCount * 2 + 2;
        Rectangle basic = this.getBoundsGuts(1, totalPads, origin, type);
        if (labelToo && !np.getHideName()) {
            Rectangle2D extraRect = this.extraPadRectangleForPads(totalPads, 1, origin, theBox.getNodeType());
            TextStats stats = this.genTextStats(extraRect, origin, 1);
            Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
            String breakDef = np.getLineBreakDef();
            Rectangle2D textRect = this.getTextBounds(frc, (float)stats.textX, (float)stats.textY, item.getName(), false, mFont, breakDef);
            Rectangle fullRect = UiUtil.rectFromRect2D(textRect);
            return fullRect.union(basic);
        }
        return basic;
    }

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem item, Layout layout, FontRenderContext frc, int orientation, Integer topPadCount) {
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Node theBox = (Node)item;
        int totalPads = topPadCount == null ? theBox.getPadCount() : topPadCount * 2 + 2;
        return this.getLandingPadOffsetGuts(1, item, origin, 0, 1, totalPads);
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double cX = origin.getX();
        double cY = origin.getY();
        double halfWidth = this.glyphHalfWidth();
        double halfHeight = this.glyphHalfHeight();
        double maxRadius = Math.max(halfWidth, halfHeight);
        Rectangle2D.Double myBounds = new Rectangle2D.Double(cX - maxRadius, cY - maxRadius, 2.0 * maxRadius, 2.0 * maxRadius);
        Rectangle2D.Double inbounds = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        if (countPartial) {
            Rectangle trueRect = this.getBounds(genome, item, layout, frc, miscInfo);
            double minX = trueRect.x;
            double minY = trueRect.y;
            double maxX = minX + (double)trueRect.width;
            double maxY = minY + (double)trueRect.height;
            Point2D.Double chkPt = new Point2D.Double(minX, minY);
            boolean gotIt = inbounds.contains(chkPt);
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(maxX, minY);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(maxX, maxY);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(minX, maxY);
                gotIt = inbounds.contains(chkPt);
            }
            if (gotIt) {
                return new Intersection(item.getID(), null, 0.0);
            }
        } else if (inbounds.contains(myBounds)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Rectangle getNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        int defaultPads;
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()))) {
            return this.getExtraPadNonExpansionRegion(genome, item, layout, frc);
        }
        return super.getNonExpansionRegion(genome, item, layout, frc);
    }

    public Vector2D getLandingPadOffset(int padNum, GenomeItem item, int sign, Layout layout, FontRenderContext frc) {
        Node theBubble = (Node)item;
        int totalPads = theBubble.getPadCount();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int growthDir = np.getExtraGrowthDirection();
        return this.getLandingPadOffsetGuts(padNum, item, origin, sign, growthDir, totalPads);
    }

    private Vector2D getLandingPadOffsetGuts(int padNum, GenomeItem item, Point2D origin, int sign, int growthDir, int totalPads) {
        double finalOffset;
        float negPosTweak = 0.0f;
        if (sign == -1) {
            negPosTweak = 3.0f;
        } else if (sign == 1) {
            negPosTweak = 4.0f;
        }
        double baseOffsetH = this.glyphHalfWidth() + this.glyphLineWidth() - this.glyphPadTweak();
        double baseOffsetV = this.glyphHalfHeight() + this.glyphLineWidth() - this.glyphPadTweak();
        double finalOffsetH = baseOffsetH + (double)negPosTweak;
        double finalOffsetV = baseOffsetV + (double)negPosTweak;
        boolean horiz = growthDir == 1;
        double d = finalOffset = horiz ? finalOffsetV : finalOffsetH;
        if (padNum < 0) {
            return this.getExtraLandingPadOffset(padNum, finalOffset, horiz, 20.0);
        }
        Rectangle2D extra = this.extraPadRectangleForPads(totalPads, growthDir, origin, ((Node)item).getNodeType());
        double topExtra = 0.0;
        double sideExtra = 0.0;
        if (extra != null) {
            if (horiz) {
                sideExtra = extra.getWidth() / 2.0;
            } else {
                topExtra = extra.getHeight() / 2.0;
            }
            sideExtra = UiUtil.forceToGridValueMax(sideExtra, 10.0);
            topExtra = UiUtil.forceToGridValueMax(topExtra, 10.0);
        }
        switch (padNum) {
            case 0: {
                return new Vector2D(0.0, -finalOffsetV - topExtra);
            }
            case 1: {
                return new Vector2D(finalOffsetH + sideExtra, 0.0);
            }
            case 2: {
                return new Vector2D(0.0, finalOffsetV + topExtra);
            }
            case 3: {
                return new Vector2D(-finalOffsetH - sideExtra, 0.0);
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector2D getLaunchPadOffset(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return this.getLandingPadOffset(padNum, item, 0, layout, frc);
    }

    public double getLandingPadWidth(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return this.glyphPadWidth();
    }

    public int getFixedLaunchPadMax() {
        return 4;
    }

    public int getFixedLandingPadMax() {
        return 4;
    }

    public boolean landingPadsCanOverflow() {
        return true;
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        Node theBubble = (Node)item;
        int totalPads = theBubble.getPadCount();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int growthDir = np.getExtraGrowthDirection();
        return this.getBoundsGuts(growthDir, totalPads, origin, theBubble.getNodeType());
    }

    private Rectangle getBoundsGuts(int growthDirection, int totalPads, Point2D origin, int nodeType) {
        int halfWidth = (int)this.glyphHalfWidth();
        int halfHeight = (int)this.glyphHalfHeight();
        Rectangle2D extra = this.extraPadRectangleForPads(totalPads, growthDirection, origin, nodeType);
        if (extra != null) {
            if (growthDirection == 1) {
                return new Rectangle((int)extra.getX() - halfWidth, (int)extra.getY(), (int)extra.getWidth() + 2 * halfWidth, (int)extra.getHeight());
            }
            return new Rectangle((int)extra.getX(), (int)extra.getY() - halfHeight, (int)extra.getWidth(), (int)extra.getHeight() + 2 * halfHeight);
        }
        int x = (int)origin.getX();
        int y = (int)origin.getY();
        return new Rectangle(x - halfWidth, y - halfHeight, 2 * halfWidth, 2 * halfHeight);
    }

    public double getHeight(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        double retval = this.glyphHalfHeight() * 2.0;
        Rectangle2D extra = this.extraPadRectangle(item, layout);
        if (extra != null) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            if (np.getExtraGrowthDirection() == 1) {
                return retval;
            }
            return retval + extra.getHeight();
        }
        return retval;
    }

    public double getGlyphHeightForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return this.glyphHalfHeight() * 2.0;
    }

    public double getWidth(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        double retval = this.glyphHalfWidth() * 2.0;
        Rectangle2D extra = this.extraPadRectangle(item, layout);
        if (extra != null) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            if (np.getExtraGrowthDirection() == 1) {
                return retval + extra.getWidth();
            }
            return retval;
        }
        return retval;
    }

    public int comparePads(int padOne, int padTwo) {
        return this.spiralComparePads(padOne, padTwo);
    }

    public double getExtraLength(Node node, Genome genome, int newCount, boolean oneSideOnly) {
        int currPadCount = node.getPadCount();
        if (oneSideOnly) {
            currPadCount /= 2;
        }
        int padDiff = newCount - currPadCount;
        if (oneSideOnly) {
            padDiff += 3;
        }
        double extra = padDiff <= 0 ? 0.0 : 20.0 * (double)padDiff;
        return extra;
    }

    protected List calcPadIntersects(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt) {
        return this.calcSharedNamespacePadIntersectSupport(item, layout, frc, pt, 4, 15.0);
    }

    protected void tabletSelectionSupport(Graphics2D g2, Intersection selected, Rectangle2D extraPad, double x, double y, NodeProperties np) {
        Rectangle2D.Double selectedBounds;
        Arc2D.Double arc2;
        Arc2D.Double arc1;
        if (selected == null) {
            return;
        }
        double halfWidth = this.glyphHalfWidth();
        double halfHeight = this.glyphHalfHeight();
        double maxRadius = Math.max(halfWidth, halfHeight);
        double bigRadius = maxRadius + 7.0;
        if (extraPad == null) {
            g2.setPaint(Color.orange);
            Ellipse2D.Double circ = new Ellipse2D.Double(x - bigRadius, y - bigRadius, 2.0 * bigRadius, 2.0 * bigRadius);
            g2.fill(circ);
            return;
        }
        int growthDir = np.getExtraGrowthDirection();
        if (growthDir == 1) {
            x = extraPad.getX();
            y = extraPad.getY();
            arc1 = new Arc2D.Double(x - bigRadius, y - 7.0, 2.0 * bigRadius, 2.0 * bigRadius, 90.0, 180.0, 0);
            arc2 = new Arc2D.Double((x += extraPad.getWidth()) - bigRadius, y - 7.0, 2.0 * bigRadius, 2.0 * bigRadius, 270.0, 180.0, 0);
            selectedBounds = new Rectangle2D.Double(extraPad.getX(), extraPad.getY() - 7.0, extraPad.getWidth(), extraPad.getHeight() + 14.0);
        } else {
            x = extraPad.getX();
            y = extraPad.getY();
            arc1 = new Arc2D.Double(x - 7.0, y - bigRadius, 2.0 * bigRadius, 2.0 * bigRadius, 0.0, 180.0, 0);
            arc2 = new Arc2D.Double(x - 7.0, (y += extraPad.getHeight()) - bigRadius, 2.0 * bigRadius, 2.0 * bigRadius, 180.0, 180.0, 0);
            selectedBounds = new Rectangle2D.Double(extraPad.getX() - 7.0, extraPad.getY(), extraPad.getWidth() + 14.0, extraPad.getHeight());
        }
        g2.setPaint(Color.orange);
        g2.fill(arc1);
        g2.fill(arc2);
        g2.fill(selectedBounds);
    }

    protected Rectangle2D extraPadRectangle(GenomeItem item, Layout layout) {
        Node theBubble = (Node)item;
        int totalPads = theBubble.getPadCount();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int growthDir = np.getExtraGrowthDirection();
        return this.extraPadRectangleForPads(totalPads, growthDir, origin, theBubble.getNodeType());
    }

    private Rectangle2D extraPadRectangleForPads(int numPads, int growthDir, Point2D origin, int nodeType) {
        int defaultPads = DBNode.getDefaultPadCount(nodeType);
        if (numPads <= defaultPads) {
            return null;
        }
        int extraPerSide = (numPads - 4) / 2;
        double extraSize = (double)extraPerSide * 20.0;
        if (growthDir == 1) {
            double height = 2.0 * this.glyphHalfHeight();
            double minX = origin.getX() - extraSize / 2.0;
            double minY = origin.getY() - this.glyphHalfHeight();
            return new Rectangle2D.Double(minX, minY, extraSize, height);
        }
        double width = 2.0 * this.glyphHalfWidth();
        double minX = origin.getX() - this.glyphHalfWidth();
        double minY = origin.getY() - extraSize / 2.0;
        return new Rectangle2D.Double(minX, minY, width, extraSize);
    }

    private static class TextStats {
        double sqRad;
        double textPad;
        double textX;
        double textY;
        Rectangle2D extra;
        int extraDir;

        private TextStats() {
        }
    }
}

