/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.AbstractRectangleNodeFree;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class BareNodeFree
extends AbstractRectangleNodeFree {
    private static final Color backupCol = new Color(230, 230, 230);

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        if (item instanceof NodeInstance) {
            int activityLevel = ((NodeInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
        }
        Color vac = this.getVariableActivityColor(item, np.getColor(), false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        Rectangle2D bounds = this.renderSupportA(g2, item, layout, selected, textBounds);
        if (this.mightHaveExtraPadWidth(item) && this.haveExtraPadWidth(item, g2.getFontRenderContext(), np)) {
            g2.setPaint(backupCol);
            g2.fill(bounds);
        }
        this.renderSupportB(g2, item, layout, isGhosted, isGhosted, showBubbles, mFont, origin, textBounds, col, col, dopt);
    }

    public void renderToPlacementGrid(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Map targetCounts, Map minPads, int strictness) {
        if (strictness == 1 || strictness == 0) {
            super.renderToPlacementGrid(genome, item, layout, frc, grid, targetCounts, minPads, strictness);
            return;
        }
        HashSet<Integer> usedPads = new HashSet<Integer>();
        String myID = item.getID();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String src;
            Linkage link = (Linkage)lit.next();
            String targ = link.getTarget();
            if (targ.equals(myID)) {
                int pad = link.getLandingPad();
                usedPads.add(new Integer(pad));
            }
            if (!(src = link.getSource()).equals(myID)) continue;
            int pad = link.getLaunchPad();
            usedPads.add(new Integer(pad));
        }
        if (usedPads.isEmpty()) {
            return;
        }
        Rectangle rect = this.getBounds(genome, item, layout, frc, null);
        Point2D.Double forcedUL = new Point2D.Double();
        UiUtil.forceToGrid(rect.x, rect.y, forcedUL, 10.0);
        Point2D.Double forcedLR = new Point2D.Double();
        UiUtil.forceToGrid(rect.x + rect.width, rect.y + rect.height, forcedLR, 10.0);
        Pattern pat = new Pattern(((int)(((Point2D)forcedLR).getX() - ((Point2D)forcedUL).getX()) + 30) / 10, ((int)(((Point2D)forcedLR).getY() - ((Point2D)forcedUL).getY()) + 30) / 10);
        int padCenterX = pat.getWidth() / 2;
        int padCenterY = pat.getHeight() / 2;
        Iterator pit = usedPads.iterator();
        while (pit.hasNext()) {
            Integer pad = (Integer)pit.next();
            Vector2D offset = this.getLandingPadOffset(pad, item, 1, layout, frc);
            int xval = (int)UiUtil.forceToGridValue(offset.getX(), 10.0) / 10;
            int yval = (int)UiUtil.forceToGridValue(offset.getY(), 10.0) / 10;
            pat.fill(padCenterX + xval, padCenterY + yval, item.getID());
        }
        grid.addNode(pat, null, item.getID(), ((int)((Point2D)forcedUL).getX() - 10) / 10, ((int)((Point2D)forcedUL).getY() - 10) / 10, strictness);
    }
}

