/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.AbstractRectangleNodeFree;

public class BoxNodeFree
extends AbstractRectangleNodeFree {
    private static final int BOX_LINE_ = 4;

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        NodeProperties np = layout.getNodeProperties(item.getID());
        boolean textGhosted = isGhosted;
        if (item instanceof NodeInstance) {
            int activityLevel = ((NodeInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
            textGhosted = isGhosted && activityLevel != 3;
        }
        Color vac = this.getVariableActivityColor(item, np.getColor(), false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Color textCol = this.getVariableActivityColor(item, Color.BLACK, true, dopt);
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        Point2D origin = np.getLocation();
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        Rectangle2D bounds = this.renderSupportA(g2, item, layout, selected, textBounds);
        g2.setStroke(new BasicStroke(4.0f));
        g2.setPaint(col);
        g2.draw(bounds);
        this.renderSupportB(g2, item, layout, isGhosted, textGhosted, showBubbles, mFont, origin, textBounds, col, textCol, dopt);
    }

    protected double padTweak(int sign) {
        float negPosTweak = 0.0f;
        if (sign == -1) {
            negPosTweak = 3.0f;
        } else if (sign == 1) {
            negPosTweak = 4.0f;
        }
        return 2.0 + (double)negPosTweak;
    }
}

