/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.AbstractTabletNodeFree;

public class BubbleNodeFree
extends AbstractTabletNodeFree {
    private static final double BUBBLE_RADIUS_ = 8.0;
    private static final double BUBBLE_DIAM_ = 16.0;
    private static final double LINE_WIDTH_ = 2.0;

    protected void renderGlyph(Graphics2D g2, GenomeItem item, Point2D origin, Rectangle2D extraPad, NodeProperties np, DisplayOptions dopt, boolean isGhosted) {
        Line2D.Double line2;
        Line2D.Double line1;
        Arc2D.Double arc2;
        Arc2D.Double arc1;
        double x = origin.getX();
        double y = origin.getY();
        if (extraPad == null) {
            Ellipse2D.Double circ = new Ellipse2D.Double(x - 8.0, y - 8.0, 16.0, 16.0);
            g2.fill(circ);
            g2.setStroke(new BasicStroke(2.0f));
            Color vac = this.getVariableActivityColor(item, Color.BLACK, false, dopt);
            g2.setPaint(isGhosted ? Color.LIGHT_GRAY : vac);
            g2.draw(circ);
            return;
        }
        int growthDir = np.getExtraGrowthDirection();
        if (growthDir == 1) {
            x = extraPad.getX();
            y = extraPad.getY();
            arc1 = new Arc2D.Double(x - 8.0, y, 16.0, 16.0, 90.0, 180.0, 0);
            arc2 = new Arc2D.Double((x += extraPad.getWidth()) - 8.0, y, 16.0, 16.0, 270.0, 180.0, 0);
            double x1 = extraPad.getX();
            double x2 = x1 + extraPad.getWidth();
            line1 = new Line2D.Double(x1, y, x2, y);
            line2 = new Line2D.Double(x2, y += extraPad.getHeight(), x1, y);
        } else {
            x = extraPad.getX();
            y = extraPad.getY();
            arc1 = new Arc2D.Double(x, y - 8.0, 16.0, 16.0, 0.0, 180.0, 0);
            arc2 = new Arc2D.Double(x, (y += extraPad.getHeight()) - 8.0, 16.0, 16.0, 180.0, 180.0, 0);
            double y1 = extraPad.getY();
            double y2 = y1 + extraPad.getHeight();
            line1 = new Line2D.Double(x, y1, x, y2);
            line2 = new Line2D.Double(x += extraPad.getWidth(), y2, x, y1);
        }
        g2.fill(arc1);
        g2.fill(arc2);
        g2.fill(extraPad);
        g2.setStroke(new BasicStroke(2.0f));
        Color vac = this.getVariableActivityColor(item, Color.BLACK, false, dopt);
        g2.setPaint(isGhosted ? Color.LIGHT_GRAY : vac);
        g2.draw(arc1);
        g2.draw(line1);
        g2.draw(arc2);
        g2.draw(line2);
    }

    protected double glyphHalfWidth() {
        return 8.0;
    }

    protected double glyphHalfHeight() {
        return 8.0;
    }

    protected double glyphLineWidth() {
        return 2.0;
    }

    protected double glyphPadWidth() {
        return 18.0;
    }

    protected double glyphPadTweak() {
        return 1.0;
    }
}

