/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.AbstractTabletNodeFree;

public class DiamondNodeFree
extends AbstractTabletNodeFree {
    private static final double LINE_WIDTH_ = 3.0;
    private static final float DIAMOND_HALF_HEIGHT_ = 20.0f;
    private static final float DIAMOND_HALF_WIDTH_ = 15.0f;

    protected void renderGlyph(Graphics2D g2, GenomeItem item, Point2D origin, Rectangle2D extraPad, NodeProperties np, DisplayOptions dopt, boolean isGhosted) {
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        GeneralPath path = new GeneralPath();
        if (extraPad == null) {
            path.moveTo(x, y - 20.0f);
            path.lineTo(x + 15.0f, y);
            path.lineTo(x, y + 20.0f);
            path.lineTo(x - 15.0f, y);
            path.closePath();
        } else {
            int growthDir = np.getExtraGrowthDirection();
            float epX = (float)extraPad.getX();
            float epY = (float)extraPad.getY();
            float epMX = (float)extraPad.getMaxX();
            float epMY = (float)extraPad.getMaxY();
            if (growthDir == 1) {
                path.moveTo(epX, epY);
                path.lineTo(epMX, epY);
                path.lineTo(epMX + 15.0f, y);
                path.lineTo(epMX, epMY);
                path.lineTo(epX, epMY);
                path.lineTo(epX - 15.0f, y);
                path.closePath();
            } else {
                path.moveTo(x, epY - 20.0f);
                path.lineTo(epMX, epY);
                path.lineTo(epMX, epMY);
                path.lineTo(x, epMY + 20.0f);
                path.lineTo(epX, epMY);
                path.lineTo(epX, epY);
                path.closePath();
            }
        }
        g2.fill(path);
        g2.setStroke(new BasicStroke(3.0f, 1, 0));
        Color lineCol = this.getVariableActivityColor(item, Color.BLACK, false, dopt);
        g2.setPaint(isGhosted ? Color.LIGHT_GRAY : lineCol);
        g2.draw(path);
    }

    protected double glyphHalfWidth() {
        return 15.0;
    }

    protected double glyphHalfHeight() {
        return 20.0;
    }

    protected double glyphLineWidth() {
        return 3.0;
    }

    protected double glyphPadWidth() {
        return 15.0;
    }

    protected double glyphPadTweak() {
        return 1.0;
    }
}

