/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.ResolvedDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.ui.freerender.DrawTreeModelDataSource;
import org.systemsbiology.biotapestry.ui.freerender.DrawTreeSegment;
import org.systemsbiology.biotapestry.ui.freerender.EvidenceGlyph;
import org.systemsbiology.biotapestry.ui.freerender.MultiSubID;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class DrawTree {
    private static final int REG_THICK = 3;
    private static final float THIN_DASH = 4.0f;
    private static final float THIN_DASH_SP = 6.0f;
    private static final float THICK_DASH = 10.0f;
    private static final float THICK_DASH_SP = 6.0f;
    private static final int SELECTED_THICK = 5;
    private static final int SELECTED_DELTA = 2;
    private static final float PAD_RADIUS_ = 5.0f;
    private static final float BB_RADIUS_ = 5.0f;
    static final Integer INACTIVE_PATH_LAYER = new Integer(0);
    static final Integer ACTIVE_PATH_LAYER = new Integer(1);
    private static final Integer MINOR_SELECTED_LAYER_ = new Integer(0);
    private static final Integer MINOR_NORMAL_LAYER_ = new Integer(1);
    private static final Integer MINOR_BRANCH_LAYER_ = new Integer(2);
    private static final Integer MINOR_BUBBLE_LAYER_ = new Integer(3);
    private static final Integer MINOR_PAD_LAYER_ = new Integer(4);
    private static final Integer MINOR_TARGET_LABEL_LAYER_ = new Integer(5);
    static final Integer MINOR_TEXT_LAYER = new Integer(6);
    private HashMap segments_ = new HashMap();
    private HashMap startForLink_ = new HashMap();
    private OverlayStateOracle oso_;

    public DrawTree(Genome genome, LinkProperties bp, DrawTreeModelDataSource mds, Layout layout, FontRenderContext frc, Intersection selected, DisplayOptions dOpt, OverlayStateOracle oso) {
        this.oso_ = oso;
        DrawTreeModelDataSource.ModelLineStyleModulation lsMod = mds.getModelLineStyleModulation(genome, dOpt);
        Iterator dit = bp.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String linkID = drop.getTargetRef();
            PerLinkDrawStyle perLink = drop.getDrawStyleForLink();
            DrawTreeModelDataSource.LinkLineStyleModulation llsm = mds.getLinkLineStyleModulation(genome, dOpt, linkID, bp, this.oso_, lsMod);
            if (llsm == null) continue;
            DrawTreeSegment lastDts = null;
            List toRoot = bp.getSegmentIDsToRootForEndDrop(drop);
            int numToRoot = toRoot.size();
            for (int i = 0; i < numToRoot; ++i) {
                LinkSegmentID segID = (LinkSegmentID)toRoot.get(i);
                DrawTreeSegment dts = (DrawTreeSegment)this.segments_.get(segID);
                if (dts == null) {
                    LinkSegment geomSeg = bp.getSegmentGeometryForID(segID, genome, layout, frc, false);
                    if (segID.isDirectOrEndDrop()) {
                        this.tweakTargetDropPath(geomSeg, llsm);
                    }
                    SuggestedDrawStyle drawStyle = bp.getDrawStyleForID(segID);
                    dts = new DrawTreeSegment(segID, geomSeg, drawStyle);
                    this.tagIfSelected(dts, segID, selected);
                    this.segments_.put(segID, dts);
                }
                if (lastDts != null) {
                    if (lastDts.getParent() == null) {
                        lastDts.setParent(segID);
                        dts.addChild();
                    }
                } else {
                    this.startForLink_.put(linkID, segID);
                }
                dts.incrementPathCount();
                if (llsm.isActive) {
                    dts.setActive();
                }
                if (perLink != null || llsm.perLinkForEvidence != null || llsm.perLinkActivity != null) {
                    dts.addPerLinkProps(perLink, linkID, llsm.perLinkForEvidence, llsm.perLinkActivity);
                }
                lastDts = dts;
            }
        }
        this.registerActiveKids();
    }

    public void renderToCache(RenderObjectCache cache, Genome genome, DrawTreeModelDataSource mds, Layout layout, FontRenderContext frc, LinkProperties lp, boolean isGhosted, boolean showBubbles, Set skipDrops, DisplayOptions dOpt, Rectangle2D clipRect, double pixDiam) {
        if (this.startForLink_.isEmpty()) {
            return;
        }
        BasicStroke branchStroke = new BasicStroke(1.0f);
        BasicStroke padStroke = new BasicStroke(1.0f);
        Color basePadCol = isGhosted ? Color.LIGHT_GRAY : Color.BLACK;
        Color padCol = this.applyAlphaToColor(basePadCol, this.oso_);
        GeneralPath currPath = new GeneralPath();
        DrawTreeSegment lastDts = null;
        FlipStatus flipStat = null;
        boolean haveSelection = false;
        HashMap<Integer, GeneralPath> selectPaths = new HashMap<Integer, GeneralPath>();
        HashMap<Integer, BasicStroke> selectStrokes = new HashMap<Integer, BasicStroke>();
        DrawTreeModelDataSource.ModelLineStyleModulation lsMod = mds.getModelLineStyleModulation(genome, dOpt);
        HashMap kiddies = new HashMap();
        LinkSegmentID rootSegID = this.resolveDrawStyles(lp, isGhosted, kiddies, lsMod.linkModulation, lsMod.forModules);
        this.clearTags();
        DrawTreeSegment rootDts = (DrawTreeSegment)this.segments_.get(rootSegID);
        ArrayList activeDrawOrder = new ArrayList();
        ArrayList inactiveDrawOrder = new ArrayList();
        this.orderForDrawing(this.segments_, kiddies, rootSegID, activeDrawOrder, inactiveDrawOrder, rootDts.isActive());
        ArrayList combined = new ArrayList(inactiveDrawOrder);
        combined.addAll(activeDrawOrder);
        int numDo = combined.size();
        for (int i = numDo - 1; i >= 0; --i) {
            DrawTreeSegment currDts;
            String linkID = (String)combined.get(i);
            LinkSegmentID lsid = (LinkSegmentID)this.startForLink_.get(linkID);
            DrawTreeModelDataSource.LinkLineStyleModulation llsm = mds.getLinkLineStyleModulation(genome, dOpt, linkID, lp, this.oso_, lsMod);
            boolean isDrop = true;
            boolean skipDrop = skipDrops != null && skipDrops.contains(linkID);
            lastDts = null;
            while (lsid != null && (currDts = (DrawTreeSegment)this.segments_.get(lsid)).getWhoDraws().equals(linkID)) {
                lsid = currDts.getParent();
                flipStat = this.pathFlipper(cache, isGhosted, currDts, lastDts, flipStat);
                Point2D strt = currDts.getStart();
                Point2D end = currDts.getEnd();
                currPath = flipStat.currPath;
                switch (flipStat.flipStatus) {
                    case 0: {
                        currPath.moveTo((float)end.getX(), (float)end.getY());
                        if (skipDrop && isDrop) {
                            currPath.moveTo((float)strt.getX(), (float)strt.getY());
                            break;
                        }
                        currPath.lineTo((float)strt.getX(), (float)strt.getY());
                        break;
                    }
                    case 1: {
                        currPath.moveTo((float)end.getX(), (float)end.getY());
                        if (skipDrop && isDrop) {
                            currPath.moveTo((float)strt.getX(), (float)strt.getY());
                            break;
                        }
                        currPath.lineTo((float)strt.getX(), (float)strt.getY());
                        break;
                    }
                    case 2: {
                        if (skipDrop && isDrop) {
                            currPath.moveTo((float)strt.getX(), (float)strt.getY());
                            break;
                        }
                        currPath.lineTo((float)strt.getX(), (float)strt.getY());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (currDts.isSelected()) {
                    int thick = flipStat.styleUsed.getThickness();
                    Integer thickObj = new Integer(thick);
                    GeneralPath selectionPath = (GeneralPath)selectPaths.get(thickObj);
                    if (selectionPath == null) {
                        selectionPath = new GeneralPath();
                        selectPaths.put(thickObj, selectionPath);
                        int selThick = thick + 2;
                        if (selThick < 5) {
                            selThick = 5;
                        }
                        BasicStroke selectedStroke = new BasicStroke(selThick, 0, 1);
                        selectStrokes.put(thickObj, selectedStroke);
                    }
                    haveSelection = true;
                    selectionPath.moveTo((float)strt.getX(), (float)strt.getY());
                    selectionPath.lineTo((float)end.getX(), (float)end.getY());
                }
                if (isDrop) {
                    if (!skipDrop) {
                        this.renderTipToCache(cache, genome, mds, layout, frc, currDts, linkID, lp, llsm, isGhosted, dOpt, lsMod.forModules);
                    }
                    isDrop = false;
                } else {
                    if (lsMod.branchRenderMode != 0 && currDts.needsBranchPoint()) {
                        Color baseCol = flipStat.styleUsed.getColor();
                        Color useCol = this.applyAlphaToColor(baseCol, this.oso_);
                        this.drawABusBranch(cache, end, useCol, padCol, lsMod.branchRenderMode, branchStroke, currDts.isActive());
                    }
                    if (showBubbles && !isDrop) {
                        this.drawAPad(cache, end, padCol, padStroke, currDts.isActive(), pixDiam);
                    }
                }
                currDts.setTag();
                lastDts = currDts;
            }
        }
        if (haveSelection) {
            Iterator spkit = selectPaths.keySet().iterator();
            while (spkit.hasNext()) {
                Integer thickObj = (Integer)spkit.next();
                GeneralPath selectionPath = (GeneralPath)selectPaths.get(thickObj);
                BasicStroke selectedStroke = (BasicStroke)selectStrokes.get(thickObj);
                RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(0, Color.red, selectedStroke, selectionPath);
                cache.addObject(ms, MINOR_SELECTED_LAYER_, MINOR_NORMAL_LAYER_);
            }
        }
        if (flipStat != null) {
            this.flushPath(cache, flipStat);
        }
    }

    private void clearTags() {
        Iterator vit = this.segments_.values().iterator();
        while (vit.hasNext()) {
            DrawTreeSegment dts = (DrawTreeSegment)vit.next();
            dts.clearTag();
        }
    }

    private void registerActiveKids() {
        Iterator vit = this.segments_.values().iterator();
        while (vit.hasNext()) {
            LinkSegmentID segID;
            DrawTreeSegment dts = (DrawTreeSegment)vit.next();
            if (!dts.isActive() || (segID = dts.getParent()) == null) continue;
            DrawTreeSegment pdts = (DrawTreeSegment)this.segments_.get(segID);
            pdts.addActiveChild();
        }
    }

    private LinkSegmentID resolveDrawStyles(LinkProperties lp, boolean isGhosted, Map kiddies, int activityDrawChange, boolean forModules) {
        LinkSegmentID retval = null;
        this.clearTags();
        Iterator kit = this.startForLink_.keySet().iterator();
        block0: while (kit.hasNext()) {
            String linkID = (String)kit.next();
            LinkSegmentID lsid = (LinkSegmentID)this.startForLink_.get(linkID);
            DrawTreeSegment lastDts = null;
            while (lsid != null) {
                DrawTreeSegment currDts = (DrawTreeSegment)this.segments_.get(lsid);
                LinkSegmentID currID = currDts.getID();
                if (lastDts != null) {
                    ArrayList<LinkSegmentID> kids = (ArrayList<LinkSegmentID>)kiddies.get(currID);
                    if (kids == null) {
                        kids = new ArrayList<LinkSegmentID>();
                        kiddies.put(currID, kids);
                    }
                    kids.add(lastDts.getID());
                }
                if (currDts.isDrawn()) continue block0;
                lsid = currDts.getParent();
                currDts.setResolvedStyle(currDts.resolveDrawStyle(lp, isGhosted, activityDrawChange, forModules));
                currDts.setTag();
                lastDts = currDts;
                if (lsid != null) continue;
                retval = currID;
            }
        }
        if (retval == null) {
            throw new IllegalStateException();
        }
        return retval;
    }

    private String orderForDrawing(Map segments, Map kiddies, LinkSegmentID currSegID, List activeDrawList, List inactiveDrawList, boolean doingActives) {
        int matchKey = Integer.MIN_VALUE;
        int colorMatchKey = matchKey + 1;
        DrawTreeSegment dts = (DrawTreeSegment)segments.get(currSegID);
        ResolvedDrawStyle currRds = dts.getResolvedStyle();
        Color currColor = currRds.getColor();
        List kids = (List)kiddies.get(currSegID);
        if (kids == null) {
            String linkID = currSegID.isDirect() ? currSegID.getDirectLinkRef() : currSegID.getEndDropLinkRef();
            List useList = doingActives ? activeDrawList : inactiveDrawList;
            useList.add(linkID);
            dts.setWhoDraws(linkID);
            return linkID;
        }
        int numKids = kids.size();
        TreeMap<Integer, ArrayList<LinkSegmentID>> drawOrder = new TreeMap<Integer, ArrayList<LinkSegmentID>>();
        for (int i = 0; i < numKids; ++i) {
            LinkSegmentID doSegID = (LinkSegmentID)kids.get(i);
            DrawTreeSegment kidDts = (DrawTreeSegment)segments.get(doSegID);
            ResolvedDrawStyle rds = kidDts.getResolvedStyle();
            int keyVal = currRds.equals(rds) ? matchKey : (currColor.equals(rds.getColor()) ? colorMatchKey : -1 * rds.getThickness());
            Integer key = new Integer(keyVal);
            ArrayList<LinkSegmentID> kidsForKey = (ArrayList<LinkSegmentID>)drawOrder.get(key);
            if (kidsForKey == null) {
                kidsForKey = new ArrayList<LinkSegmentID>();
                drawOrder.put(key, kidsForKey);
            }
            kidsForKey.add(doSegID);
        }
        String retval = null;
        Iterator doit = drawOrder.values().iterator();
        while (doit.hasNext()) {
            ArrayList toDo = (ArrayList)doit.next();
            int numtoDo = toDo.size();
            for (int i = 0; i < numtoDo; ++i) {
                LinkSegmentID doSegID = (LinkSegmentID)toDo.get(i);
                DrawTreeSegment kidDts = (DrawTreeSegment)segments.get(doSegID);
                boolean kidIsActive = kidDts.isActive();
                String firstLink = this.orderForDrawing(segments, kiddies, doSegID, activeDrawList, inactiveDrawList, kidIsActive);
                if (dts.getWhoDraws() != null) continue;
                dts.setWhoDraws(firstLink);
                retval = firstLink;
            }
        }
        return retval;
    }

    private FlipStatus pathFlipper(RenderObjectCache cache, boolean isGhosted, DrawTreeSegment currDts, DrawTreeSegment lastDts, FlipStatus lastStat) {
        Integer pathLayer;
        ResolvedDrawStyle currStyle = currDts.getResolvedStyle();
        Integer n = pathLayer = currDts.isActive() ? ACTIVE_PATH_LAYER : INACTIVE_PATH_LAYER;
        if (lastStat == null) {
            return new FlipStatus(1, new GeneralPath(), currStyle, pathLayer);
        }
        if (!currStyle.equals(lastStat.styleUsed) || !pathLayer.equals(lastStat.currentLayer)) {
            this.flushPath(cache, lastStat);
            return new FlipStatus(0, new GeneralPath(), currStyle, pathLayer);
        }
        if (lastDts == null) {
            return new FlipStatus(1, lastStat.currPath, currStyle, pathLayer);
        }
        return new FlipStatus(2, lastStat.currPath, currStyle, pathLayer);
    }

    private void flushPath(RenderObjectCache cache, FlipStatus flipStat) {
        Integer pathLayer = flipStat.currentLayer;
        Color baseCol = flipStat.styleUsed.getColor();
        Color col = this.applyAlphaToColor(baseCol, this.oso_);
        BasicStroke stroke = flipStat.styleUsed.calcStroke();
        RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(0, col, stroke, flipStat.currPath);
        cache.addObject(ms, pathLayer, MINOR_NORMAL_LAYER_);
    }

    private void tagIfSelected(DrawTreeSegment dts, LinkSegmentID segID, Intersection selected) {
        MultiSubID sub;
        if (selected != null && ((sub = (MultiSubID)selected.getSubID()) == null || sub.getParts().contains(segID))) {
            dts.setSelected();
        }
    }

    private void renderTipToCache(RenderObjectCache cache, Genome genome, DrawTreeModelDataSource mds, Layout layout, FontRenderContext frc, DrawTreeSegment dts, String linkID, LinkProperties lp, DrawTreeModelDataSource.LinkLineStyleModulation llsm, boolean isGhosted, DisplayOptions dOpt, boolean forModules) {
        DrawTreeModelDataSource.ModelDataForTip tipData = mds.getModelDataForTip(genome, layout, linkID, lp, frc, dOpt);
        Integer pathLayer = tipData.isActive ? ACTIVE_PATH_LAYER : INACTIVE_PATH_LAYER;
        ResolvedDrawStyle rds = dts.getResolvedStyle();
        Color baseCol = rds.getColor();
        Color col = this.applyAlphaToColor(baseCol, this.oso_);
        if (tipData.sign == -1) {
            BasicStroke negStroke = new BasicStroke(tipData.negThick, 0, 1);
            GeneralPath gp = this.negativeTipPath(dts, tipData);
            RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(0, col, negStroke, gp);
            cache.addObject(ms, pathLayer, MINOR_NORMAL_LAYER_);
        } else if (tipData.sign == 1) {
            BasicStroke posStroke = new BasicStroke(1.0f, 0, 1);
            GeneralPath gp = this.positiveTipPath(dts, tipData);
            RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(1, col, posStroke, gp);
            cache.addObject(ms, pathLayer, MINOR_NORMAL_LAYER_);
        }
        if (tipData.hasDiamond) {
            this.renderEvidenceGlyphToCache(cache, genome, dts, linkID, isGhosted, tipData);
        }
    }

    private Color applyAlphaToColor(Color col, OverlayStateOracle oso) {
        if (oso == null) {
            return col;
        }
        double alpha = oso.getCurrentOverlaySettings().regionBoundaryAlpha;
        if (alpha == 1.0) {
            return col;
        }
        float[] coVals = new float[4];
        col.getComponents(coVals);
        Color drawCol = new Color(coVals[0], coVals[1], coVals[2], (float)alpha);
        return drawCol;
    }

    private void tweakTargetDropPath(LinkSegment ls, DrawTreeModelDataSource.LinkLineStyleModulation llsm) {
        Vector2D run = ls.getRun();
        Point2D end = ls.getEnd();
        double offx = end.getX() - run.getX() * llsm.targetOffset;
        double offy = end.getY() - run.getY() * llsm.targetOffset;
        ls.setEnd(new Point2D.Double(offx, offy));
    }

    private GeneralPath positiveTipPath(DrawTreeSegment dts, DrawTreeModelDataSource.ModelDataForTip mdt) {
        double padWidth = mdt.padWidth;
        Vector2D arrival = mdt.arrival;
        Point2D lanLoc = mdt.lanLoc;
        Vector2D run = dts.getRun();
        Vector2D norm = dts.getNormal();
        Point2D end = dts.getEnd();
        Point2D start = dts.getStart();
        Vector2D finalRun = new Vector2D(start, lanLoc);
        if (finalRun.length() <= mdt.plusArrowDepth) {
            run = arrival;
            Vector2D fromEnd = new Vector2D(lanLoc, end);
            if (fromEnd.dot(arrival) > 0.0) {
                end = lanLoc;
            }
            norm = run.normal();
        }
        GeneralPath tipPath = new GeneralPath();
        int dropWidth = dts.getResolvedStyle().getThickness();
        double halfWidth = (double)dropWidth > mdt.thickThick ? mdt.plusArrowHalfWidth + ((double)dropWidth - mdt.thickThick) / 2.0 : mdt.plusArrowHalfWidth;
        double offnegx = end.getX() - run.getX() * (mdt.plusArrowDepth - mdt.positiveDropOffset) - norm.getX() * halfWidth;
        double offnegy = end.getY() - run.getY() * (mdt.plusArrowDepth - mdt.positiveDropOffset) - norm.getY() * halfWidth;
        double offposx = end.getX() - run.getX() * (mdt.plusArrowDepth - mdt.positiveDropOffset) + norm.getX() * halfWidth;
        double offposy = end.getY() - run.getY() * (mdt.plusArrowDepth - mdt.positiveDropOffset) + norm.getY() * halfWidth;
        double tipx = end.getX() + run.getX() * mdt.positiveDropOffset + run.getX() * mdt.tipFudge;
        double tipy = end.getY() + run.getY() * mdt.positiveDropOffset + run.getY() * mdt.tipFudge;
        tipPath.moveTo((float)offnegx, (float)offnegy);
        tipPath.lineTo((float)offposx, (float)offposy);
        tipPath.lineTo((float)tipx, (float)tipy);
        tipPath.closePath();
        return tipPath;
    }

    private GeneralPath negativeTipPath(DrawTreeSegment dts, DrawTreeModelDataSource.ModelDataForTip mdt) {
        int dropWidth;
        double padWidth = mdt.negLength;
        Vector2D arrival = mdt.arrival;
        Point2D lanLoc = mdt.lanLoc;
        Vector2D run = dts.getRun();
        Vector2D norm = dts.getNormal();
        Point2D end = dts.getEnd();
        Point2D start = dts.getStart();
        GeneralPath tipPath = new GeneralPath();
        double halfPad = padWidth / 2.0;
        Vector2D finalRun = new Vector2D(start, lanLoc);
        if (finalRun.length() <= mdt.plusArrowDepth) {
            run = arrival;
            Vector2D fromEnd = new Vector2D(lanLoc, end);
            if (fromEnd.dot(arrival) > 0.0) {
                end = lanLoc;
            }
            norm = run.normal();
        }
        double halfWidth = (double)(dropWidth = dts.getResolvedStyle().getThickness()) > mdt.thickThick ? halfPad + ((double)dropWidth - mdt.thickThick) / 2.0 : halfPad;
        double offnegx = end.getX() - norm.getX() * halfWidth;
        double offnegy = end.getY() - norm.getY() * halfWidth;
        double offposx = end.getX() + norm.getX() * halfWidth;
        double offposy = end.getY() + norm.getY() * halfWidth;
        tipPath.moveTo((float)offnegx, (float)offnegy);
        tipPath.lineTo((float)offposx, (float)offposy);
        return tipPath;
    }

    private void renderEvidenceGlyphToCache(RenderObjectCache cache, Genome genome, DrawTreeSegment dts, String linkID, boolean isGhosted, DrawTreeModelDataSource.ModelDataForTip mdt) {
        Vector2D arrival = mdt.arrival;
        Point2D lanLoc = mdt.lanLoc;
        Linkage link = genome.getLinkage(linkID);
        int level = link.getTargetLevel();
        if (level == 0) {
            return;
        }
        int sign = link.getSign();
        boolean checkForActive = genome instanceof GenomeInstance;
        boolean isActive = checkForActive ? ((LinkageInstance)link).getActivity((GenomeInstance)genome) == 0 : true;
        Vector2D run = dts.getRun();
        Vector2D norm = dts.getNormal();
        Point2D end = dts.getEnd();
        Point2D start = dts.getStart();
        Vector2D finalRun = new Vector2D(start, lanLoc);
        if (finalRun.length() <= mdt.plusArrowDepth) {
            run = arrival;
            Vector2D fromEnd = new Vector2D(lanLoc, end);
            if (fromEnd.dot(arrival) > 0.0) {
                end = lanLoc;
            }
            norm = run.normal();
        }
        double lf = mdt.levelFudge;
        float glyphBaseX = (float)(end.getX() + run.getX() * lf);
        float glyphBaseY = (float)(end.getY() + run.getY() * lf);
        GeneralPath glyphPath = new GeneralPath();
        EvidenceGlyph.addGlyphToPath(glyphPath, glyphBaseX, glyphBaseY);
        Integer pathLayer = isActive ? ACTIVE_PATH_LAYER : INACTIVE_PATH_LAYER;
        Color col = isGhosted || !isActive ? Color.LIGHT_GRAY : this.evidenceToGlyphColor(level);
        BasicStroke tagStroke = new BasicStroke(3.0f, 0, 1);
        RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(1, col, tagStroke, glyphPath);
        cache.addObject(ms, pathLayer, MINOR_TARGET_LABEL_LAYER_);
    }

    private void drawAPad(RenderObjectCache cache, Point2D pt, Color col, BasicStroke padStroke, boolean isActive, double pixDiam) {
        double x = pt.getX();
        double y = pt.getY();
        double useRad = pixDiam < 5.0 ? 5.0 : UiUtil.forceToGridValue(2.0 * pixDiam, 10.0);
        Ellipse2D.Double circ = new Ellipse2D.Double(x - useRad, y - useRad, 2.0 * useRad, 2.0 * useRad);
        Integer pathLayer = isActive ? ACTIVE_PATH_LAYER : INACTIVE_PATH_LAYER;
        RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(0, col, padStroke, circ);
        cache.addObject(ms, pathLayer, MINOR_PAD_LAYER_);
    }

    private void drawABusBranch(RenderObjectCache cache, Point2D pt, Color col1, Color col2, int branchRender, BasicStroke branchStroke, boolean isActive) {
        double x = pt.getX();
        double y = pt.getY();
        Ellipse2D.Double circ = new Ellipse2D.Double(x - 5.0, y - 5.0, 10.0, 10.0);
        Integer pathLayer = isActive ? ACTIVE_PATH_LAYER : INACTIVE_PATH_LAYER;
        RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(1, col1, branchStroke, circ);
        cache.addObject(ms, pathLayer, MINOR_BRANCH_LAYER_);
        if (branchRender == 2) {
            ms = new RenderObjectCache.ModalShape(0, col2, branchStroke, circ);
            cache.addObject(ms, pathLayer, MINOR_BRANCH_LAYER_);
        }
    }

    private Color evidenceToGlyphColor(int level) {
        switch (level) {
            case 1: {
                return Color.blue;
            }
            case 2: {
                return Color.orange;
            }
            case 3: {
                return Color.green;
            }
            case 4: {
                return Color.getHSBColor(0.534f, 1.0f, 0.5f);
            }
            case 5: {
                return Color.magenta;
            }
            case 6: {
                return Color.getHSBColor(0.033f, 0.4f, 0.9f);
            }
            case 7: {
                return Color.getHSBColor(0.1f, 1.0f, 1.0f);
            }
            case 8: {
                return Color.getHSBColor(0.567f, 1.0f, 1.0f);
            }
            case 9: {
                return Color.getHSBColor(0.0f, 0.6f, 0.55f);
            }
            case 10: {
                return Color.getHSBColor(0.283f, 0.5f, 0.8f);
            }
        }
        return Color.LIGHT_GRAY;
    }

    public static Integer getSelectionLayerKey() {
        return MINOR_SELECTED_LAYER_;
    }

    public static int getSegThick(DrawTreeModelDataSource mds, LinkSegmentID getID, Genome genome, LinkProperties lp, OverlayStateOracle oso) {
        DisplayOptions dOpt = DisplayOptionsManager.getMgr().getDisplayOptions();
        DrawTreeModelDataSource.ModelLineStyleModulation lsMod = mds.getModelLineStyleModulation(genome, dOpt);
        HashMap<LinkSegmentID, DrawTreeSegment> segments = new HashMap<LinkSegmentID, DrawTreeSegment>();
        Iterator dit = lp.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String linkID = drop.getTargetRef();
            PerLinkDrawStyle perLink = drop.getDrawStyleForLink();
            DrawTreeModelDataSource.LinkLineStyleModulation llsm = mds.getLinkLineStyleModulation(genome, dOpt, linkID, lp, oso, lsMod);
            if (llsm == null) continue;
            List toRoot = lp.getSegmentIDsToRootForEndDrop(drop);
            int numToRoot = toRoot.size();
            for (int i = 0; i < numToRoot; ++i) {
                LinkSegmentID segID = (LinkSegmentID)toRoot.get(i);
                DrawTreeSegment dts = (DrawTreeSegment)segments.get(segID);
                if (dts == null) {
                    SuggestedDrawStyle drawStyle = lp.getDrawStyleForID(segID);
                    dts = new DrawTreeSegment(segID, null, drawStyle);
                    segments.put(segID, dts);
                }
                dts.incrementPathCount();
                if (perLink == null && llsm.perLinkForEvidence == null && llsm.perLinkActivity == null) continue;
                dts.addPerLinkProps(perLink, linkID, llsm.perLinkForEvidence, llsm.perLinkActivity);
            }
        }
        DrawTreeSegment answerDts = (DrawTreeSegment)segments.get(getID);
        return answerDts.resolveDrawStyle(lp, true, lsMod.linkModulation, lsMod.forModules).getThickness();
    }

    private static class FlipStatus {
        static final int NEW_PATH = 0;
        static final int SAME_PATH_JUMP = 1;
        static final int SAME_PATH_CONTINUE = 2;
        int flipStatus;
        GeneralPath currPath;
        ResolvedDrawStyle styleUsed;
        Integer currentLayer;

        FlipStatus(int flipStatus, GeneralPath currPath, ResolvedDrawStyle styleUsed, Integer currentLayer) {
            this.flipStatus = flipStatus;
            this.currPath = currPath;
            this.styleUsed = styleUsed;
            this.currentLayer = currentLayer;
        }
    }
}

