/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.ResolvedDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.Vector2D;

public class DrawTreeSegment {
    private LinkSegmentID myID_;
    private LinkSegmentID parent_;
    private LinkSegment geomSeg_;
    private SuggestedDrawStyle perSegProps_;
    private ArrayList perLinkProps_;
    private HashMap perLinkModulation_;
    private DrawTreeCornerInfo footInfo_;
    private ResolvedDrawStyle resolved_;
    private boolean drawn_;
    private boolean selected_;
    private boolean isActive_;
    private int pathCount_;
    private String whoDraws_;

    DrawTreeSegment(LinkSegmentID myID, LinkSegment geomSeg, SuggestedDrawStyle props) {
        this.myID_ = myID;
        this.geomSeg_ = geomSeg;
        this.perSegProps_ = props;
        this.perLinkProps_ = new ArrayList();
        this.perLinkModulation_ = new HashMap();
        this.footInfo_ = new DrawTreeCornerInfo();
        this.resolved_ = null;
        this.parent_ = null;
        this.drawn_ = false;
        this.selected_ = false;
        this.isActive_ = false;
        this.pathCount_ = 0;
        this.whoDraws_ = null;
    }

    void incrementPathCount() {
        ++this.pathCount_;
    }

    void setSelected() {
        this.selected_ = true;
    }

    boolean isSelected() {
        return this.selected_;
    }

    void setTag() {
        this.drawn_ = true;
    }

    void setWhoDraws(String linkID) {
        this.whoDraws_ = linkID;
    }

    String getWhoDraws() {
        return this.whoDraws_;
    }

    void clearTag() {
        this.drawn_ = false;
    }

    boolean isDrawn() {
        return this.drawn_;
    }

    boolean isActive() {
        return this.isActive_;
    }

    void setActive() {
        this.isActive_ = true;
    }

    void setParent(LinkSegmentID parent) {
        this.parent_ = parent;
    }

    void setResolvedStyle(ResolvedDrawStyle style) {
        this.resolved_ = style;
    }

    ResolvedDrawStyle getResolvedStyle() {
        return this.resolved_;
    }

    LinkSegmentID getParent() {
        return this.parent_;
    }

    LinkSegmentID getID() {
        return this.myID_;
    }

    Vector2D getNormal() {
        return this.geomSeg_.getNormal();
    }

    Vector2D getRun() {
        return this.geomSeg_.getRun();
    }

    Point2D getStart() {
        return this.geomSeg_.getStart();
    }

    double getLength() {
        return this.geomSeg_.getLength();
    }

    Point2D getEnd() {
        return this.geomSeg_.getEnd();
    }

    SuggestedDrawStyle getPerSegmentStyle() {
        return this.perSegProps_;
    }

    int getPerLinkStyleCount() {
        return this.perLinkProps_.size();
    }

    boolean needsBranchPoint() {
        return this.footInfo_.activeKids >= 2;
    }

    void addActiveChild() {
        ++this.footInfo_.activeKids;
    }

    void addChild() {
        ++this.footInfo_.totalKids;
    }

    private boolean calcStraight(LinkSegment kidSeg, LinkSegment mySeg) {
        Vector2D myRun;
        Vector2D kidRun = kidSeg.getRun();
        double dot = kidRun.dot(myRun = mySeg.getRun());
        return Math.abs(1.0 - Math.abs(dot)) < 0.001;
    }

    void addPerLinkProps(PerLinkDrawStyle perLink, String linkID, PerLinkDrawStyle perLinkForEvidence, Double perLinkActivity) {
        if (perLinkForEvidence != null) {
            this.perLinkProps_.add(new LinkTaggedPerLinkProps(true, linkID, perLinkForEvidence));
        } else if (perLink != null) {
            this.perLinkProps_.add(new LinkTaggedPerLinkProps(false, linkID, perLink));
        }
        if (perLinkActivity != null) {
            this.perLinkModulation_.put(linkID, perLinkActivity);
        }
    }

    ResolvedDrawStyle resolveDrawStyle(LinkProperties lp, boolean isGhosted, int activityDrawChange, boolean forModules) {
        SuggestedDrawStyle currStyle = lp.getDrawStyle();
        ResolvedDrawStyle retval = this.resolvePerLinkProps(currStyle, this.isActive_, isGhosted, activityDrawChange, forModules);
        SuggestedDrawStyle perSeg = this.getPerSegmentStyle();
        if (perSeg != null) {
            retval.masterUpdate(perSeg, this.isActive_, isGhosted, forModules);
        }
        return retval;
    }

    ResolvedDrawStyle resolvePerLinkProps(SuggestedDrawStyle currStyle, boolean isActive, boolean isGhosted, int activityDrawChange, boolean forModules) {
        boolean colorMatters;
        int num = this.perLinkProps_.size();
        boolean bl = colorMatters = isActive && !isGhosted;
        if (num == 0 && this.perLinkModulation_.isEmpty()) {
            currStyle = (SuggestedDrawStyle)currStyle.clone();
            currStyle.fillWithDefaults();
            return new ResolvedDrawStyle(currStyle, colorMatters, forModules);
        }
        boolean sharedCongruentsEqual = true;
        boolean sharedCongruentsOnly = true;
        HashSet<String> styledLinks = new HashSet<String>();
        SuggestedDrawStyle shcgrSty = null;
        for (int i = 0; i < num; ++i) {
            LinkTaggedPerLinkProps ltplp = (LinkTaggedPerLinkProps)this.perLinkProps_.get(i);
            PerLinkDrawStyle plds = ltplp.style;
            styledLinks.add(ltplp.linkID);
            if (plds.getExtent() != 1) {
                sharedCongruentsOnly = false;
                continue;
            }
            if (shcgrSty == null) {
                shcgrSty = plds.getDrawStyle();
                continue;
            }
            if (shcgrSty.equals(plds.getDrawStyle())) continue;
            sharedCongruentsEqual = false;
        }
        if (styledLinks.size() < this.pathCount_) {
            sharedCongruentsOnly = false;
        }
        int maxThick = -4;
        int maxStyle = 0;
        int[] colorSums = colorMatters ? new int[3] : null;
        int numCol = 0;
        for (int i = 0; i < num; ++i) {
            LinkTaggedPerLinkProps ltplp = (LinkTaggedPerLinkProps)this.perLinkProps_.get(i);
            PerLinkDrawStyle plds = ltplp.style;
            if (this.pathCount_ > 1 && plds.getExtent() == 0 || plds.getExtent() == 1 && (!sharedCongruentsEqual || !sharedCongruentsOnly)) continue;
            SuggestedDrawStyle curr = plds.getDrawStyle();
            maxThick = curr.returnWinningThick(maxThick, forModules);
            maxStyle = curr.returnWinningStyle(maxStyle);
            if (!colorMatters) continue;
            numCol = curr.sumColors(colorSums, numCol);
        }
        Color newCol = null;
        if (colorMatters && numCol != 0) {
            for (int i = 0; i < 3; ++i) {
                colorSums[i] = colorSums[i] / numCol;
            }
            newCol = new Color(colorSums[0], colorSums[1], colorSums[2]);
        }
        ResolvedDrawStyle rds = new ResolvedDrawStyle(currStyle, colorMatters, maxThick, maxStyle, newCol, forModules);
        if (this.perLinkModulation_.isEmpty()) {
            return rds;
        }
        double maxLevel = 0.0;
        int numLevels = 0;
        Iterator plmit = this.perLinkModulation_.values().iterator();
        while (plmit.hasNext()) {
            Double perLinkActivity = (Double)plmit.next();
            double plaVal = perLinkActivity;
            if (plaVal > maxLevel) {
                maxLevel = plaVal;
            }
            ++numLevels;
        }
        if (this.pathCount_ > numLevels) {
            maxLevel = 1.0;
        }
        if (maxLevel != 1.0) {
            if (activityDrawChange == 1 || activityDrawChange == 3) {
                rds.modulateColor(maxLevel);
            }
            if (activityDrawChange == 2 || activityDrawChange == 3) {
                rds.modulateThickness(maxLevel);
            }
        }
        return rds;
    }

    static class LinkTaggedPerLinkProps {
        boolean fromEvidence;
        String linkID;
        PerLinkDrawStyle style;

        LinkTaggedPerLinkProps(boolean fromEvidence, String linkID, PerLinkDrawStyle style) {
            this.fromEvidence = fromEvidence;
            this.linkID = linkID;
            this.style = style;
        }
    }

    static class DrawTreeCornerInfo {
        int totalKids;
        int activeKids;

        DrawTreeCornerInfo() {
        }
    }
}

