/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.DBGeneRegion;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NodeRenderBase;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.EvidenceGlyph;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class GeneFree
extends NodeRenderBase {
    public static final float LINE_THICK = 5.0f;
    public static final double EXTRA_WIDTH_PER_PAD = 10.0;
    private static final float LINE_THIN_ = 3.0f;
    private static final float DIV_LINE_LEN_ = 12.0f;
    private static final float GENE_HEIGHT_ = 40.0f;
    private static final float GENE_WIDTH_ = 90.0f;
    private static final float GENE_DIAG_SQ_ = 9700.0f;
    private static final float GENE_DIAG_ = (float)Math.sqrt(9700.0);
    private static final float ARROW_HALF_HEIGHT_ = 10.0f;
    private static final float ARROW_LENGTH_ = 10.0f;
    private static final float LINE_LENGTH_ = 80.0f;
    private static final float BRANCH_OFFSET_ = 5.0f;
    private static final float BRANCH_THICK_ = 4.0f;
    private static final float PAD_WIDTH_ = 10.0f;
    private static final float PAD_HEIGHT_ = 10.0f;
    private static final float SQUARED_TOSS_RADIUS_ = 35000.0f;
    private static final float BIG_TOSS_RADIUS_ = 375.0f;
    private static final float SQUARED_BIG_TOSS_RADIUS_ = 140625.0f;
    private static final float TEXT_PAD_ = 5.0f;
    private static final float REGION_HACK_ = 50.0f;
    private static final int MAX_PADS_ = 7;
    private static final int INBOUND_REGION_HEIGHT_LEGACY_ = 3;
    private static final int INBOUND_REGION_HEIGHT_ORTHO_ = 4;
    private static final int INBOUND_REGION_WIDTH_ = 9;
    private static final float GLYPH_HACK_ = 1.0f;
    public static final int SHORTIE_CHAR = 3;
    public static final float DEFAULT_GENE_WIDTH = 90.0f;

    public double getStraightThroughOffset() {
        return -10.0;
    }

    public double getVerticalOffset() {
        return -50.0;
    }

    public Vector2D getDepartureDirection(int padNum, GenomeItem item, Layout layout) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        if (orient == 2) {
            return new Vector2D(1.0, 0.0);
        }
        return new Vector2D(-1.0, 0.0);
    }

    public Vector2D getArrivalDirection(int padNum, GenomeItem item, Layout layout) {
        return new Vector2D(0.0, 1.0);
    }

    public boolean landingPadsCanOverflow() {
        return true;
    }

    public boolean sharedPadNamespaces() {
        return false;
    }

    public Rectangle getNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double minX = origin.getX();
        double minY = origin.getY();
        double maxX = minX;
        double maxY = minY;
        Iterator lit = genome.getLinkageIterator();
        String myId = item.getID();
        while (lit.hasNext()) {
            String trg;
            Linkage link = (Linkage)lit.next();
            if (layout.getLinkProperties(link.getID()) == null) continue;
            String src = link.getSource();
            if (src.equals(myId)) {
                Vector2D lpo = this.getLaunchPadOffset(link.getLaunchPad(), item, layout, frc);
                Point2D lPad = lpo.add(origin);
                double padX = lPad.getX();
                double padY = lPad.getY();
                if (padX > maxX) {
                    maxX = padX;
                }
                if (padY > maxY) {
                    maxY = padY;
                }
                if (padX < minX) {
                    minX = padX;
                }
                if (padY < minY) {
                    minY = padY;
                }
            }
            if (!(trg = link.getTarget()).equals(myId)) continue;
            Vector2D lpo = this.getLandingPadOffset(link.getLandingPad(), item, link.getSign(), layout, frc);
            Point2D lPad = lpo.add(origin);
            double padX = lPad.getX();
            double padY = lPad.getY();
            if (padX > maxX) {
                maxX = padX;
            }
            if (padY > maxY) {
                maxY = padY;
            }
            if (padX < minX) {
                minX = padX;
            }
            if (!(padY < minY)) continue;
            minY = padY;
        }
        if (maxX == minX && maxY == minY) {
            return null;
        }
        return new Rectangle((int)minX, (int)minY, (int)maxX - (int)minX, (int)maxY - (int)minY);
    }

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Font mFont = FontManager.getMgr().getOverrideFont(3, np.getFontOverride());
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        int padCount = ((Gene)item).getPadCount();
        boolean defaultLength = padCount == 7;
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        boolean textGhosted = isGhosted;
        if (item instanceof GeneInstance) {
            int activityLevel = ((GeneInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
            textGhosted = isGhosted && activityLevel != 3;
        }
        Color vac = this.getVariableActivityColor(item, np.getColor(), false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Color textCol = this.getVariableActivityColor(item, Color.BLACK, true, dopt);
        int orient = np.getOrientation();
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        AffineTransform trans = new AffineTransform();
        AffineTransform saveTrans = g2.getTransform();
        if (orient == 1) {
            trans.translate(x + 90.0f, 0.0);
            trans.scale(-1.0, 1.0);
            trans.translate(-x, 0.0);
        }
        g2.transform(trans);
        this.selectionSupport(g2, selected, (int)(x - extraLen), (int)y, (int)(90.0f + extraLen), 40);
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(4.0f, 0, 1));
        GeneralPath path = new GeneralPath();
        path.moveTo(x + 80.0f - 5.0f, y + 40.0f);
        path.lineTo(x + 80.0f - 5.0f, y + 10.0f);
        path.lineTo(x + 90.0f - 10.0f + 2.0f, y + 10.0f);
        g2.draw(path);
        g2.setStroke(new BasicStroke(5.0f, 0, 1));
        Line2D.Float line = new Line2D.Float(x - extraLen, y + 40.0f, x + 80.0f, y + 40.0f);
        g2.draw(line);
        path.reset();
        path.moveTo(x + 90.0f - 10.0f, y);
        path.lineTo(x + 90.0f, y + 10.0f);
        path.lineTo(x + 90.0f - 10.0f, y + 20.0f);
        path.closePath();
        g2.fill(path);
        this.renderEvidenceGlyphForGene(g2, (Gene)item, origin, isGhosted);
        g2.setTransform(saveTrans);
        FontRenderContext frc = g2.getFontRenderContext();
        if (showBubbles) {
            this.renderPads(g2, isGhosted ? Color.LIGHT_GRAY : Color.BLACK, item, layout, frc);
        }
        textCol = textGhosted ? Color.LIGHT_GRAY : textCol;
        g2.setPaint(textCol);
        Iterator rit = ((Gene)item).regionIterator();
        boolean hasARegion = rit.hasNext();
        if (hasARegion) {
            Font rFont = FontManager.getMgr().getFont(2);
            g2.setFont(rFont);
            BasicStroke divStroke = new BasicStroke(3.0f, 0, 1);
            g2.setStroke(divStroke);
            DBGeneRegion lastRegion = null;
            while (rit.hasNext()) {
                DBGeneRegion region = (DBGeneRegion)rit.next();
                String label = region.getName();
                int startPad = region.getStartPad();
                int endPad = region.getEndPad();
                int midPad = (startPad + endPad) / 2;
                Vector2D off = this.getLandingPadOffset(midPad, item, 0, layout, frc);
                float xLabel = x + (float)off.getX();
                float yLabel = y + (float)off.getY();
                Rectangle2D bounds = rFont.getStringBounds(label, frc);
                float width = (float)bounds.getWidth() / 2.0f;
                g2.drawString(label, xLabel - width, (float)((double)(yLabel + 12.0f) + bounds.getHeight()));
                if (lastRegion != null) {
                    int lrEndPad = lastRegion.getEndPad();
                    Vector2D divOffL = this.getLandingPadOffset(lrEndPad, item, 0, layout, frc);
                    Vector2D divOffR = this.getLandingPadOffset(startPad, item, 0, layout, frc);
                    float divY = y + 40.0f + 2.5f;
                    float divX = x + (float)((divOffL.getX() + divOffR.getX()) / 2.0);
                    Line2D.Float divLine = new Line2D.Float(divX, divY, divX, divY + 12.0f);
                    g2.setPaint(textCol);
                    g2.draw(divLine);
                }
                this.renderEvidenceGlyphForRegion(g2, (Gene)item, layout, frc, region, origin, isGhosted);
                lastRegion = region;
                g2.setPaint(textCol);
            }
        }
        String name = item.getName();
        Point2D nStart = this.getNameStart(item, name, mFont, frc, orient, hasARegion, origin, np.getHideName(), np.getLineBreakDef());
        this.renderText(g2, (float)nStart.getX(), (float)nStart.getY(), name, np.getHideName(), mFont, np.getLineBreakDef());
        Vector2D pieOff = this.getLaunchPadOffset(0, item, layout, frc);
        double xOff = orient == 1 ? -5.0 : 5.0;
        Point2D.Double pieCenter = new Point2D.Double((double)x + pieOff.getX() + xOff, (double)y + pieOff.getY() + 20.0);
        this.drawVariableActivityPie(g2, item, col, pieCenter, dopt);
    }

    private Point2D getNameStart(GenomeItem item, String name, Font mFont, FontRenderContext frc, int orient, boolean hasARegion, Point2D origin, boolean hideName, String lineBreakDef) {
        boolean isTiny;
        double orientPad = orient == 2 ? 0.0 : 10.0;
        Dimension flDim = this.firstLineBounds(frc, name, hideName, mFont, lineBreakDef);
        double xoff = origin.getX() + 80.0 - flDim.getWidth() + orientPad;
        int regionExtraHeight = 0;
        float textPad = 5.0f;
        boolean bl = isTiny = name.length() <= 3 && this.isSingleLineText(name, hideName, lineBreakDef);
        if (hasARegion) {
            if (isTiny) {
                xoff += 50.0;
            } else {
                Rectangle2D rect4Reg = this.regionBounds(item, origin, orient, frc);
                regionExtraHeight = (int)rect4Reg.getHeight();
                textPad = 0.0f;
            }
        }
        double yoff = origin.getY() + 40.0 + (double)flDim.height + (double)regionExtraHeight + (double)textPad;
        return new Point2D.Double(xoff, yoff);
    }

    public void renderToPlacementGrid(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Map targetCounts, Map minPads, int strictness) {
        int endInbound;
        int startInbound;
        Integer min;
        int padCount;
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        boolean notATarget = true;
        int trueCount = padCount = ((Gene)item).getPadCount();
        if (minPads != null && (min = (Integer)minPads.get(item.getID())) != null) {
            notATarget = false;
            int minPad = min;
            if (minPad < 0 && minPad < 7 - padCount) {
                trueCount = 7 - minPad;
            }
        }
        int overflow = trueCount - padCount;
        boolean defaultLength = padCount == 7;
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        Rectangle rect = this.getBounds(genome, item, layout, frc, null);
        rect.width = (int)(90.0f + extraLen) + overflow * 10;
        int shift = orient == 2 ? (int)(extraLen + (float)overflow * 10.0f) : 0;
        rect.x = (int)np.getLocation().getX() - shift;
        Point2D.Double forcedUL = new Point2D.Double();
        UiUtil.forceToGrid(rect.x, rect.y, forcedUL, 10.0);
        Point2D.Double forcedLR = new Point2D.Double();
        UiUtil.forceToGrid(rect.x + rect.width, rect.y + rect.height, forcedLR, 10.0);
        int patW = ((int)(((Point2D)forcedLR).getX() - ((Point2D)forcedUL).getX()) + 30) / 10;
        int patH = ((int)(((Point2D)forcedLR).getY() - ((Point2D)forcedUL).getY()) + 30) / 10;
        if (strictness == 0) {
            patW += 2;
            patH += 2;
        }
        Pattern pat = new Pattern(patW, patH);
        String itemID = item.getID();
        if (strictness == 1 || strictness == 0) {
            pat.fillAll(itemID);
        } else {
            for (int i = 1; i < patW - 1; ++i) {
                for (int j = 1; j < patH - 1; ++j) {
                    pat.fill(i, j, itemID);
                }
            }
        }
        Pattern inbound = new Pattern(patW, patH);
        int trueWidth = 9 + (padCount - 7) + overflow;
        if (strictness == 1 || strictness == 0) {
            startInbound = orient == 2 ? 0 : patW - trueWidth;
            endInbound = orient == 2 ? trueWidth : patW;
            for (int i = startInbound; i < endInbound; ++i) {
                for (int j = 0; j < 3; ++j) {
                    inbound.fill(i, j, item.getID());
                }
            }
        } else {
            int useHeight;
            startInbound = orient == 2 ? 1 : patW - trueWidth - 1;
            endInbound = orient == 2 ? trueWidth : patW - 1;
            int minPad = Integer.MAX_VALUE;
            if (!notATarget) {
                String myID = item.getID();
                Iterator lit = genome.getLinkageIterator();
                while (lit.hasNext()) {
                    int pad;
                    Linkage link = (Linkage)lit.next();
                    String targ = link.getTarget();
                    if (!targ.equals(myID) || (pad = link.getLandingPad()) >= minPad) continue;
                    minPad = pad;
                }
            }
            int transition = startInbound;
            if (!notATarget) {
                int n = transition = orient == 2 ? minPad + 3 + (padCount - 7) + overflow : endInbound - minPad - 2 - (padCount - 7) - overflow;
            }
            if (strictness == 3) {
                useHeight = 3;
            } else if (strictness == 4) {
                useHeight = 4;
            } else {
                throw new IllegalArgumentException();
            }
            for (int i = startInbound; i < endInbound; ++i) {
                for (int j = 0; j < useHeight; ++j) {
                    if (notATarget) {
                        pat.fill(i, j, null);
                        continue;
                    }
                    if (i < transition) {
                        if (orient == 2) {
                            pat.fill(i, j, null);
                            continue;
                        }
                        inbound.fill(i, j, item.getID());
                        continue;
                    }
                    if (orient == 2) {
                        inbound.fill(i, j, item.getID());
                        continue;
                    }
                    pat.fill(i, j, null);
                }
            }
        }
        int px = ((int)((Point2D)forcedUL).getX() - 10) / 10;
        int py = ((int)((Point2D)forcedUL).getY() - 10) / 10;
        if (strictness == 0) {
            --px;
            --py;
        }
        grid.addNode(pat, inbound, item.getID(), px, py, strictness);
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        double maskH;
        double maskW;
        double maskY;
        float sqRad;
        boolean defaultLength;
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double orx = origin.getX();
        double ory = origin.getY();
        double x = pt.getX();
        double y = pt.getY();
        double dx = orx - x;
        double dy = ory - y;
        double distsq = dx * dx + dy * dy;
        int padCount = ((Gene)item).getPadCount();
        boolean bl = defaultLength = padCount == 7;
        if (defaultLength) {
            sqRad = 35000.0f;
        } else if (padCount <= 30) {
            sqRad = 140625.0f;
        } else {
            float rad = (float)padCount * 10.0f * 1.25f;
            sqRad = rad * rad;
        }
        String name = item.getName();
        String breakDef = np.getLineBreakDef();
        if (distsq > (double)sqRad && !this.isTextCandidate(frc, 3, np.getFontOverride(), name, GENE_DIAG_, dx, distsq, breakDef, true, false)) {
            return null;
        }
        int orient = np.getOrientation();
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        float lineLen = defaultLength ? 80.0f : 80.0f + extraLen;
        double maskX = orient == 2 ? orx - 2.0 - (double)extraLen : orx - 2.0 + 10.0 + 15.0;
        if (Bounds.intersects(maskX, maskY = ory - 2.0, maskX + (maskW = orient == 2 ? (double)lineLen - 10.0 + 2.0 : (double)lineLen - 15.0 + 2.0), maskY + (maskH = 20.0), x, y)) {
            return null;
        }
        double minX = orient == 2 ? orx - (double)extraLen : orx - 10.0;
        double minY = ory - 10.0;
        double maxX = orient == 2 ? orx + 90.0 + 10.0 : orx + 90.0 + (double)extraLen;
        double maxY = minY + 40.0 + 10.0 + 2.5;
        if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            List pads = this.calcPadIntersects(item, layout, frc, pt);
            if (pads != null) {
                return new Intersection(item.getID(), pads);
            }
            minY += 10.0;
            minX += orient == 2 ? 0.0 : 10.0;
            maxX -= orient == 2 ? 10.0 : 0.0;
            if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
                return new Intersection(item.getID(), null, 0.0);
            }
        }
        Rectangle2D regBounds = this.regionBounds(item, origin, orient, frc);
        boolean hasARegion = false;
        if (regBounds != null) {
            hasARegion = true;
            if (regBounds.contains(x, y)) {
                return new Intersection(item.getID(), null, 0.0);
            }
        }
        Font mFont = FontManager.getMgr().getOverrideFont(3, np.getFontOverride());
        Point2D nStart = this.getNameStart(item, name, mFont, frc, orient, hasARegion, origin, np.getHideName(), breakDef);
        Rectangle2D textRect = this.getTextBounds(frc, (float)nStart.getX(), (float)nStart.getY(), name, false, mFont, breakDef);
        minX = (int)textRect.getX();
        minY = (int)textRect.getY();
        maxX = minX + (double)((int)textRect.getWidth());
        maxY = minY + (double)((int)textRect.getHeight());
        if (textRect.contains(x, y)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    private Rectangle2D regionBounds(GenomeItem item, Point2D origin, int orient, FontRenderContext frc) {
        double orx = origin.getX();
        double ory = origin.getY();
        Font mFont = FontManager.getMgr().getFont(2);
        Iterator rit = ((Gene)item).regionIterator();
        boolean hasARegion = rit.hasNext();
        if (hasARegion) {
            double minMinX = Double.POSITIVE_INFINITY;
            double maxMaxX = Double.NEGATIVE_INFINITY;
            double minMinY = Double.POSITIVE_INFINITY;
            double maxMaxY = Double.NEGATIVE_INFINITY;
            while (rit.hasNext()) {
                DBGeneRegion region = (DBGeneRegion)rit.next();
                String label = region.getName();
                int startPad = region.getStartPad();
                int endPad = region.getEndPad();
                int midPad = (startPad + endPad) / 2;
                Vector2D off = this.getLandingPadOffsetByOrientAndSign(midPad, 0, orient);
                double xLabel = orx + off.getX();
                double yLabel = ory + off.getY();
                Rectangle2D bounds = mFont.getStringBounds(label, frc);
                float width = (float)bounds.getWidth() / 2.0f;
                double minX = xLabel - (double)width;
                double maxX = xLabel + (double)width;
                double minY = yLabel + 2.5;
                double maxY = minY + 12.0 + bounds.getHeight();
                if (minX < minMinX) {
                    minMinX = minX;
                }
                if (maxX > maxMaxX) {
                    maxMaxX = maxX;
                }
                if (minY < minMinY) {
                    minMinY = minY;
                }
                if (!(maxY > maxMaxY)) continue;
                maxMaxY = maxY;
            }
            return new Rectangle2D.Double(minMinX, minMinY, maxMaxX - minMinX, maxMaxY - minMinY);
        }
        return null;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double minX = origin.getX();
        double minY = origin.getY();
        int padCount = ((Gene)item).getPadCount();
        boolean defaultLength = padCount == 7;
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        int orient = np.getOrientation();
        minX = orient == 1 ? minX : minX - (double)extraLen;
        float width = 90.0f + extraLen;
        Rectangle2D.Double myBounds = new Rectangle2D.Double(minX, minY, width, 40.0);
        Rectangle2D.Double inbounds = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        if (countPartial) {
            Rectangle trueRect = this.getBounds(genome, item, layout, frc, miscInfo);
            minX = trueRect.x;
            minY = trueRect.y;
            double maxX = minX + (double)trueRect.width;
            double maxY = minY + (double)trueRect.height;
            Point2D.Double chkPt = new Point2D.Double(minX, minY);
            boolean gotIt = inbounds.contains(chkPt);
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(maxX, minY);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(maxX, maxY);
                gotIt = inbounds.contains(chkPt);
            }
            if (!gotIt) {
                ((Point2D)chkPt).setLocation(minX, maxY);
                gotIt = inbounds.contains(chkPt);
            }
            if (gotIt) {
                return new Intersection(item.getID(), null, 0.0);
            }
        } else if (inbounds.contains(myBounds)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Vector2D getLaunchPadOffset(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        return this.getLaunchPadOffsetByOrient(orient);
    }

    private Vector2D getLaunchPadOffsetByOrient(int orient) {
        Vector2D retval = null;
        retval = orient == 2 ? new Vector2D(90.0, 10.0) : new Vector2D(0.0, 10.0);
        return retval;
    }

    public Vector2D getLandingPadOffset(int padNum, GenomeItem item, int sign, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        return this.getLandingPadOffsetByOrientAndSign(padNum, orient, sign);
    }

    private Vector2D getLandingPadOffsetByOrientAndSign(int padNum, int orient, int sign) {
        float negPosTweak = 0.0f;
        if (sign == -1) {
            negPosTweak = 3.0f;
        } else if (sign == 1) {
            negPosTweak = 4.0f;
        }
        float vertical = 37.5f - negPosTweak;
        Vector2D retval = null;
        retval = orient == 2 ? new Vector2D(10.0f * (float)(padNum + 1), vertical) : new Vector2D(90.0f - 10.0f * (float)(padNum + 1), vertical);
        return retval;
    }

    public double getLandingPadWidth(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 10.0;
    }

    public int getFixedLaunchPadMax() {
        return 1;
    }

    public int getFixedLandingPadMax() {
        return 7;
    }

    public Rectangle2D getBoundsForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int orientation, boolean labelToo, Integer topPadCount) {
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        NodeProperties np = layout.getNodeProperties(item.getID());
        String breakDef = np.getLineBreakDef();
        boolean hideName = np.getHideName();
        Gene theGene = (Gene)item;
        int padCount = topPadCount == null ? theGene.getPadCount() : topPadCount.intValue();
        Font mFont = FontManager.getMgr().getOverrideFont(3, np.getFontOverride());
        Rectangle basic = this.getBoundsGuts(item, frc, origin, padCount, 2, breakDef, hideName, mFont);
        return basic;
    }

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem item, Layout layout, FontRenderContext frc, int orient, Integer topPadCount) {
        return this.getLaunchPadOffsetByOrient(orient);
    }

    public int topPadCount(int fullPadCount) {
        return fullPadCount;
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int padCount = ((Gene)item).getPadCount();
        int orient = np.getOrientation();
        String breakDef = np.getLineBreakDef();
        boolean hideName = np.getHideName();
        Font mFont = FontManager.getMgr().getOverrideFont(3, np.getFontOverride());
        return this.getBoundsGuts(item, frc, origin, padCount, orient, breakDef, hideName, mFont);
    }

    private Rectangle getBoundsGuts(GenomeItem item, FontRenderContext frc, Point2D origin, int padCount, int orient, String breakDef, boolean hideName, Font mFont) {
        double minXd = origin.getX();
        int minY = (int)origin.getY();
        boolean defaultLength = padCount == 7;
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        minXd = orient == 1 ? minXd : minXd - (double)extraLen;
        float geneWidth = 90.0f + extraLen;
        int minX = (int)minXd;
        boolean hasARegion = ((Gene)item).getNumRegions() > 0;
        int boundWidth = (int)geneWidth;
        String name = item.getName();
        float height = 0.0f;
        boolean isSingle = this.isSingleLineText(name, false, breakDef);
        if (isSingle) {
            Rectangle2D bounds = mFont.getStringBounds(name, frc);
            height = (float)bounds.getHeight();
            float width = (float)bounds.getWidth();
            float delta = width - (geneWidth - 10.0f);
            if (delta > 0.0f) {
                minX -= (int)delta;
                boundWidth = (int)(geneWidth + delta);
            }
            if (hasARegion && name.length() <= 3) {
                boundWidth = (int)((float)boundWidth + 45.0f);
            }
        }
        Rectangle retval = new Rectangle(minX, minY, boundWidth, (int)(40.0f + height + 5.0f));
        if (!hasARegion && isSingle) {
            return retval;
        }
        Point2D nStart = this.getNameStart(item, name, mFont, frc, orient, hasARegion, origin, hideName, breakDef);
        if (isSingle) {
            retval.height = (int)nStart.getY() - retval.y;
            return retval;
        }
        Rectangle2D textRect = this.getTextBounds(frc, (float)nStart.getX(), (float)nStart.getY(), name, false, mFont, breakDef);
        List frags = MultiLineRenderSupport.applyLineBreaksForFragments(name, breakDef);
        String frag = (String)frags.get(0);
        Rectangle2D bounds = mFont.getStringBounds(frag, frc);
        retval.height = (int)nStart.getY() - (int)(bounds.getHeight() * 0.8) + (int)textRect.getHeight() - minY;
        retval.x = (int)nStart.getX() < minX ? (int)nStart.getX() : minX;
        int maxX = retval.x + retval.width;
        int maxXForText = (int)(textRect.getX() + textRect.getWidth());
        retval.width = maxXForText > maxX ? maxXForText - retval.x : retval.width;
        return retval;
    }

    public double getGlyphHeightForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 90.0;
    }

    public double getWidth(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        int padCount = ((Gene)item).getPadCount();
        boolean defaultLength = padCount == 7;
        int extraPads = defaultLength ? 0 : padCount - 7;
        float extraLen = (float)extraPads * 10.0f;
        float geneWidth = 90.0f + extraLen;
        return geneWidth;
    }

    public NodeInsertionDirective getInsertionDirective(Vector2D travel, Point2D insertion) {
        int orient = travel.getX() >= 0.0 ? 2 : 1;
        Vector2D lau = this.getLaunchPadOffsetByOrient(orient);
        Vector2D lnd = this.getLandingPadOffsetByOrientAndSign(0, orient, 0);
        Vector2D posTweak = new Vector2D(-10.0, -10.0);
        ArrayList<Point2D> landingCorners = new ArrayList<Point2D>();
        ArrayList<Point2D.Double> launchCorners = new ArrayList<Point2D.Double>();
        Point2D tweaked = posTweak.add(insertion);
        if (travel.getX() == 0.0) {
            if (travel.getY() < 0.0) {
                Point2D.Double pt0 = new Point2D.Double(tweaked.getX() + lnd.getX(), insertion.getY() + 80.0);
                landingCorners.add(pt0);
                Point2D.Double pt1 = new Point2D.Double(((Point2D)pt0).getX() - 50.0, ((Point2D)pt0).getY());
                landingCorners.add(pt1);
                Point2D.Double pt2 = new Point2D.Double(((Point2D)pt1).getX(), insertion.getY());
                landingCorners.add(pt2);
                Point2D.Double pt3 = new Point2D.Double(((Point2D)pt0).getX(), ((Point2D)pt2).getY());
                landingCorners.add(pt3);
                Point2D.Double lpt0 = new Point2D.Double(tweaked.getX() + lau.getX() + 20.0, insertion.getY());
                Point2D.Double lpt1 = new Point2D.Double(((Point2D)lpt0).getX(), insertion.getY() - 20.0);
                Point2D.Double lpt2 = new Point2D.Double(tweaked.getX() + lnd.getX(), ((Point2D)lpt1).getY());
                launchCorners.add(lpt2);
                launchCorners.add(lpt1);
                launchCorners.add(lpt0);
            } else {
                Point2D.Double lpt0 = new Point2D.Double(tweaked.getX() + lau.getX() + 20.0, insertion.getY());
                Point2D.Double lpt1 = new Point2D.Double(((Point2D)lpt0).getX(), insertion.getY() + 50.0);
                Point2D.Double lpt2 = new Point2D.Double(tweaked.getX() + lnd.getX(), ((Point2D)lpt1).getY());
                launchCorners.add(lpt2);
                launchCorners.add(lpt1);
                launchCorners.add(lpt0);
            }
        } else if (travel.getY() == 0.0) {
            Point2D lastLanding = posTweak.add(insertion);
            lastLanding.setLocation(lastLanding.getX() + lnd.getX(), insertion.getY());
            landingCorners.add(lastLanding);
        }
        if (landingCorners.isEmpty()) {
            landingCorners = null;
        }
        if (launchCorners.isEmpty()) {
            launchCorners = null;
        }
        return new NodeInsertionDirective(0, 0, orient, posTweak, landingCorners, launchCorners);
    }

    public List getNearbyPads(GenomeItem item, int startPad, Layout layout) {
        MinMax range = this.getTargetPadRange(item);
        int count = 0;
        HashMap<Integer, Integer> distances = new HashMap<Integer, Integer>();
        int firstPad = -startPad % 2 == 0 ? range.min : range.min + 1;
        for (int i = range.min; i <= range.max; ++i) {
            Integer nextPad = new Integer(i);
            Integer nextDist = new Integer(count++);
            distances.put(nextPad, nextDist);
        }
        return this.alternationSupport(distances, startPad);
    }

    private void renderPads(Graphics2D g2, Color col, GenomeItem item, Layout layout, FontRenderContext frc) {
        int minPad;
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(1.0f));
        Vector2D lpo = this.getLaunchPadOffset(0, item, layout, frc);
        double x = origin.getX() + lpo.getX();
        double y = origin.getY() + lpo.getY();
        double padRadius = 4.0;
        Ellipse2D.Double circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
        g2.draw(circ);
        int padCount = ((Gene)item).getPadCount();
        for (int i = minPad = 7 - padCount; i < 7; ++i) {
            lpo = this.getLandingPadOffset(i, item, 1, layout, frc);
            x = origin.getX() + lpo.getX();
            y = origin.getY() + lpo.getY();
            Arc2D.Double arc = new Arc2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius, 180.0, 180.0, 0);
            g2.draw(arc);
            double xt = x;
            double yt = y - 10.0;
            arc = new Arc2D.Double(xt - padRadius, yt - padRadius, 2.0 * padRadius, 2.0 * padRadius, 0.0, 180.0, 0);
            g2.draw(arc);
            Line2D.Double line = new Line2D.Double(x - padRadius, y, xt - padRadius, yt);
            g2.draw(line);
            line = new Line2D.Double(x + padRadius, y, xt + padRadius, yt);
            g2.draw(line);
        }
    }

    private List calcPadIntersects(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt) {
        int minPad;
        double py;
        ArrayList<Intersection.PadVal> retval = new ArrayList<Intersection.PadVal>();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        Vector2D lpo = this.getLaunchPadOffset(0, item, layout, frc);
        double x = origin.getX() + lpo.getX();
        double y = origin.getY() + lpo.getY();
        double padRadius = 6.0;
        double prSq = padRadius * padRadius;
        double px = pt.getX();
        double distSq = (px - x) * (px - x) + ((py = pt.getY()) - y) * (py - y);
        if (distSq <= prSq) {
            Intersection.PadVal retpad = new Intersection.PadVal();
            retpad.okEnd = false;
            retpad.okStart = true;
            retpad.padNum = 0;
            retpad.distance = Math.sqrt(distSq);
            retval.add(retpad);
        }
        int padCount = ((Gene)item).getPadCount();
        for (int i = minPad = 7 - padCount; i < 7; ++i) {
            boolean inMiddle;
            lpo = this.getLandingPadOffset(i, item, 1, layout, frc);
            x = origin.getX() + lpo.getX();
            y = origin.getY() + lpo.getY();
            double yt = y - 10.0;
            double botBubSq = (px - x) * (px - x) + (py - y) * (py - y);
            double topBubSq = (px - x) * (px - x) + (py - yt) * (py - yt);
            boolean bl = inMiddle = Math.abs(px - x) < padRadius && py < y && py > yt;
            if (!(botBubSq <= prSq) && !(topBubSq <= prSq) && !inMiddle) continue;
            Intersection.PadVal retpad = new Intersection.PadVal();
            retpad.okEnd = true;
            retpad.okStart = false;
            retpad.padNum = i;
            retpad.distance = 0.0;
            retval.add(retpad);
        }
        return retval.isEmpty() ? null : retval;
    }

    private void renderEvidenceGlyphForGene(Graphics2D g2, Gene gene, Point2D origin, boolean isGhosted) {
        int evidence = gene.getEvidenceLevel();
        if (evidence == 0) {
            return;
        }
        double x = origin.getX();
        double y = origin.getY();
        float glyphBaseX = (float)(x + 80.0 - 5.0);
        float glyphBaseY = (float)(y + 40.0 + 2.5 + 1.0);
        Color col = isGhosted ? Color.LIGHT_GRAY : Color.red;
        EvidenceGlyph.renderEvidenceGlyph(g2, col, glyphBaseX, glyphBaseY);
    }

    private void renderEvidenceGlyphForRegion(Graphics2D g2, Gene item, Layout layout, FontRenderContext frc, DBGeneRegion region, Point2D origin, boolean isGhosted) {
        int evidence = region.getEvidenceLevel();
        if (evidence == 0) {
            return;
        }
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        Color col = isGhosted ? Color.LIGHT_GRAY : Color.red;
        int endPad = region.getEndPad();
        Vector2D off = this.getLandingPadOffset(endPad, item, 0, layout, frc);
        float glyphBaseY = y + 40.0f + 2.5f + 1.0f;
        float glyphBaseX = x + (float)off.getX();
        EvidenceGlyph.renderEvidenceGlyph(g2, col, glyphBaseX, glyphBaseY);
    }
}

