/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.ItemRenderBase;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class GroupFree
extends ItemRenderBase {
    private static final double TEXT_PAD_ = 10.0;
    private static final double HEIGHT_HACK_ = 0.75;
    private static final int SUBREGION_BORDER_ = 3;
    private static final int EMPTY_REGION_PAD_ = 100;

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        String groupRef = item.getID();
        int groupViz = 0;
        boolean genomeIsRoot = true;
        AugmentedExtraInfo augEx = null;
        ExtraInfo extra = null;
        Integer setting = null;
        List passOut = null;
        if (miscInfo != null) {
            augEx = (AugmentedExtraInfo)miscInfo;
            passOut = augEx.passOut;
            extra = augEx.extra;
            if (extra != null) {
                setting = extra.vizVal;
                genomeIsRoot = extra.genomeIsRoot;
            }
        }
        if (setting != null) {
            groupViz = setting;
        } else {
            GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
            groupViz = gsm.getGroupVisibility(genome.getID(), groupRef);
        }
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        int style = gp.getStyle();
        int layer = gp.getLayer();
        int tpad = gp.getPadding(0);
        int bpad = gp.getPadding(1);
        int lpad = gp.getPadding(2);
        int rpad = gp.getPadding(3);
        boolean doBold = layer == 0;
        Color col = gp.getColor(groupViz == 4);
        Color vlg = new Color(240, 240, 240);
        if (extra != null && extra.replacementColor != null) {
            col = groupViz != 4 ? extra.replacementColor : vlg;
        }
        Color paintColor = isGhosted ? vlg : col;
        g2.setPaint(paintColor);
        FontRenderContext frc = g2.getFontRenderContext();
        boolean drawLight = groupViz != 4 || isGhosted;
        NameAndBoldAndEmpty nab = this.getName(genome, item, extra, doBold);
        doBold = nab.doBold;
        String name = nab.name;
        TextRect textRectInfo = this.getTextRect(gp, doBold, name, frc);
        if (style == 0) {
            List drawRects = this.getRenderRects(genome, item, layout, frc, layer, textRectInfo, tpad, bpad, lpad, rpad);
            int drNum = drawRects.size();
            for (int i = 0; i < drNum; ++i) {
                Rectangle drawRect = (Rectangle)drawRects.get(i);
                g2.fillRect(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
                if (passOut == null || layer != 0) continue;
                passOut.add(new ColoredRect(drawRect, paintColor));
            }
            if (name != null && !name.trim().equals("") && drawLight) {
                double width = textRectInfo.tbounds.getWidth();
                double height = textRectInfo.tbounds.getHeight() * 0.75;
                textRectInfo.nameX = (double)(textRectInfo.extent.x + textRectInfo.extent.width / 2) - width / 2.0;
                textRectInfo.nameY = (double)(textRectInfo.extent.y + textRectInfo.extent.height / 2) + height / 2.0;
                double ty = (double)(textRectInfo.extent.y + textRectInfo.extent.height / 2) - height / 2.0;
                textRectInfo.rect = new Rectangle2D.Double(textRectInfo.nameX - 10.0, ty - 10.0, width + 20.0, height + 20.0);
            }
            if (!(name == null || name.trim().equals("") || this.calcHideLabel(genomeIsRoot, gp) && !nab.isEmpty)) {
                Color drawCol;
                Color blackCol = drawLight ? Color.LIGHT_GRAY : Color.black;
                Color color = drawCol = drawLight ? vlg : col;
                if (!doBold) {
                    g2.setPaint(blackCol);
                    Rectangle2D.Double borderRect = new Rectangle2D.Double(textRectInfo.rect.getX() - 3.0, textRectInfo.rect.getY() - 3.0, textRectInfo.rect.getWidth() + 6.0, textRectInfo.rect.getHeight() + 6.0);
                    g2.fill(borderRect);
                }
                g2.setPaint(doBold ? blackCol : drawCol);
                g2.fill(textRectInfo.rect);
                g2.setPaint(doBold ? drawCol : blackCol);
                g2.setFont(doBold ? textRectInfo.bFont : textRectInfo.mFont);
                g2.drawString(name, (float)textRectInfo.nameX, (float)textRectInfo.nameY);
            }
        }
    }

    public Rectangle getLabelBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        String groupRef = item.getID();
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        int layer = gp.getLayer();
        boolean doBold = layer == 0;
        NameAndBoldAndEmpty nab = this.getName(genome, item, null, doBold);
        doBold = nab.doBold;
        TextRect tr = this.getTextRect(gp, doBold, nab.name, frc);
        return tr.textRect;
    }

    private TextRect getTextRect(GroupProperties gp, boolean doBold, String name, FontRenderContext frc) {
        TextRect retval = new TextRect();
        retval.mFont = FontManager.getMgr().getFont(5);
        retval.bFont = FontManager.getMgr().getFont(7);
        retval.tbounds = null;
        retval.rect = null;
        retval.textRect = null;
        retval.extent = null;
        retval.nameX = 0.0;
        retval.nameY = 0.0;
        if (name != null && !name.trim().equals("")) {
            retval.tbounds = (doBold ? retval.bFont : retval.mFont).getStringBounds(name, frc);
            double width = retval.tbounds.getWidth();
            double height = retval.tbounds.getHeight() * 0.75;
            Point2D origin = gp.getLabelLocation();
            retval.nameX = origin.getX() - width / 2.0;
            retval.nameY = origin.getY() + height / 2.0;
            double ty = origin.getY() - height / 2.0;
            retval.rect = new Rectangle2D.Double(retval.nameX - 10.0, ty - 10.0, width + 20.0, height + 20.0);
            retval.textRect = new Rectangle((int)retval.rect.getX(), (int)retval.rect.getY(), (int)retval.rect.getWidth(), (int)retval.rect.getHeight());
        }
        return retval;
    }

    private NameAndBoldAndEmpty getName(Genome genome, GenomeItem item, ExtraInfo extra, boolean doBold) {
        boolean isEmpty;
        String name = ((Group)item).getInheritedDisplayName((GenomeInstance)genome);
        if (name != null && name.equals(ResourceManager.getManager().getString("groupName.noName"))) {
            name = null;
        }
        boolean bl = isEmpty = ((Group)item).getMemberCount() == 0;
        if (isEmpty && (name == null || name.trim().equals(""))) {
            name = ResourceManager.getManager().getString("groupName.empty");
        }
        if (extra != null) {
            if (extra.dropName) {
                doBold = true;
            } else if (extra.replacementName != null) {
                name = null;
            }
        }
        return new NameAndBoldAndEmpty(name, doBold, isEmpty);
    }

    private List getRenderRects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int layer, TextRect textRectInfo, int tpad, int bpad, int lpad, int rpad) {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        textRectInfo.extent = textRectInfo.textRect;
        boolean haveMember = false;
        Iterator mit = ((Group)item).getMemberIterator();
        while (mit.hasNext()) {
            GroupMember member = (GroupMember)mit.next();
            String nodeID = member.getID();
            Node node = genome.getNode(nodeID);
            NodeProperties np = layout.getNodeProperties(nodeID);
            if (np == null) continue;
            haveMember = true;
            INodeRenderer rend = np.getRenderer();
            Rectangle bounds = rend.getBounds(genome, node, layout, frc, null);
            if (layer >= 1 && layer <= 10 && node.getNodeType() == 4) {
                Bounds.padBounds(bounds, tpad, bpad, lpad, rpad);
                int fillX = bounds.x;
                int fillW = bounds.width;
                String nodeName = node.getName();
                int nnLen = nodeName.length();
                if (nnLen > 12) {
                    int overrun = nnLen - 12;
                    Rectangle2D subWidth = textRectInfo.mFont.getStringBounds(nodeName.substring(0, overrun), frc);
                    Rectangle2D allWidth = textRectInfo.mFont.getStringBounds(nodeName, frc);
                    double delta = allWidth.getWidth() - subWidth.getWidth();
                    fillX += (int)delta;
                    fillW -= (int)delta;
                }
                retval.add(new Rectangle(fillX, bounds.y, fillW, bounds.height));
                continue;
            }
            if (textRectInfo.extent == null) {
                textRectInfo.extent = bounds;
                continue;
            }
            Bounds.tweakBounds(textRectInfo.extent, bounds);
        }
        Rectangle modBounds = this.moduleBoxBounds(genome, item, layout);
        if (modBounds != null) {
            if (textRectInfo.extent == null) {
                textRectInfo.extent = modBounds;
            } else {
                Bounds.tweakBounds(textRectInfo.extent, modBounds);
            }
        }
        if (layer == 0 && textRectInfo.extent != null) {
            this.subLabelBoxBounds(genome, item, layout, frc, textRectInfo.extent);
            Bounds.padBounds(textRectInfo.extent, tpad, bpad, lpad, rpad);
            if (!haveMember) {
                Bounds.padBounds(textRectInfo.extent, 100, 0, 0, 0);
            }
            retval.add(new Rectangle(textRectInfo.extent.x, textRectInfo.extent.y, textRectInfo.extent.width, textRectInfo.extent.height));
        }
        return retval;
    }

    private boolean calcHideLabel(boolean genomeIsRoot, GroupProperties gp) {
        int labelMode = gp.getHideLabelMode();
        boolean hideLabel = labelMode == 1 || labelMode == 2 && genomeIsRoot;
        return hideLabel;
    }

    public void renderToPlacementGrid(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, LinkPlacementGrid grid) {
        String groupRef = item.getID();
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        int layer = gp.getLayer();
        int style = gp.getStyle();
        int tpad = gp.getPadding(0);
        int bpad = gp.getPadding(1);
        int lpad = gp.getPadding(2);
        int rpad = gp.getPadding(3);
        boolean doBold = layer == 0;
        NameAndBoldAndEmpty nab = this.getName(genome, item, null, doBold);
        String name = nab.name;
        TextRect textRectInfo = this.getTextRect(gp, doBold, name, frc);
        if (style == 0) {
            List drawRects = this.getRenderRects(genome, item, layout, frc, layer, textRectInfo, tpad, bpad, lpad, rpad);
            int drNum = drawRects.size();
            for (int i = 0; i < drNum; ++i) {
                Rectangle drawRect = (Rectangle)drawRects.get(i);
                grid.addGroup(drawRect, groupRef);
            }
        }
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        ExtraInfo exi;
        String groupRef = item.getID();
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        int style = gp.getStyle();
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        ExtraInfo extraInfo = exi = miscInfo != null ? ((AugmentedExtraInfo)miscInfo).extra : null;
        if (style == 0) {
            HashSet bounds = this.boxBounds(genome, item, layout, frc, false);
            Iterator bit = bounds.iterator();
            while (bit.hasNext()) {
                Rectangle rect = (Rectangle)bit.next();
                if (!Bounds.intersects(rect, x, y)) continue;
                boolean hasLabel = this.intersectsLabel(item, layout, frc, pt, exi);
                if (hasLabel) {
                    return new Intersection(item.getID(), new LabelSubID(item.getID()), 0.0);
                }
                Set subsets = ((Group)item).getSubsets((GenomeInstance)genome);
                Iterator sidit = subsets.iterator();
                while (sidit.hasNext()) {
                    String subid = (String)sidit.next();
                    Group subgroup = ((GenomeInstance)genome).getGroup(subid);
                    hasLabel = this.intersectsLabel(subgroup, layout, frc, pt, exi);
                    if (!hasLabel) continue;
                    return new Intersection(item.getID(), new LabelSubID(subid), 0.0);
                }
                return new Intersection(item.getID(), new LabelSubID(null), 0.0);
            }
        }
        return null;
    }

    private boolean intersectsLabel(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, ExtraInfo extra) {
        String groupRef = item.getID();
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        String name = item.getName();
        boolean hideName = this.calcHideLabel(extra.genomeIsRoot, gp);
        if (name == null || name.trim().equals("") || hideName) {
            return false;
        }
        boolean doBold = false;
        if (extra != null) {
            if (extra.dropName) {
                doBold = true;
            } else if (extra.replacementName != null) {
                return false;
            }
        }
        TextRect textRect = this.getTextRect(gp, doBold, name, frc);
        Rectangle2D useMe = textRect.rect;
        return Bounds.intersects(useMe.getMinX(), useMe.getMinY(), useMe.getMaxX(), useMe.getMaxY(), pt.getX(), pt.getY());
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        return null;
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        HashSet bounds = this.boxBounds(genome, item, layout, frc, true);
        if (bounds.isEmpty()) {
            return null;
        }
        Iterator bit = bounds.iterator();
        return (Rectangle)bit.next();
    }

    public boolean isGroupSubID(Intersection inter) {
        return inter.getSubID() instanceof LabelSubID;
    }

    public String getLabelID(Intersection inter) {
        return ((LabelSubID)inter.getSubID()).groupID;
    }

    public Intersection copyIntersection(Intersection inter) {
        LabelSubID lsid = (LabelSubID)inter.getSubID();
        LabelSubID newLsid = lsid != null ? new LabelSubID(lsid.groupID) : null;
        return new Intersection(inter, newLsid);
    }

    public Intersection[] getLabelIntersections(GenomeInstance gi, Group group) {
        ArrayList<Intersection> retvalHold = new ArrayList<Intersection>();
        String groupID = group.getID();
        retvalHold.add(new Intersection(groupID, new LabelSubID(groupID), 0.0));
        Set subsets = group.getSubsets(gi);
        Iterator sidit = subsets.iterator();
        while (sidit.hasNext()) {
            String subid = (String)sidit.next();
            retvalHold.add(new Intersection(groupID, new LabelSubID(subid), 0.0));
        }
        Intersection[] retval = new Intersection[retvalHold.size()];
        retvalHold.toArray(retval);
        return retval;
    }

    private HashSet boxBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, boolean onlyOne) {
        HashSet<Rectangle> retval = new HashSet<Rectangle>();
        String groupRef = item.getID();
        GroupProperties gp = layout.getGroupProperties(Group.getBaseID(groupRef));
        int style = gp.getStyle();
        int layer = gp.getLayer();
        int tpad = gp.getPadding(0);
        int bpad = gp.getPadding(1);
        int lpad = gp.getPadding(2);
        int rpad = gp.getPadding(3);
        String name = item.getName();
        Rectangle extent = null;
        TextRect tRect = null;
        if (gp.getHideLabelMode() == 1) {
            name = null;
        }
        if (((Group)item).getMemberCount() == 0 && (name == null || name.trim().equals(""))) {
            name = ResourceManager.getManager().getString("groupName.empty");
        }
        if (name != null && !name.trim().equals("")) {
            tRect = this.getTextRect(gp, true, name, frc);
        }
        if (style == 0) {
            if (tRect != null) {
                extent = tRect.textRect;
            }
            boolean haveMember = false;
            Iterator mit = ((Group)item).getMemberIterator();
            while (mit.hasNext()) {
                GroupMember member = (GroupMember)mit.next();
                String nodeID = member.getID();
                Node node = genome.getNode(nodeID);
                NodeProperties np = layout.getNodeProperties(nodeID);
                if (np == null) continue;
                haveMember = true;
                INodeRenderer rend = np.getRenderer();
                Rectangle bounds = rend.getBounds(genome, node, layout, frc, null);
                if (layer >= 1 && layer <= 10 && !onlyOne) {
                    Bounds.padBounds(bounds, tpad, bpad, lpad, rpad);
                    retval.add(bounds);
                    continue;
                }
                if (extent == null) {
                    extent = bounds;
                    continue;
                }
                Bounds.tweakBounds(extent, bounds);
            }
            Rectangle modBounds = this.moduleBoxBounds(genome, item, layout);
            if (modBounds != null) {
                if (extent == null) {
                    extent = modBounds;
                } else {
                    Bounds.tweakBounds(extent, modBounds);
                }
            }
            this.subLabelBoxBounds(genome, item, layout, frc, extent);
            if ((layer == 0 || onlyOne) && extent != null) {
                Bounds.padBounds(extent, tpad, bpad, lpad, rpad);
                if (!haveMember) {
                    Bounds.padBounds(extent, 100, 0, 0, 0);
                }
                retval.add(extent);
            }
        }
        return retval;
    }

    private Rectangle moduleBoxBounds(Genome genome, GenomeItem item, Layout layout) {
        Rectangle extent = null;
        HashSet attached = new HashSet();
        new FullGenomeHierarchyOracle().getModulesAttachedToGroup((GenomeInstance)genome, item.getID(), attached);
        Iterator ait = attached.iterator();
        while (ait.hasNext()) {
            NetModule.FullModuleKey fmk = (NetModule.FullModuleKey)ait.next();
            NetOverlayProperties nop = layout.getNetOverlayProperties(fmk.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fmk.modKey);
            Rectangle sob = nmp.shapeOnlyBounds();
            if (sob == null) continue;
            if (extent == null) {
                extent = sob;
                continue;
            }
            Bounds.tweakBounds(extent, sob);
        }
        return extent;
    }

    private void subLabelBoxBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle currBounds) {
        Group group = (Group)item;
        GenomeInstance gi = (GenomeInstance)genome;
        Set subsets = group.getSubsets(gi);
        Iterator sidit = subsets.iterator();
        while (sidit.hasNext()) {
            boolean hideLabel;
            String subid = (String)sidit.next();
            GroupProperties gps = layout.getGroupProperties(Group.getBaseID(subid));
            if (gps == null) {
                return;
            }
            Group sub = gi.getGroup(subid);
            String name = sub.getName();
            boolean bl = hideLabel = gps.getHideLabelMode() == 1;
            if (name == null || hideLabel) continue;
            TextRect tRect = this.getTextRect(gps, true, name, frc);
            Bounds.tweakBounds(currBounds, tRect.textRect);
        }
    }

    public static class ColoredRect {
        public Rectangle rect;
        public Color drawColor;

        public ColoredRect(Rectangle rect, Color drawColor) {
            this.rect = rect;
            this.drawColor = drawColor;
        }
    }

    public static class ExtraInfo {
        public boolean genomeIsRoot;
        public Integer vizVal;
        public boolean dropName;
        public String replacementName;
        public Color replacementColor;
    }

    public static class AugmentedExtraInfo {
        public ExtraInfo extra;
        public List passOut;
    }

    private class TextRect {
        double nameX;
        double nameY;
        Font mFont;
        Font bFont;
        Rectangle2D tbounds;
        Rectangle2D rect;
        Rectangle textRect;
        Rectangle extent;

        private TextRect() {
        }
    }

    private class NameAndBoldAndEmpty {
        String name;
        boolean doBold;
        boolean isEmpty;

        NameAndBoldAndEmpty(String name, boolean doBold, boolean isEmpty) {
            this.name = name;
            this.doBold = doBold;
            this.isEmpty = isEmpty;
        }
    }

    private class LabelSubID {
        String groupID;

        LabelSubID(String groupID) {
            this.groupID = groupID;
        }
    }
}

