/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NodeRenderBase;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class IntercellFree
extends NodeRenderBase {
    private static final float ARROW_HALF_HEIGHT_ = 8.0f;
    private static final float ARROW_LENGTH_ = 8.0f;
    private static final float ARROW_OFFSET_ = 10.0f;
    private static final double INTERSECT_SQ_ = 225.0;
    private static final double INTERSECT_ = 15.0;
    private static final double SELECT_ = 12.0;
    private static final double TEXT_PAD_ = 12.0;
    private static final float PAD_WIDTH_ = 10.0f;
    private static final double PAD_SPACING_ = 10.0;
    private static final double EXTRA_PAD_START_OFFSET_ = 20.0;
    private static final double EXTRA_BOX_HEIGHT_ = 6.0;
    private static final double SELECT_EXTRA_BOX_HEIGHT_ = 10.0;
    private static final double APPROX_DIAM_ = 20.0;
    private static final int STROKE_ = 3;

    public Vector2D getDepartureDirection(int padNum, GenomeItem item, Layout layout) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        AffineTransform rot = this.getRotationTransform(orient);
        Vector2D rightDepart = new Vector2D(1.0, 0.0);
        return rightDepart.doTransform(rot);
    }

    public Vector2D getArrivalDirection(int padNum, GenomeItem item, Layout layout) {
        if (padNum >= 0) {
            return this.getDepartureDirection(padNum, item, layout);
        }
        Vector2D stdArrive = -padNum % 2 == 0 ? new Vector2D(0.0, -1.0) : new Vector2D(0.0, 1.0);
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        AffineTransform rot = this.getRotationTransform(orient);
        return stdArrive.doTransform(rot);
    }

    public Rectangle getNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        int defaultPads;
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()))) {
            return this.getExtraPadNonExpansionRegion(genome, item, layout, frc);
        }
        return super.getNonExpansionRegion(genome, item, layout, frc);
    }

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        int orient = np.getOrientation();
        Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
        boolean textGhosted = isGhosted;
        if (item instanceof NodeInstance) {
            int activityLevel = ((NodeInstance)item).getActivity();
            isGhosted = isGhosted || activityLevel == 3 || activityLevel == 1;
            textGhosted = isGhosted && activityLevel != 3;
        }
        Color col1Val = np.getColor();
        Color vac = this.getVariableActivityColor(item, col1Val, false, dopt);
        Color col = isGhosted ? Color.LIGHT_GRAY : vac;
        Color col2Val = np.getSecondColor();
        col2Val = col2Val == null ? col1Val : col2Val;
        Color vac2 = this.getVariableActivityColor(item, col2Val, false, dopt);
        Color col2 = isGhosted ? Color.LIGHT_GRAY : vac2;
        Color textCol = this.getVariableActivityColor(item, Color.BLACK, true, dopt);
        AffineTransform saveTrans = g2.getTransform();
        AffineTransform trans = this.getRotationTransform(orient, origin);
        g2.transform(trans);
        this.roundSelectionSupport(g2, selected, x, y, 12.0);
        Rectangle2D extraRect = this.extraPadRectangle(item, layout);
        if (selected != null && extraRect != null) {
            this.paintExtra(g2, extraRect, 10.0);
        }
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(3.0f, 1, 0));
        GeneralPath path = new GeneralPath();
        path.moveTo(x - 8.0f, y - 8.0f);
        path.lineTo(x, y);
        path.lineTo(x - 8.0f, y + 8.0f);
        g2.draw(path);
        g2.setPaint(col2);
        path.reset();
        path.moveTo(x - 8.0f + 10.0f, y - 8.0f);
        path.lineTo(x + 10.0f, y);
        path.lineTo(x - 8.0f + 10.0f, y + 8.0f);
        g2.draw(path);
        if (extraRect != null) {
            g2.setPaint(col);
            this.paintExtra(g2, extraRect, 6.0);
        }
        g2.setTransform(saveTrans);
        FontRenderContext frc = g2.getFontRenderContext();
        if (showBubbles) {
            this.renderPads(g2, isGhosted ? Color.LIGHT_GRAY : Color.BLACK, item, layout, frc);
        }
        g2.setPaint(textGhosted ? Color.LIGHT_GRAY : textCol);
        Point2D textEnd = this.renderText(g2, (float)((double)x + 12.0), (float)((double)y - 12.0), item.getName(), np.getHideName(), mFont, np.getLineBreakDef());
        Point2D.Double pieCenter = new Point2D.Double(textEnd.getX() + 15.0, textEnd.getY());
        this.drawVariableActivityPie(g2, item, col, pieCenter, dopt);
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        int defaultPads;
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double x = origin.getX();
        double y = origin.getY();
        double dx = x - pt.getX();
        double dy = y - pt.getY();
        double distsq = dx * dx + dy * dy;
        String name = item.getName();
        if (name != null && !name.trim().equals("") && this.isTextCandidate(frc, 1, np.getFontOverride(), name, 12.0, dx, distsq, np.getLineBreakDef(), false, np.getHideName()) && this.intersectTextLabel(frc, (float)(x + 12.0), (float)(y - 12.0), name, pt, np.getHideName(), 1, np.getFontOverride(), np.getLineBreakDef())) {
            return new Intersection(item.getID(), null, 0.0);
        }
        double quickSq = 225.0;
        Node theInter = (Node)item;
        int numPads = theInter.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theInter.getNodeType()))) {
            int extraPads = numPads - defaultPads;
            double quickRad = 1.25 * (20.0 + (double)((extraPads + 1) / 2) * 10.0);
            quickSq = quickRad * quickRad;
        }
        if (distsq > quickSq) {
            return null;
        }
        Rectangle2D bounds = this.getBoundsWithExtraPads(item, layout);
        if (Bounds.intersects((bounds = UiUtil.padTheRect(bounds, 5.0)).getX(), bounds.getY(), bounds.getMaxX(), bounds.getMaxY(), pt.getX(), pt.getY())) {
            List pads = this.calcPadIntersects(item, layout, frc, pt);
            if (pads != null) {
                return new Intersection(item.getID(), pads);
            }
            return new Intersection(item.getID(), null, Math.sqrt(distsq));
        }
        return null;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        double cY;
        Rectangle2D.Double inbounds = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double cX = origin.getX();
        Rectangle2D.Double myBounds = new Rectangle2D.Double(cX - 15.0, (cY = origin.getY()) - 15.0, 30.0, 30.0);
        if (inbounds.contains(myBounds)) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Vector2D getLaunchPadOffset(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        return this.getLaunchPadOffsetGuts(orient);
    }

    private Vector2D getLaunchPadOffsetGuts(int orient) {
        AffineTransform rot = this.getRotationTransform(orient);
        Vector2D rightDepart = new Vector2D(10.0, 0.0);
        return rightDepart.doTransform(rot);
    }

    public Vector2D getLandingPadOffset(int padNum, GenomeItem item, int sign, Layout layout, FontRenderContext frc) {
        Vector2D offVec;
        Rectangle2D extra = this.extraPadRectangle(item, layout);
        if (padNum >= 0) {
            if (extra == null) {
                return new Vector2D(0.0, 0.0);
            }
            offVec = new Vector2D(-extra.getWidth(), 0.0);
        } else {
            float negPosTweak = 0.0f;
            if (sign == -1) {
                negPosTweak = 3.0f;
            } else if (sign == 1) {
                negPosTweak = 4.0f;
            }
            double baseOffset = 2.0;
            double finalOffset = baseOffset + (double)negPosTweak;
            double yOff = -padNum % 2 == 0 ? finalOffset : -finalOffset;
            double xOff = -(20.0 + (double)((-padNum - 1) / 2) * 10.0);
            offVec = new Vector2D(xOff, yOff);
        }
        NodeProperties np = layout.getNodeProperties(item.getID());
        int orient = np.getOrientation();
        AffineTransform rot = this.getRotationTransform(orient);
        return offVec.doTransform(rot);
    }

    public double getLandingPadWidth(int padNum, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 8.0;
    }

    public int getFixedLaunchPadMax() {
        return 1;
    }

    public int getFixedLandingPadMax() {
        return 1;
    }

    public boolean landingPadsCanOverflow() {
        return true;
    }

    public boolean sharedPadNamespaces() {
        return false;
    }

    public NodeInsertionDirective getInsertionDirective(Vector2D travel, Point2D insertion) {
        if (travel.getX() == 0.0) {
            if (travel.getY() < 0.0) {
                return new NodeInsertionDirective(0, 0, 3);
            }
            return new NodeInsertionDirective(0, 0, 4);
        }
        if (travel.getY() == 0.0) {
            if (travel.getX() < 0.0) {
                return new NodeInsertionDirective(0, 0, 1);
            }
            return new NodeInsertionDirective(0, 0, 2);
        }
        if (Math.abs(travel.getX()) >= Math.abs(travel.getY())) {
            if (travel.getX() > 0.0) {
                return new NodeInsertionDirective(0, 0, 2);
            }
            return new NodeInsertionDirective(0, 0, 1);
        }
        if (travel.getY() > 0.0) {
            return new NodeInsertionDirective(0, 0, 4);
        }
        return new NodeInsertionDirective(0, 0, 3);
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        Rectangle2D r2d = this.getBoundsWithExtraPads(item, layout);
        return new Rectangle((int)r2d.getX(), (int)r2d.getY(), (int)r2d.getWidth(), (int)r2d.getHeight());
    }

    public Rectangle2D getBoundsForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int orientation, boolean labelToo, Integer topPadCount) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Node theBox = (Node)item;
        int type = theBox.getNodeType();
        int totalPads = topPadCount == null ? theBox.getPadCount() : topPadCount * 2 + 1;
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Rectangle2D basic = this.getBoundsWithExtraPadsGuts(origin, totalPads, orientation, type);
        if (labelToo && !np.getHideName()) {
            Font mFont = FontManager.getMgr().getOverrideFont(1, np.getFontOverride());
            String breakDef = np.getLineBreakDef();
            Rectangle2D textRect = this.getTextBounds(frc, 12.0f, 12.0f, item.getName(), false, mFont, breakDef);
            Rectangle fullRect = UiUtil.rectFromRect2D(textRect);
            Rectangle basicAsRect = UiUtil.rectFromRect2D(basic);
            return fullRect.union(basicAsRect);
        }
        return basic;
    }

    public Vector2D getLaunchPadOffsetForLayout(GenomeItem item, Layout layout, FontRenderContext frc, int orientation, Integer topPadCount) {
        return this.getLaunchPadOffsetGuts(orientation);
    }

    public int topPadCount(int fullPadCount) {
        return (fullPadCount - fullPadCount % 2) / 2;
    }

    public double getHeight(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        Rectangle2D extra = this.extraPadRectangle(item, layout);
        if (extra != null) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            int orient = np.getOrientation();
            if (orient == 2 || orient == 1) {
                return 20.0;
            }
            return 10.0 + extra.getWidth();
        }
        return 20.0;
    }

    public double getGlyphHeightForLayout(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return 20.0;
    }

    public double getWidth(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        Rectangle2D extra = this.extraPadRectangle(item, layout);
        if (extra != null) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            int orient = np.getOrientation();
            if (orient == 3 || orient == 4) {
                return 20.0;
            }
            return 10.0 + extra.getWidth();
        }
        return 20.0;
    }

    public double getExtraLength(Node node, Genome genome, int newCount, boolean oneSideOnly) {
        int padDiff;
        int currPadCount = node.getPadCount();
        if (oneSideOnly) {
            currPadCount /= 2;
        }
        double extra = (padDiff = newCount - currPadCount) <= 0 ? 0.0 : 10.0 * (double)padDiff;
        return 2.0 * extra;
    }

    public int getBottomPad(GenomeItem item) {
        return -2;
    }

    public int getBestTopPad(GenomeItem item, Set usedPads, int expandDir, int totalNeeded, boolean startFromLeft) {
        int firstOnLeft;
        if (startFromLeft) {
            firstOnLeft = (totalNeeded - 1) * -2 - 1;
            Integer firstChoice = new Integer(firstOnLeft);
            if (!usedPads.contains(firstChoice)) {
                usedPads.add(firstChoice);
                return firstOnLeft;
            }
        } else {
            Integer firstChoice = new Integer(-1);
            if (!usedPads.contains(firstChoice)) {
                usedPads.add(firstChoice);
                return -1;
            }
        }
        if (startFromLeft) {
            int truePadNum = firstOnLeft = (totalNeeded - 1) * -2 - 1;
            while (true) {
                Integer checkChoice;
                if (!usedPads.contains(checkChoice = new Integer(truePadNum))) {
                    usedPads.add(checkChoice);
                    return truePadNum;
                }
                truePadNum += 2;
            }
        }
        int truePadNum = -1;
        while (true) {
            Integer checkChoice;
            if (!usedPads.contains(checkChoice = new Integer(truePadNum))) {
                usedPads.add(checkChoice);
                return truePadNum;
            }
            truePadNum -= 2;
        }
    }

    public int comparePads(int padOne, int padTwo) {
        if (padOne == padTwo) {
            return 0;
        }
        if (padOne == 0) {
            return -1;
        }
        if (padTwo == 0) {
            return 1;
        }
        int xOne = (-padOne - 1) / 2;
        int xTwo = (-padTwo - 1) / 2;
        if (xOne == xTwo) {
            int yOne = -padOne % 2 == 0 ? 1 : -1;
            int yTwo = -padTwo % 2 == 0 ? 1 : -1;
            return yOne - yTwo;
        }
        return xTwo - xOne;
    }

    public List getNearbyPads(GenomeItem item, int startPad, Layout layout) {
        int firstPad;
        if (!this.haveExtraPads(item) || startPad == 0) {
            return null;
        }
        MinMax range = this.getTargetPadRange(item);
        int count = 0;
        HashMap<Integer, Integer> distances = new HashMap<Integer, Integer>();
        for (int i = firstPad = -startPad % 2 == 0 ? range.min : range.min + 1; i < 0; i += 2) {
            Integer nextPad = new Integer(i);
            Integer nextDist = new Integer(count++);
            distances.put(nextPad, nextDist);
        }
        return this.alternationSupport(distances, startPad);
    }

    private void renderPads(Graphics2D g2, Color col, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(1.0f));
        Vector2D lpo = this.getLaunchPadOffset(0, item, layout, frc);
        double x = origin.getX() + lpo.getX();
        double y = origin.getY() + lpo.getY();
        double padRadius = 4.0;
        Ellipse2D.Double circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
        g2.draw(circ);
        lpo = this.getLandingPadOffset(0, item, 1, layout, frc);
        x = origin.getX() + lpo.getX();
        y = origin.getY() + lpo.getY();
        circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
        g2.draw(circ);
        Node theInter = (Node)item;
        int numPads = theInter.getPadCount();
        int defaultPads = DBNode.getDefaultPadCount(theInter.getNodeType());
        if (numPads > defaultPads) {
            int extraPads = numPads - defaultPads;
            for (int i = 1; i <= extraPads; ++i) {
                int negPadNum = -i;
                lpo = this.getLandingPadOffset(negPadNum, item, 1, layout, frc);
                x = origin.getX() + lpo.getX();
                y = origin.getY() + lpo.getY();
                circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
                g2.draw(circ);
            }
        }
    }

    private List calcPadIntersects(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt) {
        Point2D splitPt;
        Vector2D clickVec;
        ArrayList<Intersection.PadVal> retval = new ArrayList<Intersection.PadVal>();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double px = pt.getX();
        double py = pt.getY();
        Vector2D lpo = this.getLaunchPadOffset(0, item, layout, frc);
        double dot = lpo.dot(clickVec = new Vector2D(splitPt = lpo.scaled(0.5).add(origin), pt));
        if (dot >= 0.0) {
            double x = origin.getX() + lpo.getX();
            double y = origin.getY() + lpo.getY();
            double distSq = (px - x) * (px - x) + (py - y) * (py - y);
            Intersection.PadVal retpad = new Intersection.PadVal();
            retpad.okEnd = false;
            retpad.okStart = true;
            retpad.padNum = 0;
            retpad.distance = Math.sqrt(distSq);
            retval.add(retpad);
            return retval;
        }
        lpo = this.getLandingPadOffset(0, item, 1, layout, frc);
        double x = origin.getX() + lpo.getX();
        double y = origin.getY() + lpo.getY();
        double distSq = (px - x) * (px - x) + (py - y) * (py - y);
        Intersection.PadVal retpad = new Intersection.PadVal();
        retpad.okEnd = true;
        retpad.okStart = false;
        retpad.padNum = 0;
        retpad.distance = Math.sqrt(distSq);
        retval.add(retpad);
        Node theInter = (Node)item;
        int numPads = theInter.getPadCount();
        int defaultPads = DBNode.getDefaultPadCount(theInter.getNodeType());
        if (numPads > defaultPads) {
            int extraPads = numPads - defaultPads;
            for (int i = 1; i <= extraPads; ++i) {
                int negPadNum = -i;
                lpo = this.getLandingPadOffset(negPadNum, item, 1, layout, frc);
                x = origin.getX() + lpo.getX();
                y = origin.getY() + lpo.getY();
                distSq = (px - x) * (px - x) + (py - y) * (py - y);
                retpad = new Intersection.PadVal();
                retpad.okEnd = true;
                retpad.okStart = false;
                retpad.padNum = negPadNum;
                retpad.distance = Math.sqrt(distSq);
                retval.add(retpad);
            }
        }
        return retval.isEmpty() ? null : retval;
    }

    protected Rectangle2D extraPadRectangle(GenomeItem item, Layout layout) {
        Node theBubble = (Node)item;
        int totalPads = theBubble.getPadCount();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        return this.extraPadRectangleForPads(totalPads, origin, theBubble.getNodeType());
    }

    private Rectangle2D extraPadRectangleForPads(int numPads, Point2D origin, int nodeType) {
        int defaultPads = DBNode.getDefaultPadCount(nodeType);
        if (numPads <= defaultPads) {
            return null;
        }
        int extraPerSide = (numPads - 1) / 2;
        double extraSize = 20.0 + (double)(extraPerSide - 1) * 10.0;
        double height = 6.0;
        double minX = origin.getX() - extraSize;
        double minY = origin.getY() - height / 2.0;
        return new Rectangle2D.Double(minX, minY, extraSize, height);
    }

    private AffineTransform getRotationTransform(int orient, Point2D origin) {
        float x = (float)origin.getX();
        float y = (float)origin.getY();
        AffineTransform trans = new AffineTransform();
        double radians = 0.0;
        if (orient == 2) {
            radians = 0.0;
        } else if (orient == 3) {
            radians = -1.5707963267948966;
        } else if (orient == 1) {
            radians = Math.PI;
        } else if (orient == 4) {
            radians = 1.5707963267948966;
        }
        trans.rotate(radians, x, y);
        return trans;
    }

    private AffineTransform getRotationTransform(int orient) {
        AffineTransform trans = new AffineTransform();
        double radians = 0.0;
        if (orient == 2) {
            radians = 0.0;
        } else if (orient == 3) {
            radians = -1.5707963267948966;
        } else if (orient == 1) {
            radians = Math.PI;
        } else if (orient == 4) {
            radians = 1.5707963267948966;
        }
        trans.rotate(radians);
        return trans;
    }

    private Rectangle2D getBoundsWithExtraPads(GenomeItem item, Layout layout) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        int orient = np.getOrientation();
        Node theInter = (Node)item;
        int totalPads = theInter.getPadCount();
        return this.getBoundsWithExtraPadsGuts(origin, totalPads, orient, theInter.getNodeType());
    }

    private Rectangle2D getBoundsWithExtraPadsGuts(Point2D origin, int totalPads, int orient, int nodeType) {
        double x = origin.getX();
        double y = origin.getY();
        double half = 10.0;
        Rectangle2D extra = this.extraPadRectangleForPads(totalPads, origin, nodeType);
        if (extra != null) {
            if (orient == 2) {
                return new Rectangle2D.Double(x - extra.getWidth(), y - half, extra.getWidth() + half, 20.0);
            }
            if (orient == 3) {
                return new Rectangle2D.Double(x - half, y - half, 20.0, extra.getWidth() + half);
            }
            if (orient == 1) {
                return new Rectangle2D.Double(x - half, y - half, extra.getWidth() + half, 20.0);
            }
            if (orient == 4) {
                return new Rectangle2D.Double(x - half, y - extra.getWidth(), 20.0, extra.getWidth() + half);
            }
            throw new IllegalStateException();
        }
        return new Rectangle2D.Double(x - half, y - half, 20.0, 20.0);
    }

    private void paintExtra(Graphics2D g2, Rectangle2D extraRect, double diameter) {
        GeneralPath path = new GeneralPath();
        float radius = (float)diameter / 2.0f;
        g2.setStroke(new BasicStroke(1.0f, 1, 0));
        path.moveTo((float)extraRect.getX(), (float)extraRect.getCenterY() - radius);
        path.lineTo((float)extraRect.getMaxX() - 3.0f, (float)extraRect.getCenterY() - radius);
        path.lineTo((float)extraRect.getMaxX(), (float)extraRect.getCenterY());
        path.lineTo((float)extraRect.getMaxX() - 3.0f, (float)extraRect.getCenterY() + radius);
        path.lineTo((float)extraRect.getX(), (float)extraRect.getCenterY() + radius);
        path.closePath();
        g2.fill(path);
        Arc2D.Double arc1 = new Arc2D.Double((double)((float)extraRect.getX()) - diameter / 2.0, (float)extraRect.getCenterY() - radius, diameter, diameter, 90.0, 180.0, 1);
        g2.fill(arc1);
    }
}

