/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.ItemRenderBase;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.DrawTree;
import org.systemsbiology.biotapestry.ui.freerender.DrawTreeModelDataSource;
import org.systemsbiology.biotapestry.ui.freerender.MultiSubID;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridRenderer;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridSupport;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LinkageFree
extends ItemRenderBase
implements DrawTreeModelDataSource,
PlacementGridRenderer {
    private static final double INTERSECT_TOL = 5.0;
    private static final int NEG_THICK_ = 2;
    private static final double PLUS_ARROW_DEPTH_ = 8.0;
    private static final double POSITIVE_DROP_OFFSET_ = 7.0;
    private static final double PLUS_ARROW_HALF_WIDTH_ = 5.0;
    private static final double TIP_FUDGE_ = 5.0;
    private static final double LEVEL_FUDGE_ = 17.0;
    private static final double LEVEL_FUDGE_NEG_ = 9.0;

    public void renderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set skipLinks, OverlayStateOracle oso, String overID) {
        new PlacementGridSupport().renderToPlacementGrid(genome, lp, layout, frc, grid, skipLinks, oso, overID);
    }

    public boolean canRenderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set dropSet, OverlayStateOracle oso, String overID) {
        return new PlacementGridSupport().canRenderToPlacementGrid(genome, lp, layout, frc, grid, dropSet, oso, overID);
    }

    public Map getPointPairMap(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, OverlayStateOracle oso, String overID) {
        return new PlacementGridSupport().getPointPairMap(genome, lp, layout, frc, oso, overID);
    }

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        BusProperties lp = layout.getLinkProperties(item.getID());
        FontRenderContext frc = g2.getFontRenderContext();
        BusProperties bp = lp;
        DisplayOptions dop = ((AugmentedDisplayOptions)miscInfo).opts;
        DrawTree dTree = new DrawTree(genome, bp, this, layout, frc, selected, dop, null);
        dTree.renderToCache(cache, genome, this, layout, frc, bp, isGhosted, showBubbles, ((AugmentedDisplayOptions)miscInfo).skipDrops, dop, clipRect, pixDiam);
        Font mFont = FontManager.getMgr().getFont(4);
        String label = bp.getLabel(genome);
        if (label != null && !label.trim().equals("")) {
            Point2D txtLoc = lp.getTextPosition();
            float txtX = txtLoc == null ? 0.0f : (float)txtLoc.getX();
            float txtY = txtLoc == null ? 0.0f : (float)txtLoc.getY();
            int txtDir = lp.getTextDirection();
            double radians = 0.0;
            if (txtDir == 1) {
                radians = 0.0;
            } else if (txtDir == 3) {
                radians = -1.5707963267948966;
            } else if (txtDir == 4) {
                radians = 1.5707963267948966;
            } else if (txtDir == 2) {
                radians = Math.PI;
            }
            AffineTransform trans = new AffineTransform();
            trans.rotate(radians, txtX, txtY);
            Color textCol = isGhosted ? Color.LIGHT_GRAY : lp.getColor();
            RenderObjectCache.ModalShape ms = new RenderObjectCache.ModalShape(label, textCol, mFont, trans, txtX, txtY);
            cache.addObject(ms, DrawTree.ACTIVE_PATH_LAYER, DrawTree.MINOR_TEXT_LAYER);
        }
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        return this.intersectBusForSelectedDrops(genome, item, layout, frc, pt, pixDiam, null);
    }

    public Intersection intersectBusForSelectedDrops(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Set omittedDrops) {
        BusProperties bp = layout.getLinkProperties(item.getID());
        double useDiam = 2.0 * pixDiam > 5.0 ? 2.0 * pixDiam : 5.0;
        LinkProperties.DistancedLinkSegID dslsid = bp.intersectBusSegment(genome, null, layout, pt, frc, omittedDrops, useDiam);
        return dslsid == null ? null : new Intersection(item.getID(), new MultiSubID(dslsid.segID), dslsid.distance, true);
    }

    public Intersection fullIntersection(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, boolean includeRoot) {
        MultiSubID retSub = null;
        BusProperties bp = layout.getLinkProperties(item.getID());
        List segs = bp.getAllBusLinkSegments(genome, null, layout, includeRoot, frc);
        Iterator sit = segs.iterator();
        while (sit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)sit.next();
            MultiSubID si = new MultiSubID(lsid);
            if (retSub == null) {
                retSub = si;
                continue;
            }
            retSub.merge(si);
        }
        return new Intersection(item.getID(), retSub, 0.0, true);
    }

    public Intersection pathIntersection(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        MultiSubID retSub = null;
        BusProperties bp = layout.getLinkProperties(item.getID());
        List segs = bp.getBusLinkSegmentsForOneLink(genome, null, item.getID());
        Iterator sit = segs.iterator();
        while (sit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)sit.next();
            MultiSubID si = new MultiSubID(lsid);
            if (retSub == null) {
                retSub = si;
                continue;
            }
            retSub.merge(si);
        }
        return new Intersection(item.getID(), retSub, 0.0, true);
    }

    public Intersection intersectionForSegmentIDs(String linkID, Set segIDs) {
        MultiSubID retSub = null;
        Iterator sit = segIDs.iterator();
        while (sit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)sit.next();
            MultiSubID si = new MultiSubID(lsid);
            if (retSub == null) {
                retSub = si;
                continue;
            }
            retSub.merge(si);
        }
        return new Intersection(linkID, retSub, 0.0, true);
    }

    public boolean isLinkageSubID(Intersection inter) {
        return inter.getSubID() instanceof MultiSubID;
    }

    public Intersection copyIntersection(Intersection inter) {
        MultiSubID msid = (MultiSubID)inter.getSubID();
        MultiSubID newMsid = msid != null ? new MultiSubID(msid) : null;
        return new Intersection(inter, newMsid);
    }

    public boolean intersectsLabel(Genome genome, GenomeItem item, LinkProperties lp, FontRenderContext frc, Point2D pt) {
        Rectangle2D bounds = this.labelBounds(genome, item, lp, frc);
        if (bounds == null) {
            return false;
        }
        return Bounds.intersects(bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getMaxY(), pt.getX(), pt.getY());
    }

    public boolean intersectsLabel(Genome genome, GenomeItem item, LinkProperties lp, FontRenderContext frc, Rectangle rect) {
        Rectangle2D bounds = this.labelBounds(genome, item, lp, frc);
        if (bounds == null) {
            return false;
        }
        Rectangle2D.Double testRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        return testRect.contains(bounds);
    }

    private Rectangle2D labelBounds(Genome genome, GenomeItem item, LinkProperties lp, FontRenderContext frc) {
        double minY;
        double maxY;
        double maxX;
        double minX;
        String label = ((BusProperties)lp).getLabel(genome);
        if (label == null || label.trim().equals("")) {
            return null;
        }
        Font mFont = FontManager.getMgr().getFont(4);
        Rectangle2D bounds = mFont.getStringBounds(label, frc);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Point2D txtLoc = lp.getTextPosition();
        float txtX = txtLoc == null ? 0.0f : (float)txtLoc.getX();
        float txtY = txtLoc == null ? 0.0f : (float)txtLoc.getY();
        int txtDir = lp.getTextDirection();
        if (txtDir == 1) {
            minX = txtX;
            maxX = (double)txtX + width;
            maxY = txtY;
            minY = (double)txtY - height;
        } else if (txtDir == 3) {
            minX = (double)txtX - height;
            maxX = txtX;
            maxY = txtY;
            minY = (double)txtY - width;
        } else if (txtDir == 4) {
            minX = txtX;
            maxX = (double)txtX + height;
            maxY = (double)txtY + width;
            minY = txtY;
        } else if (txtDir == 2) {
            minX = (double)txtX - width;
            maxX = txtX;
            maxY = (double)txtY + height;
            minY = txtY;
        } else {
            throw new IllegalStateException();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        Rectangle2D.Double testRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        MultiSubID retSub = null;
        String itemID = item.getID();
        BusProperties bp = layout.getLinkProperties(itemID);
        List segs = bp.intersectBusSegmentsWithRect(genome, null, layout, testRect, false, frc);
        Iterator sit = segs.iterator();
        while (sit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)sit.next();
            MultiSubID si = new MultiSubID(lsid);
            if (retSub == null) {
                retSub = si;
                continue;
            }
            retSub.merge(si);
        }
        return retSub == null ? null : new Intersection(item.getID(), retSub, 0.0, true);
    }

    public Intersection mergeIntersect(Intersection first, Intersection second) {
        if (!first.getObjectID().equals(second.getObjectID())) {
            throw new IllegalArgumentException();
        }
        MultiSubID sub1 = (MultiSubID)first.getSubID();
        MultiSubID sub2 = (MultiSubID)second.getSubID();
        if (sub1 == null || sub2 == null) {
            return new Intersection(first.getObjectID(), null, 0.0, true);
        }
        MultiSubID retSub = new MultiSubID();
        retSub.getParts().addAll(sub1.getParts());
        retSub.merge(sub2);
        return new Intersection(first.getObjectID(), retSub, 0.0, true);
    }

    public Intersection intersectComplement(Intersection first, Intersection second) {
        if (!first.getObjectID().equals(second.getObjectID())) {
            throw new IllegalArgumentException();
        }
        MultiSubID sub1 = (MultiSubID)first.getSubID();
        MultiSubID sub2 = (MultiSubID)second.getSubID();
        MultiSubID retSub = sub1.intersectComplement(sub2);
        return new Intersection(first.getObjectID(), retSub, 0.0, true);
    }

    public Intersection intersection(Intersection first, Intersection second) {
        if (!first.getObjectID().equals(second.getObjectID())) {
            throw new IllegalArgumentException();
        }
        MultiSubID sub1 = (MultiSubID)first.getSubID();
        MultiSubID sub2 = (MultiSubID)second.getSubID();
        MultiSubID retSub = sub1.intersection(sub2);
        return new Intersection(first.getObjectID(), retSub, 0.0, true);
    }

    public Rectangle getBoundsOfSegments(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, MultiSubID subIDs, boolean doLinkLabels) {
        String label;
        BusProperties bp = layout.getLinkProperties(item.getID());
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        ArrayList<LinkSegment> segsToCheck = new ArrayList<LinkSegment>();
        LinkSegmentID[] segsFromMulti = null;
        if (subIDs != null) {
            segsFromMulti = Intersection.segmentIDsFromMultiSubID(subIDs);
            for (int i = 0; i < segsFromMulti.length; ++i) {
                LinkSegment fakeSeg = bp.getSegmentGeometryForID(segsFromMulti[i], genome, layout, frc, true);
                segsToCheck.add(fakeSeg);
            }
        } else {
            Iterator sit = bp.getSegments();
            while (sit.hasNext()) {
                LinkSegment seg = (LinkSegment)sit.next();
                segsToCheck.add(seg);
            }
        }
        int numToCheck = segsToCheck.size();
        for (int i = 0; i < numToCheck; ++i) {
            LinkSegment seg = (LinkSegment)segsToCheck.get(i);
            Point2D pt = seg.getStart();
            double x = pt.getX();
            double y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if ((pt = seg.getEnd()) == null) continue;
            x = pt.getX();
            y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        if (subIDs == null && doLinkLabels && (label = bp.getLabel(genome)) != null && !label.trim().equals("")) {
            double txtY;
            Point2D txtLoc = bp.getTextPosition();
            double txtX = txtLoc == null ? 0.0 : txtLoc.getX();
            double d = txtY = txtLoc == null ? 0.0 : txtLoc.getY();
            if (txtX < minX) {
                minX = txtX;
            }
            if (txtY < minY) {
                minY = txtY;
            }
            if (txtX > maxX) {
                maxX = txtX;
            }
            if (txtY > maxY) {
                maxY = txtY;
            }
        }
        if (minX == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        return this.getBoundsOfSegments(genome, item, layout, frc, null, true);
    }

    public Rectangle getBoundsForSinglePath(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        BusProperties lp = layout.getLinkProperties(item.getID());
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        BusProperties bp = lp;
        Iterator dit = bp.getDrops();
        BusDrop itemDrop = null;
        String itemID = item.getID();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            String ref = drop.getTargetRef();
            if (ref == null || !ref.equals(itemID)) continue;
            itemDrop = drop;
            break;
        }
        Iterator sit = null;
        if (itemDrop != null) {
            sit = bp.getSegmentsToRoot(itemDrop).iterator();
        }
        if (sit == null) {
            return null;
        }
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            Point2D pt = seg.getStart();
            double x = pt.getX();
            double y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if ((pt = seg.getEnd()) == null) continue;
            x = pt.getX();
            y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        if (minX == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public DrawTreeModelDataSource.ModelLineStyleModulation getModelLineStyleModulation(Genome genome, DisplayOptions dOpt) {
        DrawTreeModelDataSource.ModelLineStyleModulation retval = new DrawTreeModelDataSource.ModelLineStyleModulation();
        retval.linkModulation = dOpt == null ? 0 : dOpt.getLinkActivity();
        retval.checkForActive = genome instanceof GenomeInstance;
        retval.branchRenderMode = dOpt == null ? 0 : dOpt.getBranchMode();
        retval.forModules = false;
        return retval;
    }

    public DrawTreeModelDataSource.LinkLineStyleModulation getLinkLineStyleModulation(Genome genome, DisplayOptions dOpt, String linkID, LinkProperties lp, OverlayStateOracle oso, DrawTreeModelDataSource.ModelLineStyleModulation modulationInfo) {
        if (!lp.linkIsInModel(genome, oso, linkID)) {
            return null;
        }
        Linkage link = genome.getLinkage(linkID);
        DrawTreeModelDataSource.LinkLineStyleModulation retval = new DrawTreeModelDataSource.LinkLineStyleModulation();
        int evidence = link.getTargetLevel();
        retval.perLinkForEvidence = dOpt == null ? null : dOpt.getEvidenceDrawChange(evidence);
        retval.sign = link.getSign();
        retval.perLinkActivity = null;
        retval.isActive = true;
        if (modulationInfo.checkForActive) {
            LinkageInstance li = (LinkageInstance)link;
            GenomeInstance gi = (GenomeInstance)genome;
            int linkageActivity = li.getActivity(gi);
            boolean bl = retval.isActive = linkageActivity != 1;
            if (modulationInfo.linkModulation != 0 && linkageActivity == 2) {
                retval.perLinkActivity = new Double(li.getActivityLevel(gi));
            }
        }
        retval.targetOffset = retval.sign == 1 ? 7.0 : 0.0;
        return retval;
    }

    public DrawTreeModelDataSource.ModelDataForTip getModelDataForTip(Genome genome, Layout layout, String linkID, LinkProperties lp, FontRenderContext frc, DisplayOptions dOpt) {
        DrawTreeModelDataSource.ModelDataForTip retval = new DrawTreeModelDataSource.ModelDataForTip();
        Linkage link = genome.getLinkage(linkID);
        retval.sign = link.getSign();
        Node node = genome.getNode(link.getTarget());
        NodeProperties nProp = layout.getNodeProperties(node.getID());
        INodeRenderer render = nProp.getRenderer();
        int land = link.getLandingPad();
        retval.padWidth = render.getLandingPadWidth(land, node, layout, frc);
        retval.arrival = render.getArrivalDirection(land, node, layout);
        Point2D trgLoc = nProp.getLocation();
        Vector2D lanPO = render.getLandingPadOffset(land, node, retval.sign, layout, frc);
        retval.lanLoc = lanPO.add(trgLoc);
        retval.negLength = retval.padWidth + (double)dOpt.getExtraFootSize();
        retval.negThick = Math.round((float)(2.0 * (retval.negLength / retval.padWidth)));
        boolean checkForActive = genome instanceof GenomeInstance;
        retval.isActive = checkForActive ? ((LinkageInstance)link).getActivity((GenomeInstance)genome) == 0 : true;
        retval.plusArrowDepth = 8.0;
        retval.positiveDropOffset = 7.0;
        retval.plusArrowHalfWidth = 5.0;
        retval.thickThick = 7.0;
        retval.tipFudge = 5.0;
        retval.levelFudge = retval.sign == -1 ? 9.0 : 17.0;
        int level = link.getTargetLevel();
        retval.hasDiamond = dOpt == null ? false : dOpt.drawEvidenceGlyphs(level);
        return retval;
    }

    public static class AugmentedDisplayOptions {
        public DisplayOptions opts;
        public Set skipDrops;

        public AugmentedDisplayOptions(DisplayOptions opts, Set skipDrops) {
            this.opts = opts;
            this.skipDrops = skipDrops;
        }
    }
}

