/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.Mergeable;

public class MultiSubID
implements Mergeable {
    private HashSet parts = new HashSet();

    public MultiSubID() {
    }

    public MultiSubID(MultiSubID other) {
        Iterator oit = other.parts.iterator();
        while (oit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)oit.next();
            this.parts.add(new LinkSegmentID(lsid));
        }
    }

    public MultiSubID(LinkSegmentID lsid) {
        this.parts.add(lsid);
    }

    public MultiSubID(Set lsidSet) {
        this.parts.addAll(lsidSet);
    }

    public Set getParts() {
        return this.parts;
    }

    public String toString() {
        return this.parts.toString();
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MultiSubID)) {
            return false;
        }
        MultiSubID otherMS = (MultiSubID)other;
        return this.parts.equals(otherMS.parts);
    }

    public boolean intersects(Mergeable other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MultiSubID)) {
            return false;
        }
        MultiSubID otherMS = (MultiSubID)other;
        HashSet intersect = new HashSet(this.parts);
        intersect.retainAll(otherMS.parts);
        return intersect.size() != 0;
    }

    public MultiSubID intersectComplement(MultiSubID other) {
        HashSet retset = new HashSet(this.parts);
        retset.addAll(other.parts);
        HashSet inter = new HashSet(this.parts);
        inter.retainAll(other.parts);
        retset.removeAll(inter);
        MultiSubID retval = new MultiSubID();
        retval.parts = retset;
        return retval;
    }

    public MultiSubID intersection(MultiSubID other) {
        HashSet inter = new HashSet(this.parts);
        inter.retainAll(other.parts);
        MultiSubID retval = new MultiSubID();
        retval.parts = inter;
        return retval;
    }

    public void merge(MultiSubID other) {
        this.parts.addAll(other.parts);
    }
}

