/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;

public class NetModuleAlphaBuilder {
    public static final int MINIMAL_ALL_MEMBER_VIZ = 50;
    private static final double LABEL_START_ = 1.0;
    private static final double LABEL_END_ = 0.8;
    private static final double LABEL_FLOOR_VAL_ = 0.0;
    private static final double FILL_START_ = 1.0;
    private static final double FILL_END_ = 0.5;
    private static final double FILL_FLOOR_VAL_ = 0.0;
    private static final double BOUND_START_ = 0.4;
    private static final double BOUND_END_ = 0.0;
    private static final double BOUND_FLOOR_VAL_ = 0.1;
    private static final double BACK_START_ = 0.6;
    private static final double BACK_END_ = 0.4;
    private static final double BACK_FLOOR_VAL_ = 0.0;

    public void alphaCalc(double masterVal, NetModuleFree.CurrentSettings settings) {
        if (masterVal < 0.0 || masterVal > 100.0) {
            throw new IllegalArgumentException();
        }
        double masterFraction = masterVal / 100.0;
        settings.regionFillAlpha = this.calcRegionFill(masterFraction);
        settings.regionBoundaryAlpha = this.calcRegionBoundary(masterFraction);
        settings.regionLabelAlpha = this.calcFastLabel(masterFraction);
        settings.fastDecayLabelVisible = settings.regionLabelAlpha > 0.0;
        settings.backgroundOverlayAlpha = this.calcBackground(masterFraction);
        double maskCutoff = 0.9;
        settings.intersectionMask = settings.regionFillAlpha > maskCutoff ? 2 : (settings.backgroundOverlayAlpha > maskCutoff ? 1 : 0);
    }

    public boolean modContentsMasked(NetModuleFree.CurrentSettings settings) {
        return settings.regionFillAlpha > 0.0;
    }

    private double calcRegionFill(double masterFraction) {
        return this.calcPiecewise(masterFraction, 1.0, 0.5, 0.0);
    }

    private double calcRegionBoundary(double masterFraction) {
        return this.calcPiecewise(masterFraction, 0.4, 0.0, 0.1);
    }

    private double calcFastLabel(double masterFraction) {
        return this.calcPiecewise(masterFraction, 1.0, 0.8, 0.0);
    }

    private double calcBackground(double masterFraction) {
        return this.calcPiecewise(masterFraction, 0.6, 0.4, 0.0);
    }

    private double calcPiecewise(double masterFraction, double startx, double endx, double yFloor) {
        if (masterFraction > startx) {
            return 1.0;
        }
        if (masterFraction < endx) {
            return yFloor;
        }
        double xfrac = (masterFraction - endx) / (startx - endx);
        double delY = 1.0 - yFloor;
        return yFloor + delY * xfrac;
    }
}

