/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.NodeBounder;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class NetModuleFree {
    public static final double PAD_SIZE = 10.0;
    public static final int PAD_SIZE_INT = 10;
    private static final double INTERSECT_TOL = 5.0;
    private static final double PAD_RADIUS = 5.0;
    private static final int PAD_PAD = 20;
    private static final double BIG_RADIUS = 20.0;
    private static final float DOT_ = 2.0f;
    private static final float DOT_SP_ = 6.0f;
    private static final float DASH_ = 8.0f;
    private static final float DASH_SP_ = 4.0f;
    private static final float LONG_DASH_ = 12.0f;
    private static final float LONG_DASH_SP_ = 4.0f;
    private final float[] dotPatternArray = new float[]{2.0f, 6.0f};
    private final float[] dashPatternArray = new float[]{8.0f, 4.0f};
    private final float[] longDashPatternArray = new float[]{12.0f, 4.0f};
    private static final int NORMAL_PADS_ = 0;
    private static final int ALL_BUT_CORNER_PADS_ = 1;
    private static final int ALL_PADS_ = 2;
    private FontRenderContext fixedFrc_ = new FontRenderContext(null, true, true);

    public void renderToPlacementGrid(Genome genome, DynamicInstanceProxy dip, Layout layout, NetModule module, String ovrID, LinkPlacementGrid grid) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        Iterator sit = nmp.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D rect = (Rectangle2D)sit.next();
            grid.addGroup(UiUtil.rectFromRect2D(rect), module.getID());
        }
    }

    public void render(Graphics2D g2, Genome genome, DynamicInstanceProxy dip, Set useGroups, Layout layout, String ovrID, NetModule module, CurrentSettings settings, boolean showComponents, boolean showBubbles, boolean showContents, Rectangle2D clipRect, double pixDiam) {
        boolean nameHiding;
        Shape boundArea;
        TaggedShape nextShape;
        int i;
        FontRenderContext frc = g2.getFontRenderContext();
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        boolean tinyPads = !(pixDiam < 20.0);
        ArrayList padList = showBubbles && !tinyPads ? new ArrayList() : null;
        int nopType = nop.getType();
        boolean isOpq = nopType == 1;
        float fillAlpha = showContents && isOpq ? 0.0f : (float)settings.regionFillAlpha;
        List shapeList = this.getShape(frc, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, showComponents, padList);
        boolean twoPass = false;
        if (isOpq) {
            if ((double)fillAlpha != 0.0) {
                g2.setComposite(AlphaComposite.Src);
            } else {
                g2.setComposite(AlphaComposite.Clear);
                twoPass = true;
            }
        }
        float[] coVals = new float[4];
        int numShape = shapeList.size();
        if (twoPass) {
            for (i = 0; i < numShape; ++i) {
                nextShape = (TaggedShape)shapeList.get(i);
                if (nextShape.shapeClass == 1 || nextShape.shapeClass == 3) continue;
                boundArea = nextShape.shape;
                g2.setPaint(Color.black);
                g2.fill(boundArea);
            }
            g2.setComposite(AlphaComposite.Src);
        }
        if (nopType == 1 || nopType == 2) {
            for (i = 0; i < numShape; ++i) {
                nextShape = (TaggedShape)shapeList.get(i);
                if (nextShape.shapeClass == 1 || nextShape.shapeClass == 3) continue;
                boundArea = nextShape.shape;
                if (nopType != 1 && nopType != 2) continue;
                Color fillCol = nmp.getFillColor();
                fillCol.getComponents(coVals);
                Color aDrawCol = new Color(coVals[0], coVals[1], coVals[2], fillAlpha);
                g2.setPaint(aDrawCol);
                g2.fill(boundArea);
            }
        }
        for (i = 0; i < numShape; ++i) {
            nextShape = (TaggedShape)shapeList.get(i);
            boundArea = nextShape.shape;
            BasicStroke useStroke = this.calcStroke(nmp.getType(), nextShape.shapeClass, showComponents);
            if (useStroke == null) continue;
            g2.setStroke(useStroke);
            Color borderCol = nmp.getColor();
            borderCol.getComponents(coVals);
            Color bDrawCol = new Color(coVals[0], coVals[1], coVals[2], (float)settings.regionBoundaryAlpha);
            g2.setPaint(bDrawCol);
            g2.draw(boundArea);
        }
        g2.setComposite(AlphaComposite.SrcOver);
        boolean quickFade = nmp.getNameFadeMode() == 0;
        boolean bl = nameHiding = showContents && isOpq && quickFade;
        if (nameBounds != null && !nameHiding) {
            Color textCol = Color.black;
            textCol.getComponents(coVals);
            float labelAlpha = quickFade ? (float)settings.regionLabelAlpha : (float)settings.regionBoundaryAlpha;
            Color tDrawCol = new Color(coVals[0], coVals[1], coVals[2], labelAlpha);
            String name = module.getName();
            Font bFont = FontManager.getMgr().getOverrideFont(6, nmp.getFontOverride());
            String breakDef = nmp.getLineBreakDef();
            if (breakDef == null) {
                g2.setPaint(tDrawCol);
                g2.setFont(bFont);
                Rectangle2D textBounds = bFont.getStringBounds(name, frc);
                double textX = nameBounds.getCenterX() - textBounds.getCenterX();
                double textY = nameBounds.getCenterY() - textBounds.getCenterY() * 0.8;
                g2.drawString(name, (float)textX, (float)textY);
            } else {
                Point2D nameLoc = nmp.getNameLoc();
                List frags = MultiLineRenderSupport.applyLineBreaksForFragments(name, breakDef);
                String[] toks = new String[frags.size()];
                frags.toArray(toks);
                MultiLineRenderSupport.multiLineRender(g2, frc, toks, bFont, nameLoc, false, 1, tDrawCol);
            }
        }
        if (padList != null) {
            ArrayList bubbleList = new ArrayList();
            this.bubbleShapesForPads(padList, bubbleList);
            Color padCol = Color.black;
            padCol.getComponents(coVals);
            Color bDrawCol = new Color(coVals[0], coVals[1], coVals[2], (float)settings.regionBoundaryAlpha);
            g2.setPaint(bDrawCol);
            g2.setStroke(new BasicStroke(1.0f));
            int numBub = bubbleList.size();
            for (int i2 = 0; i2 < numBub; ++i2) {
                Ellipse2D nextPad = (Ellipse2D)bubbleList.get(i2);
                g2.draw(nextPad);
            }
        }
    }

    public Rectangle bounds(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, FontRenderContext frc) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        this.getShape(frc, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, null);
        return outerRect;
    }

    public boolean intersects(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        List shapeList = this.getShape(frc, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, null);
        if (!outerRect.contains(pt)) {
            return false;
        }
        int numShape = shapeList.size();
        for (int i = 0; i < numShape; ++i) {
            Shape boundArea = ((TaggedShape)shapeList.get((int)i)).shape;
            if (!boundArea.contains(pt)) continue;
            return true;
        }
        return false;
    }

    public boolean nameInRegion(Intersection intersect, NetModule module, Layout layout, String ovrID, int mode, FontRenderContext frc) {
        Set shapes;
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        IntersectionExtraInfo ei = (IntersectionExtraInfo)intersect.getSubID();
        if (mode == 0) {
            shapes = nmp.rectsForDirect(ei);
        } else if (mode == 1) {
            shapes = ei.contigInfo.intersectedShape;
        } else {
            throw new IllegalArgumentException();
        }
        if (shapes == null || shapes.isEmpty()) {
            return false;
        }
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        if (nameBounds == null) {
            return false;
        }
        Iterator sit = shapes.iterator();
        while (sit.hasNext()) {
            Rectangle2D chkShape = (Rectangle2D)sit.next();
            Rectangle2D interRect = chkShape.createIntersection(nameBounds);
            if (!(interRect.getHeight() >= 0.0) || !(interRect.getWidth() >= 0.0)) continue;
            return true;
        }
        return false;
    }

    public Set membersInRegion(Intersection intersect, NetModule module, Layout layout, String ovrID, int mode) {
        Set shapes;
        HashSet<Object> retval = new HashSet<Object>();
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        IntersectionExtraInfo ei = (IntersectionExtraInfo)intersect.getSubID();
        if (mode == 0) {
            shapes = nmp.rectsForDirect(ei);
        } else if (mode == 1) {
            shapes = ei.contigInfo.intersectedShape;
            retval.addAll(ei.contigInfo.memberShapes.keySet());
        } else {
            throw new IllegalArgumentException();
        }
        if (shapes == null || shapes.isEmpty()) {
            return retval;
        }
        Iterator memit = module.getMemberIterator();
        while (memit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)memit.next();
            String nodeID = nmm.getID();
            if (retval.contains(nodeID)) continue;
            NodeProperties np = layout.getNodeProperties(nodeID);
            Point2D pt = np.getLocation();
            Iterator sit = shapes.iterator();
            while (sit.hasNext()) {
                Rectangle2D chkShape = (Rectangle2D)sit.next();
                if (!chkShape.contains(pt)) continue;
                retval.add(nodeID);
            }
        }
        return retval;
    }

    public List shapesFromIntersection(Intersection intersect, String moduleID, Layout layout, String ovrID, int mode, Rectangle outerBounds) {
        Set shapes;
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
        IntersectionExtraInfo ei = (IntersectionExtraInfo)intersect.getSubID();
        if (mode == 0) {
            shapes = nmp.rectsForDirect(ei);
        } else if (mode == 1) {
            shapes = ei.contigInfo.intersectedShape;
        } else {
            throw new IllegalArgumentException();
        }
        if (shapes == null) {
            outerBounds.setBounds(0, 0, 0, 0);
            return new ArrayList();
        }
        Area oneArea = null;
        Rectangle extent = null;
        Iterator sit = shapes.iterator();
        while (sit.hasNext()) {
            Rectangle2D nextRect = (Rectangle2D)sit.next();
            Area rectArea = new Area(nextRect);
            if (oneArea == null) {
                oneArea = rectArea;
            } else {
                oneArea.add(rectArea);
            }
            Rectangle eaRect = UiUtil.rectFromRect2D(nextRect);
            if (extent == null) {
                extent = eaRect;
                continue;
            }
            Bounds.tweakBounds(extent, eaRect);
        }
        if (extent == null) {
            outerBounds.setBounds(0, 0, 0, 0);
        } else {
            outerBounds.setBounds(extent);
        }
        ArrayList<Area> retval = new ArrayList<Area>();
        if (oneArea != null) {
            retval.add(oneArea);
        }
        return retval;
    }

    public List getModuleShapes(Genome ownerGenome, Genome genomeForShape, Set useGroups, Layout layout, String ovrID, String moduleID, FontRenderContext frc, Rectangle2D outerRectRet) {
        Database db = Database.getDB();
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(ownerGenome.getID());
        DynamicInstanceProxy dip = null;
        if (ownerGenome instanceof DynamicGenomeInstance) {
            dip = db.getDynamicProxy(((DynamicGenomeInstance)ownerGenome).getProxyID());
        }
        NetworkOverlay novr = owner.getNetworkOverlay(ovrID);
        NetModule mod = novr.getModule(moduleID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, mod, frc);
        List shapeList = this.getShape(frc, genomeForShape, dip, useGroups, layout, ovrID, mod, nameBounds, outerRect, nop, nmp, false, null);
        ArrayList<Shape> retval = new ArrayList<Shape>();
        int numShapes = shapeList.size();
        for (int i = 0; i < numShapes; ++i) {
            retval.add(((TaggedShape)shapeList.get((int)i)).shape);
        }
        outerRectRet.setRect(outerRect.getX(), outerRect.getY(), outerRect.getWidth(), outerRect.getHeight());
        return retval;
    }

    public Intersection intersectsName(NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        String moduleID;
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID = module.getID());
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        if (nameBounds != null && nameBounds.contains(pt)) {
            return new Intersection(moduleID, null, 0.0);
        }
        return null;
    }

    public Intersection intersectsLinkPad(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        String moduleID = module.getID();
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, this.fixedFrc_);
        ArrayList padList = new ArrayList();
        this.getShape(this.fixedFrc_, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, padList);
        int usePad = 2 * (int)pixDiam > 20 ? 2 * (int)pixDiam : 20;
        Rectangle padded = new Rectangle(outerRect.x - usePad, outerRect.y - usePad, outerRect.width + 2 * usePad, outerRect.height + 2 * usePad);
        if (!padded.contains(pt)) {
            return null;
        }
        LinkPad interPad = this.intersectsPad(padList, pt, pixDiam);
        if (interPad != null) {
            IntersectionExtraInfo ei = new IntersectionExtraInfo(interPad.point, interPad.getNormal());
            Intersection intersect = new Intersection(moduleID, ei, 0.0);
            return intersect;
        }
        return null;
    }

    public Intersection intersectsBoundary(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        String moduleID = module.getID();
        double[] coords = new double[6];
        Point2D.Double movePt = new Point2D.Double(0.0, 0.0);
        Point2D.Double startPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPt = new Point2D.Double(0.0, 0.0);
        LinkSegment seg = new LinkSegment(startPt, (Point2D)endPt);
        Intersection result = null;
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        ArrayList<Object> intersectedShape = new ArrayList<Object>();
        List shapeList = this.getShape(frc, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, true, null);
        int numShape = shapeList.size();
        for (int i = 0; i < numShape; ++i) {
            TaggedShape ts = (TaggedShape)shapeList.get(i);
            if (nmp.getType() == 2 ? ts.shapeClass != 2 && ts.shapeClass != 4 : ts.shapeClass != 0) continue;
            Shape boundArea = ts.shape;
            PathIterator pit = boundArea.getPathIterator(null);
            boolean haveIntersect = false;
            while (!pit.isDone()) {
                int segType = pit.currentSegment(coords);
                switch (segType) {
                    case 4: {
                        IntersectionExtraInfo ei;
                        ((Point2D)startPt).setLocation(coords[0], coords[1]);
                        intersectedShape.add(startPt.clone());
                        if (!haveIntersect) {
                            seg.setBoth(startPt, movePt);
                            result = this.checkSeg(seg, pt, moduleID, startPt, movePt, pixDiam);
                            if (result != null) {
                                ei = (IntersectionExtraInfo)result.getSubID();
                                this.fillBoundaryLocation(outerRect, nmp, ei);
                                haveIntersect = true;
                            }
                        }
                        if (!haveIntersect) break;
                        return this.fillOutIntersection(result, genome, module, layout, ovrID, frc, pt, pixDiam, intersectedShape, shapeList, nmp, nameBounds);
                    }
                    case 1: {
                        IntersectionExtraInfo ei;
                        ((Point2D)endPt).setLocation(coords[0], coords[1]);
                        intersectedShape.add(endPt.clone());
                        if (!haveIntersect) {
                            seg.setBoth(startPt, endPt);
                            result = this.checkSeg(seg, pt, moduleID, startPt, endPt, pixDiam);
                            if (result != null) {
                                ei = (IntersectionExtraInfo)result.getSubID();
                                this.fillBoundaryLocation(outerRect, nmp, ei);
                                haveIntersect = true;
                            }
                        }
                        ((Point2D)startPt).setLocation(coords[0], coords[1]);
                        break;
                    }
                    case 0: {
                        ((Point2D)movePt).setLocation(coords[0], coords[1]);
                        ((Point2D)startPt).setLocation(coords[0], coords[1]);
                        if (haveIntersect) {
                            return this.fillOutIntersection(result, genome, module, layout, ovrID, frc, pt, pixDiam, intersectedShape, shapeList, nmp, nameBounds);
                        }
                        intersectedShape.clear();
                        intersectedShape.add(startPt.clone());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                pit.next();
            }
            if (!haveIntersect) continue;
            return this.fillOutIntersection(result, genome, module, layout, ovrID, frc, pt, pixDiam, intersectedShape, shapeList, nmp, nameBounds);
        }
        return null;
    }

    private Intersection fillOutIntersection(Intersection result, Genome genome, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam, List intersectedShape, List shapeList, NetModuleProperties nmp, Rectangle2D nameBounds) {
        IntersectionExtraInfo ei = (IntersectionExtraInfo)result.getSubID();
        ei.contigInfo = nmp.rectsForContig(intersectedShape, shapeList);
        ei.directShape = nmp.directRectIntersect(pt, shapeList);
        if (ei.directShape != null) {
            ei.nonDirectAlternative = this.intersectsDefinitionBoundary(genome, module, layout, ovrID, frc, pt, pixDiam) != null;
        }
        ei.gotNameBounds = nameBounds != null && NetModuleProperties.matchRect(nameBounds, pt, 5.0) != 0;
        return result;
    }

    public Intersection intersectsDefinitionBoundary(Genome genome, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        String moduleID = module.getID();
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
        Point2D.Double startPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPt = new Point2D.Double(0.0, 0.0);
        LinkSegment seg = new LinkSegment(startPt, (Point2D)endPt);
        Iterator sit = nmp.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D rect = (Rectangle2D)sit.next();
            Point2D.Double topLeft = new Point2D.Double(rect.getX(), rect.getY());
            Point2D.Double topRight = new Point2D.Double(rect.getMaxX(), rect.getY());
            Point2D.Double bottomRight = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
            Point2D.Double bottomLeft = new Point2D.Double(rect.getX(), rect.getMaxY());
            seg.setBoth(topLeft, topRight);
            Intersection result = this.checkSeg(seg, pt, moduleID, topLeft, topRight, pixDiam);
            if (result != null) {
                return result;
            }
            seg.setBoth(topRight, bottomRight);
            result = this.checkSeg(seg, pt, moduleID, topRight, bottomRight, pixDiam);
            if (result != null) {
                return result;
            }
            seg.setBoth(bottomRight, bottomLeft);
            result = this.checkSeg(seg, pt, moduleID, bottomRight, bottomLeft, pixDiam);
            if (result != null) {
                return result;
            }
            seg.setBoth(bottomLeft, topLeft);
            result = this.checkSeg(seg, pt, moduleID, bottomLeft, topLeft, pixDiam);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Intersection intersectsInterior(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleProperties nmp = nop.getNetModuleProperties(module.getID());
        String moduleID = module.getID();
        double[] coords = new double[6];
        Point2D.Double nextPt = new Point2D.Double(0.0, 0.0);
        Rectangle outerRect = new Rectangle();
        ArrayList<Object> intersectedShape = new ArrayList<Object>();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        List shapeList = this.getShape(frc, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, true, null);
        if (!outerRect.contains(pt)) {
            return null;
        }
        GeneralPath subShape = new GeneralPath();
        int numShape = shapeList.size();
        for (int i = 0; i < numShape; ++i) {
            Shape boundArea;
            TaggedShape ts = (TaggedShape)shapeList.get(i);
            if ((nmp.getType() != 2 ? ts.shapeClass != 0 : ts.shapeClass != 2) || !(boundArea = ts.shape).contains(pt)) continue;
            subShape.reset();
            PathIterator pit = boundArea.getPathIterator(null);
            while (!pit.isDone()) {
                int segType = pit.currentSegment(coords);
                switch (segType) {
                    case 4: {
                        ((Point2D)nextPt).setLocation(coords[0], coords[1]);
                        intersectedShape.add(nextPt.clone());
                        subShape.closePath();
                        if (!subShape.contains(pt)) break;
                        IntersectionExtraInfo ei = new IntersectionExtraInfo((Point2D)pt.clone());
                        Intersection result = new Intersection(moduleID, ei, 0.0);
                        ei.contigInfo = nmp.rectsForContig(intersectedShape, shapeList);
                        return result;
                    }
                    case 1: {
                        ((Point2D)nextPt).setLocation(coords[0], coords[1]);
                        intersectedShape.add(nextPt.clone());
                        subShape.lineTo((float)coords[0], (float)coords[1]);
                        break;
                    }
                    case 0: {
                        ((Point2D)nextPt).setLocation(coords[0], coords[1]);
                        subShape.reset();
                        subShape.moveTo((float)coords[0], (float)coords[1]);
                        intersectedShape.clear();
                        intersectedShape.add(nextPt.clone());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                pit.next();
            }
        }
        return null;
    }

    public int getPadCountForModule(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, NetModuleProperties nmp, FontRenderContext frc) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, this.fixedFrc_);
        ArrayList padList = new ArrayList();
        this.getShape(this.fixedFrc_, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, padList);
        return padList.size();
    }

    public Set padsForModule(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, NetModuleProperties nmp, FontRenderContext frc) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, this.fixedFrc_);
        ArrayList padList = new ArrayList();
        this.getShape(this.fixedFrc_, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, padList);
        HashSet retval = new HashSet(padList);
        return retval;
    }

    public void needRowsAndCols(Genome genome, DynamicInstanceProxy dip, NetModule module, Layout layout, String ovrID, NetModuleProperties nmp, FontRenderContext frc, Rectangle bounds, SortedSet needRows, SortedSet needCols, Set usedPads) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        List shapeList = this.getShape(frc, genome, dip, null, layout, ovrID, module, nameBounds, outerRect, nop, nmp, true, null);
        int slnum = shapeList.size();
        for (int i = 0; i < slnum; ++i) {
            TaggedShape shape = (TaggedShape)shapeList.get(i);
            if (shape.shapeClass == 0 || shape.shapeClass == 1) {
                this.fillRowColNeeds((Area)shape.shape, bounds, needCols, needRows);
                continue;
            }
            if (shape.shapeClass != 2) continue;
            this.fillRectRowColNeeds(shape.rect, bounds, needCols, needRows, false);
        }
        if (nameBounds != null) {
            this.fillRectRowColNeeds(nameBounds, bounds, needCols, needRows, false);
        }
        Iterator upit = usedPads.iterator();
        while (upit.hasNext()) {
            Point2D padPt = (Point2D)upit.next();
            if (bounds != null && !bounds.contains(padPt)) continue;
            needCols.add(new Integer((int)padPt.getX() / 10));
            needRows.add(new Integer((int)padPt.getY() / 10));
        }
    }

    public void expansionExcludedRowsAndCols(Genome genome, DynamicInstanceProxy dip, NetModule module, Layout layout, String ovrID, NetModuleProperties nmp, FontRenderContext frc, Rectangle bounds, SortedSet excludeRows, SortedSet excludeCols, Set usedPads) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, frc);
        List shapeList = this.getShape(frc, genome, dip, null, layout, ovrID, module, nameBounds, outerRect, nop, nmp, true, null);
        TreeSet usedRows = new TreeSet();
        TreeSet usedCols = new TreeSet();
        int slnum = shapeList.size();
        if (nmp.getType() == 2) {
            if (!usedPads.isEmpty()) {
                for (int i = 0; i < slnum; ++i) {
                    TaggedShape shape = (TaggedShape)shapeList.get(i);
                    this.fillRectRowColNeeds(shape.rect, bounds, excludeCols, excludeRows, true);
                }
            }
            return;
        }
        for (int i = 0; i < slnum; ++i) {
            TaggedShape shape = (TaggedShape)shapeList.get(i);
            if (shape.shapeClass == 0 || shape.shapeClass == 1) {
                this.fillRowColNeeds((Area)shape.shape, bounds, usedCols, usedRows);
                break;
            }
            if (shape.shapeClass != 2) continue;
            this.fillRectRowColNeeds(shape.rect, bounds, excludeCols, excludeRows, true);
        }
        Iterator upit = usedPads.iterator();
        while (upit.hasNext()) {
            Point2D padPt = (Point2D)upit.next();
            int padX = (int)padPt.getX() / 10;
            int padY = (int)padPt.getY() / 10;
            excludeCols.add(new Integer(padX));
            excludeRows.add(new Integer(padY));
            Integer xm = new Integer(padX - 1);
            Integer xp = new Integer(padX + 1);
            Integer ym = new Integer(padY - 1);
            Integer yp = new Integer(padY + 1);
            if (usedCols.contains(xm)) {
                excludeCols.add(xm);
            }
            if (usedCols.contains(xp)) {
                excludeCols.add(xp);
            }
            if (usedRows.contains(ym)) {
                excludeRows.add(ym);
            }
            if (!usedRows.contains(yp)) continue;
            excludeRows.add(yp);
        }
    }

    public Map closestRemainingPads(Genome genome, DynamicInstanceProxy dip, Set useGroups, NetModule module, Layout layout, String ovrID, NetModuleProperties nmp, FontRenderContext frc, Map rigidMoves, Map wantPads, Map currPads, boolean orphansOnly) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        Rectangle outerRect = new Rectangle();
        Rectangle2D nameBounds = this.getNameBounds(nmp, module, this.fixedFrc_);
        ArrayList padList = new ArrayList();
        this.getShape(this.fixedFrc_, genome, dip, useGroups, layout, ovrID, module, nameBounds, outerRect, nop, nmp, false, padList);
        HashMap retval = new HashMap();
        HashSet padSet = new HashSet(padList);
        this.onePadPass(padSet, retval, wantPads, rigidMoves, true, currPads, orphansOnly);
        this.onePadPass(padSet, retval, wantPads, rigidMoves, false, currPads, orphansOnly);
        return retval;
    }

    public Rectangle2D getNameBounds(NetModuleProperties nmp, NetModule module, FontRenderContext frc) {
        Rectangle2D nameBounds;
        if (nmp.isHidingLabel()) {
            return null;
        }
        String name = module.getName();
        Point2D nameLoc = nmp.getNameLoc();
        if (nameLoc == null) {
            return null;
        }
        Font bFont = FontManager.getMgr().getOverrideFont(6, nmp.getFontOverride());
        String breakDef = nmp.getLineBreakDef();
        if (breakDef == null) {
            nameBounds = bFont.getStringBounds(name, frc);
            double padWidth = nameBounds.getWidth() + 20.0;
            double padHeight = nameBounds.getHeight() + 10.0;
            nameBounds.setRect(nameLoc.getX() - padWidth / 2.0, nameLoc.getY() - padHeight / 2.0, padWidth, padHeight);
        } else {
            List frags = MultiLineRenderSupport.applyLineBreaksForFragments(name, breakDef);
            String[] toks = new String[frags.size()];
            frags.toArray(toks);
            nameBounds = MultiLineRenderSupport.multiLineGuts(frc, toks, bFont, nameLoc, null, null, null, null);
            nameBounds.setRect(nameBounds.getX() - 10.0, nameBounds.getY() - 10.0, nameBounds.getWidth() + 20.0, nameBounds.getHeight() + 20.0);
        }
        UiUtil.force2DToGrid(nameBounds, 10.0);
        return nameBounds;
    }

    public List newReassemble(NetModuleProperties nmp) {
        if (nmp.getType() != 1) {
            return null;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        Area oneArea = null;
        Iterator sit = nmp.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D rect = (Rectangle2D)sit.next();
            double rectX = rect.getX();
            double rectY = rect.getY();
            if (rectX < minX) {
                minX = rectX;
            }
            if (rectY < minY) {
                minY = rectY;
            }
            Area rectArea = new Area(rect);
            if (oneArea == null) {
                oneArea = (Area)rectArea.clone();
                continue;
            }
            oneArea.add(rectArea);
        }
        Point2D.Double minULPt = new Point2D.Double(minX, minY);
        ArrayList<Rectangle2D> retval = new ArrayList<Rectangle2D>();
        while (true) {
            Rectangle2D nextRect;
            if ((nextRect = this.ohGrowUp(oneArea, minULPt)) == null) {
                if (retval.isEmpty()) {
                    Iterator ebit = nmp.getShapeIterator();
                    while (ebit.hasNext()) {
                        Rectangle2D rect = (Rectangle2D)ebit.next();
                        retval.add(rect);
                    }
                }
                return retval;
            }
            if (nextRect.getWidth() > 0.0) {
                retval.add(nextRect);
            }
            oneArea.subtract(new Area(nextRect));
        }
    }

    private Rectangle2D ohGrowUp(Area workingArea, Point2D minULPt) {
        TreeMap<Double, Point2D> sortMap = new TreeMap<Double, Point2D>();
        List corners = this.buildCornerList(workingArea);
        Point2D.Double testInPt = new Point2D.Double();
        int numCorner = corners.size();
        if (numCorner == 0) {
            return null;
        }
        for (int i = 0; i < numCorner; ++i) {
            CornerInfo ci = (CornerInfo)corners.get(i);
            int inDirCanon = ci.inDir.canonicalDir();
            int outDirCanon = ci.outDir.canonicalDir();
            if ((inDirCanon != 0 || outDirCanon != 1) && (outDirCanon != 2 || inDirCanon != 3)) continue;
            ((Point2D)testInPt).setLocation(ci.point.getX() + 5.0, ci.point.getY() + 5.0);
            if (!workingArea.contains(testInPt)) continue;
            double distSq = minULPt.distanceSq(ci.point);
            sortMap.put(new Double(distSq), ci.point);
        }
        if (sortMap.isEmpty()) {
            return null;
        }
        Point2D startPt = (Point2D)sortMap.get(sortMap.keySet().iterator().next());
        double stX = startPt.getX();
        double stY = startPt.getY();
        Rectangle2D.Double testRect = new Rectangle2D.Double();
        Rectangle2D.Double lastRect = new Rectangle2D.Double(stX, stY, 0.0, 1.0);
        boolean doX = true;
        boolean doY = true;
        while (doX || doY) {
            if (doX) {
                ((Rectangle2D)testRect).setRect(((RectangularShape)lastRect).getX(), ((RectangularShape)lastRect).getY(), ((RectangularShape)lastRect).getWidth() + 1.0, ((RectangularShape)lastRect).getHeight());
                if (!this.addAndCheck(workingArea, testRect, lastRect)) {
                    doX = false;
                }
            }
            if (!doY) continue;
            ((Rectangle2D)testRect).setRect(((RectangularShape)lastRect).getX(), ((RectangularShape)lastRect).getY(), ((RectangularShape)lastRect).getWidth(), ((RectangularShape)lastRect).getHeight() + 1.0);
            if (this.addAndCheck(workingArea, testRect, lastRect)) continue;
            doY = false;
        }
        return lastRect;
    }

    private boolean addAndCheck(Area workingArea, Rectangle2D testRect, Rectangle2D lastRect) {
        Area checkingArea = (Area)workingArea.clone();
        checkingArea.add(new Area(testRect));
        if (!checkingArea.equals(workingArea)) {
            return false;
        }
        lastRect.setRect(testRect);
        return true;
    }

    private Intersection checkSeg(LinkSegment seg, Point2D pt, String moduleID, Point2D startPt, Point2D endPt, double pixDiam) {
        double useTol = 5.0 > pixDiam ? 5.0 : 2.0 * pixDiam;
        Double is = seg.intersectsStart(pt, useTol);
        if (is != null) {
            Point2D onSeg = (Point2D)startPt.clone();
            IntersectionExtraInfo ei = new IntersectionExtraInfo(startPt, null, onSeg);
            Intersection intersect = new Intersection(moduleID, ei, is);
            return intersect;
        }
        is = seg.intersectsEnd(pt, useTol);
        if (is != null) {
            Point2D onSeg = (Point2D)endPt.clone();
            IntersectionExtraInfo ei = new IntersectionExtraInfo(endPt, null, onSeg);
            Intersection intersect = new Intersection(moduleID, ei, is);
            return intersect;
        }
        is = seg.intersects(pt, useTol);
        if (is != null) {
            Point2D onSeg = seg.getClosestPoint(pt);
            IntersectionExtraInfo ei = new IntersectionExtraInfo(startPt, endPt, onSeg);
            Intersection intersect = new Intersection(moduleID, ei, is);
            return intersect;
        }
        return null;
    }

    private void fillBoundaryLocation(Rectangle2D outerRect, NetModuleProperties nmp, IntersectionExtraInfo iexi) {
        if (nmp.getType() == 0) {
            iexi.outerMatch = NetModuleProperties.matchRectExact(outerRect, iexi.intersectPt);
        }
    }

    private List getShape(FontRenderContext frc, Genome genome, DynamicInstanceProxy dip, Set useGroups, Layout layout, String ovrID, NetModule module, Rectangle2D textBounds, Rectangle outerRect, NetOverlayProperties nop, NetModuleProperties nmp, boolean showComponents, List bubbleList) {
        switch (nmp.getType()) {
            case 0: {
                return this.getContigRectShape(frc, genome, dip, useGroups, layout, module, textBounds, outerRect, nmp, showComponents, bubbleList);
            }
            case 1: {
                return this.getMultiRectShape(frc, genome, dip, useGroups, layout, module, textBounds, outerRect, nmp, showComponents, bubbleList);
            }
            case 2: {
                return this.getMembersOnlyShape(frc, genome, layout, module, textBounds, outerRect, nmp, bubbleList);
            }
        }
        throw new IllegalArgumentException();
    }

    private Set getNonMembers(Genome genome, Set useGroups, NetModule module, Set nodes, DynamicInstanceProxy dip) {
        HashSet<String> allNonMems = new HashSet<String>();
        if (useGroups == null) {
            Iterator git = genome.getAllNodeIterator();
            while (git.hasNext()) {
                Node node = (Node)git.next();
                allNonMems.add(node.getID());
            }
        } else {
            GenomeInstance gi = (GenomeInstance)genome;
            Iterator ugit = useGroups.iterator();
            while (ugit.hasNext()) {
                String grpID = (String)ugit.next();
                Group grp = gi.getGroup(Group.getBaseID(grpID));
                Iterator mit = grp.getMemberIterator();
                while (mit.hasNext()) {
                    GroupMember gm = (GroupMember)mit.next();
                    allNonMems.add(gm.getID());
                }
            }
        }
        if (dip != null && dip.hasAddedNodes()) {
            Iterator ait = dip.getAddedNodeIterator();
            while (ait.hasNext()) {
                DynamicInstanceProxy.AddedNode an = (DynamicInstanceProxy.AddedNode)ait.next();
                allNonMems.add(an.nodeName);
            }
        }
        Iterator mit = module.getMemberIterator();
        while (mit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)mit.next();
            String nmID = nmm.getID();
            nodes.add(nmID);
            allNonMems.remove(nmID);
        }
        return allNonMems;
    }

    private List getContigRectShape(FontRenderContext frc, Genome genome, DynamicInstanceProxy dip, Set useGroups, Layout layout, NetModule module, Rectangle2D textBounds, Rectangle outerRect, NetModuleProperties nmp, boolean showComponents, List bubbleList) {
        if (!nmp.hasOneShape()) {
            throw new IllegalStateException();
        }
        ArrayList<TaggedShape> retval = new ArrayList<TaggedShape>();
        HashSet nodes = new HashSet();
        Set allNonMems = this.getNonMembers(genome, useGroups, module, nodes, dip);
        Rectangle2D rect = (Rectangle2D)nmp.getShapeIterator().next();
        HashMap membRects = null;
        Rectangle intRect = UiUtil.rectFromRect2D(rect);
        if (showComponents) {
            Area rectArea = new Area(rect);
            membRects = new HashMap();
            retval.add(new TaggedShape(1, rectArea, rect, null));
            if (textBounds != null) {
                rectArea = new Area(textBounds);
                retval.add(new TaggedShape(4, rectArea, textBounds, null));
            }
        }
        Rectangle labelRect = UiUtil.rectFromRect2D(textBounds);
        Rectangle finRect = NodeBounder.nodeBounds(nodes, genome, layout, frc, intRect, labelRect, 10, membRects);
        outerRect.setBounds(finRect);
        Area boundArea = new Area(finRect);
        if (showComponents) {
            Iterator kit = membRects.keySet().iterator();
            while (kit.hasNext()) {
                String memberID = (String)kit.next();
                Rectangle memberRect = (Rectangle)membRects.get(memberID);
                retval.add(new TaggedShape(2, memberRect, memberRect.getBounds2D(), memberID));
            }
        }
        Area padArea = null;
        if (bubbleList != null) {
            Rectangle padPath = this.padRect(finRect);
            padArea = new Area(padPath);
        }
        Map skipRects = NodeBounder.nodeRects(allNonMems, genome, layout, frc, 10);
        Area origArea = (Area)boundArea.clone();
        Area subPadArea = padArea != null ? (Area)padArea.clone() : null;
        TreeSet sortedSRkeys = new TreeSet(skipRects.keySet());
        Iterator rit = sortedSRkeys.iterator();
        while (rit.hasNext()) {
            String skipID = (String)rit.next();
            Rectangle eaRect = (Rectangle)skipRects.get(skipID);
            if (!origArea.intersects(eaRect)) continue;
            Area rectArea = new Area(eaRect);
            if (showComponents) {
                retval.add(new TaggedShape(3, rectArea, eaRect.getBounds2D(), skipID));
            }
            Area nextArea = (Area)boundArea.clone();
            nextArea.subtract(rectArea);
            if (nextArea.isEmpty()) continue;
            boundArea = nextArea;
            if (bubbleList == null) continue;
            Rectangle padPath = this.padRect(eaRect);
            Area eaPadArea = new Area(padPath);
            if (subPadArea == null) {
                subPadArea = (Area)eaPadArea.clone();
                continue;
            }
            subPadArea.subtract(eaPadArea);
        }
        this.bubbleMachine(padArea, subPadArea, boundArea, nmp, bubbleList, null, null);
        retval.add(new TaggedShape(0, boundArea, null, null));
        return retval;
    }

    private List getMultiRectShape(FontRenderContext frc, Genome genome, DynamicInstanceProxy dip, Set useGroups, Layout layout, NetModule module, Rectangle2D textBounds, Rectangle outerRect, NetModuleProperties nmp, boolean showComponents, List bubbleList) {
        ArrayList<TaggedShape> retval = new ArrayList<TaggedShape>();
        Rectangle extent = null;
        Area oneArea = null;
        Area onePadArea = null;
        Iterator sit = nmp.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D rect = (Rectangle2D)sit.next();
            Area rectArea = new Area(rect);
            if (showComponents) {
                retval.add(new TaggedShape(1, rectArea, rect, null));
            }
            if (oneArea == null) {
                oneArea = (Area)rectArea.clone();
            } else {
                oneArea.add(rectArea);
            }
            Rectangle extAdd = UiUtil.rectFromRect2D(rect);
            if (extent == null) {
                extent = extAdd;
            } else {
                Bounds.tweakBounds(extent, extAdd);
            }
            if (bubbleList == null) continue;
            Rectangle padPath = this.padRect(extAdd);
            Area padArea = new Area(padPath);
            if (onePadArea == null) {
                onePadArea = (Area)padArea.clone();
                continue;
            }
            onePadArea.add(padArea);
        }
        Area rectOnlyPadArea = null;
        if (bubbleList != null) {
            rectOnlyPadArea = (Area)onePadArea.clone();
        }
        HashSet nodes = new HashSet();
        Set allNonMems = this.getNonMembers(genome, useGroups, module, nodes, dip);
        HashMap<String, Area> memPadAreas = new HashMap<String, Area>();
        Map eachRect = NodeBounder.nodeRects(nodes, genome, layout, frc, 10);
        Iterator rit = eachRect.keySet().iterator();
        while (rit.hasNext()) {
            String memberID = (String)rit.next();
            Rectangle eaRect = (Rectangle)eachRect.get(memberID);
            Area rectArea = new Area(eaRect);
            if (showComponents) {
                retval.add(new TaggedShape(2, rectArea, eaRect.getBounds2D(), memberID));
            }
            if (oneArea == null) {
                oneArea = (Area)rectArea.clone();
            } else {
                oneArea.add(rectArea);
            }
            if (extent == null) {
                extent = eaRect;
            } else {
                Bounds.tweakBounds(extent, eaRect);
            }
            if (bubbleList == null) continue;
            Rectangle padPath = this.padRect(eaRect);
            Area padArea = new Area(padPath);
            memPadAreas.put(memberID, padArea);
            if (onePadArea == null) {
                onePadArea = (Area)padArea.clone();
                continue;
            }
            onePadArea.add(padArea);
        }
        if (textBounds != null) {
            Area rectArea = new Area(textBounds);
            if (showComponents) {
                retval.add(new TaggedShape(4, rectArea, textBounds, null));
            }
            if (oneArea == null) {
                oneArea = (Area)rectArea.clone();
            } else {
                oneArea.add(rectArea);
            }
            Rectangle txtAdd = UiUtil.rectFromRect2D(textBounds);
            if (extent == null) {
                extent = txtAdd;
            } else {
                Bounds.tweakBounds(extent, txtAdd);
            }
            if (bubbleList != null) {
                Rectangle padPath = this.padRect(txtAdd);
                Area padArea = new Area(padPath);
                if (onePadArea == null) {
                    onePadArea = (Area)padArea.clone();
                } else {
                    onePadArea.add(padArea);
                }
            }
        }
        Area subPadArea = onePadArea != null ? (Area)onePadArea.clone() : null;
        Map skipRects = NodeBounder.nodeRects(allNonMems, genome, layout, frc, 10);
        Area origArea = (Area)oneArea.clone();
        TreeSet sortedSRkeys = new TreeSet(skipRects.keySet());
        Iterator srit = sortedSRkeys.iterator();
        while (srit.hasNext()) {
            String skipID = (String)srit.next();
            Rectangle eaRect = (Rectangle)skipRects.get(skipID);
            if (!origArea.intersects(eaRect)) continue;
            Area rectArea = new Area(eaRect);
            retval.add(new TaggedShape(3, rectArea, eaRect.getBounds2D(), skipID));
            Area nextArea = (Area)oneArea.clone();
            nextArea.subtract(rectArea);
            if (nextArea.isEmpty()) continue;
            oneArea = nextArea;
            if (bubbleList == null) continue;
            Rectangle padPath = this.padRect(eaRect);
            Area padArea = new Area(padPath);
            if (subPadArea == null) {
                subPadArea = (Area)padArea.clone();
                continue;
            }
            subPadArea.subtract(padArea);
        }
        this.bubbleMachine(onePadArea, subPadArea, oneArea, nmp, bubbleList, memPadAreas, rectOnlyPadArea);
        retval.add(new TaggedShape(0, oneArea, null, null));
        outerRect.setBounds(extent);
        return retval;
    }

    private void bubbleMachine(Area onePadArea, Area subPadArea, Area trueArea, NetModuleProperties nmp, List bubbleList, Map multiRectMemPadAreas, Area rectOnlyPadArea) {
        if (bubbleList == null) {
            return;
        }
        this.bubbleMachineCore(onePadArea, subPadArea, trueArea, bubbleList, multiRectMemPadAreas, rectOnlyPadArea, 0);
        if (bubbleList.size() < 4) {
            bubbleList.clear();
            this.bubbleMachineCore(onePadArea, subPadArea, trueArea, bubbleList, multiRectMemPadAreas, rectOnlyPadArea, 1);
        }
        if (bubbleList.size() < 4) {
            bubbleList.clear();
            this.bubbleMachineCore(onePadArea, subPadArea, trueArea, bubbleList, multiRectMemPadAreas, rectOnlyPadArea, 2);
        }
        if (bubbleList.size() < 2) {
            bubbleList.clear();
            Rectangle2D rect = (Rectangle2D)nmp.getShapeIterator().next();
            double x = rect.getCenterX();
            double y = rect.getCenterY();
            x = UiUtil.forceToGridValue(x, 10.0);
            y = UiUtil.forceToGridValue(y, 10.0);
            Point2D.Double nextPoint = new Point2D.Double(x - 10.0, y);
            LinkPad lp = new LinkPad(new Vector2D(-1.0, 0.0), new Vector2D(0.0, 1.0), nextPoint, 0, null);
            bubbleList.add(lp);
            nextPoint = new Point2D.Double(x + 10.0, y);
            lp = new LinkPad(new Vector2D(1.0, 0.0), new Vector2D(0.0, -1.0), nextPoint, 0, null);
            bubbleList.add(lp);
        }
    }

    private void bubbleMachineCore(Area onePadArea, Area subPadArea, Area trueArea, List bubbleList, Map multiRectMemPadAreas, Area rectOnlyPadArea, int forceLevel) {
        boolean multiRect = multiRectMemPadAreas != null;
        List corners = multiRect ? this.buildCornerList(trueArea) : null;
        HashMap<Point2D, String> bubToMem = null;
        if (multiRect) {
            bubToMem = new HashMap<Point2D, String>();
            ArrayList rectOnlyList = new ArrayList();
            this.buildPadList(rectOnlyPadArea, rectOnlyList, null, 2, null);
            Set rectOnlySubSet = this.pointSetForPadList(rectOnlyList);
            Iterator kit = multiRectMemPadAreas.keySet().iterator();
            while (kit.hasNext()) {
                String memID = (String)kit.next();
                Area memPadArea = (Area)multiRectMemPadAreas.get(memID);
                ArrayList memList = new ArrayList();
                this.buildPadList(memPadArea, memList, null, 2, memID);
                int numMem = memList.size();
                for (int i = 0; i < numMem; ++i) {
                    LinkPad forMem = (LinkPad)memList.get(i);
                    if (rectOnlySubSet.contains(forMem.point)) continue;
                    if (bubToMem.get(forMem.point) != null) {
                        // empty if block
                    }
                    bubToMem.put(forMem.point, memID);
                }
            }
        }
        ArrayList addList = new ArrayList();
        this.buildPadList(onePadArea, addList, corners, forceLevel, null);
        ArrayList subList = new ArrayList();
        this.buildPadList(subPadArea, subList, null, 2, null);
        Set subSet = this.pointSetForPadList(subList);
        int numAdd = addList.size();
        for (int i = 0; i < numAdd; ++i) {
            String memberID;
            LinkPad toAdd = (LinkPad)addList.get(i);
            if (!subSet.contains(toAdd.point)) continue;
            if (bubToMem != null && (memberID = (String)bubToMem.get(toAdd.point)) != null && toAdd.nodeID == null) {
                toAdd.nodeID = memberID;
            }
            bubbleList.add(toAdd);
        }
    }

    private List getMembersOnlyShape(FontRenderContext frc, Genome genome, Layout layout, NetModule module, Rectangle2D textBounds, Rectangle outerRect, NetModuleProperties nmp, List bubbleList) {
        if (nmp.hasShapes()) {
            throw new IllegalStateException();
        }
        HashSet<String> nodes = new HashSet<String>();
        Iterator mit = module.getMemberIterator();
        while (mit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)mit.next();
            nodes.add(nmm.getID());
        }
        ArrayList<TaggedShape> retval = new ArrayList<TaggedShape>();
        Rectangle extent = null;
        Map eachRect = NodeBounder.nodeRects(nodes, genome, layout, frc, 10);
        Iterator rit = eachRect.keySet().iterator();
        while (rit.hasNext()) {
            String memberID = (String)rit.next();
            Rectangle eaRect = (Rectangle)eachRect.get(memberID);
            Area rectArea = new Area(eaRect);
            if (bubbleList != null) {
                Rectangle padPath = this.padRect(eaRect);
                this.buildPadList(new Area(padPath), bubbleList, null, 0, memberID);
            }
            retval.add(new TaggedShape(2, rectArea, eaRect.getBounds2D(), memberID));
            if (extent == null) {
                extent = eaRect;
                continue;
            }
            Bounds.tweakBounds(extent, eaRect);
        }
        if (textBounds != null) {
            Area rectArea = new Area(textBounds);
            retval.add(new TaggedShape(4, rectArea, textBounds, null));
            Rectangle txtAdd = UiUtil.rectFromRect2D(textBounds);
            if (extent == null) {
                extent = txtAdd;
            } else {
                Bounds.tweakBounds(extent, txtAdd);
            }
        }
        outerRect.setBounds(extent);
        return retval;
    }

    private BasicStroke calcStroke(int modType, int shapeClass, boolean showComponents) {
        float[] usePattern;
        if (shapeClass == 3) {
            return null;
        }
        if (!showComponents || shapeClass == 0 || modType == 2) {
            return new BasicStroke(8.0f, 0, 1);
        }
        int butt = 0;
        int join = 1;
        float miter = 10.0f;
        switch (shapeClass) {
            case 1: {
                usePattern = this.longDashPatternArray;
                break;
            }
            case 2: {
                usePattern = this.dotPatternArray;
                break;
            }
            case 4: {
                usePattern = this.dashPatternArray;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new BasicStroke(4.0f, butt, join, miter, usePattern, 0.0f);
    }

    private Rectangle padRect(Rectangle shapeRect) {
        return new Rectangle(shapeRect.x - 10, shapeRect.y - 10, shapeRect.width + 20, shapeRect.height + 20);
    }

    private Set pointSetForPadList(List padList) {
        HashSet<Point2D> retval = new HashSet<Point2D>();
        int numPad = padList.size();
        for (int i = 0; i < numPad; ++i) {
            LinkPad pad = (LinkPad)padList.get(i);
            retval.add(pad.point);
        }
        return retval;
    }

    private void buildPadList(Area padOutline, List bubbleList, List cornerList, int forceLevel, String nodeID) {
        double[] coords = new double[6];
        Point2D.Double firstPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double lastPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double nextPt = new Point2D.Double(0.0, 0.0);
        Vector2D firstDir = null;
        Vector2D lastDir = null;
        Vector2D currDir = null;
        ArrayList startPads = new ArrayList();
        ArrayList endPads = new ArrayList();
        ArrayList firstStartPads = null;
        ArrayList lastEndPads = new ArrayList();
        double lastLen = -1.0;
        double firstLen = -1.0;
        PathIterator pit = padOutline.getPathIterator(null);
        while (!pit.isDone()) {
            int segType = pit.currentSegment(coords);
            switch (segType) {
                case 4: {
                    NormAndLen nl = this.padsForSegment(bubbleList, lastPt, firstPt, 0, startPads, endPads, nodeID);
                    if (nl != null) {
                        currDir = nl.vec;
                        this.calcJointPads(bubbleList, currDir, lastDir, startPads, lastEndPads, lastPt, cornerList, lastLen, forceLevel);
                        this.calcJointPads(bubbleList, firstDir, currDir, firstStartPads, endPads, firstPt, cornerList, nl.len, forceLevel);
                    }
                    startPads.clear();
                    endPads.clear();
                    break;
                }
                case 1: {
                    ((Point2D)nextPt).setLocation(coords[0], coords[1]);
                    NormAndLen nl = this.padsForSegment(bubbleList, lastPt, nextPt, 0, startPads, endPads, nodeID);
                    if (nl != null) {
                        currDir = nl.vec;
                        if (firstStartPads == null) {
                            firstStartPads = new ArrayList(startPads);
                        } else {
                            this.calcJointPads(bubbleList, currDir, lastDir, startPads, lastEndPads, lastPt, cornerList, lastLen, forceLevel);
                        }
                    }
                    lastEndPads.clear();
                    lastEndPads.addAll(endPads);
                    startPads.clear();
                    endPads.clear();
                    if (firstDir == null) {
                        firstDir = currDir;
                    }
                    lastDir = currDir;
                    lastLen = nl == null ? -1.0 : nl.len;
                    lastPt.setLocation(nextPt);
                    break;
                }
                case 0: {
                    ((Point2D)firstPt).setLocation(coords[0], coords[1]);
                    lastPt.setLocation(firstPt);
                    lastDir = null;
                    firstStartPads = null;
                    lastEndPads.clear();
                    firstDir = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            pit.next();
        }
    }

    private void fillRowColNeeds(Area rectOutline, Rectangle bounds, SortedSet needCols, SortedSet needRows) {
        double[] coords = new double[6];
        Point2D.Double movePt = new Point2D.Double(0.0, 0.0);
        Point2D.Double startPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPt = new Point2D.Double(0.0, 0.0);
        PathIterator pit = rectOutline.getPathIterator(null);
        while (!pit.isDone()) {
            int segType = pit.currentSegment(coords);
            switch (segType) {
                case 4: {
                    ((Point2D)startPt).setLocation(coords[0], coords[1]);
                    this.isNeeded(bounds, startPt, movePt, needCols, needRows);
                    break;
                }
                case 1: {
                    ((Point2D)endPt).setLocation(coords[0], coords[1]);
                    this.isNeeded(bounds, startPt, endPt, needCols, needRows);
                    ((Point2D)startPt).setLocation(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    ((Point2D)movePt).setLocation(coords[0], coords[1]);
                    ((Point2D)startPt).setLocation(coords[0], coords[1]);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            pit.next();
        }
    }

    private void isNeeded(Rectangle bounds, Point2D startPt, Point2D endPt, SortedSet needCols, SortedSet needRows) {
        double startX = startPt.getX();
        double startY = startPt.getY();
        double endX = endPt.getX();
        double endY = endPt.getY();
        if (bounds == null) {
            needCols.add(new Integer((int)startX / 10));
            needCols.add(new Integer((int)endX / 10));
            needRows.add(new Integer((int)startY / 10));
            needRows.add(new Integer((int)endY / 10));
            return;
        }
        boolean oneIn = false;
        if (bounds.contains(startX, startY)) {
            needCols.add(new Integer((int)startX / 10));
            needRows.add(new Integer((int)startY / 10));
            oneIn = true;
        }
        if (bounds.contains(endX, endY)) {
            needCols.add(new Integer((int)endX / 10));
            needRows.add(new Integer((int)endY / 10));
            oneIn = true;
        }
        if (!oneIn && bounds.intersectsLine(startX, startY, endX, endY)) {
            if (startX == endX) {
                needCols.add(new Integer((int)startX / 10));
            }
            if (startY == endY) {
                needRows.add(new Integer((int)startY / 10));
            }
        }
    }

    private void fillRectRowColNeeds(Rectangle2D rect, Rectangle bounds, SortedSet needCols, SortedSet needRows, boolean padPads) {
        if (bounds != null) {
            Rectangle2D interRect = rect.createIntersection(bounds);
            if (interRect.getHeight() > 0.0 && interRect.getWidth() > 0.0) {
                rect = interRect;
            } else {
                return;
            }
        }
        int pad = padPads ? 1 : 0;
        int minX = (int)rect.getMinX() / 10 - pad;
        int minY = (int)rect.getMinY() / 10 - pad;
        int maxX = (int)rect.getMaxX() / 10 + pad;
        int maxY = (int)rect.getMaxY() / 10 + pad;
        for (int x = minX; x <= maxX; ++x) {
            needCols.add(new Integer(x));
        }
        for (int y = minY; y <= maxY; ++y) {
            needRows.add(new Integer(y));
        }
    }

    private List buildCornerList(Area coreOutline) {
        double[] coords = new double[6];
        Point2D.Double firstPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double lastPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double nextPt = new Point2D.Double(0.0, 0.0);
        Vector2D firstDir = null;
        Vector2D lastDir = null;
        Vector2D currDir = null;
        ArrayList<CornerInfo> retval = new ArrayList<CornerInfo>();
        PathIterator pit = coreOutline.getPathIterator(null);
        while (!pit.isDone()) {
            int segType = pit.currentSegment(coords);
            switch (segType) {
                case 4: {
                    currDir = new Vector2D(lastPt, firstPt);
                    if (!lastDir.equals(currDir)) {
                        retval.add(new CornerInfo((Point2D)lastPt.clone(), lastDir.normalized(), currDir.normalized()));
                    }
                    if (firstDir.equals(currDir)) break;
                    retval.add(new CornerInfo((Point2D)firstPt.clone(), currDir.normalized(), firstDir.normalized()));
                    break;
                }
                case 1: {
                    ((Point2D)nextPt).setLocation(coords[0], coords[1]);
                    currDir = new Vector2D(lastPt, nextPt);
                    if (firstDir == null) {
                        firstDir = (Vector2D)currDir.clone();
                    } else if (!lastDir.equals(currDir)) {
                        retval.add(new CornerInfo((Point2D)lastPt.clone(), lastDir.normalized(), currDir.normalized()));
                    }
                    lastDir = currDir;
                    lastPt.setLocation(nextPt);
                    break;
                }
                case 0: {
                    ((Point2D)firstPt).setLocation(coords[0], coords[1]);
                    lastPt.setLocation(firstPt);
                    lastDir = null;
                    firstDir = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            pit.next();
        }
        return retval;
    }

    private void calcJointPads(List padList, Vector2D currDir, Vector2D lastDir, List startPads, List endPads, Point2D corner, List cornerList, double lastLen, int forceLevel) {
        if (forceLevel == 2 || currDir != null && lastDir != null && currDir.equals(lastDir)) {
            if (startPads != null) {
                padList.addAll(startPads);
            }
            if (!endPads.isEmpty()) {
                padList.add(endPads.get(0));
            }
        } else if (cornerList == null || this.isOuterCorner(corner, lastDir, currDir, cornerList)) {
            if (forceLevel == 1) {
                if (startPads != null && startPads.size() > 1) {
                    padList.add(startPads.get(1));
                }
                if (!endPads.isEmpty() && lastLen >= 30.0) {
                    padList.add(endPads.get(0));
                }
            } else {
                this.tossShortSidePad(padList, startPads, endPads, true);
            }
        } else {
            if (startPads != null && startPads.size() > 1) {
                padList.add(startPads.get(1));
            }
            if (!endPads.isEmpty() && lastLen >= 30.0) {
                padList.add(endPads.get(0));
            }
            this.tossShortSidePad(padList, startPads, endPads, false);
        }
    }

    private void tossShortSidePad(List padList, List startPads, List endPads, boolean isOuter) {
        HashSet<Point2D> badPads = new HashSet<Point2D>();
        if (isOuter) {
            if (endPads != null && endPads.size() >= 1) {
                badPads.add(((LinkPad)endPads.get((int)0)).point);
            }
            if (startPads != null) {
                if (startPads.size() > 0) {
                    badPads.add(((LinkPad)startPads.get((int)0)).point);
                }
                if (startPads.size() > 1) {
                    badPads.add(((LinkPad)startPads.get((int)1)).point);
                }
            }
        } else if (startPads != null && startPads.size() > 0) {
            badPads.add(((LinkPad)startPads.get((int)0)).point);
        }
        if (badPads.isEmpty()) {
            return;
        }
        int count = 0;
        while (count < padList.size()) {
            LinkPad lp = (LinkPad)padList.get(count);
            Point2D padPt = lp.point;
            if (badPads.contains(padPt)) {
                padList.remove(count);
                continue;
            }
            ++count;
        }
    }

    private boolean isOuterCorner(Point2D padCornerPt, Vector2D lastDir, Vector2D currDir, List cornerList) {
        double cpx = padCornerPt.getX();
        double cpy = padCornerPt.getY();
        CornerInfo useCorner = null;
        int numC = cornerList.size();
        for (int i = 0; i < numC; ++i) {
            CornerInfo testCorner = (CornerInfo)cornerList.get(i);
            double tcx = testCorner.point.getX();
            double tcy = testCorner.point.getY();
            if (!(Math.abs(cpx - tcx) <= 10.0) || !(Math.abs(cpy - tcy) <= 10.0) || !testCorner.inDir.equals(lastDir) || !testCorner.outDir.equals(currDir)) continue;
            if (useCorner != null) {
                return true;
            }
            useCorner = testCorner;
        }
        if (useCorner == null) {
            return true;
        }
        double testLength = 50.0;
        Point2D beforePad = lastDir.scaled(-testLength).add(padCornerPt);
        Vector2D toUse = new Vector2D(beforePad, useCorner.point);
        double dot = lastDir.dot(toUse);
        boolean isOut = dot < testLength;
        return isOut;
    }

    private NormAndLen padsForSegment(List padList, Point2D start, Point2D end, int side, List startPads, List endPads, String nodeID) {
        Vector2D vec = new Vector2D(start, end);
        if (!vec.isCanonical()) {
            return null;
        }
        Vector2D normal = vec.normal();
        double len = vec.length();
        Vector2D normRun = vec.scaled(1.0 / len);
        int count = (int)(len / 10.0) + 1;
        int countm1 = count - 1;
        int countm2 = count - 2;
        double radius = 5.0;
        Vector2D normVec = vec.normalized();
        for (int i = 0; i < count; ++i) {
            double factor = i * 10;
            Point2D nextPoint = normVec.scaled(factor).add(start);
            LinkPad lp = new LinkPad(normal, normRun, nextPoint, side, nodeID);
            boolean notTerminal = true;
            if (i == 0 || i == 1) {
                if (startPads != null) {
                    startPads.add(lp);
                }
                notTerminal = false;
            }
            if (i == countm1 || i == countm2) {
                if (endPads != null) {
                    endPads.add(lp);
                }
                notTerminal = false;
            }
            if (!notTerminal) continue;
            padList.add(lp);
        }
        return new NormAndLen(normVec, len);
    }

    private void bubbleShapesForPads(List padList, List bubbleList) {
        int numPads = padList.size();
        for (int i = 0; i < numPads; ++i) {
            Point2D nextPoint = ((LinkPad)padList.get((int)i)).point;
            Ellipse2D.Double circ = new Ellipse2D.Double(nextPoint.getX() - 5.0, nextPoint.getY() - 5.0, 10.0, 10.0);
            bubbleList.add(circ);
        }
    }

    private LinkPad intersectsPad(List padList, Point2D clickPt, double pixDiam) {
        int numPads = padList.size();
        double radiusSq = 25.0;
        double bigRadiusSq = 20.0 < 2.0 * pixDiam ? 4.0 * (pixDiam * pixDiam) : 400.0;
        double clkX = clickPt.getX();
        double clkY = clickPt.getY();
        ArrayList<LinkPad> cand = null;
        for (int i = 0; i < numPads; ++i) {
            double nextY;
            LinkPad nextPad = (LinkPad)padList.get(i);
            Point2D nextPoint = nextPad.point;
            double nextX = nextPoint.getX();
            double distSq = (nextX - clkX) * (nextX - clkX) + ((nextY = nextPoint.getY()) - clkY) * (nextY - clkY);
            if (distSq <= radiusSq) {
                return nextPad;
            }
            if (!(distSq <= bigRadiusSq)) continue;
            if (cand == null) {
                cand = new ArrayList<LinkPad>();
            }
            cand.add(nextPad);
        }
        if (cand != null) {
            double radiusForMin = 5.0 < 2.0 * pixDiam ? 6.0 * pixDiam : 15.0;
            double minOff = Double.POSITIVE_INFINITY;
            LinkPad currBest = null;
            int numCand = cand.size();
            for (int i = 0; i < numCand; ++i) {
                double off;
                LinkPad chkPad = (LinkPad)cand.get(i);
                Vector2D toClick = new Vector2D(chkPad.point, clickPt);
                double perp = Math.abs(chkPad.getRun().dot(toClick));
                if (!(perp < minOff) || !((off = chkPad.getNormal().dot(toClick)) > -radiusForMin) || !(off < radiusForMin)) continue;
                minOff = perp;
                currBest = chkPad;
            }
            if (currBest != null) {
                return currBest;
            }
        }
        return null;
    }

    public Map padsForRectangle(Rectangle2D shapeRect, String nodeID) {
        LinkPad pad;
        int i;
        HashMap<Point2D, LinkPad> retval = new HashMap<Point2D, LinkPad>();
        Rectangle paddedRect = this.padRect(UiUtil.rectFromRect2D(shapeRect));
        ArrayList padList = new ArrayList();
        Point2D.Double topLeft = new Point2D.Double(paddedRect.getX(), paddedRect.getY());
        Point2D.Double topRight = new Point2D.Double(paddedRect.getMaxX(), paddedRect.getY());
        this.padsForSegment(padList, topLeft, topRight, 2, null, null, nodeID);
        int numPads = padList.size();
        for (int i2 = 0; i2 < numPads; ++i2) {
            LinkPad pad2 = (LinkPad)padList.get(i2);
            retval.put(pad2.point, pad2);
        }
        padList.clear();
        Point2D.Double bottomRight = new Point2D.Double(paddedRect.getMaxX(), paddedRect.getMaxY());
        this.padsForSegment(padList, topRight, bottomRight, 4, null, null, nodeID);
        numPads = padList.size();
        for (int i3 = 0; i3 < numPads; ++i3) {
            LinkPad pad3 = (LinkPad)padList.get(i3);
            retval.put(pad3.point, pad3);
        }
        padList.clear();
        Point2D.Double bottomLeft = new Point2D.Double(paddedRect.getX(), paddedRect.getMaxY());
        this.padsForSegment(padList, bottomRight, bottomLeft, 6, null, null, nodeID);
        numPads = padList.size();
        for (i = 0; i < numPads; ++i) {
            pad = (LinkPad)padList.get(i);
            retval.put(pad.point, pad);
        }
        padList.clear();
        this.padsForSegment(padList, bottomLeft, topLeft, 8, null, null, nodeID);
        numPads = padList.size();
        for (i = 0; i < numPads; ++i) {
            pad = (LinkPad)padList.get(i);
            retval.put(pad.point, pad);
        }
        return retval;
    }

    private void onePadPass(HashSet padSet, HashMap results, Map wantPads, Map rigidMoves, boolean isFirst, Map currPads, boolean orphansOnly) {
        Map padSource = orphansOnly && currPads != null ? currPads : wantPads;
        Iterator wpit = padSource.keySet().iterator();
        while (wpit.hasNext()) {
            Vector2D rigidDelta;
            Layout.PointNoPoint pnp = (Layout.PointNoPoint)wpit.next();
            if (isFirst && pnp.noPoint != null || !isFirst && pnp.noPoint == null) continue;
            HashSet<String> haveNodeIDs = new HashSet<String>();
            Iterator pstit = padSet.iterator();
            while (pstit.hasNext()) {
                LinkPad nextPad = (LinkPad)pstit.next();
                if (nextPad.nodeID == null) continue;
                haveNodeIDs.add(nextPad.nodeID);
            }
            LinkPad wantPad = (LinkPad)padSource.get(pnp);
            if (orphansOnly && currPads != null && padSet.contains(wantPad)) {
                results.put(pnp, wantPad);
                continue;
            }
            LinkPad usePad = wantPad;
            if (rigidMoves != null && (rigidDelta = (Vector2D)rigidMoves.get(pnp)) != null) {
                Point2D rigidMove = rigidDelta.add(wantPad.point);
                usePad = (LinkPad)wantPad.clone();
                usePad.point = rigidMove;
            }
            if (padSet.contains(usePad)) {
                results.put(pnp, usePad);
                continue;
            }
            LinkPad withoutNodeID = this.gotAMatchAfterLostNodeID(padSet, usePad, haveNodeIDs);
            if (withoutNodeID != null) {
                results.put(pnp, usePad);
                continue;
            }
            LinkPad havePad = this.closestPad(padSet, pnp, usePad, results, haveNodeIDs);
            if (havePad == null) continue;
            results.put(pnp, havePad);
        }
    }

    private LinkPad gotAMatchAfterLostNodeID(HashSet padSet, LinkPad wantPad, Set haveNodeIDs) {
        if (wantPad.nodeID != null && !haveNodeIDs.contains(wantPad.nodeID)) {
            Iterator psit = padSet.iterator();
            while (psit.hasNext()) {
                LinkPad lp = (LinkPad)psit.next();
                if (lp.nodeID == null) continue;
                lp = (LinkPad)lp.clone();
                lp.nodeID = null;
                if (!lp.equals(wantPad)) continue;
                return wantPad;
            }
        }
        return null;
    }

    private LinkPad closestPad(Set havePads, Layout.PointNoPoint pnp, LinkPad wantPad, Map assigned, Set haveNodeIDs) {
        if (wantPad == null) {
            return null;
        }
        LinkPad cantUse = null;
        if (pnp.noPoint != null) {
            Iterator akit = assigned.keySet().iterator();
            while (akit.hasNext()) {
                Layout.PointNoPoint akey = (Layout.PointNoPoint)akit.next();
                if (!akey.point.equals(pnp.noPoint)) continue;
                cantUse = (LinkPad)assigned.get(akey);
                break;
            }
        }
        double minCandDistSq = Double.POSITIVE_INFINITY;
        LinkPad bestPad = null;
        Vector2D wantPadNorm = wantPad.getNormal();
        Iterator hpit = havePads.iterator();
        while (hpit.hasNext()) {
            double distSq;
            LinkPad havePad = (LinkPad)hpit.next();
            if (cantUse != null && havePad.point.equals(cantUse.point) || wantPad.nodeID != null && haveNodeIDs.contains(wantPad.nodeID) && !wantPad.nodeID.equals(havePad.nodeID) || !havePad.getNormal().equals(wantPadNorm)) continue;
            if (wantPadNorm.getX() == 0.0) {
                if (wantPad.point.getX() != havePad.point.getX() || !((distSq = wantPad.point.distanceSq(havePad.point)) < minCandDistSq)) continue;
                bestPad = havePad;
                minCandDistSq = distSq;
                continue;
            }
            if (wantPadNorm.getY() != 0.0 || wantPad.point.getY() != havePad.point.getY() || !((distSq = wantPad.point.distanceSq(havePad.point)) < minCandDistSq)) continue;
            bestPad = havePad;
            minCandDistSq = distSq;
        }
        if (bestPad != null) {
            return bestPad;
        }
        LinkPad lastDitchRetval = null;
        LinkPad retvalForNorm = null;
        double minDistSq = Double.POSITIVE_INFINITY;
        double minDistSqForNorm = Double.POSITIVE_INFINITY;
        hpit = havePads.iterator();
        while (hpit.hasNext()) {
            LinkPad havePad = (LinkPad)hpit.next();
            if (cantUse != null && havePad.point.equals(cantUse.point) || wantPad.nodeID != null && haveNodeIDs.contains(wantPad.nodeID) && !wantPad.nodeID.equals(havePad.nodeID)) continue;
            double distSq = wantPad.point.distanceSq(havePad.point);
            if (havePad.getNormal().equals(wantPadNorm)) {
                if (!(distSq < minDistSqForNorm)) continue;
                retvalForNorm = havePad;
                minDistSqForNorm = distSq;
                continue;
            }
            if (!(distSq < minDistSq)) continue;
            lastDitchRetval = havePad;
            minDistSq = distSq;
        }
        return retvalForNorm == null ? lastDitchRetval : retvalForNorm;
    }

    public static class ContigBreakdown {
        public Set intersectedShape;
        public Map memberShapes;

        public ContigBreakdown(Set intersectedShape, Map memberShapes) {
            this.intersectedShape = intersectedShape;
            this.memberShapes = memberShapes;
        }
    }

    public static class IntersectionExtraInfo {
        public static final int IS_BOUNDARY = 0;
        public static final int IS_INTERNAL = 1;
        public static final int IS_PAD = 2;
        public Point2D startPt;
        public Point2D endPt;
        public Point2D intersectPt;
        public int type;
        public int outerMatch;
        public ContigBreakdown contigInfo;
        public TaggedShape directShape;
        public boolean nonDirectAlternative;
        public Vector2D padNorm;
        public boolean gotNameBounds;

        public IntersectionExtraInfo(Point2D startPt, Point2D endPt, Point2D intersectPt) {
            this.type = 0;
            this.startPt = startPt;
            this.endPt = endPt;
            this.intersectPt = intersectPt;
            this.outerMatch = 0;
        }

        public IntersectionExtraInfo(Point2D intersectPt) {
            this.type = 1;
            this.intersectPt = intersectPt;
            this.outerMatch = 0;
        }

        public IntersectionExtraInfo(Point2D intersectPt, int type) {
            this.type = type;
            this.intersectPt = intersectPt;
            this.outerMatch = 0;
        }

        public IntersectionExtraInfo(Point2D intersectPt, Vector2D norm) {
            this.type = 2;
            this.padNorm = norm;
            this.intersectPt = intersectPt;
            this.outerMatch = 0;
        }
    }

    public static class CurrentSettings {
        public static final double INTERSECTION_CUTOFF = 0.9;
        public static final int NOTHING_MASKED = 0;
        public static final int NON_MEMBERS_MASKED = 1;
        public static final int ALL_MASKED = 2;
        public double regionLabelAlpha = 1.0;
        public double regionFillAlpha = 1.0;
        public double regionBoundaryAlpha = 1.0;
        public double backgroundOverlayAlpha = 1.0;
        public int intersectionMask = 2;
        public boolean fastDecayLabelVisible = true;

        public CurrentSettings() {
        }

        public CurrentSettings(int maskType) {
            this();
            if (maskType == 1) {
                throw new IllegalArgumentException();
            }
            if (maskType == 0) {
                this.regionLabelAlpha = 0.0;
                this.regionFillAlpha = 0.0;
                this.regionBoundaryAlpha = 0.0;
                this.backgroundOverlayAlpha = 0.0;
                this.intersectionMask = 0;
                this.fastDecayLabelVisible = false;
            }
        }
    }

    public static class TaggedShape {
        public static final int FULL_DRAW_SHAPE = 0;
        public static final int COMPONENT_SHAPE = 1;
        public static final int AUTO_MEMBER_SHAPE = 2;
        public static final int NON_MEMBER_SHAPE = 3;
        public static final int TITLE_SHAPE = 4;
        public int shapeClass;
        public Shape shape;
        public Rectangle2D rect;
        public String memberID;

        TaggedShape(int shapeClass, Shape shape, Rectangle2D rect, String memberID) {
            this.shapeClass = shapeClass;
            this.rect = rect;
            this.shape = shape;
            this.memberID = memberID;
        }

        public String toString() {
            return "TaggedShape " + this.shapeClass + " " + this.rect + " " + this.shape + " " + this.memberID;
        }
    }

    public static class LinkPad
    implements Cloneable {
        private Vector2D normal_;
        private Vector2D run_;
        public Point2D point;
        public int rectSide;
        public String nodeID;

        LinkPad(Vector2D normal, Vector2D normRun, Point2D point, int rectSide, String nodeID) {
            this.normal_ = normal;
            this.run_ = normRun;
            this.point = point;
            this.rectSide = rectSide;
            this.nodeID = nodeID;
        }

        public String toString() {
            return "LinkPad " + this.normal_ + " " + this.run_ + " " + this.point + " " + this.rectSide + " " + this.nodeID;
        }

        public Vector2D getNormal() {
            return this.normal_;
        }

        public Vector2D getRun() {
            return this.run_;
        }

        public int hashCode() {
            return this.normal_.hashCode() + this.run_.hashCode() + this.point.hashCode() + (this.nodeID == null ? 0 : this.nodeID.hashCode()) + this.rectSide;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof LinkPad)) {
                return false;
            }
            LinkPad otherLP = (LinkPad)other;
            if (!this.point.equals(otherLP.point)) {
                return false;
            }
            if (this.rectSide != otherLP.rectSide) {
                return false;
            }
            if (!this.normal_.equals(otherLP.normal_)) {
                return false;
            }
            if (!this.run_.equals(otherLP.run_)) {
                return false;
            }
            if (this.nodeID == null) {
                return otherLP.nodeID == null;
            }
            return this.nodeID.equals(otherLP.nodeID);
        }

        public Object clone() {
            try {
                return (LinkPad)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }

    static class CornerInfo {
        Vector2D inDir;
        Point2D point;
        Vector2D outDir;

        CornerInfo(Point2D point, Vector2D inDir, Vector2D outDir) {
            this.inDir = inDir;
            this.point = point;
            this.outDir = outDir;
        }

        public String toString() {
            return "CornerInfo " + this.inDir + " " + this.point + " " + this.outDir;
        }
    }

    static class NormAndLen {
        Vector2D vec;
        double len;

        NormAndLen(Vector2D vec, double len) {
            this.vec = vec;
            this.len = len;
        }
    }
}

