/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleBusDrop;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.DrawTree;
import org.systemsbiology.biotapestry.ui.freerender.DrawTreeModelDataSource;
import org.systemsbiology.biotapestry.ui.freerender.MultiSubID;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridRenderer;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridSupport;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.Vector2D;

public class NetModuleLinkageFree
implements DrawTreeModelDataSource,
PlacementGridRenderer {
    private static final double INTERSECT_TOL = 10.0;
    private static final double PLUS_ARROW_DEPTH_MOD_ = 20.0;
    private static final double NEG_FOOT_MOD_ = 17.0;
    private static final double POSITIVE_DROP_OFFSET_MOD_ = 19.0;
    private static final double PLUS_ARROW_HALF_WIDTH_MOD_ = 7.0;
    private static final double TIP_FUDGE_MOD_ = 0.0;
    private static final int NEG_THICK_MOD_ = 4;
    private static final double NEGATIVE_DROP_OFFSET_MOD_ = 4.0;
    private static final double LEVEL_FUDGE_ = 0.0;
    private static final double LEVEL_FUDGE_NEG_ = 0.0;

    public void renderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set skipLinks, OverlayStateOracle oso, String overID) {
        new PlacementGridSupport().renderToPlacementGrid(genome, lp, layout, frc, grid, skipLinks, oso, overID);
    }

    public boolean canRenderToPlacementGrid(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Set dropSet, OverlayStateOracle oso, String overID) {
        return new PlacementGridSupport().canRenderToPlacementGrid(genome, lp, layout, frc, grid, dropSet, oso, overID);
    }

    public Map getPointPairMap(Genome genome, LinkProperties lp, Layout layout, FontRenderContext frc, OverlayStateOracle oso, String overID) {
        return new PlacementGridSupport().getPointPairMap(genome, lp, layout, frc, oso, overID);
    }

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, OverlayStateOracle oso, Layout layout, String ovrID, boolean showBubbles, String treeID, Rectangle2D clipRect, double pixDiam) {
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
        FontRenderContext frc = g2.getFontRenderContext();
        DisplayOptions dopt = DisplayOptionsManager.getMgr().getDisplayOptions();
        DrawTree dTree = new DrawTree(genome, nmlp, this, layout, frc, null, dopt, oso);
        dTree.renderToCache(cache, genome, this, layout, frc, nmlp, false, showBubbles, null, dopt, clipRect, pixDiam);
    }

    public Intersection intersects(Genome genome, OverlayStateOracle oso, String treeID, Layout layout, String ovrID, FontRenderContext frc, Point2D pt, double pixDiam) {
        double useTol;
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
        LinkProperties.DistancedLinkSegID dslid = nmlp.intersectBusSegment(genome, oso, layout, pt, frc, null, useTol = 10.0 > pixDiam ? 10.0 : 2.0 * pixDiam);
        if (dslid != null) {
            if (nmlp.isDirect()) {
                dslid.segID.clearTaggedEndpoint();
            }
            return new Intersection(treeID, new MultiSubID(dslid.segID), dslid.distance, true);
        }
        return null;
    }

    public Rectangle getBoundsForSinglePath(NetModuleLinkageProperties nmlp, String linkID, FontRenderContext frc) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterator dit = nmlp.getDrops();
        NetModuleBusDrop itemDrop = null;
        while (dit.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)dit.next();
            String ref = drop.getTargetRef();
            if (ref == null || !ref.equals(linkID)) continue;
            itemDrop = drop;
            break;
        }
        Iterator sit = null;
        if (itemDrop != null) {
            sit = nmlp.getSegmentsToRoot(itemDrop).iterator();
        }
        if (sit == null) {
            return null;
        }
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            Point2D pt = seg.getStart();
            double x = pt.getX();
            double y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if ((pt = seg.getEnd()) == null) continue;
            x = pt.getX();
            y = pt.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        if (minX == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public DrawTreeModelDataSource.ModelLineStyleModulation getModelLineStyleModulation(Genome genome, DisplayOptions dOpt) {
        DrawTreeModelDataSource.ModelLineStyleModulation retval = new DrawTreeModelDataSource.ModelLineStyleModulation();
        retval.linkModulation = 0;
        retval.checkForActive = false;
        retval.branchRenderMode = 0;
        retval.forModules = true;
        return retval;
    }

    public DrawTreeModelDataSource.LinkLineStyleModulation getLinkLineStyleModulation(Genome genome, DisplayOptions dOpt, String linkID, LinkProperties lp, OverlayStateOracle oso, DrawTreeModelDataSource.ModelLineStyleModulation modulationInfo) {
        if (!lp.linkIsInModel(genome, oso, linkID)) {
            return null;
        }
        DrawTreeModelDataSource.LinkLineStyleModulation retval = new DrawTreeModelDataSource.LinkLineStyleModulation();
        NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)lp;
        NetworkOverlay no = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID()).getNetworkOverlay(nmlp.getOverlayID());
        NetModuleLinkage link = no.getLinkage(linkID);
        retval.sign = link.getSign();
        retval.perLinkActivity = null;
        retval.perLinkForEvidence = null;
        retval.isActive = true;
        retval.targetOffset = 0.0;
        if (retval.sign == 1) {
            retval.targetOffset = 19.0;
        } else if (retval.sign == -1) {
            retval.targetOffset = 4.0;
        }
        return retval;
    }

    public DrawTreeModelDataSource.ModelDataForTip getModelDataForTip(Genome genome, Layout layout, String linkID, LinkProperties lp, FontRenderContext frc, DisplayOptions dOpt) {
        DrawTreeModelDataSource.ModelDataForTip retval = new DrawTreeModelDataSource.ModelDataForTip();
        NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)lp;
        NetworkOverlay no = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID()).getNetworkOverlay(nmlp.getOverlayID());
        NetModuleLinkage link = no.getLinkage(linkID);
        retval.sign = link.getSign();
        retval.isActive = true;
        retval.padWidth = 10.0;
        LinkSegmentID segID = nmlp.isDirect() ? LinkSegmentID.buildIDForDirect(linkID) : LinkSegmentID.buildIDForEndDrop(linkID);
        LinkSegment geom = nmlp.getSegmentGeometryForID(segID, genome, layout, frc, true);
        retval.arrival = new Vector2D(1.0, 0.0);
        double segLen = geom.getLength();
        if (segLen > 0.0) {
            retval.arrival = geom.getRun();
        } else if (!nmlp.isDirect()) {
            List segs = nmlp.getSegmentIDsToRootForEndDrop(nmlp.getDrop(segID));
            int numSegs = segs.size();
            for (int i = 0; i < numSegs; ++i) {
                LinkSegmentID nextID = (LinkSegmentID)segs.get(i);
                geom = nmlp.getSegmentGeometryForID(nextID, genome, layout, frc, true);
                if (!(geom.getLength() > 0.0)) continue;
                retval.arrival = geom.getRun();
                break;
            }
        }
        retval.lanLoc = retval.sign == -1 ? retval.arrival.scaled(-4.0).add(geom.getEnd()) : (Point2D)geom.getEnd().clone();
        retval.negLength = 17.0;
        retval.negThick = 4;
        retval.plusArrowDepth = 20.0;
        retval.positiveDropOffset = 19.0;
        retval.plusArrowHalfWidth = 7.0;
        retval.thickThick = 9.0;
        retval.tipFudge = 0.0;
        retval.levelFudge = retval.sign == -1 ? 0.0 : 0.0;
        retval.hasDiamond = false;
        return retval;
    }
}

