/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleLinkageFree;
import org.systemsbiology.biotapestry.util.TaggedSet;

public class NetOverlayFree {
    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, Layout layout, NetworkOverlay netOvr, List renderedRects, OverlayStateOracle oso, boolean doUnderlay, Set showComponents, boolean showBubbles, Rectangle2D clipRect, double pixDiam) {
        NetOverlayOwner noo;
        boolean isOpq;
        TaggedSet currentNetMods = oso.getCurrentNetModules();
        HashSet currMods = currentNetMods == null ? null : currentNetMods.set;
        NetModuleFree.CurrentSettings settings = oso.getCurrentOverlaySettings();
        String ovrID = netOvr.getID();
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrID);
        int nopType = nop.getType();
        if (nopType == 2 && !doUnderlay || nopType != 2 && doUnderlay) {
            return;
        }
        boolean bl = isOpq = nopType == 1;
        if (isOpq && renderedRects != null) {
            g2.setComposite(AlphaComposite.Src);
            float[] coVals = new float[4];
            Iterator rrit = renderedRects.iterator();
            while (rrit.hasNext()) {
                GroupFree.ColoredRect cr = (GroupFree.ColoredRect)rrit.next();
                cr.drawColor.getComponents(coVals);
                Color aDrawCol = new Color(coVals[0], coVals[1], coVals[2], (float)settings.backgroundOverlayAlpha);
                g2.setPaint(aDrawCol);
                g2.fill(cr.rect);
            }
            g2.setComposite(AlphaComposite.SrcOver);
        }
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        DynamicInstanceProxy dip = (noo = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID())).overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
        Set useGroups = noo.getGroupsForOverlayRendering();
        TaggedSet revealed = oso.getRevealedModules();
        Iterator nmit = netOvr.getModuleIterator();
        while (nmit.hasNext()) {
            NetModule nm = (NetModule)nmit.next();
            String modID = nm.getID();
            if (!currMods.contains(modID)) continue;
            boolean showContents = revealed != null && revealed.set.contains(modID);
            NetModuleProperties nmp = nop.getNetModuleProperties(modID);
            NetModuleFree nmf = nmp.getRenderer();
            boolean showingComponents = showComponents != null && showComponents.contains(modID);
            nmf.render(g2, useGenome, dip, useGroups, layout, ovrID, nm, settings, showingComponents, showBubbles, showContents, clipRect, pixDiam);
        }
        Iterator nlit = nop.getNetModuleLinkagePropertiesKeys();
        NetModuleLinkageFree nmlf = new NetModuleLinkageFree();
        while (nlit.hasNext()) {
            String treeID = (String)nlit.next();
            nmlf.render(g2, cache, genome, oso, layout, ovrID, showBubbles, treeID, clipRect, pixDiam);
        }
    }
}

