/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.Bounds;

public class NodeBounder {
    public static final int DEFAULT_EXTRA_PAD = 10;

    private NodeBounder() {
    }

    public static Rectangle nodeBounds(Set nodes, Genome genome, Layout layout, FontRenderContext frc, Rectangle minRect, Rectangle extraRect, int extraPad, Map eachRect) {
        Rectangle extent = minRect;
        Iterator mit = nodes.iterator();
        while (mit.hasNext()) {
            NodeProperties np;
            String nodeID = (String)mit.next();
            Node node = genome.getNode(nodeID);
            if (node == null || (np = layout.getNodeProperties(nodeID)) == null) continue;
            INodeRenderer rend = np.getRenderer();
            Rectangle bounds = rend.getModuleBounds(genome, node, layout, frc, extraPad, null);
            if (extent == null) {
                extent = bounds;
            } else {
                Bounds.tweakBounds(extent, bounds);
            }
            if (eachRect == null) continue;
            eachRect.put(nodeID, bounds);
        }
        if (extraRect != null) {
            if (extent == null) {
                extent = extraRect;
            } else {
                Bounds.tweakBounds(extent, extraRect);
            }
        }
        return extent;
    }

    public static Point2D prelimLabelLocation(String firstNodeID, Genome genome, Layout layout, FontRenderContext frc, int extraPad) {
        Node node = genome.getNode(firstNodeID);
        NodeProperties np = layout.getNodeProperties(firstNodeID);
        INodeRenderer rend = np.getRenderer();
        Rectangle bounds = rend.getModuleBounds(genome, node, layout, frc, extraPad, null);
        return new Point2D.Double(bounds.getCenterX(), bounds.getY() - 50.0);
    }

    public static Map nodeRects(Set nodes, Genome genome, Layout layout, FontRenderContext frc, int extraPad) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        Iterator mit = nodes.iterator();
        while (mit.hasNext()) {
            NodeProperties np;
            String nodeID = (String)mit.next();
            Node node = genome.getNode(nodeID);
            if (node == null || (np = layout.getNodeProperties(nodeID)) == null) continue;
            INodeRenderer rend = np.getRenderer();
            Rectangle bounds = rend.getModuleBounds(genome, node, layout, frc, extraPad, null);
            retval.put(nodeID, bounds);
        }
        return retval;
    }

    public static Set getNodesInRect(Rectangle rect, Genome genome, Layout layout, FontRenderContext frc) {
        HashSet<String> retval = new HashSet<String>();
        Iterator git = genome.getAllNodeIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            String nodeID = node.getID();
            INodeRenderer render = layout.getNodeProperties(nodeID).getRenderer();
            Intersection inter = render.intersects(genome, (GenomeItem)node, layout, frc, rect, true, null);
            if (inter == null) continue;
            retval.add(nodeID);
        }
        if (genome instanceof DynamicGenomeInstance) {
            DynamicGenomeInstance dgi = (DynamicGenomeInstance)genome;
            DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(dgi.getProxyID());
            if (dip.hasAddedNodes()) {
                Iterator ait = dip.getAddedNodeIterator();
                while (ait.hasNext()) {
                    Node node = (Node)ait.next();
                    String nodeID = node.getID();
                    INodeRenderer render = layout.getNodeProperties(nodeID).getRenderer();
                    Intersection inter = render.intersects(genome, (GenomeItem)node, layout, frc, rect, true, null);
                    if (inter == null) continue;
                    retval.add(nodeID);
                }
            }
        }
        return retval;
    }
}

