/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.freerender;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.ItemRenderBase;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;

public class NoteFree
extends ItemRenderBase {
    private static final double TEXT_PAD_ = 10.0;
    private static final double HEIGHT_HACK_ = 0.75;

    public void render(Graphics2D g2, RenderObjectCache cache, Genome genome, GenomeItem item, Layout layout, Intersection selected, boolean isGhosted, boolean showBubbles, Rectangle2D clipRect, double pixDiam, Object miscInfo) {
        NoteProperties np = layout.getNoteProperties(item.getID());
        Point2D origin = np.getLocation();
        Color col = isGhosted ? Color.LIGHT_GRAY : np.getColor();
        Font bFont = FontManager.getMgr().getOverrideFont(8, np.getFontOverride());
        FontRenderContext frc = g2.getFontRenderContext();
        String name = item.getName();
        if (name.indexOf(10) == -1) {
            Rectangle2D bounds = bFont.getStringBounds(name, frc);
            double width = bounds.getWidth();
            double height = bounds.getHeight() * 0.75;
            double x = origin.getX() - width / 2.0;
            double by = origin.getY() + height / 2.0;
            double ty = origin.getY() - height / 2.0;
            if (selected != null) {
                g2.setPaint(Color.orange);
                Rectangle2D.Float rect = new Rectangle2D.Float((float)x, (float)ty, (float)width, (float)height);
                g2.fill(rect);
            }
            g2.setPaint(col);
            g2.setFont(bFont);
            g2.drawString(name, (float)x, (float)by);
        } else {
            this.multiLineRender(g2, name, bFont, origin, selected != null, np.getJustification(), col);
        }
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, double pixDiam, Object miscInfo) {
        Rectangle bounds = this.getBounds(genome, item, layout, frc, miscInfo);
        if (Bounds.intersects(bounds, (int)pt.getX(), (int)pt.getY())) {
            return new Intersection(item.getID(), null, 0.0);
        }
        return null;
    }

    public Intersection intersects(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Rectangle rect, boolean countPartial, Object miscInfo) {
        return null;
    }

    public Rectangle getBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, Object miscInfo) {
        NoteProperties np = layout.getNoteProperties(item.getID());
        Point2D origin = np.getLocation();
        String name = item.getName();
        Font bFont = FontManager.getMgr().getOverrideFont(8, np.getFontOverride());
        if (name.indexOf(10) == -1) {
            Rectangle2D bounds = bFont.getStringBounds(name, frc);
            double width = bounds.getWidth() + 20.0;
            double height = bounds.getHeight() * 0.75 + 20.0;
            double minX = origin.getX() - width / 2.0;
            double minY = origin.getY() - height / 2.0;
            return new Rectangle((int)minX, (int)minY, (int)width, (int)height);
        }
        String[] toks = name.split("\n");
        Rectangle2D rect2D = MultiLineRenderSupport.multiLineGuts(frc, toks, bFont, origin, null, null, null, null);
        return new Rectangle((int)rect2D.getX(), (int)rect2D.getY(), (int)rect2D.getWidth(), (int)rect2D.getHeight());
    }

    private Rectangle2D multiLineRender(Graphics2D g2, String name, Font mFont, Point2D origin, boolean selected, int justification, Color col) {
        FontRenderContext frc = g2.getFontRenderContext();
        String[] toks = name.split("\n");
        if (toks.length == 0) {
            return null;
        }
        return MultiLineRenderSupport.multiLineRender(g2, frc, toks, mFont, origin, selected, justification, col);
    }
}

